/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLabelUI;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import sun.swing.plaf.synth.SynthIcon;
import sun.swing.plaf.synth.SynthUI;

class SynthTreeUI
extends BasicTreeUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private SynthStyle cellStyle;
    private SynthContext paintContext;
    private boolean drawHorizontalLines;
    private boolean drawVerticalLines;
    private int leadRow;
    private int padding;
    private boolean useTreeColors;
    private Icon expandedIconWrapper = new ExpandedIconWrapper();

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthTreeUI();
    }

    SynthTreeUI() {
    }

    public Icon getExpandedIcon() {
        return this.expandedIconWrapper;
    }

    protected void installDefaults() {
        this.updateStyle(this.tree);
    }

    private void updateStyle(JTree jTree) {
        SynthContext synthContext = this.getContext((JComponent)jTree, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.setExpandedIcon(this.style.getIcon(synthContext, "Tree.expandedIcon"));
            this.setCollapsedIcon(this.style.getIcon(synthContext, "Tree.collapsedIcon"));
            this.setLeftChildIndent(this.style.getInt(synthContext, "Tree.leftChildIndent", 0));
            this.setRightChildIndent(this.style.getInt(synthContext, "Tree.rightChildIndent", 0));
            this.drawHorizontalLines = this.style.getBoolean(synthContext, "Tree.drawHorizontalLines", true);
            this.drawVerticalLines = this.style.getBoolean(synthContext, "Tree.drawVerticalLines", true);
            Object object = this.style.get(synthContext, "Tree.rowHeight");
            if (object != null) {
                LookAndFeel.installProperty(jTree, "rowHeight", object);
            }
            LookAndFeel.installProperty(jTree, "scrollsOnExpand", (object = this.style.get(synthContext, "Tree.scrollsOnExpand")) != null ? object : Boolean.TRUE);
            this.padding = this.style.getInt(synthContext, "Tree.padding", 0);
            this.largeModel = jTree.isLargeModel() && jTree.getRowHeight() > 0;
            this.useTreeColors = this.style.getBoolean(synthContext, "Tree.rendererUseTreeColors", true);
            Boolean bl2 = this.style.getBoolean(synthContext, "Tree.showsRootHandles", Boolean.TRUE);
            LookAndFeel.installProperty(jTree, "showsRootHandles", bl2);
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
        synthContext = this.getContext(jTree, Region.TREE_CELL, 1);
        this.cellStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    protected void installListeners() {
        super.installListeners();
        this.tree.addPropertyChangeListener(this);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    private Region getRegion(JTree jTree) {
        return SynthLookAndFeel.getRegion(jTree);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    private SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent, region));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, region, this.cellStyle, n2);
    }

    private int getComponentState(JComponent jComponent, Region region) {
        return 513;
    }

    protected TreeCellEditor createDefaultCellEditor() {
        TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
        SynthTreeCellEditor synthTreeCellEditor = treeCellRenderer != null && treeCellRenderer instanceof DefaultTreeCellRenderer ? new SynthTreeCellEditor(this.tree, (DefaultTreeCellRenderer)treeCellRenderer) : new SynthTreeCellEditor(this.tree, null);
        return synthTreeCellEditor;
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new SynthTreeCellRenderer();
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext((JComponent)this.tree, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        synthContext = this.getContext(this.tree, Region.TREE_CELL, 1);
        this.cellStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.cellStyle = null;
        if (this.tree.getTransferHandler() instanceof UIResource) {
            this.tree.setTransferHandler(null);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tree.removePropertyChangeListener(this);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintTreeBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        synthContext.getPainter().paintTreeBorder(synthContext, graphics, n2, n3, n4, n5);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    private void adjustCellBounds(JTree jTree, Rectangle rectangle, Insets insets) {
        if (rectangle != null) {
            if (insets == null) {
                insets = SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS;
            }
            rectangle.x += insets.left;
            rectangle.y += insets.top;
        }
    }

    private void updateLeadRow() {
        this.leadRow = this.getRowForPath(this.tree, this.tree.getLeadSelectionPath());
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        this.paintContext = synthContext;
        this.updateLeadRow();
        Rectangle rectangle = graphics.getClipBounds();
        Insets insets = this.tree.getInsets();
        TreePath treePath = this.getClosestPathForLocation(this.tree, 0, rectangle.y);
        Enumeration<TreePath> enumeration = this.treeState.getVisiblePathsFrom(treePath);
        int n2 = this.treeState.getRowForPath(treePath);
        int n3 = rectangle.y + rectangle.height;
        TreeModel treeModel = this.tree.getModel();
        SynthContext synthContext2 = this.getContext((JComponent)this.tree, Region.TREE_CELL);
        this.drawingCache.clear();
        this.setHashColor(synthContext.getStyle().getColor(synthContext, ColorType.FOREGROUND));
        if (enumeration != null) {
            Rectangle rectangle2;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            TreePath treePath2;
            boolean bl5 = false;
            Rectangle rectangle3 = new Rectangle();
            Rectangle rectangle4 = new Rectangle(0, 0, this.tree.getWidth(), 0);
            TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
            DefaultTreeCellRenderer defaultTreeCellRenderer = treeCellRenderer instanceof DefaultTreeCellRenderer ? (DefaultTreeCellRenderer)treeCellRenderer : null;
            this.configureRenderer(synthContext2);
            while (!bl5 && enumeration.hasMoreElements()) {
                treePath2 = enumeration.nextElement();
                if (treePath2 != null) {
                    bl4 = treeModel.isLeaf(treePath2.getLastPathComponent());
                    if (bl4) {
                        bl3 = false;
                        bl2 = false;
                    } else {
                        bl2 = this.treeState.getExpandedState(treePath2);
                        bl3 = this.tree.hasBeenExpanded(treePath2);
                    }
                    rectangle2 = this.treeState.getBounds(treePath2, rectangle3);
                    this.adjustCellBounds(this.tree, rectangle2, insets);
                    rectangle4.y = rectangle2.y;
                    rectangle4.height = rectangle2.height;
                    this.paintRow(treeCellRenderer, defaultTreeCellRenderer, synthContext, synthContext2, graphics, rectangle, insets, rectangle2, rectangle4, treePath2, n2, bl2, bl3, bl4);
                    if (rectangle2.y + rectangle2.height >= n3) {
                        bl5 = true;
                    }
                } else {
                    bl5 = true;
                }
                ++n2;
            }
            boolean bl6 = this.tree.isRootVisible();
            TreePath treePath3 = treePath;
            for (treePath3 = treePath3.getParentPath(); treePath3 != null; treePath3 = treePath3.getParentPath()) {
                this.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath3);
                this.drawingCache.put(treePath3, Boolean.TRUE);
            }
            bl5 = false;
            enumeration = this.treeState.getVisiblePathsFrom(treePath);
            while (!bl5 && enumeration.hasMoreElements()) {
                treePath2 = enumeration.nextElement();
                if (treePath2 != null) {
                    bl4 = treeModel.isLeaf(treePath2.getLastPathComponent());
                    if (bl4) {
                        bl3 = false;
                        bl2 = false;
                    } else {
                        bl2 = this.treeState.getExpandedState(treePath2);
                        bl3 = this.tree.hasBeenExpanded(treePath2);
                    }
                    rectangle2 = this.treeState.getBounds(treePath2, rectangle3);
                    this.adjustCellBounds(this.tree, rectangle2, insets);
                    treePath3 = treePath2.getParentPath();
                    if (treePath3 != null) {
                        if (this.drawingCache.get(treePath3) == null) {
                            this.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath3);
                            this.drawingCache.put(treePath3, Boolean.TRUE);
                        }
                        this.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle2, treePath2, n2, bl2, bl3, bl4);
                    } else if (bl6 && n2 == 0) {
                        this.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle2, treePath2, n2, bl2, bl3, bl4);
                    }
                    if (this.shouldPaintExpandControl(treePath2, n2, bl2, bl3, bl4)) {
                        this.paintExpandControl(graphics, rectangle, insets, rectangle2, treePath2, n2, bl2, bl3, bl4);
                    }
                    if (rectangle2.y + rectangle2.height >= n3) {
                        bl5 = true;
                    }
                } else {
                    bl5 = true;
                }
                ++n2;
            }
        }
        synthContext2.dispose();
        this.rendererPane.removeAll();
    }

    private void configureRenderer(SynthContext synthContext) {
        TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
        if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
            SynthStyle synthStyle = synthContext.getStyle();
            synthContext.setComponentState(513);
            Color color = defaultTreeCellRenderer.getTextSelectionColor();
            if (color == null || color instanceof UIResource) {
                defaultTreeCellRenderer.setTextSelectionColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            }
            if ((color = defaultTreeCellRenderer.getBackgroundSelectionColor()) == null || color instanceof UIResource) {
                defaultTreeCellRenderer.setBackgroundSelectionColor(synthStyle.getColor(synthContext, ColorType.TEXT_BACKGROUND));
            }
            synthContext.setComponentState(1);
            color = defaultTreeCellRenderer.getTextNonSelectionColor();
            if (color == null || color instanceof UIResource) {
                defaultTreeCellRenderer.setTextNonSelectionColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            }
            if ((color = defaultTreeCellRenderer.getBackgroundNonSelectionColor()) instanceof UIResource) {
                defaultTreeCellRenderer.setBackgroundNonSelectionColor(synthStyle.getColor(synthContext, ColorType.TEXT_BACKGROUND));
            }
        }
    }

    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n2, boolean bl2, boolean bl3, boolean bl4) {
        if (this.drawHorizontalLines) {
            super.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle2, treePath, n2, bl2, bl3, bl4);
        }
    }

    protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n2, int n3, int n4) {
        this.paintContext.getStyle().getGraphicsUtils(this.paintContext).drawLine(this.paintContext, "Tree.horizontalLine", graphics, n3, n2, n4, n2);
    }

    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        if (this.drawVerticalLines) {
            super.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath);
        }
    }

    protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n2, int n3, int n4) {
        this.paintContext.getStyle().getGraphicsUtils(this.paintContext).drawLine(this.paintContext, "Tree.verticalLine", graphics, n2, n3, n2, n4);
    }

    protected void paintRow(TreeCellRenderer treeCellRenderer, DefaultTreeCellRenderer defaultTreeCellRenderer, SynthContext synthContext, SynthContext synthContext2, Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, Rectangle rectangle3, TreePath treePath, int n2, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = this.tree.isRowSelected(n2);
        if (bl5) {
            synthContext2.setComponentState(513);
        } else {
            synthContext2.setComponentState(1);
        }
        if (defaultTreeCellRenderer != null && defaultTreeCellRenderer.getBorderSelectionColor() instanceof UIResource) {
            defaultTreeCellRenderer.setBorderSelectionColor(this.style.getColor(synthContext2, ColorType.FOCUS));
        }
        SynthLookAndFeel.updateSubregion(synthContext2, graphics, rectangle3);
        synthContext2.getPainter().paintTreeCellBackground(synthContext2, graphics, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        synthContext2.getPainter().paintTreeCellBorder(synthContext2, graphics, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        if (this.editingComponent != null && this.editingRow == n2) {
            return;
        }
        int n3 = this.tree.hasFocus() ? this.leadRow : -1;
        Component component = treeCellRenderer.getTreeCellRendererComponent(this.tree, treePath.getLastPathComponent(), bl5, bl2, bl4, n2, n3 == n2);
        this.rendererPane.paintComponent(graphics, component, this.tree, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, true);
    }

    protected void drawCentered(Component component, Graphics graphics, Icon icon, int n2, int n3) {
        int n4 = SynthIcon.getIconWidth(icon, this.paintContext);
        int n5 = SynthIcon.getIconHeight(icon, this.paintContext);
        SynthIcon.paintIcon(icon, this.paintContext, graphics, n2 - n4 / 2, n3 - n5 / 2, n4, n5);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JTree)propertyChangeEvent.getSource());
        }
    }

    protected int getRowX(int n2, int n3) {
        return super.getRowX(n2, n3) + this.padding;
    }

    private class ExpandedIconWrapper
    extends SynthIcon {
        private ExpandedIconWrapper() {
        }

        public void paintIcon(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
            if (synthContext == null) {
                synthContext = SynthTreeUI.this.getContext(SynthTreeUI.this.tree);
                SynthIcon.paintIcon(SynthTreeUI.this.expandedIcon, synthContext, graphics, n2, n3, n4, n5);
                synthContext.dispose();
            } else {
                SynthIcon.paintIcon(SynthTreeUI.this.expandedIcon, synthContext, graphics, n2, n3, n4, n5);
            }
        }

        public int getIconWidth(SynthContext synthContext) {
            int n2;
            if (synthContext == null) {
                synthContext = SynthTreeUI.this.getContext(SynthTreeUI.this.tree);
                n2 = SynthIcon.getIconWidth(SynthTreeUI.this.expandedIcon, synthContext);
                synthContext.dispose();
            } else {
                n2 = SynthIcon.getIconWidth(SynthTreeUI.this.expandedIcon, synthContext);
            }
            return n2;
        }

        public int getIconHeight(SynthContext synthContext) {
            int n2;
            if (synthContext == null) {
                synthContext = SynthTreeUI.this.getContext(SynthTreeUI.this.tree);
                n2 = SynthIcon.getIconHeight(SynthTreeUI.this.expandedIcon, synthContext);
                synthContext.dispose();
            } else {
                n2 = SynthIcon.getIconHeight(SynthTreeUI.this.expandedIcon, synthContext);
            }
            return n2;
        }
    }

    private static class SynthTreeCellEditor
    extends DefaultTreeCellEditor {
        public SynthTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
            super(jTree, defaultTreeCellRenderer);
            this.setBorderSelectionColor(null);
        }

        protected TreeCellEditor createTreeCellEditor() {
            JTextField jTextField = new JTextField(){

                public String getName() {
                    return "Tree.cellEditor";
                }
            };
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField);
            defaultCellEditor.setClickCountToStart(1);
            return defaultCellEditor;
        }
    }

    private class SynthTreeCellRenderer
    extends DefaultTreeCellRenderer
    implements UIResource {
        SynthTreeCellRenderer() {
        }

        public String getName() {
            return "Tree.cellRenderer";
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
            if (!SynthTreeUI.this.useTreeColors && (bl2 || bl5)) {
                SynthLookAndFeel.setSelectedUI((SynthLabelUI)SynthLookAndFeel.getUIOfType(this.getUI(), SynthLabelUI.class), bl2, bl5, jTree.isEnabled());
            } else {
                SynthLookAndFeel.resetSelectedUI();
            }
            return super.getTreeCellRendererComponent(jTree, object, bl2, bl3, bl4, n2, bl5);
        }

        public void paint(Graphics graphics) {
            this.paintComponent(graphics);
            if (this.hasFocus) {
                SynthContext synthContext = SynthTreeUI.this.getContext(SynthTreeUI.this.tree, Region.TREE_CELL);
                if (synthContext.getStyle() == null) {
                    assert (false) : "SynthTreeCellRenderer is being used outside of UI that created it";
                    return;
                }
                int n2 = 0;
                Icon icon = this.getIcon();
                if (icon != null && this.getText() != null) {
                    n2 = icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                }
                if (this.selected) {
                    synthContext.setComponentState(513);
                } else {
                    synthContext.setComponentState(1);
                }
                if (this.getComponentOrientation().isLeftToRight()) {
                    synthContext.getPainter().paintTreeCellFocus(synthContext, graphics, n2, 0, this.getWidth() - n2, this.getHeight());
                } else {
                    synthContext.getPainter().paintTreeCellFocus(synthContext, graphics, 0, 0, this.getWidth() - n2, this.getHeight());
                }
                synthContext.dispose();
            }
            SynthLookAndFeel.resetSelectedUI();
        }
    }
}

