/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthEditorPaneUI;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

class SynthTextPaneUI
extends SynthEditorPaneUI {
    SynthTextPaneUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthTextPaneUI();
    }

    protected String getPropertyPrefix() {
        return "TextPane";
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.updateForeground(jComponent.getForeground());
        this.updateFont(jComponent.getFont());
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("foreground")) {
            this.updateForeground((Color)propertyChangeEvent.getNewValue());
        } else if (string.equals("font")) {
            this.updateFont((Font)propertyChangeEvent.getNewValue());
        } else if (string.equals("document")) {
            JTextComponent jTextComponent = this.getComponent();
            this.updateForeground(jTextComponent.getForeground());
            this.updateFont(jTextComponent.getFont());
        }
    }

    private void updateForeground(Color color) {
        StyledDocument styledDocument = (StyledDocument)this.getComponent().getDocument();
        Style style = styledDocument.getStyle("default");
        if (style == null) {
            return;
        }
        if (color == null) {
            style.removeAttribute(StyleConstants.Foreground);
        } else {
            StyleConstants.setForeground(style, color);
        }
    }

    private void updateFont(Font font) {
        StyledDocument styledDocument = (StyledDocument)this.getComponent().getDocument();
        Style style = styledDocument.getStyle("default");
        if (style == null) {
            return;
        }
        if (font == null) {
            style.removeAttribute(StyleConstants.FontFamily);
            style.removeAttribute(StyleConstants.FontSize);
            style.removeAttribute(StyleConstants.Bold);
            style.removeAttribute(StyleConstants.Italic);
        } else {
            StyleConstants.setFontFamily(style, font.getName());
            StyleConstants.setFontSize(style, font.getSize());
            StyleConstants.setBold(style, font.isBold());
            StyleConstants.setItalic(style, font.isItalic());
        }
    }

    void paintBackground(SynthContext synthContext, Graphics graphics, JComponent jComponent) {
        synthContext.getPainter().paintTextPaneBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        synthContext.getPainter().paintTextPaneBorder(synthContext, graphics, n2, n3, n4, n5);
    }
}

