/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthSliderUI
extends BasicSliderUI
implements PropertyChangeListener,
SynthUI {
    protected Dimension contentDim = new Dimension();
    protected Rectangle valueRect = new Rectangle();
    protected boolean paintValue;
    private int trackHeight;
    private int trackBorder;
    private int thumbWidth;
    private int thumbHeight;
    private SynthStyle style;
    private SynthStyle sliderTrackStyle;
    private SynthStyle sliderThumbStyle;
    private transient boolean thumbActive;
    private static Rectangle unionRect = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthSliderUI((JSlider)jComponent);
    }

    public SynthSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    protected void installDefaults(JSlider jSlider) {
        this.updateStyle(jSlider);
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext((JComponent)this.slider, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        synthContext = this.getContext(this.slider, Region.SLIDER_TRACK, 1);
        this.sliderTrackStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.sliderTrackStyle = null;
        synthContext = this.getContext(this.slider, Region.SLIDER_THUMB, 1);
        this.sliderThumbStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.sliderThumbStyle = null;
    }

    protected void installListeners(JSlider jSlider) {
        super.installListeners(jSlider);
        jSlider.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        this.slider.removePropertyChangeListener(this);
        super.uninstallListeners(this.slider);
    }

    private void updateStyle(JSlider jSlider) {
        SynthContext synthContext = this.getContext((JComponent)jSlider, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.thumbWidth = this.style.getInt(synthContext, "Slider.thumbWidth", 30);
            this.thumbHeight = this.style.getInt(synthContext, "Slider.thumbHeight", 14);
            this.trackBorder = this.style.getInt(synthContext, "Slider.trackBorder", 1);
            this.trackHeight = this.thumbHeight + this.trackBorder * 2;
            this.paintValue = this.style.getBoolean(synthContext, "Slider.paintValue", true);
            if (synthStyle != null) {
                this.uninstallKeyboardActions(jSlider);
                this.installKeyboardActions(jSlider);
            }
        }
        synthContext.dispose();
        synthContext = this.getContext(jSlider, Region.SLIDER_TRACK, 1);
        this.sliderTrackStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
        synthContext = this.getContext(jSlider, Region.SLIDER_THUMB, 1);
        this.sliderThumbStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new SynthTrackListener();
    }

    private void updateThumbState(int n2, int n3) {
        this.setThumbActive(this.thumbRect.contains(n2, n3));
    }

    private void setThumbActive(boolean bl2) {
        if (this.thumbActive != bl2) {
            this.thumbActive = bl2;
            this.slider.repaint(this.thumbRect);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        this.recalculateIfInsetsChanged();
        Dimension dimension = new Dimension(this.contentDim);
        if (this.slider.getOrientation() == 1) {
            dimension.height = 200;
        } else {
            dimension.width = 200;
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        this.recalculateIfInsetsChanged();
        Dimension dimension = new Dimension(this.contentDim);
        if (this.slider.getOrientation() == 1) {
            dimension.height = this.thumbRect.height + this.insetCache.top + this.insetCache.bottom;
        } else {
            dimension.width = this.thumbRect.width + this.insetCache.left + this.insetCache.right;
        }
        return dimension;
    }

    protected void calculateGeometry() {
        this.layout();
        this.calculateThumbLocation();
    }

    protected void layout() {
        SynthContext synthContext = this.getContext(this.slider);
        SynthGraphicsUtils synthGraphicsUtils = this.style.getGraphicsUtils(synthContext);
        Dimension dimension = this.getThumbSize();
        this.thumbRect.setSize(dimension.width, dimension.height);
        Insets insets = new Insets(0, 0, 0, 0);
        SynthContext synthContext2 = this.getContext((JComponent)this.slider, Region.SLIDER_TRACK);
        this.style.getInsets(synthContext2, insets);
        synthContext2.dispose();
        if (this.slider.getOrientation() == 0) {
            this.valueRect.height = 0;
            if (this.paintValue) {
                this.valueRect.height = synthGraphicsUtils.getMaximumCharHeight(synthContext);
            }
            this.trackRect.height = this.trackHeight;
            this.tickRect.height = 0;
            if (this.slider.getPaintTicks()) {
                this.tickRect.height = this.getTickLength();
            }
            this.labelRect.height = 0;
            if (this.slider.getPaintLabels()) {
                this.labelRect.height = this.getHeightOfTallestLabel();
            }
            this.contentDim.height = this.valueRect.height + this.trackRect.height + insets.top + insets.bottom + this.tickRect.height + this.labelRect.height + 4;
            this.contentDim.width = this.slider.getWidth() - this.insetCache.left - this.insetCache.right;
            int n2 = this.slider.getHeight() / 2 - this.contentDim.height / 2;
            this.tickRect.x = this.labelRect.x = this.insetCache.left;
            this.trackRect.x = this.labelRect.x;
            this.valueRect.x = this.labelRect.x;
            this.tickRect.width = this.labelRect.width = this.contentDim.width;
            this.trackRect.width = this.labelRect.width;
            this.valueRect.width = this.labelRect.width;
            this.valueRect.y = n2;
            this.trackRect.y = (n2 += this.valueRect.height + 2) + insets.top;
            this.tickRect.y = n2 += this.trackRect.height + insets.top + insets.bottom;
            this.labelRect.y = n2 += this.tickRect.height + 2;
            n2 += this.labelRect.height;
        } else {
            this.trackRect.width = this.trackHeight;
            this.tickRect.width = 0;
            if (this.slider.getPaintTicks()) {
                this.tickRect.width = this.getTickLength();
            }
            this.labelRect.width = 0;
            if (this.slider.getPaintLabels()) {
                this.labelRect.width = this.getWidthOfWidestLabel();
            }
            this.valueRect.y = this.insetCache.top;
            this.valueRect.height = 0;
            if (this.paintValue) {
                this.valueRect.height = synthGraphicsUtils.getMaximumCharHeight(synthContext);
            }
            this.contentDim.width = this.trackRect.width + insets.left + insets.right + this.tickRect.width + this.labelRect.width + 2 + this.insetCache.left + this.insetCache.right;
            this.contentDim.height = this.slider.getHeight() - this.insetCache.top - this.insetCache.bottom;
            int n3 = this.slider.getWidth() / 2 - this.contentDim.width / 2;
            FontMetrics fontMetrics = this.slider.getFontMetrics(this.slider.getFont());
            this.valueRect.width = Math.max(synthGraphicsUtils.computeStringWidth(synthContext, this.slider.getFont(), fontMetrics, "" + this.slider.getMaximum()), synthGraphicsUtils.computeStringWidth(synthContext, this.slider.getFont(), fontMetrics, "" + this.slider.getMinimum()));
            if (this.valueRect.width > this.trackRect.width + insets.left + insets.right) {
                int n4 = (this.valueRect.width - (this.trackRect.width + insets.left + insets.right)) / 2;
                this.contentDim.width += n4;
                n3 += n4;
            }
            this.tickRect.y = this.labelRect.y = this.valueRect.y + this.valueRect.height;
            this.trackRect.y = this.labelRect.y;
            this.tickRect.height = this.labelRect.height = this.contentDim.height - this.valueRect.height;
            this.trackRect.height = this.labelRect.height;
            if (SynthLookAndFeel.isLeftToRight(this.slider)) {
                this.trackRect.x = n3 + insets.left;
                this.tickRect.x = n3 += this.trackRect.width + insets.right + insets.left;
                this.labelRect.x = n3 += this.tickRect.width + 2;
            } else {
                this.labelRect.x = n3;
                this.tickRect.x = n3 += this.labelRect.width + 2;
                this.trackRect.x = n3 += this.tickRect.width + insets.left;
            }
        }
        synthContext.dispose();
    }

    protected void calculateThumbLocation() {
        int n2;
        if (this.slider.getSnapToTicks()) {
            int n3 = n2 = this.slider.getValue();
            int n4 = this.slider.getMajorTickSpacing();
            int n5 = this.slider.getMinorTickSpacing();
            int n6 = 0;
            if (n5 > 0) {
                n6 = n5;
            } else if (n4 > 0) {
                n6 = n4;
            }
            if (n6 != 0) {
                if ((n2 - this.slider.getMinimum()) % n6 != 0) {
                    float f2 = (float)(n2 - this.slider.getMinimum()) / (float)n6;
                    int n7 = Math.round(f2);
                    n3 = this.slider.getMinimum() + n7 * n6;
                }
                if (n3 != n2) {
                    this.slider.setValue(n3);
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            n2 = this.xPositionForValue(this.slider.getValue());
            this.thumbRect.x = n2 - this.thumbRect.width / 2;
            this.thumbRect.y = this.trackRect.y + this.trackBorder;
        } else {
            n2 = this.yPositionForValue(this.slider.getValue());
            this.thumbRect.x = this.trackRect.x + this.trackBorder;
            this.thumbRect.y = n2 - this.thumbRect.height / 2;
        }
    }

    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height + 2 + this.getTickLength();
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.getTickLength();
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.y;
                this.tickRect.height = 0;
            }
        } else {
            if (SynthLookAndFeel.isLeftToRight(this.slider)) {
                this.tickRect.x = this.trackRect.x + this.trackRect.width;
                this.tickRect.width = this.getTickLength();
            } else {
                this.tickRect.width = this.getTickLength();
                this.tickRect.x = this.trackRect.x - this.tickRect.width;
            }
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.x;
                this.tickRect.width = 0;
            }
        }
    }

    public void setThumbLocation(int n2, int n3) {
        super.setThumbLocation(n2, n3);
        this.slider.repaint(this.valueRect.x, this.valueRect.y, this.valueRect.width, this.valueRect.height);
        this.setThumbActive(false);
    }

    protected int xPositionForValue(int n2) {
        int n3;
        int n4 = this.slider.getMinimum();
        int n5 = this.slider.getMaximum();
        int n6 = this.trackRect.x + this.thumbRect.width / 2 + this.trackBorder;
        int n7 = this.trackRect.x + this.trackRect.width - this.thumbRect.width / 2 - this.trackBorder;
        int n8 = n7 - n6;
        double d2 = (double)n5 - (double)n4;
        double d3 = (double)n8 / d2;
        if (!this.drawInverted()) {
            n3 = n6;
            n3 = (int)((long)n3 + Math.round(d3 * ((double)n2 - (double)n4)));
        } else {
            n3 = n7;
            n3 = (int)((long)n3 - Math.round(d3 * ((double)n2 - (double)n4)));
        }
        n3 = Math.max(n6, n3);
        n3 = Math.min(n7, n3);
        return n3;
    }

    protected int yPositionForValue(int n2) {
        int n3;
        int n4 = this.slider.getMinimum();
        int n5 = this.slider.getMaximum();
        int n6 = this.trackRect.y + this.thumbRect.height / 2 + this.trackBorder;
        int n7 = this.trackRect.y + this.trackRect.height - this.thumbRect.height / 2 - this.trackBorder;
        int n8 = n7 - n6;
        double d2 = (double)n5 - (double)n4;
        double d3 = (double)n8 / d2;
        if (!this.drawInverted()) {
            n3 = n6;
            n3 = (int)((long)n3 + Math.round(d3 * ((double)n5 - (double)n2)));
        } else {
            n3 = n6;
            n3 = (int)((long)n3 + Math.round(d3 * ((double)n2 - (double)n4)));
        }
        n3 = Math.max(n6, n3);
        n3 = Math.min(n7, n3);
        return n3;
    }

    public int valueForYPosition(int n2) {
        int n3;
        int n4 = this.slider.getMinimum();
        int n5 = this.slider.getMaximum();
        int n6 = this.trackRect.y + this.thumbRect.height / 2 + this.trackBorder;
        int n7 = this.trackRect.y + this.trackRect.height - this.thumbRect.height / 2 - this.trackBorder;
        int n8 = n7 - n6;
        if (n2 <= n6) {
            n3 = this.drawInverted() ? n4 : n5;
        } else if (n2 >= n7) {
            n3 = this.drawInverted() ? n5 : n4;
        } else {
            int n9 = n2 - n6;
            double d2 = (double)n5 - (double)n4;
            double d3 = d2 / (double)n8;
            int n10 = (int)Math.round((double)n9 * d3);
            n3 = this.drawInverted() ? n4 + n10 : n5 - n10;
        }
        return n3;
    }

    public int valueForXPosition(int n2) {
        int n3;
        int n4 = this.slider.getMinimum();
        int n5 = this.slider.getMaximum();
        int n6 = this.trackRect.x + this.thumbRect.width / 2 + this.trackBorder;
        int n7 = this.trackRect.x + this.trackRect.width - this.thumbRect.width / 2 - this.trackBorder;
        int n8 = n7 - n6;
        if (n2 <= n6) {
            n3 = this.drawInverted() ? n5 : n4;
        } else if (n2 >= n7) {
            n3 = this.drawInverted() ? n4 : n5;
        } else {
            int n9 = n2 - n6;
            double d2 = (double)n5 - (double)n4;
            double d3 = d2 / (double)n8;
            int n10 = (int)Math.round((double)n9 * d3);
            n3 = this.drawInverted() ? n5 - n10 : n4 + n10;
        }
        return n3;
    }

    protected Dimension getThumbSize() {
        Dimension dimension = new Dimension();
        if (this.slider.getOrientation() == 1) {
            dimension.width = this.thumbHeight;
            dimension.height = this.thumbWidth;
        } else {
            dimension.width = this.thumbWidth;
            dimension.height = this.thumbHeight;
        }
        return dimension;
    }

    protected void recalculateIfInsetsChanged() {
        SynthContext synthContext = this.getContext(this.slider);
        Insets insets = this.style.getInsets(synthContext, null);
        if (!insets.equals(this.insetCache)) {
            this.insetCache = insets;
            this.calculateGeometry();
        }
        synthContext.dispose();
    }

    public Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    public SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    public SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent, region));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n2) {
        SynthStyle synthStyle = null;
        Class<SynthContext> clazz = SynthContext.class;
        if (region == Region.SLIDER_TRACK) {
            synthStyle = this.sliderTrackStyle;
        } else if (region == Region.SLIDER_THUMB) {
            synthStyle = this.sliderThumbStyle;
        }
        return SynthContext.getContext(clazz, jComponent, region, synthStyle, n2);
    }

    public int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    private int getComponentState(JComponent jComponent, Region region) {
        if (region == Region.SLIDER_THUMB && this.thumbActive && jComponent.isEnabled()) {
            return 2;
        }
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintSliderBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(SynthContext synthContext, Graphics graphics) {
        Object object;
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle rectangle = graphics.getClipBounds();
        if (this.paintValue) {
            object = SwingUtilities2.getFontMetrics(this.slider, graphics);
            this.valueRect.x = this.thumbRect.x + this.thumbRect.width / 2 - synthContext.getStyle().getGraphicsUtils(synthContext).computeStringWidth(synthContext, graphics.getFont(), (FontMetrics)object, "" + this.slider.getValue()) / 2;
            graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.TEXT_FOREGROUND));
            synthContext.getStyle().getGraphicsUtils(synthContext).paintText(synthContext, graphics, "" + this.slider.getValue(), this.valueRect.x, this.valueRect.y, -1);
        }
        object = this.getContext((JComponent)this.slider, Region.SLIDER_TRACK);
        this.paintTrack((SynthContext)object, graphics, this.trackRect);
        ((SynthContext)object).dispose();
        object = this.getContext((JComponent)this.slider, Region.SLIDER_THUMB);
        this.paintThumb((SynthContext)object, graphics, this.thumbRect);
        ((SynthContext)object).dispose();
        if (this.slider.getPaintTicks() && rectangle.intersects(this.tickRect)) {
            this.paintTicks(graphics);
        }
        if (this.slider.getPaintLabels() && rectangle.intersects(this.labelRect)) {
            this.paintLabels(graphics);
        }
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        synthContext.getPainter().paintSliderBorder(synthContext, graphics, n2, n3, n4, n5);
    }

    public void paintThumb(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        int n2 = this.slider.getOrientation();
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
        synthContext.getPainter().paintSliderThumbBackground(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n2);
        synthContext.getPainter().paintSliderThumbBorder(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n2);
    }

    public void paintTrack(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
        synthContext.getPainter().paintSliderTrackBackground(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        synthContext.getPainter().paintSliderTrackBorder(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JSlider)propertyChangeEvent.getSource());
        }
    }

    protected class SynthTrackListener
    extends BasicSliderUI.TrackListener {
        protected SynthTrackListener() {
            super(SynthSliderUI.this);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            SynthSliderUI.this.setThumbActive(false);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            SynthSliderUI.this.updateThumbState(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n2 = 0;
            if (!SynthSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (!SynthSliderUI.this.isDragging()) {
                return;
            }
            SynthSliderUI.this.slider.setValueIsAdjusting(true);
            switch (SynthSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int n3 = ((SynthSliderUI)SynthSliderUI.this).thumbRect.height / 2;
                    int n4 = mouseEvent.getY() - this.offset;
                    int n5 = ((SynthSliderUI)SynthSliderUI.this).trackRect.y;
                    int n6 = ((SynthSliderUI)SynthSliderUI.this).trackRect.y + ((SynthSliderUI)SynthSliderUI.this).trackRect.height - n3 - SynthSliderUI.this.trackBorder;
                    int n7 = SynthSliderUI.this.yPositionForValue(SynthSliderUI.this.slider.getMaximum() - SynthSliderUI.this.slider.getExtent());
                    if (SynthSliderUI.this.drawInverted()) {
                        n6 = n7;
                    } else {
                        n5 = n7;
                    }
                    n4 = Math.max(n4, n5 - n3);
                    n4 = Math.min(n4, n6 - n3);
                    SynthSliderUI.this.setThumbLocation(((SynthSliderUI)SynthSliderUI.this).thumbRect.x, n4);
                    n2 = n4 + n3;
                    SynthSliderUI.this.slider.setValue(SynthSliderUI.this.valueForYPosition(n2));
                    break;
                }
                case 0: {
                    int n8 = ((SynthSliderUI)SynthSliderUI.this).thumbRect.width / 2;
                    int n9 = mouseEvent.getX() - this.offset;
                    int n10 = ((SynthSliderUI)SynthSliderUI.this).trackRect.x + n8 + SynthSliderUI.this.trackBorder;
                    int n11 = ((SynthSliderUI)SynthSliderUI.this).trackRect.x + ((SynthSliderUI)SynthSliderUI.this).trackRect.width - n8 - SynthSliderUI.this.trackBorder;
                    int n12 = SynthSliderUI.this.xPositionForValue(SynthSliderUI.this.slider.getMaximum() - SynthSliderUI.this.slider.getExtent());
                    if (SynthSliderUI.this.drawInverted()) {
                        n10 = n12;
                    } else {
                        n11 = n12;
                    }
                    n9 = Math.max(n9, n10 - n8);
                    n9 = Math.min(n9, n11 - n8);
                    SynthSliderUI.this.setThumbLocation(n9, ((SynthSliderUI)SynthSliderUI.this).thumbRect.y);
                    n2 = n9 + n8;
                    SynthSliderUI.this.slider.setValue(SynthSliderUI.this.valueForXPosition(n2));
                    break;
                }
                default: {
                    return;
                }
            }
            if (SynthSliderUI.this.slider.getValueIsAdjusting()) {
                SynthSliderUI.this.setThumbActive(true);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            SynthSliderUI.this.updateThumbState(mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

