/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthMenuItemUI;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthMenuUI
extends BasicMenuUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private SynthStyle accStyle;
    private String acceleratorDelimiter;

    SynthMenuUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthMenuUI();
    }

    protected void installDefaults() {
        this.updateStyle(this.menuItem);
    }

    protected void installListeners() {
        super.installListeners();
        this.menuItem.addPropertyChangeListener(this);
    }

    private void updateStyle(JMenuItem jMenuItem) {
        Object object;
        SynthStyle synthStyle = this.style;
        SynthContext synthContext = this.getContext((JComponent)jMenuItem, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (synthStyle != this.style) {
            object = this.getPropertyPrefix();
            this.defaultTextIconGap = this.style.getInt(synthContext, (String)object + ".textIconGap", 4);
            if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
                Insets insets = (Insets)this.style.get(synthContext, (String)object + ".margin");
                if (insets == null) {
                    insets = SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS;
                }
                this.menuItem.setMargin(insets);
            }
            this.acceleratorDelimiter = this.style.getString(synthContext, (String)object + ".acceleratorDelimiter", "+");
            this.arrowIcon = this.style.getIcon(synthContext, (String)object + ".arrowIcon");
            this.checkIcon = this.style.getIcon(synthContext, (String)object + ".checkIcon");
            ((JMenu)this.menuItem).setDelay(this.style.getInt(synthContext, (String)object + ".delay", 200));
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
        object = this.getContext(jMenuItem, Region.MENU_ITEM_ACCELERATOR, 1);
        this.accStyle = SynthLookAndFeel.updateStyle((SynthContext)object, this);
        ((SynthContext)object).dispose();
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext((JComponent)this.menuItem, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        SynthContext synthContext2 = this.getContext(this.menuItem, Region.MENU_ITEM_ACCELERATOR, 1);
        this.accStyle.uninstallDefaults(synthContext2);
        synthContext2.dispose();
        this.accStyle = null;
        super.uninstallDefaults();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removePropertyChangeListener(this);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    SynthContext getContext(JComponent jComponent, int n2) {
        Region region = this.getRegion(jComponent);
        return SynthContext.getContext(SynthContext.class, jComponent, region, this.style, n2);
    }

    public SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent, region));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, region, this.accStyle, n2);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        if (!jComponent.isEnabled()) {
            return 8;
        }
        int n2 = this.menuItem.isArmed() ? 2 : SynthLookAndFeel.getComponentState(jComponent);
        if (this.menuItem.isSelected()) {
            n2 |= 0x200;
        }
        return n2;
    }

    private int getComponentState(JComponent jComponent, Region region) {
        return this.getComponentState(jComponent);
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n2) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthContext synthContext2 = this.getContext(jComponent, Region.MENU_ITEM_ACCELERATOR);
        Dimension dimension = SynthMenuItemUI.getPreferredMenuItemSize(synthContext, synthContext2, this.useCheckAndArrow(), jComponent, icon, icon2, n2, this.acceleratorDelimiter);
        synthContext.dispose();
        synthContext2.dispose();
        return dimension;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintMenuBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        SynthContext synthContext2 = this.getContext((JComponent)this.menuItem, Region.MENU_ITEM_ACCELERATOR);
        SynthMenuItemUI.paint(synthContext, synthContext2, graphics, this.checkIcon, this.arrowIcon, this.useCheckAndArrow(), this.acceleratorDelimiter, this.defaultTextIconGap);
        synthContext2.dispose();
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        synthContext.getPainter().paintMenuBorder(synthContext, graphics, n2, n3, n4, n5);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JMenu)propertyChangeEvent.getSource());
        }
    }

    private boolean useCheckAndArrow() {
        return !((JMenu)this.menuItem).isTopLevelMenu();
    }
}

