/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.swing.ProgressMonitor;

public class ProgressMonitorInputStream
extends FilterInputStream {
    private ProgressMonitor monitor;
    private int nread = 0;
    private int size = 0;

    public ProgressMonitorInputStream(Component component, Object object, InputStream inputStream) {
        super(inputStream);
        try {
            this.size = inputStream.available();
        }
        catch (IOException iOException) {
            this.size = 0;
        }
        this.monitor = new ProgressMonitor(component, object, null, 0, this.size);
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public int read() throws IOException {
        int n2 = this.in.read();
        if (n2 >= 0) {
            this.monitor.setProgress(++this.nread);
        }
        if (this.monitor.isCanceled()) {
            InterruptedIOException interruptedIOException = new InterruptedIOException("progress");
            interruptedIOException.bytesTransferred = this.nread;
            throw interruptedIOException;
        }
        return n2;
    }

    public int read(byte[] byArray) throws IOException {
        int n2 = this.in.read(byArray);
        if (n2 > 0) {
            this.monitor.setProgress(this.nread += n2);
        }
        if (this.monitor.isCanceled()) {
            InterruptedIOException interruptedIOException = new InterruptedIOException("progress");
            interruptedIOException.bytesTransferred = this.nread;
            throw interruptedIOException;
        }
        return n2;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.in.read(byArray, n2, n3);
        if (n4 > 0) {
            this.monitor.setProgress(this.nread += n4);
        }
        if (this.monitor.isCanceled()) {
            InterruptedIOException interruptedIOException = new InterruptedIOException("progress");
            interruptedIOException.bytesTransferred = this.nread;
            throw interruptedIOException;
        }
        return n4;
    }

    public long skip(long l2) throws IOException {
        long l3 = this.in.skip(l2);
        if (l3 > 0L) {
            this.nread = (int)((long)this.nread + l3);
            this.monitor.setProgress(this.nread);
        }
        return l3;
    }

    public void close() throws IOException {
        this.in.close();
        this.monitor.close();
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this.nread = this.size - this.in.available();
        this.monitor.setProgress(this.nread);
    }
}

