/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JLayeredPane
extends JComponent
implements Accessible {
    public static final Integer DEFAULT_LAYER = new Integer(0);
    public static final Integer PALETTE_LAYER = new Integer(100);
    public static final Integer MODAL_LAYER = new Integer(200);
    public static final Integer POPUP_LAYER = new Integer(300);
    public static final Integer DRAG_LAYER = new Integer(400);
    public static final Integer FRAME_CONTENT_LAYER = new Integer(-30000);
    public static final String LAYER_PROPERTY = "layeredContainerLayer";
    private Hashtable<Component, Integer> componentToLayer;
    private boolean optimizedDrawingPossible = true;

    public JLayeredPane() {
        this.setLayout(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateOptimizedDrawing() {
        boolean bl2 = false;
        Object object = this.getTreeLock();
        synchronized (object) {
            Integer n2 = null;
            for (Component component : this.getComponents()) {
                n2 = null;
                if (!(component instanceof JInternalFrame) && (!(component instanceof JComponent) || (n2 = (Integer)((JComponent)component).getClientProperty(LAYER_PROPERTY)) == null) || n2 != null && n2.equals(FRAME_CONTENT_LAYER)) continue;
                bl2 = true;
                break;
            }
        }
        this.optimizedDrawingPossible = !bl2;
    }

    @Override
    protected void addImpl(Component component, Object object, int n2) {
        int n3 = DEFAULT_LAYER;
        if (object instanceof Integer) {
            n3 = (Integer)object;
            this.setLayer(component, n3);
        } else {
            n3 = this.getLayer(component);
        }
        int n4 = this.insertIndexForLayer(n3, n2);
        super.addImpl(component, object, n4);
        component.validate();
        component.repaint();
        this.validateOptimizedDrawing();
    }

    @Override
    public void remove(int n2) {
        Component component = this.getComponent(n2);
        super.remove(n2);
        if (component != null && !(component instanceof JComponent)) {
            this.getComponentToLayer().remove(component);
        }
        this.validateOptimizedDrawing();
    }

    @Override
    public void removeAll() {
        Component[] componentArray = this.getComponents();
        Hashtable<Component, Integer> hashtable = this.getComponentToLayer();
        for (int i2 = componentArray.length - 1; i2 >= 0; --i2) {
            Component component = componentArray[i2];
            if (component == null || component instanceof JComponent) continue;
            hashtable.remove(component);
        }
        super.removeAll();
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return this.optimizedDrawingPossible;
    }

    public static void putLayer(JComponent jComponent, int n2) {
        Integer n3 = new Integer(n2);
        jComponent.putClientProperty(LAYER_PROPERTY, n3);
    }

    public static int getLayer(JComponent jComponent) {
        Integer n2 = (Integer)jComponent.getClientProperty(LAYER_PROPERTY);
        if (n2 != null) {
            return n2;
        }
        return DEFAULT_LAYER;
    }

    public static JLayeredPane getLayeredPaneAbove(Component component) {
        Container container;
        if (component == null) {
            return null;
        }
        for (container = component.getParent(); container != null && !(container instanceof JLayeredPane); container = container.getParent()) {
        }
        return (JLayeredPane)container;
    }

    public void setLayer(Component component, int n2) {
        this.setLayer(component, n2, -1);
    }

    public void setLayer(Component component, int n2, int n3) {
        Integer n4 = this.getObjectForLayer(n2);
        if (n2 == this.getLayer(component) && n3 == this.getPosition(component)) {
            this.repaint(component.getBounds());
            return;
        }
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty(LAYER_PROPERTY, n4);
        } else {
            this.getComponentToLayer().put(component, n4);
        }
        if (component.getParent() == null || component.getParent() != this) {
            this.repaint(component.getBounds());
            return;
        }
        int n5 = this.insertIndexForLayer(component, n2, n3);
        this.setComponentZOrder(component, n5);
        this.repaint(component.getBounds());
    }

    public int getLayer(Component component) {
        Integer n2 = component instanceof JComponent ? (Integer)((JComponent)component).getClientProperty(LAYER_PROPERTY) : this.getComponentToLayer().get(component);
        if (n2 == null) {
            return DEFAULT_LAYER;
        }
        return n2;
    }

    public int getIndexOf(Component component) {
        int n2 = this.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (component != this.getComponent(i2)) continue;
            return i2;
        }
        return -1;
    }

    public void moveToFront(Component component) {
        this.setPosition(component, 0);
    }

    public void moveToBack(Component component) {
        this.setPosition(component, -1);
    }

    public void setPosition(Component component, int n2) {
        this.setLayer(component, this.getLayer(component), n2);
    }

    public int getPosition(Component component) {
        int n2 = 0;
        int n3 = this.getComponentCount();
        int n4 = this.getIndexOf(component);
        if (n4 == -1) {
            return -1;
        }
        int n5 = this.getLayer(component);
        for (int i2 = n4 - 1; i2 >= 0; --i2) {
            int n6 = this.getLayer(this.getComponent(i2));
            if (n6 == n5) {
                ++n2;
                continue;
            }
            return n2;
        }
        return n2;
    }

    public int highestLayer() {
        if (this.getComponentCount() > 0) {
            return this.getLayer(this.getComponent(0));
        }
        return 0;
    }

    public int lowestLayer() {
        int n2 = this.getComponentCount();
        if (n2 > 0) {
            return this.getLayer(this.getComponent(n2 - 1));
        }
        return 0;
    }

    public int getComponentCountInLayer(int n2) {
        int n3 = 0;
        int n4 = this.getComponentCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = this.getLayer(this.getComponent(i2));
            if (n5 == n2) {
                ++n3;
                continue;
            }
            if (n3 > 0 || n5 < n2) break;
        }
        return n3;
    }

    public Component[] getComponentsInLayer(int n2) {
        int n3 = 0;
        Component[] componentArray = new Component[this.getComponentCountInLayer(n2)];
        int n4 = this.getComponentCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = this.getLayer(this.getComponent(i2));
            if (n5 == n2) {
                componentArray[n3++] = this.getComponent(i2);
                continue;
            }
            if (n3 > 0 || n5 < n2) break;
        }
        return componentArray;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.isOpaque()) {
            Rectangle rectangle = graphics.getClipBounds();
            Color color = this.getBackground();
            if (color == null) {
                color = Color.lightGray;
            }
            graphics.setColor(color);
            if (rectangle != null) {
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
        super.paint(graphics);
    }

    protected Hashtable<Component, Integer> getComponentToLayer() {
        if (this.componentToLayer == null) {
            this.componentToLayer = new Hashtable(4);
        }
        return this.componentToLayer;
    }

    protected Integer getObjectForLayer(int n2) {
        Integer n3;
        switch (n2) {
            case 0: {
                n3 = DEFAULT_LAYER;
                break;
            }
            case 100: {
                n3 = PALETTE_LAYER;
                break;
            }
            case 200: {
                n3 = MODAL_LAYER;
                break;
            }
            case 300: {
                n3 = POPUP_LAYER;
                break;
            }
            case 400: {
                n3 = DRAG_LAYER;
                break;
            }
            default: {
                n3 = new Integer(n2);
            }
        }
        return n3;
    }

    protected int insertIndexForLayer(int n2, int n3) {
        return this.insertIndexForLayer(null, n2, n3);
    }

    private int insertIndexForLayer(Component component, int n2, int n3) {
        int n4 = -1;
        int n5 = -1;
        int n6 = this.getComponentCount();
        ArrayList<Component> arrayList = new ArrayList<Component>(n6);
        for (int i2 = 0; i2 < n6; ++i2) {
            if (this.getComponent(i2) == component) continue;
            arrayList.add(this.getComponent(i2));
        }
        int n7 = arrayList.size();
        for (int i3 = 0; i3 < n7; ++i3) {
            int n8 = this.getLayer((Component)arrayList.get(i3));
            if (n4 == -1 && n8 == n2) {
                n4 = i3;
            }
            if (n8 >= n2) continue;
            if (i3 == 0) {
                n4 = 0;
                n5 = 0;
                break;
            }
            n5 = i3;
            break;
        }
        if (n4 == -1 && n5 == -1) {
            return n7;
        }
        if (n4 != -1 && n5 == -1) {
            n5 = n7;
        }
        if (n5 != -1 && n4 == -1) {
            n4 = n5;
        }
        if (n3 == -1) {
            return n5;
        }
        if (n3 > -1 && n4 + n3 <= n5) {
            return n4 + n3;
        }
        return n5;
    }

    @Override
    protected String paramString() {
        String string = this.optimizedDrawingPossible ? "true" : "false";
        return super.paramString() + ",optimizedDrawingPossible=" + string;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJLayeredPane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJLayeredPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleJLayeredPane() {
            super(JLayeredPane.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LAYERED_PANE;
        }
    }
}

