/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;
import javax.management.MBeanServerPermissionCollection;

public class MBeanServerPermission
extends BasicPermission {
    private static final long serialVersionUID = -5661980843569388590L;
    private static final int CREATE = 0;
    private static final int FIND = 1;
    private static final int NEW = 2;
    private static final int RELEASE = 3;
    private static final int N_NAMES = 4;
    private static final String[] names = new String[]{"createMBeanServer", "findMBeanServer", "newMBeanServer", "releaseMBeanServer"};
    private static final int CREATE_MASK = 1;
    private static final int FIND_MASK = 2;
    private static final int NEW_MASK = 4;
    private static final int RELEASE_MASK = 8;
    private static final int ALL_MASK = 15;
    private static final String[] canonicalNames = new String[16];
    transient int mask;

    public MBeanServerPermission(String string) {
        this(string, null);
    }

    public MBeanServerPermission(String string, String string2) {
        super(MBeanServerPermission.getCanonicalName(MBeanServerPermission.parseMask(string)), string2);
        this.mask = MBeanServerPermission.parseMask(string);
        if (string2 != null && string2.length() > 0) {
            throw new IllegalArgumentException("MBeanServerPermission actions must be null: " + string2);
        }
    }

    MBeanServerPermission(int n2) {
        super(MBeanServerPermission.getCanonicalName(n2));
        this.mask = MBeanServerPermission.impliedMask(n2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.mask = MBeanServerPermission.parseMask(this.getName());
    }

    static int simplifyMask(int n2) {
        if ((n2 & 1) != 0) {
            n2 &= 0xFFFFFFFB;
        }
        return n2;
    }

    static int impliedMask(int n2) {
        if ((n2 & 1) != 0) {
            n2 |= 4;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getCanonicalName(int n2) {
        if (n2 == 15) {
            return "*";
        }
        n2 = MBeanServerPermission.simplifyMask(n2);
        String[] stringArray = canonicalNames;
        synchronized (canonicalNames) {
            if (canonicalNames[n2] == null) {
                MBeanServerPermission.canonicalNames[n2] = MBeanServerPermission.makeCanonicalName(n2);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return canonicalNames[n2];
        }
    }

    private static String makeCanonicalName(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < 4; ++i2) {
            if ((n2 & 1 << i2) == 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(names[i2]);
        }
        return stringBuffer.toString().intern();
    }

    private static int parseMask(String string) {
        if (string == null) {
            throw new NullPointerException("MBeanServerPermission: target name can't be null");
        }
        if ((string = string.trim()).equals("*")) {
            return 15;
        }
        if (string.indexOf(44) < 0) {
            return MBeanServerPermission.impliedMask(1 << MBeanServerPermission.nameIndex(string.trim()));
        }
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n3 = MBeanServerPermission.nameIndex(string2.trim());
            n2 |= 1 << n3;
        }
        return MBeanServerPermission.impliedMask(n2);
    }

    private static int nameIndex(String string) throws IllegalArgumentException {
        for (int i2 = 0; i2 < 4; ++i2) {
            if (!names[i2].equals(string)) continue;
            return i2;
        }
        String string2 = "Invalid MBeanServerPermission name: \"" + string + "\"";
        throw new IllegalArgumentException(string2);
    }

    public int hashCode() {
        return this.mask;
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof MBeanServerPermission)) {
            return false;
        }
        MBeanServerPermission mBeanServerPermission = (MBeanServerPermission)permission;
        return (this.mask & mBeanServerPermission.mask) == mBeanServerPermission.mask;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MBeanServerPermission)) {
            return false;
        }
        MBeanServerPermission mBeanServerPermission = (MBeanServerPermission)object;
        return this.mask == mBeanServerPermission.mask;
    }

    public PermissionCollection newPermissionCollection() {
        return new MBeanServerPermissionCollection();
    }
}

