/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedList<E>
extends AbstractSequentialList<E>
implements List<E>,
Queue<E>,
Cloneable,
Serializable {
    private transient Entry<E> header = new Entry<Object>(null, null, null);
    private transient int size = 0;
    private static final long serialVersionUID = 876323262645176354L;

    public LinkedList() {
        this.header.previous = this.header;
        this.header.next = this.header.previous;
    }

    public LinkedList(Collection<? extends E> collection) {
        this();
        this.addAll(collection);
    }

    public E getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.next.element;
    }

    public E getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.previous.element;
    }

    public E removeFirst() {
        return this.remove(this.header.next);
    }

    public E removeLast() {
        return this.remove(this.header.previous);
    }

    public void addFirst(E e2) {
        this.addBefore(e2, this.header.next);
    }

    public void addLast(E e2) {
        this.addBefore(e2, this.header);
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(E e2) {
        this.addBefore(e2, this.header);
        return true;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (entry.element == null) {
                    this.remove(entry);
                    return true;
                }
                entry = entry.next;
            }
        } else {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (object.equals(entry.element)) {
                    this.remove(entry);
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.addAll(this.size, collection);
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        if (n2 < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size);
        }
        Object[] objectArray = collection.toArray();
        int n3 = objectArray.length;
        if (n3 == 0) {
            return false;
        }
        ++this.modCount;
        Entry<E> entry = n2 == this.size ? this.header : this.entry(n2);
        Entry<Object> entry2 = entry.previous;
        for (int i2 = 0; i2 < n3; ++i2) {
            Entry<Object> entry3 = new Entry<Object>(objectArray[i2], entry, entry2);
            entry2.next = entry3;
            entry2 = entry3;
        }
        entry.previous = entry2;
        this.size += n3;
        return true;
    }

    @Override
    public void clear() {
        Entry entry = this.header.next;
        while (entry != this.header) {
            Entry entry2 = entry.next;
            entry.previous = null;
            entry.next = null;
            entry.element = null;
            entry = entry2;
        }
        this.header.previous = this.header;
        this.header.next = this.header.previous;
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public E get(int n2) {
        return this.entry((int)n2).element;
    }

    @Override
    public E set(int n2, E e2) {
        Entry<E> entry = this.entry(n2);
        Object e3 = entry.element;
        entry.element = e2;
        return e3;
    }

    @Override
    public void add(int n2, E e2) {
        this.addBefore(e2, n2 == this.size ? this.header : this.entry(n2));
    }

    @Override
    public E remove(int n2) {
        return this.remove(this.entry(n2));
    }

    private Entry<E> entry(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size);
        }
        Entry<E> entry = this.header;
        if (n2 < this.size >> 1) {
            for (int i2 = 0; i2 <= n2; ++i2) {
                entry = entry.next;
            }
        } else {
            for (int i3 = this.size; i3 > n2; --i3) {
                entry = entry.previous;
            }
        }
        return entry;
    }

    @Override
    public int indexOf(Object object) {
        int n2 = 0;
        if (object == null) {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (entry.element == null) {
                    return n2;
                }
                ++n2;
                entry = entry.next;
            }
        } else {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (object.equals(entry.element)) {
                    return n2;
                }
                ++n2;
                entry = entry.next;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n2 = this.size;
        if (object == null) {
            Entry entry = this.header.previous;
            while (entry != this.header) {
                --n2;
                if (entry.element == null) {
                    return n2;
                }
                entry = entry.previous;
            }
        } else {
            Entry entry = this.header.previous;
            while (entry != this.header) {
                --n2;
                if (object.equals(entry.element)) {
                    return n2;
                }
                entry = entry.previous;
            }
        }
        return -1;
    }

    @Override
    public E peek() {
        if (this.size == 0) {
            return null;
        }
        return this.getFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E poll() {
        if (this.size == 0) {
            return null;
        }
        return this.removeFirst();
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public boolean offer(E e2) {
        return this.add(e2);
    }

    @Override
    public ListIterator<E> listIterator(int n2) {
        return new ListItr(n2);
    }

    private Entry<E> addBefore(E e2, Entry<E> entry) {
        Entry<E> entry2 = new Entry<E>(e2, entry, entry.previous);
        entry2.previous.next = entry2;
        entry2.next.previous = entry2;
        ++this.size;
        ++this.modCount;
        return entry2;
    }

    private E remove(Entry<E> entry) {
        if (entry == this.header) {
            throw new NoSuchElementException();
        }
        Object e2 = entry.element;
        entry.previous.next = entry.next;
        entry.next.previous = entry.previous;
        entry.previous = null;
        entry.next = null;
        entry.element = null;
        --this.size;
        ++this.modCount;
        return e2;
    }

    public Object clone() {
        LinkedList linkedList = null;
        try {
            linkedList = (LinkedList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        linkedList.header = new Entry<Object>(null, null, null);
        linkedList.header.previous = linkedList.header;
        linkedList.header.next = linkedList.header.previous;
        linkedList.size = 0;
        linkedList.modCount = 0;
        Entry entry = this.header.next;
        while (entry != this.header) {
            linkedList.add(entry.element);
            entry = entry.next;
        }
        return linkedList;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        int n2 = 0;
        Entry entry = this.header.next;
        while (entry != this.header) {
            objectArray[n2++] = entry.element;
            entry = entry.next;
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        int n2 = 0;
        T[] TArray = objectArray;
        Entry entry = this.header.next;
        while (entry != this.header) {
            TArray[n2++] = entry.element;
            entry = entry.next;
        }
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Entry entry = this.header.next;
        while (entry != this.header) {
            objectOutputStream.writeObject(entry.element);
            entry = entry.next;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.header = new Entry<Object>(null, null, null);
        this.header.previous = this.header;
        this.header.next = this.header.previous;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.addBefore(objectInputStream.readObject(), this.header);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<E> {
        E element;
        Entry<E> next;
        Entry<E> previous;

        Entry(E e2, Entry<E> entry, Entry<E> entry2) {
            this.element = e2;
            this.next = entry;
            this.previous = entry2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListItr
    implements ListIterator<E> {
        private Entry<E> lastReturned;
        private Entry<E> next;
        private int nextIndex;
        private int expectedModCount;

        ListItr(int n2) {
            this.lastReturned = LinkedList.this.header;
            this.expectedModCount = LinkedList.this.modCount;
            if (n2 < 0 || n2 > LinkedList.this.size) {
                throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + LinkedList.this.size);
            }
            if (n2 < LinkedList.this.size >> 1) {
                this.next = ((LinkedList)LinkedList.this).header.next;
                this.nextIndex = 0;
                while (this.nextIndex < n2) {
                    this.next = this.next.next;
                    ++this.nextIndex;
                }
            } else {
                this.next = LinkedList.this.header;
                this.nextIndex = LinkedList.this.size;
                while (this.nextIndex > n2) {
                    this.next = this.next.previous;
                    --this.nextIndex;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex != LinkedList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            if (this.nextIndex == LinkedList.this.size) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.element;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex != 0;
        }

        @Override
        public E previous() {
            if (this.nextIndex == 0) {
                throw new NoSuchElementException();
            }
            this.next = this.next.previous;
            this.lastReturned = this.next;
            --this.nextIndex;
            this.checkForComodification();
            return this.lastReturned.element;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            this.checkForComodification();
            Entry entry = this.lastReturned.next;
            try {
                LinkedList.this.remove(this.lastReturned);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IllegalStateException();
            }
            if (this.next == this.lastReturned) {
                this.next = entry;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = LinkedList.this.header;
            ++this.expectedModCount;
        }

        @Override
        public void set(E e2) {
            if (this.lastReturned == LinkedList.this.header) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.element = e2;
        }

        @Override
        public void add(E e2) {
            this.checkForComodification();
            this.lastReturned = LinkedList.this.header;
            LinkedList.this.addBefore(e2, this.next);
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        final void checkForComodification() {
            if (LinkedList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

