/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hashtable<K, V>
extends Dictionary<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private static final long serialVersionUID = 1421746759512286392L;
    private volatile transient Set<K> keySet = null;
    private volatile transient Set<Map.Entry<K, V>> entrySet = null;
    private volatile transient Collection<V> values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;
    private static Enumeration emptyEnumerator = new EmptyEnumerator();
    private static Iterator emptyIterator = new EmptyIterator();

    public Hashtable(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n2);
        }
        if (f2 <= 0.0f || Float.isNaN(f2)) {
            throw new IllegalArgumentException("Illegal Load: " + f2);
        }
        if (n2 == 0) {
            n2 = 1;
        }
        this.loadFactor = f2;
        this.table = new Entry[n2];
        this.threshold = (int)((float)n2 * f2);
    }

    public Hashtable(int n2) {
        this(n2, 0.75f);
    }

    public Hashtable() {
        this(11, 0.75f);
    }

    public Hashtable(Map<? extends K, ? extends V> map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    @Override
    public synchronized int size() {
        return this.count;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public synchronized Enumeration<K> keys() {
        return this.getEnumeration(0);
    }

    @Override
    public synchronized Enumeration<V> elements() {
        return this.getEnumeration(1);
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        while (n2-- > 0) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    @Override
    public synchronized boolean containsKey(Object object) {
        Entry[] entryArray = this.table;
        int n2 = object.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2 && entry.key.equals(object)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public synchronized V get(Object object) {
        Entry[] entryArray = this.table;
        int n2 = object.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2 && entry.key.equals(object)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    protected void rehash() {
        int n2 = this.table.length;
        Entry[] entryArray = this.table;
        int n3 = n2 * 2 + 1;
        Entry[] entryArray2 = new Entry[n3];
        ++this.modCount;
        this.threshold = (int)((float)n3 * this.loadFactor);
        this.table = entryArray2;
        int n4 = n2;
        while (n4-- > 0) {
            Entry entry = entryArray[n4];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n5 = (entry2.hash & Integer.MAX_VALUE) % n3;
                entry2.next = entryArray2[n5];
                entryArray2[n5] = entry2;
            }
        }
    }

    @Override
    public synchronized V put(K k2, V v2) {
        if (v2 == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n2 = k2.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2 && entry.key.equals(k2)) {
                Object v3 = entry.value;
                entry.value = v2;
                return v3;
            }
            entry = entry.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        }
        entry = entryArray[n3];
        entryArray[n3] = new Entry<K, V>(n2, k2, v2, entry);
        ++this.count;
        return null;
    }

    @Override
    public synchronized V remove(Object object) {
        Entry[] entryArray = this.table;
        int n2 = object.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n2 && entry.key.equals(object)) {
                ++this.modCount;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n3] = entry.next;
                }
                --this.count;
                Object v2 = entry.value;
                entry.value = null;
                return v2;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized void clear() {
        Entry[] entryArray = this.table;
        ++this.modCount;
        int n2 = entryArray.length;
        while (--n2 >= 0) {
            entryArray[n2] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        try {
            Hashtable hashtable = (Hashtable)super.clone();
            hashtable.table = new Entry[this.table.length];
            int n2 = this.table.length;
            while (n2-- > 0) {
                hashtable.table[n2] = this.table[n2] != null ? (Entry)this.table[n2].clone() : null;
            }
            hashtable.keySet = null;
            hashtable.entrySet = null;
            hashtable.values = null;
            hashtable.modCount = 0;
            return hashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized String toString() {
        int n2 = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        stringBuffer.append("{");
        for (int i2 = 0; i2 <= n2; ++i2) {
            Map.Entry<K, V> entry = iterator.next();
            K k2 = entry.getKey();
            V v2 = entry.getValue();
            stringBuffer.append((k2 == this ? "(this Map)" : "" + k2) + "=" + (v2 == this ? "(this Map)" : "" + v2));
            if (i2 >= n2) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private <T> Enumeration<T> getEnumeration(int n2) {
        if (this.count == 0) {
            return emptyEnumerator;
        }
        return new Enumerator(n2, false);
    }

    private <T> Iterator<T> getIterator(int n2) {
        if (this.count == 0) {
            return emptyIterator;
        }
        return new Enumerator(n2, true);
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = Collections.synchronizedSet(new KeySet(), this);
        }
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = Collections.synchronizedSet(new EntrySet(), this);
        }
        return this.entrySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = Collections.synchronizedCollection(new ValueCollection(), this);
        }
        return this.values;
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> entry : this.entrySet()) {
                K k2 = entry.getKey();
                V v2 = entry.getValue();
                if (!(v2 == null ? map.get(k2) != null || !map.containsKey(k2) : !v2.equals(map.get(k2)))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    @Override
    public synchronized int hashCode() {
        int n2 = 0;
        if (this.count == 0 || this.loadFactor < 0.0f) {
            return n2;
        }
        this.loadFactor = -this.loadFactor;
        Entry[] entryArray = this.table;
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            Entry entry = entryArray[i2];
            while (entry != null) {
                n2 += entry.key.hashCode() ^ entry.value.hashCode();
                entry = entry.next;
            }
        }
        this.loadFactor = -this.loadFactor;
        return n2;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        for (int i2 = this.table.length - 1; i2 >= 0; --i2) {
            Entry entry = this.table[i2];
            while (entry != null) {
                objectOutputStream.writeObject(entry.key);
                objectOutputStream.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        int n3 = objectInputStream.readInt();
        int n4 = (int)((float)n3 * this.loadFactor) + n3 / 20 + 3;
        if (n4 > n3 && (n4 & 1) == 0) {
            --n4;
        }
        if (n2 > 0 && n4 > n2) {
            n4 = n2;
        }
        this.table = new Entry[n4];
        this.count = 0;
        while (n3 > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.reconstitutionPut(object, object2);
            --n3;
        }
    }

    private void reconstitutionPut(K k2, V v2) throws StreamCorruptedException {
        if (v2 == null) {
            throw new StreamCorruptedException();
        }
        Entry[] entryArray = this.table;
        int n2 = k2.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2 && entry.key.equals(k2)) {
                throw new StreamCorruptedException();
            }
            entry = entry.next;
        }
        entry = entryArray[n3];
        entryArray[n3] = new Entry<K, V>(n2, k2, v2, entry);
        ++this.count;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyEnumerator
    implements Enumeration<Object> {
        EmptyEnumerator() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public Object nextElement() {
            throw new NoSuchElementException("Hashtable Enumerator");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyIterator
    implements Iterator<Object> {
        EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException("Hashtable Iterator");
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Hashtable Iterator");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        int hash;
        K key;
        V value;
        Entry<K, V> next;

        protected Entry(int n2, K k2, V v2, Entry<K, V> entry) {
            this.hash = n2;
            this.key = k2;
            this.value = v2;
            this.next = entry;
        }

        protected Object clone() {
            return new Entry<K, V>(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v2) {
            if (v2 == null) {
                throw new NullPointerException();
            }
            V v3 = this.value;
            this.value = v2;
            return v3;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        @Override
        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key.toString() + "=" + this.value.toString();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return Hashtable.this.getIterator(2);
        }

        public boolean add(Object object) {
            return super.add(object);
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k2 = entry.getKey();
            Entry[] entryArray = Hashtable.this.table;
            int n2 = k2.hashCode();
            int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
            Entry entry2 = entryArray[n3];
            while (entry2 != null) {
                if (entry2.hash == n2 && entry2.equals(entry)) {
                    return true;
                }
                entry2 = entry2.next;
            }
            return false;
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k2 = entry.getKey();
            Entry[] entryArray = Hashtable.this.table;
            int n2 = k2.hashCode();
            int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
            Entry entry2 = entryArray[n3];
            Entry entry3 = null;
            while (entry2 != null) {
                if (entry2.hash == n2 && entry2.equals(entry)) {
                    Hashtable.this.modCount++;
                    if (entry3 != null) {
                        entry3.next = entry2.next;
                    } else {
                        entryArray[n3] = entry2.next;
                    }
                    Hashtable.this.count--;
                    entry2.value = null;
                    return true;
                }
                entry3 = entry2;
                entry2 = entry2.next;
            }
            return false;
        }

        public int size() {
            return Hashtable.this.count;
        }

        public void clear() {
            Hashtable.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Enumerator<T>
    implements Enumeration<T>,
    Iterator<T> {
        Entry[] table;
        int index;
        Entry<K, V> entry;
        Entry<K, V> lastReturned;
        int type;
        boolean iterator;
        protected int expectedModCount;

        Enumerator(int n2, boolean bl2) {
            this.table = Hashtable.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = Hashtable.this.modCount;
            this.type = n2;
            this.iterator = bl2;
        }

        @Override
        public boolean hasMoreElements() {
            Entry entry = this.entry;
            int n2 = this.index;
            Entry[] entryArray = this.table;
            while (entry == null && n2 > 0) {
                entry = entryArray[--n2];
            }
            this.entry = entry;
            this.index = n2;
            return entry != null;
        }

        @Override
        public T nextElement() {
            Entry entry = this.entry;
            int n2 = this.index;
            Entry[] entryArray = this.table;
            while (entry == null && n2 > 0) {
                entry = entryArray[--n2];
            }
            this.entry = entry;
            this.index = n2;
            if (entry != null) {
                this.lastReturned = this.entry;
                Entry entry2 = this.lastReturned;
                this.entry = entry2.next;
                return (T)(this.type == 0 ? entry2.key : (this.type == 1 ? entry2.value : entry2));
            }
            throw new NoSuchElementException("Hashtable Enumerator");
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements();
        }

        @Override
        public T next() {
            if (Hashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextElement();
        }

        @Override
        public void remove() {
            if (!this.iterator) {
                throw new UnsupportedOperationException();
            }
            if (this.lastReturned == null) {
                throw new IllegalStateException("Hashtable Enumerator");
            }
            if (Hashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                Entry[] entryArray = Hashtable.this.table;
                int n2 = (this.lastReturned.hash & Integer.MAX_VALUE) % entryArray.length;
                Entry entry = entryArray[n2];
                Entry entry2 = null;
                while (entry != null) {
                    if (entry == this.lastReturned) {
                        Hashtable.this.modCount++;
                        ++this.expectedModCount;
                        if (entry2 == null) {
                            entryArray[n2] = entry.next;
                        } else {
                            entry2.next = entry.next;
                        }
                        Hashtable.this.count--;
                        this.lastReturned = null;
                        return;
                    }
                    entry2 = entry;
                    entry = entry.next;
                }
                throw new ConcurrentModificationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return Hashtable.this.getIterator(0);
        }

        @Override
        public int size() {
            return Hashtable.this.count;
        }

        @Override
        public boolean contains(Object object) {
            return Hashtable.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return Hashtable.this.remove(object) != null;
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueCollection
    extends AbstractCollection<V> {
        private ValueCollection() {
        }

        @Override
        public Iterator<V> iterator() {
            return Hashtable.this.getIterator(1);
        }

        @Override
        public int size() {
            return Hashtable.this.count;
        }

        @Override
        public boolean contains(Object object) {
            return Hashtable.this.containsValue(object);
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }
    }
}

