/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.text.resources.LocaleData;

public final class Currency
implements Serializable {
    private static final long serialVersionUID = -158308464356906721L;
    private final String currencyCode;
    private final transient int defaultFractionDigits;
    private static HashMap instances = new HashMap(7);
    static String mainTable;
    static long[] scCutOverTimes;
    static String[] scOldCurrencies;
    static String[] scNewCurrencies;
    static int[] scOldCurrenciesDFD;
    static int[] scNewCurrenciesDFD;
    static String otherCurrencies;
    static int[] otherCurrenciesDFD;
    private static final int A_TO_Z = 26;
    private static final int INVALID_COUNTRY_ENTRY = 127;
    private static final int COUNTRY_WITHOUT_CURRENCY_ENTRY = 128;
    private static final int SIMPLE_CASE_COUNTRY_MASK = 0;
    private static final int SIMPLE_CASE_COUNTRY_FINAL_CHAR_MASK = 31;
    private static final int SIMPLE_CASE_COUNTRY_DEFAULT_DIGITS_MASK = 96;
    private static final int SIMPLE_CASE_COUNTRY_DEFAULT_DIGITS_SHIFT = 5;
    private static final int SPECIAL_CASE_COUNTRY_MASK = 128;
    private static final int SPECIAL_CASE_COUNTRY_INDEX_MASK = 31;
    private static final int SPECIAL_CASE_COUNTRY_INDEX_DELTA = 1;
    private static final int COUNTRY_TYPE_MASK = 128;

    private Currency(String string, int n2) {
        this.currencyCode = string;
        this.defaultFractionDigits = n2;
    }

    public static Currency getInstance(String string) {
        return Currency.getInstance(string, Integer.MIN_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Currency getInstance(String string, int n2) {
        HashMap hashMap = instances;
        synchronized (hashMap) {
            Currency currency = (Currency)instances.get(string);
            if (currency != null) {
                return currency;
            }
            if (n2 == Integer.MIN_VALUE) {
                char c2;
                if (string.length() != 3) {
                    throw new IllegalArgumentException();
                }
                char c3 = string.charAt(0);
                int n3 = Currency.getMainTableEntry(c3, c2 = string.charAt(1));
                if ((n3 & 0x80) == 0 && n3 != 127 && string.charAt(2) - 65 == (n3 & 0x1F)) {
                    n2 = (n3 & 0x60) >> 5;
                } else {
                    if (string.charAt(2) == '-') {
                        throw new IllegalArgumentException();
                    }
                    int n4 = otherCurrencies.indexOf(string);
                    if (n4 == -1) {
                        throw new IllegalArgumentException();
                    }
                    n2 = otherCurrenciesDFD[n4 / 4];
                }
            }
            currency = new Currency(string, n2);
            instances.put(string, currency);
            return currency;
        }
    }

    public static Currency getInstance(Locale locale) {
        char c2;
        String string = locale.getCountry();
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() != 2) {
            throw new IllegalArgumentException();
        }
        char c3 = string.charAt(0);
        int n2 = Currency.getMainTableEntry(c3, c2 = string.charAt(1));
        if ((n2 & 0x80) == 0 && n2 != 127) {
            char c4 = (char)((n2 & 0x1F) + 65);
            int n3 = (n2 & 0x60) >> 5;
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(c4);
            return Currency.getInstance(stringBuffer.toString(), n3);
        }
        if (n2 == 127) {
            throw new IllegalArgumentException();
        }
        if (n2 == 128) {
            return null;
        }
        int n4 = (n2 & 0x1F) - 1;
        if (scCutOverTimes[n4] == Long.MAX_VALUE || System.currentTimeMillis() < scCutOverTimes[n4]) {
            return Currency.getInstance(scOldCurrencies[n4], scOldCurrenciesDFD[n4]);
        }
        return Currency.getInstance(scNewCurrencies[n4], scNewCurrenciesDFD[n4]);
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getSymbol() {
        return this.getSymbol(Locale.getDefault());
    }

    public String getSymbol(Locale locale) {
        ResourceBundle resourceBundle;
        try {
            resourceBundle = LocaleData.getLocaleElements(locale);
        }
        catch (MissingResourceException missingResourceException) {
            return this.currencyCode;
        }
        String[][] stringArray = (String[][])resourceBundle.getObject("CurrencySymbols");
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!stringArray[i2][0].equals(this.currencyCode)) continue;
                return stringArray[i2][1];
            }
        }
        return this.currencyCode;
    }

    public int getDefaultFractionDigits() {
        return this.defaultFractionDigits;
    }

    public String toString() {
        return this.currencyCode;
    }

    private Object readResolve() {
        return Currency.getInstance(this.currencyCode);
    }

    private static int getMainTableEntry(char c2, char c3) {
        if (c2 < 'A' || c2 > 'Z' || c3 < 'A' || c3 > 'Z') {
            throw new IllegalArgumentException();
        }
        return mainTable.charAt((c2 - 65) * 26 + (c3 - 65));
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = Class.forName("java.util.CurrencyData");
                    mainTable = (String)clazz.getDeclaredField("mainTable").get(clazz);
                    scCutOverTimes = (long[])clazz.getDeclaredField("scCutOverTimes").get(clazz);
                    scOldCurrencies = (String[])clazz.getDeclaredField("scOldCurrencies").get(clazz);
                    scNewCurrencies = (String[])clazz.getDeclaredField("scNewCurrencies").get(clazz);
                    scOldCurrenciesDFD = (int[])clazz.getDeclaredField("scOldCurrenciesDFD").get(clazz);
                    scNewCurrenciesDFD = (int[])clazz.getDeclaredField("scNewCurrenciesDFD").get(clazz);
                    otherCurrencies = (String)clazz.getDeclaredField("otherCurrencies").get(clazz);
                    otherCurrenciesDFD = (int[])clazz.getDeclaredField("otherCurrenciesDFD").get(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InternalError();
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new InternalError();
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new InternalError();
                }
                return null;
            }
        });
    }
}

