/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509Extension;
import java.util.Date;
import javax.security.auth.x500.X500Principal;

public abstract class X509CRLEntry
implements X509Extension {
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509CRLEntry)) {
            return false;
        }
        try {
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = ((X509CRLEntry)object).getEncoded();
            if (byArray.length != byArray2.length) {
                return false;
            }
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                if (byArray[i2] == byArray2[i2]) continue;
                return false;
            }
        }
        catch (CRLException cRLException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        try {
            byte[] byArray = this.getEncoded();
            for (int i2 = 1; i2 < byArray.length; ++i2) {
                n2 += byArray[i2] * i2;
            }
        }
        catch (CRLException cRLException) {
            return n2;
        }
        return n2;
    }

    public abstract byte[] getEncoded() throws CRLException;

    public abstract BigInteger getSerialNumber();

    public X500Principal getCertificateIssuer() {
        return null;
    }

    public abstract Date getRevocationDate();

    public abstract boolean hasExtensions();

    public abstract String toString();
}

