/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.HeapCharBufferR;

class HeapCharBuffer
extends CharBuffer {
    HeapCharBuffer(int n2, int n3) {
        super(-1, 0, n3, n2, new char[n2], 0);
    }

    HeapCharBuffer(char[] cArray, int n2, int n3) {
        super(-1, n2, n2 + n3, cArray.length, cArray, 0);
    }

    protected HeapCharBuffer(char[] cArray, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5, cArray, n6);
    }

    public CharBuffer slice() {
        return new HeapCharBuffer(this.hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    public CharBuffer duplicate() {
        return new HeapCharBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public CharBuffer asReadOnlyBuffer() {
        return new HeapCharBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n2) {
        return n2 + this.offset;
    }

    public char get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    public char get(int n2) {
        return this.hb[this.ix(this.checkIndex(n2))];
    }

    public CharBuffer get(char[] cArray, int n2, int n3) {
        HeapCharBuffer.checkBounds(n2, n3, cArray.length);
        if (n3 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(this.position()), cArray, n2, n3);
        this.position(this.position() + n3);
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public CharBuffer put(char c2) {
        this.hb[this.ix((int)this.nextPutIndex())] = c2;
        return this;
    }

    public CharBuffer put(int n2, char c2) {
        this.hb[this.ix((int)this.checkIndex((int)n2))] = c2;
        return this;
    }

    public CharBuffer put(char[] cArray, int n2, int n3) {
        HeapCharBuffer.checkBounds(n2, n3, cArray.length);
        if (n3 > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(cArray, n2, this.hb, this.ix(this.position()), n3);
        this.position(this.position() + n3);
        return this;
    }

    public CharBuffer put(CharBuffer charBuffer) {
        if (charBuffer instanceof HeapCharBuffer) {
            if (charBuffer == this) {
                throw new IllegalArgumentException();
            }
            HeapCharBuffer heapCharBuffer = (HeapCharBuffer)charBuffer;
            int n2 = heapCharBuffer.remaining();
            if (n2 > this.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(heapCharBuffer.hb, heapCharBuffer.ix(heapCharBuffer.position()), this.hb, this.ix(this.position()), n2);
            heapCharBuffer.position(heapCharBuffer.position() + n2);
            this.position(this.position() + n2);
        } else if (charBuffer.isDirect()) {
            int n3 = charBuffer.remaining();
            if (n3 > this.remaining()) {
                throw new BufferOverflowException();
            }
            charBuffer.get(this.hb, this.ix(this.position()), n3);
            this.position(this.position() + n3);
        } else {
            super.put(charBuffer);
        }
        return this;
    }

    public CharBuffer compact() {
        System.arraycopy(this.hb, this.ix(this.position()), this.hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        return this;
    }

    String toString(int n2, int n3) {
        try {
            return new String(this.hb, n2 + this.offset, n3 - n2);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public CharSequence subSequence(int n2, int n3) {
        if (n2 < 0 || n3 > this.length() || n2 > n3) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n3 - n2;
        return new HeapCharBuffer(this.hb, -1, 0, n4, n4, this.offset + this.position() + n2);
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

