/*
 * Decompiled with CFR 0.152.
 */
package java.awt.print;

import java.awt.AWTError;
import java.awt.HeadlessException;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.PrintRequestAttributeSet;

public abstract class PrinterJob {
    public static PrinterJob getPrinterJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return (PrinterJob)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("java.awt.printerjob", null);
                try {
                    return (PrinterJob)Class.forName(string).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AWTError("PrinterJob not found: " + string);
                }
                catch (InstantiationException instantiationException) {
                    throw new AWTError("Could not instantiate PrinterJob: " + string);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AWTError("Could not access PrinterJob: " + string);
                }
            }
        });
    }

    public static PrintService[] lookupPrintServices() {
        return PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
    }

    public static StreamPrintServiceFactory[] lookupStreamPrintServices(String string) {
        return StreamPrintServiceFactory.lookupStreamPrintServiceFactories(DocFlavor.SERVICE_FORMATTED.PAGEABLE, string);
    }

    public PrintService getPrintService() {
        return null;
    }

    public void setPrintService(PrintService printService) throws PrinterException {
        throw new PrinterException("Setting a service is not supported on this class");
    }

    public abstract void setPrintable(Printable var1);

    public abstract void setPrintable(Printable var1, PageFormat var2);

    public abstract void setPageable(Pageable var1) throws NullPointerException;

    public abstract boolean printDialog() throws HeadlessException;

    public boolean printDialog(PrintRequestAttributeSet printRequestAttributeSet) throws HeadlessException {
        if (printRequestAttributeSet == null) {
            throw new NullPointerException("attributes");
        }
        return this.printDialog();
    }

    public abstract PageFormat pageDialog(PageFormat var1) throws HeadlessException;

    public PageFormat pageDialog(PrintRequestAttributeSet printRequestAttributeSet) throws HeadlessException {
        if (printRequestAttributeSet == null) {
            throw new NullPointerException("attributes");
        }
        return this.pageDialog(this.defaultPage());
    }

    public abstract PageFormat defaultPage(PageFormat var1);

    public PageFormat defaultPage() {
        return this.defaultPage(new PageFormat());
    }

    public abstract PageFormat validatePage(PageFormat var1);

    public abstract void print() throws PrinterException;

    public void print(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        this.print();
    }

    public abstract void setCopies(int var1);

    public abstract int getCopies();

    public abstract String getUserName();

    public abstract void setJobName(String var1);

    public abstract String getJobName();

    public abstract void cancel();

    public abstract boolean isCancelled();
}

