/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import sun.awt.image.ImagingLib;

public class BandCombineOp
implements RasterOp {
    float[][] matrix;
    int nrows = 0;
    int ncols = 0;
    RenderingHints hints;

    public BandCombineOp(float[][] fArray, RenderingHints renderingHints) {
        this.nrows = fArray.length;
        this.ncols = fArray[0].length;
        this.matrix = new float[this.nrows][this.ncols + 1];
        for (int i2 = 0; i2 < this.nrows; ++i2) {
            System.arraycopy(fArray[i2], 0, this.matrix[i2], 0, this.ncols);
        }
        this.hints = renderingHints;
    }

    public final float[][] getMatrix() {
        return (float[][])this.matrix.clone();
    }

    public WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        int n2 = raster.getNumBands();
        if (this.ncols != n2 && this.ncols != n2 + 1) {
            throw new IllegalArgumentException("Number of columns in the matrix (" + this.ncols + ") must be equal to the number" + " of bands ([+1]) in src (" + n2 + ").");
        }
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        } else if (this.nrows != writableRaster.getNumBands()) {
            throw new IllegalArgumentException("Number of rows in the matrix (" + this.nrows + ") must be equal to the number" + " of bands ([+1]) in dst (" + n2 + ").");
        }
        if (ImagingLib.filter(this, raster, writableRaster) != null) {
            return writableRaster;
        }
        int[] nArray = null;
        int[] nArray2 = new int[writableRaster.getNumBands()];
        int n3 = raster.getMinX();
        int n4 = raster.getMinY();
        int n5 = writableRaster.getMinX();
        int n6 = writableRaster.getMinY();
        if (this.ncols == n2) {
            int n7 = 0;
            while (n7 < raster.getHeight()) {
                int n8 = n5;
                int n9 = n3;
                int n10 = 0;
                while (n10 < raster.getWidth()) {
                    nArray = raster.getPixel(n9, n4, nArray);
                    for (int i2 = 0; i2 < this.nrows; ++i2) {
                        float f2 = 0.0f;
                        for (int i3 = 0; i3 < this.ncols; ++i3) {
                            f2 += this.matrix[i2][i3] * (float)nArray[i3];
                        }
                        nArray2[i2] = (int)f2;
                    }
                    writableRaster.setPixel(n8, n6, nArray2);
                    ++n10;
                    ++n9;
                    ++n8;
                }
                ++n7;
                ++n4;
                ++n6;
            }
        } else {
            int n11 = 0;
            while (n11 < raster.getHeight()) {
                int n12 = n5;
                int n13 = n3;
                int n14 = 0;
                while (n14 < raster.getWidth()) {
                    nArray = raster.getPixel(n13, n4, nArray);
                    for (int i4 = 0; i4 < this.nrows; ++i4) {
                        float f3 = 0.0f;
                        for (int i5 = 0; i5 < n2; ++i5) {
                            f3 += this.matrix[i4][i5] * (float)nArray[i5];
                        }
                        nArray2[i4] = (int)(f3 + this.matrix[i4][n2]);
                    }
                    writableRaster.setPixel(n12, n6, nArray2);
                    ++n14;
                    ++n13;
                    ++n12;
                }
                ++n11;
                ++n4;
                ++n6;
            }
        }
        return writableRaster;
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        int n2 = raster.getNumBands();
        if (this.ncols != n2 && this.ncols != n2 + 1) {
            throw new IllegalArgumentException("Number of columns in the matrix (" + this.ncols + ") must be equal to the number" + " of bands ([+1]) in src (" + n2 + ").");
        }
        if (raster.getNumBands() == this.nrows) {
            return raster.createCompatibleWritableRaster();
        }
        throw new IllegalArgumentException("Don't know how to create a  compatible Raster with " + this.nrows + " bands.");
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Float();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }
}

