/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.font.CharArrayIterator;
import java.awt.font.FontRenderContext;
import java.awt.font.GraphicAttribute;
import java.awt.font.LineMetrics;
import java.awt.font.NumericShaper;
import java.awt.font.StyledParagraph;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.font.TextLine;
import java.text.AttributedCharacterIterator;
import java.text.Bidi;
import java.text.BreakIterator;
import java.util.Hashtable;
import java.util.Map;
import sun.font.BidiUtils;
import sun.font.TextLabelFactory;
import sun.font.TextLineComponent;

public final class TextMeasurer
implements Cloneable {
    private static float EST_LINES = 2.1f;
    private FontRenderContext fFrc;
    private int fStart;
    private char[] fChars;
    private Bidi fBidi;
    private byte[] fLevels;
    private TextLineComponent[] fComponents;
    private int fComponentStart;
    private int fComponentLimit;
    private boolean haveLayoutWindow;
    private BreakIterator fLineBreak = null;
    private CharArrayIterator charIter = null;
    int layoutCount = 0;
    int layoutCharCount = 0;
    private StyledParagraph fParagraph;
    private boolean fIsDirectionLTR;
    private byte fBaseline;
    private float[] fBaselineOffsets;
    private float fJustifyRatio = 1.0f;
    private int formattedChars = 0;
    private static boolean wantStats = false;
    private boolean collectStats = false;

    public TextMeasurer(AttributedCharacterIterator attributedCharacterIterator, FontRenderContext fontRenderContext) {
        this.fFrc = fontRenderContext;
        this.initAll(attributedCharacterIterator);
    }

    protected Object clone() {
        TextMeasurer textMeasurer;
        try {
            textMeasurer = (TextMeasurer)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
        if (this.fComponents != null) {
            textMeasurer.fComponents = (TextLineComponent[])this.fComponents.clone();
        }
        return textMeasurer;
    }

    private void invalidateComponents() {
        this.fComponentStart = this.fComponentLimit = this.fChars.length;
        this.fComponents = null;
        this.haveLayoutWindow = false;
    }

    private void initAll(AttributedCharacterIterator attributedCharacterIterator) {
        this.fStart = attributedCharacterIterator.getBeginIndex();
        this.fChars = new char[attributedCharacterIterator.getEndIndex() - this.fStart];
        int n2 = 0;
        char c2 = attributedCharacterIterator.first();
        while (true) {
            if (c2 == '\uffff') break;
            this.fChars[n2++] = c2;
            c2 = attributedCharacterIterator.next();
        }
        attributedCharacterIterator.first();
        this.fBidi = new Bidi(attributedCharacterIterator);
        if (this.fBidi.isLeftToRight()) {
            this.fBidi = null;
        }
        attributedCharacterIterator.first();
        Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
        if (map != null) {
            try {
                NumericShaper numericShaper = (NumericShaper)map.get(TextAttribute.NUMERIC_SHAPING);
                if (numericShaper != null) {
                    numericShaper.shape(this.fChars, 0, this.fChars.length);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.fParagraph = new StyledParagraph(attributedCharacterIterator, this.fChars);
        this.fJustifyRatio = TextLine.getJustifyRatio(map);
        boolean bl2 = TextLine.advanceToFirstFont(attributedCharacterIterator);
        if (bl2) {
            Font font = TextLine.getFontAtCurrentPos(attributedCharacterIterator);
            int n3 = attributedCharacterIterator.getIndex() - attributedCharacterIterator.getBeginIndex();
            LineMetrics lineMetrics = font.getLineMetrics(this.fChars, n3, n3 + 1, this.fFrc);
            this.fBaseline = (byte)lineMetrics.getBaselineIndex();
            this.fBaselineOffsets = lineMetrics.getBaselineOffsets();
        } else {
            GraphicAttribute graphicAttribute = (GraphicAttribute)map.get(TextAttribute.CHAR_REPLACEMENT);
            this.fBaseline = TextLayout.getBaselineFromGraphic(graphicAttribute);
            Font font = new Font(new Hashtable(5, 0.9f));
            LineMetrics lineMetrics = font.getLineMetrics(" ", 0, 1, this.fFrc);
            this.fBaselineOffsets = lineMetrics.getBaselineOffsets();
        }
        this.fBaselineOffsets = TextLine.getNormalizedOffsets(this.fBaselineOffsets, this.fBaseline);
        this.invalidateComponents();
    }

    private void generateComponents(int n2, int n3) {
        if (this.collectStats) {
            this.formattedChars += n3 - n2;
        }
        int n4 = 0;
        TextLabelFactory textLabelFactory = new TextLabelFactory(this.fFrc, this.fChars, this.fBidi, n4);
        int[] nArray = null;
        if (this.fBidi != null) {
            this.fLevels = BidiUtils.getLevels(this.fBidi);
            int[] nArray2 = BidiUtils.createVisualToLogicalMap(this.fLevels);
            nArray = BidiUtils.createInverseMap(nArray2);
            this.fIsDirectionLTR = this.fBidi.baseIsLeftToRight();
        } else {
            this.fLevels = null;
            this.fIsDirectionLTR = true;
        }
        try {
            this.fComponents = TextLine.getComponents(this.fParagraph, this.fChars, n2, n3, nArray, this.fLevels, textLabelFactory);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("startingAt=" + n2 + "; endingAt=" + n3);
            System.out.println("fComponentLimit=" + this.fComponentLimit);
            throw illegalArgumentException;
        }
        this.fComponentStart = n2;
        this.fComponentLimit = n3;
    }

    private int calcLineBreak(int n2, float f2) {
        int n3;
        int n4;
        int n5 = n2;
        float f3 = f2;
        int n6 = this.fComponentStart;
        for (n4 = 0; n4 < this.fComponents.length && (n3 = n6 + this.fComponents[n4].getNumCharacters()) <= n5; ++n4) {
            n6 = n3;
        }
        while (n4 < this.fComponents.length) {
            TextLineComponent textLineComponent = this.fComponents[n4];
            int n7 = textLineComponent.getNumCharacters();
            int n8 = textLineComponent.getLineBreakIndex(n5 - n6, f3);
            if (n8 == n7 && n4 < this.fComponents.length) {
                f3 -= textLineComponent.getAdvanceBetween(n5 - n6, n8);
            } else {
                return n6 + n8;
            }
            n5 = n6 += n7;
            ++n4;
        }
        if (this.fComponentLimit < this.fChars.length) {
            this.generateComponents(n2, this.fChars.length);
            return this.calcLineBreak(n2, f2);
        }
        return this.fChars.length;
    }

    private int trailingCdWhitespaceStart(int n2, int n3) {
        if (this.fLevels != null) {
            byte by = (byte)(!this.fIsDirectionLTR ? 1 : 0);
            int n4 = n3;
            while (--n4 >= n2) {
                if (this.fLevels[n4] % 2 != by && Character.getDirectionality(this.fChars[n4]) == 12) continue;
                return ++n4;
            }
        }
        return n2;
    }

    private TextLineComponent[] makeComponentsOnRange(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = this.trailingCdWhitespaceStart(n2, n3);
        int n8 = this.fComponentStart;
        for (n6 = 0; n6 < this.fComponents.length && (n5 = n8 + this.fComponents[n6].getNumCharacters()) <= n2; ++n6) {
            n8 = n5;
        }
        boolean bl2 = false;
        int n9 = n8;
        int n10 = n6;
        int n11 = 1;
        while (n11 != 0) {
            n4 = n9 + this.fComponents[n10].getNumCharacters();
            if (n7 > Math.max(n9, n2) && n7 < Math.min(n4, n3)) {
                bl2 = true;
            }
            if (n4 >= n3) {
                n11 = 0;
            } else {
                n9 = n4;
            }
            ++n10;
        }
        n5 = n10 - n6;
        if (bl2) {
            ++n5;
        }
        TextLineComponent[] textLineComponentArray = new TextLineComponent[n5];
        n9 = 0;
        n10 = n2;
        n11 = n7;
        if (n11 == n2) {
            n4 = this.fIsDirectionLTR ? 0 : 1;
            n11 = n3;
        } else {
            n4 = 2;
        }
        while (n10 < n3) {
            int n12 = this.fComponents[n6].getNumCharacters();
            int n13 = n8 + n12;
            int n14 = Math.max(n10, n8);
            int n15 = Math.min(n11, n13);
            textLineComponentArray[n9++] = this.fComponents[n6].getSubset(n14 - n8, n15 - n8, n4);
            if ((n10 += n15 - n14) == n11) {
                n11 = n3;
                int n16 = n4 = this.fIsDirectionLTR ? 0 : 1;
            }
            if (n10 != n13) continue;
            ++n6;
            n8 = n13;
        }
        return textLineComponentArray;
    }

    private TextLine makeTextLineOnRange(int n2, int n3) {
        TextLineComponent[] textLineComponentArray;
        int[] nArray = null;
        byte[] byArray = null;
        if (this.fBidi != null) {
            textLineComponentArray = this.fBidi.createLineBidi(n2, n3);
            byArray = BidiUtils.getLevels((Bidi)textLineComponentArray);
            int[] nArray2 = BidiUtils.createVisualToLogicalMap(byArray);
            nArray = BidiUtils.createInverseMap(nArray2);
        }
        textLineComponentArray = this.makeComponentsOnRange(n2, n3);
        return new TextLine(textLineComponentArray, this.fBaselineOffsets, this.fChars, n2, n3, nArray, byArray, this.fIsDirectionLTR);
    }

    private void ensureComponents(int n2, int n3) {
        if (n2 < this.fComponentStart || n3 > this.fComponentLimit) {
            this.generateComponents(n2, n3);
        }
    }

    private void makeLayoutWindow(int n2) {
        int n3 = n2;
        int n4 = this.fChars.length;
        if (this.layoutCount > 0 && !this.haveLayoutWindow) {
            float f2 = Math.max(this.layoutCharCount / this.layoutCount, 1);
            n4 = Math.min(n2 + (int)(f2 * EST_LINES), this.fChars.length);
        }
        if (n2 > 0 || n4 < this.fChars.length) {
            if (this.charIter == null) {
                this.charIter = new CharArrayIterator(this.fChars);
            } else {
                this.charIter.reset(this.fChars);
            }
            if (this.fLineBreak == null) {
                this.fLineBreak = BreakIterator.getLineInstance();
            }
            this.fLineBreak.setText(this.charIter);
            if (n2 > 0 && !this.fLineBreak.isBoundary(n2)) {
                n3 = this.fLineBreak.preceding(n2);
            }
            if (n4 < this.fChars.length && !this.fLineBreak.isBoundary(n4)) {
                n4 = this.fLineBreak.following(n4);
            }
        }
        this.ensureComponents(n3, n4);
        this.haveLayoutWindow = true;
    }

    public int getLineBreakIndex(int n2, float f2) {
        int n3 = n2 - this.fStart;
        if (!this.haveLayoutWindow || n3 < this.fComponentStart || n3 >= this.fComponentLimit) {
            this.makeLayoutWindow(n3);
        }
        return this.calcLineBreak(n3, f2) + this.fStart;
    }

    public float getAdvanceBetween(int n2, int n3) {
        int n4 = n2 - this.fStart;
        int n5 = n3 - this.fStart;
        this.ensureComponents(n4, n5);
        TextLine textLine = this.makeTextLineOnRange(n4, n5);
        return textLine.getMetrics().advance;
    }

    public TextLayout getLayout(int n2, int n3) {
        int n4 = n2 - this.fStart;
        int n5 = n3 - this.fStart;
        this.ensureComponents(n4, n5);
        TextLine textLine = this.makeTextLineOnRange(n4, n5);
        if (n5 < this.fChars.length) {
            this.layoutCharCount += n3 - n2;
            ++this.layoutCount;
        }
        return new TextLayout(textLine, this.fBaseline, this.fBaselineOffsets, this.fJustifyRatio);
    }

    private void printStats() {
        System.out.println("formattedChars: " + this.formattedChars);
        this.collectStats = false;
    }

    public void insertChar(AttributedCharacterIterator attributedCharacterIterator, int n2) {
        char c2;
        if (this.collectStats) {
            this.printStats();
        }
        if (wantStats) {
            this.collectStats = true;
        }
        this.fStart = attributedCharacterIterator.getBeginIndex();
        int n3 = attributedCharacterIterator.getEndIndex();
        if (n3 - this.fStart != this.fChars.length + 1) {
            this.initAll(attributedCharacterIterator);
        }
        char[] cArray = new char[n3 - this.fStart];
        int n4 = n2 - this.fStart;
        System.arraycopy(this.fChars, 0, cArray, 0, n4);
        cArray[n4] = c2 = attributedCharacterIterator.setIndex(n2);
        System.arraycopy(this.fChars, n4, cArray, n4 + 1, n3 - n2 - 1);
        this.fChars = cArray;
        if (this.fBidi != null || Bidi.requiresBidi(cArray, n4, n4 + 1) || attributedCharacterIterator.getAttribute(TextAttribute.BIDI_EMBEDDING) != null) {
            this.fBidi = new Bidi(attributedCharacterIterator);
            if (this.fBidi.isLeftToRight()) {
                this.fBidi = null;
            }
        }
        this.fParagraph = StyledParagraph.insertChar(attributedCharacterIterator, this.fChars, n2, this.fParagraph);
        this.invalidateComponents();
    }

    public void deleteChar(AttributedCharacterIterator attributedCharacterIterator, int n2) {
        this.fStart = attributedCharacterIterator.getBeginIndex();
        int n3 = attributedCharacterIterator.getEndIndex();
        if (n3 - this.fStart != this.fChars.length - 1) {
            this.initAll(attributedCharacterIterator);
        }
        char[] cArray = new char[n3 - this.fStart];
        int n4 = n2 - this.fStart;
        System.arraycopy(this.fChars, 0, cArray, 0, n2 - this.fStart);
        System.arraycopy(this.fChars, n4 + 1, cArray, n4, n3 - n2);
        this.fChars = cArray;
        if (this.fBidi != null) {
            this.fBidi = new Bidi(attributedCharacterIterator);
            if (this.fBidi.isLeftToRight()) {
                this.fBidi = null;
            }
        }
        this.fParagraph = StyledParagraph.deleteChar(attributedCharacterIterator, this.fChars, n2, this.fParagraph);
        this.invalidateComponents();
    }

    char[] getChars() {
        return this.fChars;
    }
}

