/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.util;

import com.sun.org.apache.xerces.internal.impl.xs.util.SimpleLocator;
import com.sun.org.apache.xerces.internal.jaxp.validation.WrappedSAXException;
import com.sun.org.apache.xerces.internal.util.LocatorWrapper;
import com.sun.org.apache.xerces.internal.util.NamespaceSupport;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.XMLAttributesImpl;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLDocumentHandler;
import com.sun.org.apache.xerces.internal.xni.XMLLocator;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import com.sun.org.apache.xerces.internal.xni.parser.XMLDocumentSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAX2XNI
implements ContentHandler,
XMLDocumentSource {
    private XMLDocumentHandler fCore;
    private final NamespaceSupport nsContext = new NamespaceSupport();
    private final SymbolTable symbolTable = new SymbolTable();
    private Locator locator;
    private final XMLAttributes xa = new XMLAttributesImpl();

    public SAX2XNI(XMLDocumentHandler xMLDocumentHandler) {
        this.fCore = xMLDocumentHandler;
    }

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fCore = xMLDocumentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fCore;
    }

    public void startDocument() throws SAXException {
        try {
            this.nsContext.reset();
            XMLLocator xMLLocator = this.locator == null ? new SimpleLocator(null, null, -1, -1) : new LocatorWrapper(this.locator);
            this.fCore.startDocument(xMLLocator, null, this.nsContext, null);
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.fCore.endDocument(null);
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            this.fCore.startElement(this.createQName(string, string2, string3), this.createAttributes(attributes), null);
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.fCore.endElement(this.createQName(string, string2, string3), null);
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        try {
            this.fCore.characters(new XMLString(cArray, n2, n3), null);
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        try {
            this.fCore.ignorableWhitespace(new XMLString(cArray, n2, n3), null);
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    public void startPrefixMapping(String string, String string2) {
        this.nsContext.pushContext();
        this.nsContext.declarePrefix(string, string2);
    }

    public void endPrefixMapping(String string) {
        this.nsContext.popContext();
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            this.fCore.processingInstruction(this.symbolize(string), this.createXMLString(string2), null);
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    public void skippedEntity(String string) {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private QName createQName(String string, String string2, String string3) {
        int n2 = string3.indexOf(58);
        if (string2.length() == 0) {
            string = "";
            string2 = n2 < 0 ? string3 : string3.substring(n2 + 1);
        }
        String string4 = n2 < 0 ? null : string3.substring(0, n2);
        if (string != null && string.length() == 0) {
            string = null;
        }
        return new QName(this.symbolize(string4), this.symbolize(string2), this.symbolize(string3), this.symbolize(string));
    }

    private String symbolize(String string) {
        if (string == null) {
            return null;
        }
        return this.symbolTable.addSymbol(string);
    }

    private XMLString createXMLString(String string) {
        return new XMLString(string.toCharArray(), 0, string.length());
    }

    private XMLAttributes createAttributes(Attributes attributes) {
        this.xa.removeAllAttributes();
        int n2 = attributes.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.xa.addAttribute(this.createQName(attributes.getURI(i2), attributes.getLocalName(i2), attributes.getQName(i2)), attributes.getType(i2), attributes.getValue(i2));
        }
        return this.xa;
    }
}

