/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.regexp.internal;

import com.sun.org.apache.regexp.internal.REProgram;
import com.sun.org.apache.regexp.internal.RESyntaxException;
import java.util.Hashtable;

public class RECompiler {
    char[] instruction = new char[128];
    int lenInstruction = 0;
    String pattern;
    int len;
    int idx;
    int parens;
    static final int NODE_NORMAL = 0;
    static final int NODE_NULLABLE = 1;
    static final int NODE_TOPLEVEL = 2;
    static final char ESC_MASK = '\ufff0';
    static final char ESC_BACKREF = '\uffff';
    static final char ESC_COMPLEX = '\ufffe';
    static final char ESC_CLASS = '\ufffd';
    static final int maxBrackets = 10;
    static int brackets = 0;
    static int[] bracketStart = null;
    static int[] bracketEnd = null;
    static int[] bracketMin = null;
    static int[] bracketOpt = null;
    static final int bracketUnbounded = -1;
    static final int bracketFinished = -2;
    static Hashtable hashPOSIX = new Hashtable();

    void ensure(int n2) {
        int n3 = this.instruction.length;
        if (this.lenInstruction + n2 >= n3) {
            while (this.lenInstruction + n2 >= n3) {
                n3 *= 2;
            }
            char[] cArray = new char[n3];
            System.arraycopy(this.instruction, 0, cArray, 0, this.lenInstruction);
            this.instruction = cArray;
        }
    }

    void emit(char c2) {
        this.ensure(1);
        this.instruction[this.lenInstruction++] = c2;
    }

    void nodeInsert(char c2, int n2, int n3) {
        this.ensure(3);
        System.arraycopy(this.instruction, n3, this.instruction, n3 + 3, this.lenInstruction - n3);
        this.instruction[n3 + 0] = c2;
        this.instruction[n3 + 1] = (char)n2;
        this.instruction[n3 + 2] = '\u0000';
        this.lenInstruction += 3;
    }

    void setNextOfEnd(int n2, int n3) {
        char c2;
        while ((c2 = this.instruction[n2 + 2]) != '\u0000') {
            n2 += c2;
        }
        this.instruction[n2 + 2] = (char)(n3 - n2);
    }

    int node(char c2, int n2) {
        this.ensure(3);
        this.instruction[this.lenInstruction + 0] = c2;
        this.instruction[this.lenInstruction + 1] = (char)n2;
        this.instruction[this.lenInstruction + 2] = '\u0000';
        this.lenInstruction += 3;
        return this.lenInstruction - 3;
    }

    void internalError() throws Error {
        throw new Error("Internal error!");
    }

    void syntaxError(String string) throws RESyntaxException {
        throw new RESyntaxException(string);
    }

    void allocBrackets() {
        if (bracketStart == null) {
            bracketStart = new int[10];
            bracketEnd = new int[10];
            bracketMin = new int[10];
            bracketOpt = new int[10];
            for (int i2 = 0; i2 < 10; ++i2) {
                RECompiler.bracketOpt[i2] = -1;
                RECompiler.bracketMin[i2] = -1;
                RECompiler.bracketEnd[i2] = -1;
                RECompiler.bracketStart[i2] = -1;
            }
        }
    }

    void bracket() throws RESyntaxException {
        if (this.idx >= this.len || this.pattern.charAt(this.idx++) != '{') {
            this.internalError();
        }
        if (this.idx >= this.len || !Character.isDigit(this.pattern.charAt(this.idx))) {
            this.syntaxError("Expected digit");
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx))) {
            stringBuffer.append(this.pattern.charAt(this.idx++));
        }
        try {
            RECompiler.bracketMin[RECompiler.brackets] = Integer.parseInt(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            this.syntaxError("Expected valid number");
        }
        if (this.idx >= this.len) {
            this.syntaxError("Expected comma or right bracket");
        }
        if (this.pattern.charAt(this.idx) == '}') {
            ++this.idx;
            RECompiler.bracketOpt[RECompiler.brackets] = 0;
            return;
        }
        if (this.idx >= this.len || this.pattern.charAt(this.idx++) != ',') {
            this.syntaxError("Expected comma");
        }
        if (this.idx >= this.len) {
            this.syntaxError("Expected comma or right bracket");
        }
        if (this.pattern.charAt(this.idx) == '}') {
            ++this.idx;
            RECompiler.bracketOpt[RECompiler.brackets] = -1;
            return;
        }
        if (this.idx >= this.len || !Character.isDigit(this.pattern.charAt(this.idx))) {
            this.syntaxError("Expected digit");
        }
        stringBuffer.setLength(0);
        while (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx))) {
            stringBuffer.append(this.pattern.charAt(this.idx++));
        }
        try {
            RECompiler.bracketOpt[RECompiler.brackets] = Integer.parseInt(stringBuffer.toString()) - bracketMin[brackets];
        }
        catch (NumberFormatException numberFormatException) {
            this.syntaxError("Expected valid number");
        }
        if (bracketOpt[brackets] <= 0) {
            this.syntaxError("Bad range");
        }
        if (this.idx >= this.len || this.pattern.charAt(this.idx++) != '}') {
            this.syntaxError("Missing close brace");
        }
    }

    char escape() throws RESyntaxException {
        if (this.pattern.charAt(this.idx) != '\\') {
            this.internalError();
        }
        if (this.idx + 1 == this.len) {
            this.syntaxError("Escape terminates string");
        }
        this.idx += 2;
        char c2 = this.pattern.charAt(this.idx - 1);
        switch (c2) {
            case 'B': 
            case 'b': {
                return '\ufffe';
            }
            case 'D': 
            case 'S': 
            case 'W': 
            case 'd': 
            case 's': 
            case 'w': {
                return '\ufffd';
            }
            case 'u': 
            case 'x': {
                int n2 = c2 == 'u' ? 4 : 2;
                int n3 = 0;
                while (this.idx < this.len && n2-- > 0) {
                    char c3 = this.pattern.charAt(this.idx);
                    if (c3 >= '0' && c3 <= '9') {
                        n3 = (n3 << 4) + c3 - 48;
                    } else if ((c3 = Character.toLowerCase(c3)) >= 'a' && c3 <= 'f') {
                        n3 = (n3 << 4) + (c3 - 97) + 10;
                    } else {
                        this.syntaxError("Expected " + n2 + " hexadecimal digits after \\" + c2);
                    }
                    ++this.idx;
                }
                return (char)n3;
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx)) || c2 == '0') {
                    int n4 = c2 - 48;
                    if (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx))) {
                        n4 = (n4 << 3) + (this.pattern.charAt(this.idx++) - 48);
                        if (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx))) {
                            n4 = (n4 << 3) + (this.pattern.charAt(this.idx++) - 48);
                        }
                    }
                    return (char)n4;
                }
                return '\uffff';
            }
        }
        return c2;
    }

    int characterClass() throws RESyntaxException {
        int n2;
        int n3;
        int n4;
        if (this.pattern.charAt(this.idx) != '[') {
            this.internalError();
        }
        if (this.idx + 1 >= this.len || this.pattern.charAt(++this.idx) == ']') {
            this.syntaxError("Empty or unterminated class");
        }
        if (this.idx < this.len && this.pattern.charAt(this.idx) == ':') {
            ++this.idx;
            n4 = this.idx;
            while (this.idx < this.len && this.pattern.charAt(this.idx) >= 'a' && this.pattern.charAt(this.idx) <= 'z') {
                ++this.idx;
            }
            if (this.idx + 1 < this.len && this.pattern.charAt(this.idx) == ':' && this.pattern.charAt(this.idx + 1) == ']') {
                String string = this.pattern.substring(n4, this.idx);
                Character c2 = (Character)hashPOSIX.get(string);
                if (c2 != null) {
                    this.idx += 2;
                    return this.node('P', c2.charValue());
                }
                this.syntaxError("Invalid POSIX character class '" + string + "'");
            }
            this.syntaxError("Invalid POSIX character class syntax");
        }
        n4 = this.node('[', 0);
        int n5 = n3 = 65535;
        int n6 = 0;
        boolean bl2 = true;
        boolean bl3 = false;
        int n7 = this.idx;
        int n8 = 0;
        RERange rERange = new RERange();
        block16: while (this.idx < this.len && this.pattern.charAt(this.idx) != ']') {
            switch (this.pattern.charAt(this.idx)) {
                case '^': {
                    boolean bl4 = bl2 = !bl2;
                    if (this.idx == n7) {
                        rERange.include(0, 65535, true);
                    }
                    ++this.idx;
                    continue block16;
                }
                case '\\': {
                    n2 = this.escape();
                    switch (n2) {
                        case 65534: 
                        case 65535: {
                            this.syntaxError("Bad character class");
                        }
                        case 65533: {
                            if (bl3) {
                                this.syntaxError("Bad character class");
                            }
                            switch (this.pattern.charAt(this.idx - 1)) {
                                case 'D': 
                                case 'S': 
                                case 'W': {
                                    this.syntaxError("Bad character class");
                                }
                                case 's': {
                                    rERange.include('\t', bl2);
                                    rERange.include('\r', bl2);
                                    rERange.include('\f', bl2);
                                    rERange.include('\n', bl2);
                                    rERange.include('\b', bl2);
                                    rERange.include(' ', bl2);
                                    break;
                                }
                                case 'w': {
                                    rERange.include(97, 122, bl2);
                                    rERange.include(65, 90, bl2);
                                    rERange.include('_', bl2);
                                }
                                case 'd': {
                                    rERange.include(48, 57, bl2);
                                }
                            }
                            n5 = n3;
                            continue block16;
                        }
                    }
                    n6 = n2;
                    break;
                }
                case '-': {
                    if (bl3) {
                        this.syntaxError("Bad class range");
                    }
                    bl3 = true;
                    int n9 = n8 = n5 == n3 ? 0 : n5;
                    if (this.idx + 1 >= this.len || this.pattern.charAt(++this.idx) != ']') continue block16;
                    n6 = 65535;
                    break;
                }
                default: {
                    n6 = this.pattern.charAt(this.idx++);
                }
            }
            if (bl3) {
                int n10 = n6;
                if (n8 >= n10) {
                    this.syntaxError("Bad character class");
                }
                rERange.include(n8, n10, bl2);
                n5 = n3;
                bl3 = false;
                continue;
            }
            if (this.idx + 1 >= this.len || this.pattern.charAt(this.idx + 1) != '-') {
                rERange.include((char)n6, bl2);
            }
            n5 = n6;
        }
        if (this.idx == this.len) {
            this.syntaxError("Unterminated character class");
        }
        ++this.idx;
        this.instruction[n4 + 1] = (char)rERange.num;
        for (n2 = 0; n2 < rERange.num; ++n2) {
            this.emit((char)rERange.minRange[n2]);
            this.emit((char)rERange.maxRange[n2]);
        }
        return n4;
    }

    /*
     * Unable to fully structure code
     */
    int atom() throws RESyntaxException {
        var1_1 = this.node('A', 0);
        var2_2 = 0;
        block8: while (this.idx < this.len) {
            if (this.idx + 1 >= this.len) ** GOTO lbl-1000
            var3_3 = this.pattern.charAt(this.idx + 1);
            if (this.pattern.charAt(this.idx) == '\\') {
                var4_4 = this.idx;
                this.escape();
                if (this.idx < this.len) {
                    var3_3 = this.pattern.charAt(this.idx);
                }
                this.idx = var4_4;
            }
            switch (var3_3) {
                case 42: 
                case 43: 
                case 63: 
                case 123: {
                    if (var2_2 != 0) break block8;
                }
                default: lbl-1000:
                // 2 sources

                {
                    switch (this.pattern.charAt(this.idx)) {
                        case '$': 
                        case '(': 
                        case ')': 
                        case '.': 
                        case '[': 
                        case ']': 
                        case '^': 
                        case '|': {
                            break block8;
                        }
                        case '*': 
                        case '+': 
                        case '?': 
                        case '{': {
                            if (var2_2 != 0) break block8;
                            this.syntaxError("Missing operand to closure");
                            break block8;
                        }
                        case '\\': {
                            var3_3 = this.idx;
                            var4_4 = this.escape();
                            if ((var4_4 & 65520) == 65520) {
                                this.idx = var3_3;
                                break block8;
                            }
                            this.emit((char)var4_4);
                            ++var2_2;
                            continue block8;
                        }
                        default: {
                            this.emit(this.pattern.charAt(this.idx++));
                            ++var2_2;
                            continue block8;
                        }
                    }
                }
            }
        }
        if (var2_2 == 0) {
            this.internalError();
        }
        this.instruction[var1_1 + 1] = (char)var2_2;
        return var1_1;
    }

    int terminal(int[] nArray) throws RESyntaxException {
        switch (this.pattern.charAt(this.idx)) {
            case '$': 
            case '.': 
            case '^': {
                return this.node(this.pattern.charAt(this.idx++), 0);
            }
            case '[': {
                return this.characterClass();
            }
            case '(': {
                return this.expr(nArray);
            }
            case ')': {
                this.syntaxError("Unexpected close paren");
            }
            case '|': {
                this.internalError();
            }
            case ']': {
                this.syntaxError("Mismatched class");
            }
            case '\u0000': {
                this.syntaxError("Unexpected end of input");
            }
            case '*': 
            case '+': 
            case '?': 
            case '{': {
                this.syntaxError("Missing operand to closure");
            }
            case '\\': {
                int n2 = this.idx;
                switch (this.escape()) {
                    case '\ufffd': 
                    case '\ufffe': {
                        nArray[0] = nArray[0] & 0xFFFFFFFE;
                        return this.node('\\', this.pattern.charAt(this.idx - 1));
                    }
                    case '\uffff': {
                        char c2 = (char)(this.pattern.charAt(this.idx - 1) - 48);
                        if (this.parens <= c2) {
                            this.syntaxError("Bad backreference");
                        }
                        nArray[0] = nArray[0] | 1;
                        return this.node('#', c2);
                    }
                }
                this.idx = n2;
                nArray[0] = nArray[0] & 0xFFFFFFFE;
            }
        }
        nArray[0] = nArray[0] & 0xFFFFFFFE;
        return this.atom();
    }

    /*
     * Enabled aggressive block sorting
     */
    int closure(int[] nArray) throws RESyntaxException {
        int n2;
        int n3 = this.idx;
        int[] nArray2 = new int[]{0};
        int n4 = this.terminal(nArray2);
        nArray[0] = nArray[0] | nArray2[0];
        if (this.idx >= this.len) {
            return n4;
        }
        boolean bl2 = true;
        int n5 = this.pattern.charAt(this.idx);
        switch (n5) {
            case 42: 
            case 63: {
                nArray[0] = nArray[0] | 1;
            }
            case 43: {
                ++this.idx;
            }
            case 123: {
                n2 = this.instruction[n4 + 0];
                if (n2 == 94 || n2 == 36) {
                    this.syntaxError("Bad closure operand");
                }
                if ((nArray2[0] & 1) == 0) break;
                this.syntaxError("Closure operand can't be nullable");
                break;
            }
        }
        if (this.idx < this.len && this.pattern.charAt(this.idx) == '?') {
            ++this.idx;
            bl2 = false;
        }
        if (bl2) {
            switch (n5) {
                case 123: {
                    int n6;
                    n2 = 0;
                    this.allocBrackets();
                    for (n6 = 0; n6 < brackets; ++n6) {
                        if (bracketStart[n6] != this.idx) continue;
                        n2 = 1;
                        break;
                    }
                    if (n2 == 0) {
                        if (brackets >= 10) {
                            this.syntaxError("Too many bracketed closures (limit is 10)");
                        }
                        RECompiler.bracketStart[RECompiler.brackets] = this.idx;
                        this.bracket();
                        RECompiler.bracketEnd[RECompiler.brackets] = this.idx;
                        n6 = brackets++;
                    }
                    int n7 = n6;
                    bracketMin[n7] = bracketMin[n7] - 1;
                    if (bracketMin[n7] > 0) {
                        this.idx = n3;
                        return n4;
                    }
                    if (bracketOpt[n6] == -2) {
                        n5 = 42;
                        RECompiler.bracketOpt[n6] = 0;
                        this.idx = bracketEnd[n6];
                    } else {
                        if (bracketOpt[n6] == -1) {
                            this.idx = n3;
                            RECompiler.bracketOpt[n6] = -2;
                            return n4;
                        }
                        int n8 = n6;
                        int n9 = bracketOpt[n8];
                        bracketOpt[n8] = n9 - 1;
                        if (n9 <= 0) {
                            this.idx = bracketEnd[n6];
                            return n4;
                        }
                        this.idx = n3;
                        n5 = 63;
                    }
                }
                case 42: 
                case 63: {
                    if (!bl2) {
                        return n4;
                    }
                    if (n5 == 63) {
                        this.nodeInsert('|', 0, n4);
                        this.setNextOfEnd(n4, this.node('|', 0));
                        n2 = this.node('N', 0);
                        this.setNextOfEnd(n4, n2);
                        this.setNextOfEnd(n4 + 3, n2);
                    }
                    if (n5 != 42) return n4;
                    this.nodeInsert('|', 0, n4);
                    this.setNextOfEnd(n4 + 3, this.node('|', 0));
                    this.setNextOfEnd(n4 + 3, this.node('G', 0));
                    this.setNextOfEnd(n4 + 3, n4);
                    this.setNextOfEnd(n4, this.node('|', 0));
                    this.setNextOfEnd(n4, this.node('N', 0));
                    return n4;
                }
                case 43: {
                    n2 = this.node('|', 0);
                    this.setNextOfEnd(n4, n2);
                    this.setNextOfEnd(this.node('G', 0), n4);
                    this.setNextOfEnd(n2, this.node('|', 0));
                    this.setNextOfEnd(n4, this.node('N', 0));
                    return n4;
                }
            }
            return n4;
        }
        this.setNextOfEnd(n4, this.node('E', 0));
        switch (n5) {
            case 63: {
                this.nodeInsert('/', 0, n4);
                break;
            }
            case 42: {
                this.nodeInsert('8', 0, n4);
                break;
            }
            case 43: {
                this.nodeInsert('=', 0, n4);
                break;
            }
        }
        this.setNextOfEnd(n4, this.lenInstruction);
        return n4;
    }

    int branch(int[] nArray) throws RESyntaxException {
        int n2 = this.node('|', 0);
        int n3 = -1;
        int[] nArray2 = new int[1];
        boolean bl2 = true;
        while (this.idx < this.len && this.pattern.charAt(this.idx) != '|' && this.pattern.charAt(this.idx) != ')') {
            nArray2[0] = 0;
            int n4 = this.closure(nArray2);
            if (nArray2[0] == 0) {
                bl2 = false;
            }
            if (n3 != -1) {
                this.setNextOfEnd(n3, n4);
            }
            n3 = n4;
        }
        if (n3 == -1) {
            this.node('N', 0);
        }
        if (bl2) {
            nArray[0] = nArray[0] | 1;
        }
        return n2;
    }

    int expr(int[] nArray) throws RESyntaxException {
        int n2;
        boolean bl2 = false;
        int n3 = -1;
        int n4 = this.parens;
        if ((nArray[0] & 2) == 0 && this.pattern.charAt(this.idx) == '(') {
            ++this.idx;
            bl2 = true;
            n3 = this.node('(', this.parens++);
        }
        nArray[0] = nArray[0] & 0xFFFFFFFD;
        int n5 = this.branch(nArray);
        if (n3 == -1) {
            n3 = n5;
        } else {
            this.setNextOfEnd(n3, n5);
        }
        while (this.idx < this.len && this.pattern.charAt(this.idx) == '|') {
            ++this.idx;
            n5 = this.branch(nArray);
            this.setNextOfEnd(n3, n5);
        }
        if (bl2) {
            if (this.idx < this.len && this.pattern.charAt(this.idx) == ')') {
                ++this.idx;
            } else {
                this.syntaxError("Missing close paren");
            }
            n2 = this.node(')', n4);
        } else {
            n2 = this.node('E', 0);
        }
        this.setNextOfEnd(n3, n2);
        int n6 = -1;
        int n7 = n3;
        while (n6 != 0) {
            if (this.instruction[n7 + 0] == '|') {
                this.setNextOfEnd(n7 + 3, n2);
            }
            n6 = this.instruction[n7 + 2];
            n7 += n6;
        }
        return n3;
    }

    public REProgram compile(String string) throws RESyntaxException {
        this.pattern = string;
        this.len = string.length();
        this.idx = 0;
        this.lenInstruction = 0;
        this.parens = 1;
        brackets = 0;
        int[] nArray = new int[]{2};
        this.expr(nArray);
        if (this.idx != this.len) {
            if (string.charAt(this.idx) == ')') {
                this.syntaxError("Unmatched close paren");
            }
            this.syntaxError("Unexpected input remains");
        }
        char[] cArray = new char[this.lenInstruction];
        System.arraycopy(this.instruction, 0, cArray, 0, this.lenInstruction);
        return new REProgram(cArray);
    }

    static {
        hashPOSIX.put("alnum", new Character('w'));
        hashPOSIX.put("alpha", new Character('a'));
        hashPOSIX.put("blank", new Character('b'));
        hashPOSIX.put("cntrl", new Character('c'));
        hashPOSIX.put("digit", new Character('d'));
        hashPOSIX.put("graph", new Character('g'));
        hashPOSIX.put("lower", new Character('l'));
        hashPOSIX.put("print", new Character('p'));
        hashPOSIX.put("punct", new Character('!'));
        hashPOSIX.put("space", new Character('s'));
        hashPOSIX.put("upper", new Character('u'));
        hashPOSIX.put("xdigit", new Character('x'));
        hashPOSIX.put("javastart", new Character('j'));
        hashPOSIX.put("javapart", new Character('k'));
    }

    class RERange {
        int size = 16;
        int[] minRange = new int[this.size];
        int[] maxRange = new int[this.size];
        int num = 0;

        RERange() {
        }

        void delete(int n2) {
            if (this.num == 0 || n2 >= this.num) {
                return;
            }
            while (n2++ < this.num) {
                if (n2 - 1 < 0) continue;
                this.minRange[n2 - 1] = this.minRange[n2];
                this.maxRange[n2 - 1] = this.maxRange[n2];
            }
            --this.num;
        }

        void merge(int n2, int n3) {
            for (int i2 = 0; i2 < this.num; ++i2) {
                if (n2 >= this.minRange[i2] && n3 <= this.maxRange[i2]) {
                    return;
                }
                if (n2 <= this.minRange[i2] && n3 >= this.maxRange[i2]) {
                    this.delete(i2);
                    this.merge(n2, n3);
                    return;
                }
                if (n2 >= this.minRange[i2] && n2 <= this.maxRange[i2]) {
                    this.delete(i2);
                    n2 = this.minRange[i2];
                    this.merge(n2, n3);
                    return;
                }
                if (n3 < this.minRange[i2] || n3 > this.maxRange[i2]) continue;
                this.delete(i2);
                n3 = this.maxRange[i2];
                this.merge(n2, n3);
                return;
            }
            if (this.num >= this.size) {
                this.size *= 2;
                int[] nArray = new int[this.size];
                int[] nArray2 = new int[this.size];
                System.arraycopy(this.minRange, 0, nArray, 0, this.num);
                System.arraycopy(this.maxRange, 0, nArray2, 0, this.num);
                this.minRange = nArray;
                this.maxRange = nArray2;
            }
            this.minRange[this.num] = n2;
            this.maxRange[this.num] = n3;
            ++this.num;
        }

        void remove(int n2, int n3) {
            for (int i2 = 0; i2 < this.num; ++i2) {
                if (this.minRange[i2] >= n2 && this.maxRange[i2] <= n3) {
                    this.delete(i2);
                    --i2;
                    return;
                }
                if (n2 >= this.minRange[i2] && n3 <= this.maxRange[i2]) {
                    int n4 = this.minRange[i2];
                    int n5 = this.maxRange[i2];
                    this.delete(i2);
                    if (n4 < n2 - 1) {
                        this.merge(n4, n2 - 1);
                    }
                    if (n3 + 1 < n5) {
                        this.merge(n3 + 1, n5);
                    }
                    return;
                }
                if (this.minRange[i2] >= n2 && this.minRange[i2] <= n3) {
                    this.minRange[i2] = n3 + 1;
                    return;
                }
                if (this.maxRange[i2] < n2 || this.maxRange[i2] > n3) continue;
                this.maxRange[i2] = n2 - 1;
                return;
            }
        }

        void include(int n2, int n3, boolean bl2) {
            if (bl2) {
                this.merge(n2, n3);
            } else {
                this.remove(n2, n3);
            }
        }

        void include(char c2, boolean bl2) {
            this.include(c2, c2, bl2);
        }
    }
}

