/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.verifier.statics;

import com.sun.org.apache.bcel.internal.Repository;
import com.sun.org.apache.bcel.internal.classfile.AccessFlags;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.CodeException;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantFieldref;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantInterfaceMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.LineNumber;
import com.sun.org.apache.bcel.internal.classfile.LineNumberTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.generic.ALOAD;
import com.sun.org.apache.bcel.internal.generic.ANEWARRAY;
import com.sun.org.apache.bcel.internal.generic.ASTORE;
import com.sun.org.apache.bcel.internal.generic.ATHROW;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.BREAKPOINT;
import com.sun.org.apache.bcel.internal.generic.CHECKCAST;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.DLOAD;
import com.sun.org.apache.bcel.internal.generic.DSTORE;
import com.sun.org.apache.bcel.internal.generic.EmptyVisitor;
import com.sun.org.apache.bcel.internal.generic.FLOAD;
import com.sun.org.apache.bcel.internal.generic.FSTORE;
import com.sun.org.apache.bcel.internal.generic.FieldInstruction;
import com.sun.org.apache.bcel.internal.generic.GETSTATIC;
import com.sun.org.apache.bcel.internal.generic.GotoInstruction;
import com.sun.org.apache.bcel.internal.generic.IINC;
import com.sun.org.apache.bcel.internal.generic.ILOAD;
import com.sun.org.apache.bcel.internal.generic.IMPDEP1;
import com.sun.org.apache.bcel.internal.generic.IMPDEP2;
import com.sun.org.apache.bcel.internal.generic.INSTANCEOF;
import com.sun.org.apache.bcel.internal.generic.INVOKEINTERFACE;
import com.sun.org.apache.bcel.internal.generic.INVOKESPECIAL;
import com.sun.org.apache.bcel.internal.generic.INVOKESTATIC;
import com.sun.org.apache.bcel.internal.generic.INVOKEVIRTUAL;
import com.sun.org.apache.bcel.internal.generic.ISTORE;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.InvokeInstruction;
import com.sun.org.apache.bcel.internal.generic.JsrInstruction;
import com.sun.org.apache.bcel.internal.generic.LDC;
import com.sun.org.apache.bcel.internal.generic.LDC2_W;
import com.sun.org.apache.bcel.internal.generic.LLOAD;
import com.sun.org.apache.bcel.internal.generic.LOOKUPSWITCH;
import com.sun.org.apache.bcel.internal.generic.LSTORE;
import com.sun.org.apache.bcel.internal.generic.LoadClass;
import com.sun.org.apache.bcel.internal.generic.MULTIANEWARRAY;
import com.sun.org.apache.bcel.internal.generic.NEW;
import com.sun.org.apache.bcel.internal.generic.NEWARRAY;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.PUTSTATIC;
import com.sun.org.apache.bcel.internal.generic.RET;
import com.sun.org.apache.bcel.internal.generic.ReturnInstruction;
import com.sun.org.apache.bcel.internal.generic.TABLESWITCH;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.verifier.PassVerifier;
import com.sun.org.apache.bcel.internal.verifier.VerificationResult;
import com.sun.org.apache.bcel.internal.verifier.Verifier;
import com.sun.org.apache.bcel.internal.verifier.VerifierFactory;
import com.sun.org.apache.bcel.internal.verifier.exc.AssertionViolatedException;
import com.sun.org.apache.bcel.internal.verifier.exc.ClassConstraintException;
import com.sun.org.apache.bcel.internal.verifier.exc.InvalidMethodException;
import com.sun.org.apache.bcel.internal.verifier.exc.StaticCodeConstraintException;
import com.sun.org.apache.bcel.internal.verifier.exc.StaticCodeInstructionConstraintException;
import com.sun.org.apache.bcel.internal.verifier.exc.StaticCodeInstructionOperandConstraintException;
import com.sun.org.apache.bcel.internal.verifier.statics.IntList;

public final class Pass3aVerifier
extends PassVerifier {
    private Verifier myOwner;
    private int method_no;
    InstructionList instructionList;
    Code code;

    public Pass3aVerifier(Verifier verifier, int n2) {
        this.myOwner = verifier;
        this.method_no = n2;
    }

    public VerificationResult do_verify() {
        if (this.myOwner.doPass2().equals(VerificationResult.VR_OK)) {
            JavaClass javaClass = Repository.lookupClass(this.myOwner.getClassName());
            Method[] methodArray = javaClass.getMethods();
            if (this.method_no >= methodArray.length) {
                throw new InvalidMethodException("METHOD DOES NOT EXIST!");
            }
            Method method = methodArray[this.method_no];
            this.code = method.getCode();
            if (method.isAbstract() || method.isNative()) {
                return VerificationResult.VR_OK;
            }
            try {
                this.instructionList = new InstructionList(method.getCode().getCode());
            }
            catch (RuntimeException runtimeException) {
                return new VerificationResult(2, "Bad bytecode in the code array of the Code attribute of method '" + method + "'.");
            }
            this.instructionList.setPositions(true);
            VerificationResult verificationResult = VerificationResult.VR_OK;
            try {
                this.delayedPass2Checks();
            }
            catch (ClassConstraintException classConstraintException) {
                verificationResult = new VerificationResult(2, classConstraintException.getMessage());
                return verificationResult;
            }
            try {
                this.pass3StaticInstructionChecks();
                this.pass3StaticInstructionOperandsChecks();
            }
            catch (StaticCodeConstraintException staticCodeConstraintException) {
                verificationResult = new VerificationResult(2, staticCodeConstraintException.getMessage());
            }
            return verificationResult;
        }
        return VerificationResult.VR_NOTYET;
    }

    private void delayedPass2Checks() {
        int n2;
        int n3;
        int n4;
        Cloneable[] cloneableArray;
        int[] nArray = this.instructionList.getInstructionPositions();
        int n5 = this.code.getCode().length;
        LineNumberTable lineNumberTable = this.code.getLineNumberTable();
        if (lineNumberTable != null) {
            cloneableArray = lineNumberTable.getLineNumberTable();
            IntList intList = new IntList();
            block0: for (n4 = 0; n4 < cloneableArray.length; ++n4) {
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    n3 = ((LineNumber)cloneableArray[n4]).getStartPC();
                    if (nArray[i2] != n3) continue;
                    if (intList.contains(n3)) {
                        this.addMessage("LineNumberTable attribute '" + this.code.getLineNumberTable() + "' refers to the same code offset ('" + n3 + "') more than once which is violating the semantics [but is sometimes produced by IBM's 'jikes' compiler].");
                        continue block0;
                    }
                    intList.add(n3);
                    continue block0;
                }
                throw new ClassConstraintException("Code attribute '" + this.code + "' has a LineNumberTable attribute '" + this.code.getLineNumberTable() + "' referring to a code offset ('" + ((LineNumber)cloneableArray[n4]).getStartPC() + "') that does not exist.");
            }
        }
        cloneableArray = this.code.getAttributes();
        for (int i3 = 0; i3 < cloneableArray.length; ++i3) {
            LocalVariableTable localVariableTable;
            if (!(cloneableArray[i3] instanceof LocalVariableTable) || (localVariableTable = (LocalVariableTable)cloneableArray[i3]) == null) continue;
            LocalVariable[] localVariableArray = localVariableTable.getLocalVariableTable();
            for (n3 = 0; n3 < localVariableArray.length; ++n3) {
                n2 = localVariableArray[n3].getStartPC();
                int n6 = localVariableArray[n3].getLength();
                if (!Pass3aVerifier.contains(nArray, n2)) {
                    throw new ClassConstraintException("Code attribute '" + this.code + "' has a LocalVariableTable attribute '" + this.code.getLocalVariableTable() + "' referring to a code offset ('" + n2 + "') that does not exist.");
                }
                if (Pass3aVerifier.contains(nArray, n2 + n6) || n2 + n6 == n5) continue;
                throw new ClassConstraintException("Code attribute '" + this.code + "' has a LocalVariableTable attribute '" + this.code.getLocalVariableTable() + "' referring to a code offset start_pc+length ('" + (n2 + n6) + "') that does not exist.");
            }
        }
        CodeException[] codeExceptionArray = this.code.getExceptionTable();
        for (n4 = 0; n4 < codeExceptionArray.length; ++n4) {
            int n7 = codeExceptionArray[n4].getStartPC();
            n3 = codeExceptionArray[n4].getEndPC();
            n2 = codeExceptionArray[n4].getHandlerPC();
            if (n7 >= n3) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + codeExceptionArray[n4] + "' that has its start_pc ('" + n7 + "') not smaller than its end_pc ('" + n3 + "').");
            }
            if (!Pass3aVerifier.contains(nArray, n7)) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + codeExceptionArray[n4] + "' that has a non-existant bytecode offset as its start_pc ('" + n7 + "').");
            }
            if (!Pass3aVerifier.contains(nArray, n3) && n3 != n5) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + codeExceptionArray[n4] + "' that has a non-existant bytecode offset as its end_pc ('" + n7 + "') [that is also not equal to code_length ('" + n5 + "')].");
            }
            if (Pass3aVerifier.contains(nArray, n2)) continue;
            throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + codeExceptionArray[n4] + "' that has a non-existant bytecode offset as its handler_pc ('" + n2 + "').");
        }
    }

    private void pass3StaticInstructionChecks() {
        Instruction instruction;
        if (this.code.getCode().length >= 65536) {
            throw new StaticCodeInstructionConstraintException("Code array in code attribute '" + this.code + "' too big: must be smaller than 65536 bytes.");
        }
        for (InstructionHandle instructionHandle = this.instructionList.getStart(); instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
            instruction = instructionHandle.getInstruction();
            if (instruction instanceof IMPDEP1) {
                throw new StaticCodeInstructionConstraintException("IMPDEP1 must not be in the code, it is an illegal instruction for _internal_ JVM use!");
            }
            if (instruction instanceof IMPDEP2) {
                throw new StaticCodeInstructionConstraintException("IMPDEP2 must not be in the code, it is an illegal instruction for _internal_ JVM use!");
            }
            if (!(instruction instanceof BREAKPOINT)) continue;
            throw new StaticCodeInstructionConstraintException("BREAKPOINT must not be in the code, it is an illegal instruction for _internal_ JVM use!");
        }
        instruction = this.instructionList.getEnd().getInstruction();
        if (!(instruction instanceof ReturnInstruction || instruction instanceof RET || instruction instanceof GotoInstruction || instruction instanceof ATHROW)) {
            throw new StaticCodeInstructionConstraintException("Execution must not fall off the bottom of the code array. This constraint is enforced statically as some existing verifiers do - so it may be a false alarm if the last instruction is not reachable.");
        }
    }

    private void pass3StaticInstructionOperandsChecks() {
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(Repository.lookupClass(this.myOwner.getClassName()).getConstantPool());
        InstOperandConstraintVisitor instOperandConstraintVisitor = new InstOperandConstraintVisitor(constantPoolGen);
        for (InstructionHandle instructionHandle = this.instructionList.getStart(); instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
            Instruction instruction = instructionHandle.getInstruction();
            if (instruction instanceof JsrInstruction) {
                InstructionHandle instructionHandle2 = ((JsrInstruction)instruction).getTarget();
                if (instructionHandle2 == this.instructionList.getStart()) {
                    throw new StaticCodeInstructionOperandConstraintException("Due to JustIce's clear definition of subroutines, no JSR or JSR_W may have a top-level instruction (such as the very first instruction, which is targeted by instruction '" + instructionHandle + "' as its target.");
                }
                if (!(instructionHandle2.getInstruction() instanceof ASTORE)) {
                    throw new StaticCodeInstructionOperandConstraintException("Due to JustIce's clear definition of subroutines, no JSR or JSR_W may target anything else than an ASTORE instruction. Instruction '" + instructionHandle + "' targets '" + instructionHandle2 + "'.");
                }
            }
            instructionHandle.accept(instOperandConstraintVisitor);
        }
    }

    private static boolean contains(int[] nArray, int n2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] != n2) continue;
            return true;
        }
        return false;
    }

    public int getMethodNo() {
        return this.method_no;
    }

    private class InstOperandConstraintVisitor
    extends EmptyVisitor {
        private ConstantPoolGen cpg;

        InstOperandConstraintVisitor(ConstantPoolGen constantPoolGen) {
            this.cpg = constantPoolGen;
        }

        private int max_locals() {
            return Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName()).getMethods()[Pass3aVerifier.this.method_no].getCode().getMaxLocals();
        }

        private void constraintViolated(Instruction instruction, String string) {
            throw new StaticCodeInstructionOperandConstraintException("Instruction " + instruction + " constraint violated: " + string);
        }

        private void indexValid(Instruction instruction, int n2) {
            if (n2 < 0 || n2 >= this.cpg.getSize()) {
                this.constraintViolated(instruction, "Illegal constant pool index '" + n2 + "'.");
            }
        }

        public void visitLoadClass(LoadClass loadClass) {
            Verifier verifier;
            VerificationResult verificationResult;
            ObjectType objectType = loadClass.getLoadClassType(this.cpg);
            if (objectType != null && (verificationResult = (verifier = VerifierFactory.getVerifier(objectType.getClassName())).doPass1()).getStatus() != 1) {
                this.constraintViolated((Instruction)((Object)loadClass), "Class '" + loadClass.getLoadClassType(this.cpg).getClassName() + "' is referenced, but cannot be loaded: '" + verificationResult + "'.");
            }
        }

        public void visitLDC(LDC lDC) {
            this.indexValid(lDC, lDC.getIndex());
            Constant constant = this.cpg.getConstant(lDC.getIndex());
            if (!(constant instanceof ConstantInteger || constant instanceof ConstantFloat || constant instanceof ConstantString)) {
                this.constraintViolated(lDC, "Operand of LDC or LDC_W must be one of CONSTANT_Integer, CONSTANT_Float or CONSTANT_String, but is '" + constant + "'.");
            }
        }

        public void visitLDC2_W(LDC2_W lDC2_W) {
            this.indexValid(lDC2_W, lDC2_W.getIndex());
            Constant constant = this.cpg.getConstant(lDC2_W.getIndex());
            if (!(constant instanceof ConstantLong) && !(constant instanceof ConstantDouble)) {
                this.constraintViolated(lDC2_W, "Operand of LDC2_W must be CONSTANT_Long or CONSTANT_Double, but is '" + constant + "'.");
            }
            try {
                this.indexValid(lDC2_W, lDC2_W.getIndex() + 1);
            }
            catch (StaticCodeInstructionOperandConstraintException staticCodeInstructionOperandConstraintException) {
                throw new AssertionViolatedException("OOPS: Does not BCEL handle that? LDC2_W operand has a problem.");
            }
        }

        public void visitFieldInstruction(FieldInstruction fieldInstruction) {
            this.indexValid(fieldInstruction, fieldInstruction.getIndex());
            Constant constant = this.cpg.getConstant(fieldInstruction.getIndex());
            if (!(constant instanceof ConstantFieldref)) {
                this.constraintViolated(fieldInstruction, "Indexing a constant that's not a CONSTANT_Fieldref but a '" + constant + "'.");
            }
        }

        public void visitInvokeInstruction(InvokeInstruction invokeInstruction) {
            Object object;
            Object object2;
            Object object3;
            this.indexValid(invokeInstruction, invokeInstruction.getIndex());
            if (invokeInstruction instanceof INVOKEVIRTUAL || invokeInstruction instanceof INVOKESPECIAL || invokeInstruction instanceof INVOKESTATIC) {
                object3 = this.cpg.getConstant(invokeInstruction.getIndex());
                if (!(object3 instanceof ConstantMethodref)) {
                    this.constraintViolated(invokeInstruction, "Indexing a constant that's not a CONSTANT_Methodref but a '" + object3 + "'.");
                } else {
                    object2 = (ConstantNameAndType)this.cpg.getConstant(((ConstantMethodref)object3).getNameAndTypeIndex());
                    object = (ConstantUtf8)this.cpg.getConstant(object2.getNameIndex());
                    if (((ConstantUtf8)object).getBytes().equals("<init>") && !(invokeInstruction instanceof INVOKESPECIAL)) {
                        this.constraintViolated(invokeInstruction, "Only INVOKESPECIAL is allowed to invoke instance initialization methods.");
                    }
                    if (!((ConstantUtf8)object).getBytes().equals("<init>") && ((ConstantUtf8)object).getBytes().startsWith("<")) {
                        this.constraintViolated(invokeInstruction, "No method with a name beginning with '<' other than the instance initialization methods may be called by the method invocation instructions.");
                    }
                }
            } else {
                object3 = this.cpg.getConstant(invokeInstruction.getIndex());
                if (!(object3 instanceof ConstantInterfaceMethodref)) {
                    this.constraintViolated(invokeInstruction, "Indexing a constant that's not a CONSTANT_InterfaceMethodref but a '" + object3 + "'.");
                }
                if (((String)(object = ((ConstantUtf8)this.cpg.getConstant((object2 = (ConstantNameAndType)this.cpg.getConstant(((ConstantInterfaceMethodref)object3).getNameAndTypeIndex())).getNameIndex())).getBytes())).equals("<init>")) {
                    this.constraintViolated(invokeInstruction, "Method to invoke must not be '<init>'.");
                }
                if (((String)object).equals("<clinit>")) {
                    this.constraintViolated(invokeInstruction, "Method to invoke must not be '<clinit>'.");
                }
            }
            object3 = invokeInstruction.getReturnType(this.cpg);
            if (object3 instanceof ArrayType) {
                object3 = ((ArrayType)object3).getBasicType();
            }
            if (object3 instanceof ObjectType && ((VerificationResult)(object = (object2 = VerifierFactory.getVerifier(((ObjectType)object3).getClassName())).doPass2())).getStatus() != 1) {
                this.constraintViolated(invokeInstruction, "Return type class/interface could not be verified successfully: '" + ((VerificationResult)object).getMessage() + "'.");
            }
            object2 = invokeInstruction.getArgumentTypes(this.cpg);
            for (int i2 = 0; i2 < ((Type[])object2).length; ++i2) {
                Verifier verifier;
                VerificationResult verificationResult;
                object3 = object2[i2];
                if (object3 instanceof ArrayType) {
                    object3 = ((ArrayType)object3).getBasicType();
                }
                if (!(object3 instanceof ObjectType) || (verificationResult = (verifier = VerifierFactory.getVerifier(((ObjectType)object3).getClassName())).doPass2()).getStatus() == 1) continue;
                this.constraintViolated(invokeInstruction, "Argument type class/interface could not be verified successfully: '" + verificationResult.getMessage() + "'.");
            }
        }

        public void visitINSTANCEOF(INSTANCEOF iNSTANCEOF) {
            this.indexValid(iNSTANCEOF, iNSTANCEOF.getIndex());
            Constant constant = this.cpg.getConstant(iNSTANCEOF.getIndex());
            if (!(constant instanceof ConstantClass)) {
                this.constraintViolated(iNSTANCEOF, "Expecting a CONSTANT_Class operand, but found a '" + constant + "'.");
            }
        }

        public void visitCHECKCAST(CHECKCAST cHECKCAST) {
            this.indexValid(cHECKCAST, cHECKCAST.getIndex());
            Constant constant = this.cpg.getConstant(cHECKCAST.getIndex());
            if (!(constant instanceof ConstantClass)) {
                this.constraintViolated(cHECKCAST, "Expecting a CONSTANT_Class operand, but found a '" + constant + "'.");
            }
        }

        public void visitNEW(NEW nEW) {
            this.indexValid(nEW, nEW.getIndex());
            Constant constant = this.cpg.getConstant(nEW.getIndex());
            if (!(constant instanceof ConstantClass)) {
                this.constraintViolated(nEW, "Expecting a CONSTANT_Class operand, but found a '" + constant + "'.");
            } else {
                ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpg.getConstant(((ConstantClass)constant).getNameIndex());
                Type type = Type.getType("L" + constantUtf8.getBytes() + ";");
                if (type instanceof ArrayType) {
                    this.constraintViolated(nEW, "NEW must not be used to create an array.");
                }
            }
        }

        public void visitMULTIANEWARRAY(MULTIANEWARRAY mULTIANEWARRAY) {
            Type type;
            short s2;
            this.indexValid(mULTIANEWARRAY, mULTIANEWARRAY.getIndex());
            Constant constant = this.cpg.getConstant(mULTIANEWARRAY.getIndex());
            if (!(constant instanceof ConstantClass)) {
                this.constraintViolated(mULTIANEWARRAY, "Expecting a CONSTANT_Class operand, but found a '" + constant + "'.");
            }
            if ((s2 = mULTIANEWARRAY.getDimensions()) < 1) {
                this.constraintViolated(mULTIANEWARRAY, "Number of dimensions to create must be greater than zero.");
            }
            if ((type = mULTIANEWARRAY.getType(this.cpg)) instanceof ArrayType) {
                int n2 = ((ArrayType)type).getDimensions();
                if (n2 < s2) {
                    this.constraintViolated(mULTIANEWARRAY, "Not allowed to create array with more dimensions ('+dimensions2create+') than the one referenced by the CONSTANT_Class '" + type + "'.");
                }
            } else {
                this.constraintViolated(mULTIANEWARRAY, "Expecting a CONSTANT_Class referencing an array type. [Constraint not found in The Java Virtual Machine Specification, Second Edition, 4.8.1]");
            }
        }

        public void visitANEWARRAY(ANEWARRAY aNEWARRAY) {
            int n2;
            Type type;
            this.indexValid(aNEWARRAY, aNEWARRAY.getIndex());
            Constant constant = this.cpg.getConstant(aNEWARRAY.getIndex());
            if (!(constant instanceof ConstantClass)) {
                this.constraintViolated(aNEWARRAY, "Expecting a CONSTANT_Class operand, but found a '" + constant + "'.");
            }
            if ((type = aNEWARRAY.getType(this.cpg)) instanceof ArrayType && (n2 = ((ArrayType)type).getDimensions()) >= 255) {
                this.constraintViolated(aNEWARRAY, "Not allowed to create an array with more than 255 dimensions.");
            }
        }

        public void visitNEWARRAY(NEWARRAY nEWARRAY) {
            byte by = nEWARRAY.getTypecode();
            if (by != 4 && by != 5 && by != 6 && by != 7 && by != 8 && by != 9 && by != 10 && by != 11) {
                this.constraintViolated(nEWARRAY, "Illegal type code '+t+' for 'atype' operand.");
            }
        }

        public void visitILOAD(ILOAD iLOAD) {
            int n2 = iLOAD.getIndex();
            if (n2 < 0) {
                this.constraintViolated(iLOAD, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(iLOAD, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        public void visitFLOAD(FLOAD fLOAD) {
            int n2 = fLOAD.getIndex();
            if (n2 < 0) {
                this.constraintViolated(fLOAD, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(fLOAD, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        public void visitALOAD(ALOAD aLOAD) {
            int n2 = aLOAD.getIndex();
            if (n2 < 0) {
                this.constraintViolated(aLOAD, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(aLOAD, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        public void visitISTORE(ISTORE iSTORE) {
            int n2 = iSTORE.getIndex();
            if (n2 < 0) {
                this.constraintViolated(iSTORE, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(iSTORE, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        public void visitFSTORE(FSTORE fSTORE) {
            int n2 = fSTORE.getIndex();
            if (n2 < 0) {
                this.constraintViolated(fSTORE, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(fSTORE, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        public void visitASTORE(ASTORE aSTORE) {
            int n2 = aSTORE.getIndex();
            if (n2 < 0) {
                this.constraintViolated(aSTORE, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(aSTORE, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        public void visitIINC(IINC iINC) {
            int n2 = iINC.getIndex();
            if (n2 < 0) {
                this.constraintViolated(iINC, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(iINC, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        public void visitRET(RET rET) {
            int n2 = rET.getIndex();
            if (n2 < 0) {
                this.constraintViolated(rET, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(rET, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        public void visitLLOAD(LLOAD lLOAD) {
            int n2 = lLOAD.getIndex();
            if (n2 < 0) {
                this.constraintViolated(lLOAD, "Index '" + n2 + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int n3 = this.max_locals() - 2;
                if (n2 > n3) {
                    this.constraintViolated(lLOAD, "Index '" + n2 + "' must not be greater than max_locals-2 '" + n3 + "'.");
                }
            }
        }

        public void visitDLOAD(DLOAD dLOAD) {
            int n2 = dLOAD.getIndex();
            if (n2 < 0) {
                this.constraintViolated(dLOAD, "Index '" + n2 + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int n3 = this.max_locals() - 2;
                if (n2 > n3) {
                    this.constraintViolated(dLOAD, "Index '" + n2 + "' must not be greater than max_locals-2 '" + n3 + "'.");
                }
            }
        }

        public void visitLSTORE(LSTORE lSTORE) {
            int n2 = lSTORE.getIndex();
            if (n2 < 0) {
                this.constraintViolated(lSTORE, "Index '" + n2 + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int n3 = this.max_locals() - 2;
                if (n2 > n3) {
                    this.constraintViolated(lSTORE, "Index '" + n2 + "' must not be greater than max_locals-2 '" + n3 + "'.");
                }
            }
        }

        public void visitDSTORE(DSTORE dSTORE) {
            int n2 = dSTORE.getIndex();
            if (n2 < 0) {
                this.constraintViolated(dSTORE, "Index '" + n2 + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int n3 = this.max_locals() - 2;
                if (n2 > n3) {
                    this.constraintViolated(dSTORE, "Index '" + n2 + "' must not be greater than max_locals-2 '" + n3 + "'.");
                }
            }
        }

        public void visitLOOKUPSWITCH(LOOKUPSWITCH lOOKUPSWITCH) {
            int[] nArray = lOOKUPSWITCH.getMatchs();
            int n2 = Integer.MIN_VALUE;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] == n2 && i2 != 0) {
                    this.constraintViolated(lOOKUPSWITCH, "Match '" + nArray[i2] + "' occurs more than once.");
                }
                if (nArray[i2] < n2) {
                    this.constraintViolated(lOOKUPSWITCH, "Lookup table must be sorted but isn't.");
                    continue;
                }
                n2 = nArray[i2];
            }
        }

        public void visitTABLESWITCH(TABLESWITCH tABLESWITCH) {
        }

        public void visitPUTSTATIC(PUTSTATIC pUTSTATIC) {
            String string = pUTSTATIC.getFieldName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(pUTSTATIC.getClassType(this.cpg).getClassName());
            Field[] fieldArray = javaClass.getFields();
            AccessFlags accessFlags = null;
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                if (!fieldArray[i2].getName().equals(string)) continue;
                accessFlags = fieldArray[i2];
                break;
            }
            if (accessFlags == null) {
                throw new AssertionViolatedException("Field not found?!?");
            }
            if (accessFlags.isFinal() && !Pass3aVerifier.this.myOwner.getClassName().equals(pUTSTATIC.getClassType(this.cpg).getClassName())) {
                this.constraintViolated(pUTSTATIC, "Referenced field '" + accessFlags + "' is final and must therefore be declared in the current class '" + Pass3aVerifier.this.myOwner.getClassName() + "' which is not the case: it is declared in '" + pUTSTATIC.getClassType(this.cpg).getClassName() + "'.");
            }
            if (!accessFlags.isStatic()) {
                this.constraintViolated(pUTSTATIC, "Referenced field '" + accessFlags + "' is not static which it should be.");
            }
            String string2 = Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName()).getMethods()[Pass3aVerifier.this.method_no].getName();
            if (!javaClass.isClass() && !string2.equals("<clinit>")) {
                this.constraintViolated(pUTSTATIC, "Interface field '" + accessFlags + "' must be set in a '" + "<clinit>" + "' method.");
            }
        }

        public void visitGETSTATIC(GETSTATIC gETSTATIC) {
            String string = gETSTATIC.getFieldName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(gETSTATIC.getClassType(this.cpg).getClassName());
            Field[] fieldArray = javaClass.getFields();
            AccessFlags accessFlags = null;
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                if (!fieldArray[i2].getName().equals(string)) continue;
                accessFlags = fieldArray[i2];
                break;
            }
            if (accessFlags == null) {
                throw new AssertionViolatedException("Field not found?!?");
            }
            if (!accessFlags.isStatic()) {
                this.constraintViolated(gETSTATIC, "Referenced field '" + accessFlags + "' is not static which it should be.");
            }
        }

        public void visitINVOKEINTERFACE(INVOKEINTERFACE iNVOKEINTERFACE) {
            String string = iNVOKEINTERFACE.getClassName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(string);
            Method[] methodArray = javaClass.getMethods();
            Method method = null;
            for (int i2 = 0; i2 < methodArray.length; ++i2) {
                if (!methodArray[i2].getName().equals(iNVOKEINTERFACE.getMethodName(this.cpg)) || !Type.getReturnType(methodArray[i2].getSignature()).equals(iNVOKEINTERFACE.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(methodArray[i2].getSignature()), iNVOKEINTERFACE.getArgumentTypes(this.cpg))) continue;
                method = methodArray[i2];
                break;
            }
            if (method == null) {
                this.constraintViolated(iNVOKEINTERFACE, "Referenced method '" + iNVOKEINTERFACE.getMethodName(this.cpg) + "' with expected signature not found in class '" + javaClass.getClassName() + "'. The native verfier does allow the method to be declared in some superinterface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if (javaClass.isClass()) {
                this.constraintViolated(iNVOKEINTERFACE, "Referenced class '" + javaClass.getClassName() + "' is a class, but not an interface as expected.");
            }
        }

        public void visitINVOKESPECIAL(INVOKESPECIAL iNVOKESPECIAL) {
            JavaClass javaClass;
            String string = iNVOKESPECIAL.getClassName(this.cpg);
            JavaClass javaClass2 = Repository.lookupClass(string);
            Method[] methodArray = javaClass2.getMethods();
            Method method = null;
            for (int i2 = 0; i2 < methodArray.length; ++i2) {
                if (!methodArray[i2].getName().equals(iNVOKESPECIAL.getMethodName(this.cpg)) || !Type.getReturnType(methodArray[i2].getSignature()).equals(iNVOKESPECIAL.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(methodArray[i2].getSignature()), iNVOKESPECIAL.getArgumentTypes(this.cpg))) continue;
                method = methodArray[i2];
                break;
            }
            if (method == null) {
                this.constraintViolated(iNVOKESPECIAL, "Referenced method '" + iNVOKESPECIAL.getMethodName(this.cpg) + "' with expected signature not found in class '" + javaClass2.getClassName() + "'. The native verfier does allow the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if ((javaClass = Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName())).isSuper() && Repository.instanceOf(javaClass, javaClass2) && !javaClass.equals(javaClass2) && !iNVOKESPECIAL.getMethodName(this.cpg).equals("<init>")) {
                int n2 = -1;
                Method method2 = null;
                while (n2 != 0) {
                    n2 = javaClass.getSuperclassNameIndex();
                    javaClass = Repository.lookupClass(javaClass.getSuperclassName());
                    Method[] methodArray2 = javaClass.getMethods();
                    for (int i3 = 0; i3 < methodArray2.length; ++i3) {
                        if (!methodArray2[i3].getName().equals(iNVOKESPECIAL.getMethodName(this.cpg)) || !Type.getReturnType(methodArray2[i3].getSignature()).equals(iNVOKESPECIAL.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(methodArray2[i3].getSignature()), iNVOKESPECIAL.getArgumentTypes(this.cpg))) continue;
                        method2 = methodArray2[i3];
                        break;
                    }
                    if (method2 == null) continue;
                    break;
                }
                if (method2 == null) {
                    this.constraintViolated(iNVOKESPECIAL, "ACC_SUPER special lookup procedure not successful: method '" + iNVOKESPECIAL.getMethodName(this.cpg) + "' with proper signature not declared in superclass hierarchy.");
                }
            }
        }

        public void visitINVOKESTATIC(INVOKESTATIC iNVOKESTATIC) {
            String string = iNVOKESTATIC.getClassName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(string);
            Method[] methodArray = javaClass.getMethods();
            AccessFlags accessFlags = null;
            for (int i2 = 0; i2 < methodArray.length; ++i2) {
                if (!methodArray[i2].getName().equals(iNVOKESTATIC.getMethodName(this.cpg)) || !Type.getReturnType(methodArray[i2].getSignature()).equals(iNVOKESTATIC.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(methodArray[i2].getSignature()), iNVOKESTATIC.getArgumentTypes(this.cpg))) continue;
                accessFlags = methodArray[i2];
                break;
            }
            if (accessFlags == null) {
                this.constraintViolated(iNVOKESTATIC, "Referenced method '" + iNVOKESTATIC.getMethodName(this.cpg) + "' with expected signature not found in class '" + javaClass.getClassName() + "'. The native verifier possibly allows the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if (!accessFlags.isStatic()) {
                this.constraintViolated(iNVOKESTATIC, "Referenced method '" + iNVOKESTATIC.getMethodName(this.cpg) + "' has ACC_STATIC unset.");
            }
        }

        public void visitINVOKEVIRTUAL(INVOKEVIRTUAL iNVOKEVIRTUAL) {
            String string = iNVOKEVIRTUAL.getClassName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(string);
            Method[] methodArray = javaClass.getMethods();
            Method method = null;
            for (int i2 = 0; i2 < methodArray.length; ++i2) {
                if (!methodArray[i2].getName().equals(iNVOKEVIRTUAL.getMethodName(this.cpg)) || !Type.getReturnType(methodArray[i2].getSignature()).equals(iNVOKEVIRTUAL.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(methodArray[i2].getSignature()), iNVOKEVIRTUAL.getArgumentTypes(this.cpg))) continue;
                method = methodArray[i2];
                break;
            }
            if (method == null) {
                this.constraintViolated(iNVOKEVIRTUAL, "Referenced method '" + iNVOKEVIRTUAL.getMethodName(this.cpg) + "' with expected signature not found in class '" + javaClass.getClassName() + "'. The native verfier does allow the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if (!javaClass.isClass()) {
                this.constraintViolated(iNVOKEVIRTUAL, "Referenced class '" + javaClass.getClassName() + "' is an interface, but not a class as expected.");
            }
        }

        private boolean objarrayequals(Object[] objectArray, Object[] objectArray2) {
            if (objectArray.length != objectArray2.length) {
                return false;
            }
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (objectArray[i2].equals(objectArray2[i2])) continue;
                return false;
            }
            return true;
        }
    }
}

