/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.ExceptionConstants;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.generic.AllocationInstruction;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.CPInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.ExceptionThrower;
import com.sun.org.apache.bcel.internal.generic.LoadClass;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.generic.Visitor;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class MULTIANEWARRAY
extends CPInstruction
implements LoadClass,
AllocationInstruction,
ExceptionThrower {
    private short dimensions;

    MULTIANEWARRAY() {
    }

    public MULTIANEWARRAY(int n2, short s2) {
        super((short)197, n2);
        if (s2 < 1) {
            throw new ClassGenException("Invalid dimensions value: " + s2);
        }
        this.dimensions = s2;
        this.length = (short)4;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
        dataOutputStream.writeShort(this.index);
        dataOutputStream.writeByte(this.dimensions);
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl2) throws IOException {
        super.initFromFile(byteSequence, bl2);
        this.dimensions = byteSequence.readByte();
        this.length = (short)4;
    }

    public final short getDimensions() {
        return this.dimensions;
    }

    public String toString(boolean bl2) {
        return super.toString(bl2) + " " + this.index + " " + this.dimensions;
    }

    public String toString(ConstantPool constantPool) {
        return super.toString(constantPool) + " " + this.dimensions;
    }

    public int consumeStack(ConstantPoolGen constantPoolGen) {
        return this.dimensions;
    }

    public Class[] getExceptions() {
        Class[] classArray = new Class[2 + ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length];
        System.arraycopy(ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION, 0, classArray, 0, ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length);
        classArray[ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length + 1] = ExceptionConstants.NEGATIVE_ARRAY_SIZE_EXCEPTION;
        classArray[ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length] = ExceptionConstants.ILLEGAL_ACCESS_ERROR;
        return classArray;
    }

    public ObjectType getLoadClassType(ConstantPoolGen constantPoolGen) {
        Type type = this.getType(constantPoolGen);
        if (type instanceof ArrayType) {
            type = ((ArrayType)type).getBasicType();
        }
        return type instanceof ObjectType ? (ObjectType)type : null;
    }

    public void accept(Visitor visitor) {
        visitor.visitLoadClass(this);
        visitor.visitAllocationInstruction(this);
        visitor.visitExceptionThrower(this);
        visitor.visitTypedInstruction(this);
        visitor.visitCPInstruction(this);
        visitor.visitMULTIANEWARRAY(this);
    }
}

