/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.FastShortMessage;
import com.sun.media.sound.FastSysexMessage;
import com.sun.media.sound.MidiOutDevice;
import com.sun.media.sound.MixerSynth;
import com.sun.media.sound.ReferenceCountingDevice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractMidiDevice
implements MidiDevice,
ReferenceCountingDevice {
    private static final boolean TRACE_TRANSMITTER = false;
    private ArrayList<Receiver> receiverList;
    private TransmitterList transmitterList;
    private Object traRecLock = new Object();
    private MidiDevice.Info info;
    protected boolean open = false;
    private int openRefCount;
    private List openKeepingObjects;
    protected long id = 0L;

    protected AbstractMidiDevice(MidiDevice.Info info) {
        this.info = info;
        this.openRefCount = 0;
    }

    @Override
    public MidiDevice.Info getDeviceInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws MidiUnavailableException {
        AbstractMidiDevice abstractMidiDevice = this;
        synchronized (abstractMidiDevice) {
            this.openRefCount = -1;
            this.doOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openInternal(Object object) throws MidiUnavailableException {
        AbstractMidiDevice abstractMidiDevice = this;
        synchronized (abstractMidiDevice) {
            if (this.openRefCount != -1) {
                ++this.openRefCount;
                this.getOpenKeepingObjects().add(object);
            }
            this.doOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOpen() throws MidiUnavailableException {
        AbstractMidiDevice abstractMidiDevice = this;
        synchronized (abstractMidiDevice) {
            if (!this.isOpen()) {
                this.implOpen();
                this.open = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AbstractMidiDevice abstractMidiDevice = this;
        synchronized (abstractMidiDevice) {
            this.doClose();
            this.openRefCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeInternal(Object object) {
        AbstractMidiDevice abstractMidiDevice = this;
        synchronized (abstractMidiDevice) {
            if (this.getOpenKeepingObjects().remove(object) && this.openRefCount > 0) {
                --this.openRefCount;
                if (this.openRefCount == 0) {
                    this.doClose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doClose() {
        AbstractMidiDevice abstractMidiDevice = this;
        synchronized (abstractMidiDevice) {
            if (this.isOpen()) {
                this.implClose();
                this.open = false;
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implClose() {
        Object object = this.traRecLock;
        synchronized (object) {
            if (this.receiverList != null) {
                for (int i2 = 0; i2 < this.receiverList.size(); ++i2) {
                    this.receiverList.get(i2).close();
                }
                this.receiverList.clear();
            }
            if (this.transmitterList != null) {
                this.transmitterList.close();
            }
        }
    }

    @Override
    public long getMicrosecondPosition() {
        return -1L;
    }

    @Override
    public final int getMaxReceivers() {
        if (this.hasReceivers()) {
            return -1;
        }
        return 0;
    }

    @Override
    public final int getMaxTransmitters() {
        if (this.hasTransmitters()) {
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Receiver getReceiver() throws MidiUnavailableException {
        Receiver receiver;
        Object object = this.traRecLock;
        synchronized (object) {
            receiver = this.createReceiver();
            this.getReceiverList().add(receiver);
        }
        return receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<Receiver> getReceivers() {
        List<Object> list;
        Object object = this.traRecLock;
        synchronized (object) {
            list = this.receiverList == null ? Collections.unmodifiableList(new ArrayList(0)) : Collections.unmodifiableList((List)this.receiverList.clone());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Transmitter getTransmitter() throws MidiUnavailableException {
        Transmitter transmitter;
        Object object = this.traRecLock;
        synchronized (object) {
            transmitter = this.createTransmitter();
            this.getTransmitterList().add(transmitter);
        }
        return transmitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<Transmitter> getTransmitters() {
        List<Transmitter> list;
        Object object = this.traRecLock;
        synchronized (object) {
            list = this.transmitterList == null || this.transmitterList.transmitters.size() == 0 ? Collections.unmodifiableList(new ArrayList(0)) : Collections.unmodifiableList((List)this.transmitterList.transmitters.clone());
        }
        return list;
    }

    long getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Receiver getReceiverReferenceCounting() throws MidiUnavailableException {
        Receiver receiver;
        Object object = this.traRecLock;
        synchronized (object) {
            receiver = this.getReceiver();
            this.openInternal(receiver);
        }
        return receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transmitter getTransmitterReferenceCounting() throws MidiUnavailableException {
        Transmitter transmitter;
        Object object = this.traRecLock;
        synchronized (object) {
            transmitter = this.getTransmitter();
            this.openInternal(transmitter);
        }
        return transmitter;
    }

    private synchronized List getOpenKeepingObjects() {
        if (this.openKeepingObjects == null) {
            this.openKeepingObjects = new ArrayList();
        }
        return this.openKeepingObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Receiver> getReceiverList() {
        Object object = this.traRecLock;
        synchronized (object) {
            if (this.receiverList == null) {
                this.receiverList = new ArrayList();
            }
        }
        return this.receiverList;
    }

    protected boolean hasReceivers() {
        return false;
    }

    protected Receiver createReceiver() throws MidiUnavailableException {
        throw new MidiUnavailableException("MIDI IN receiver not available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransmitterList getTransmitterList() {
        Object object = this.traRecLock;
        synchronized (object) {
            if (this.transmitterList == null) {
                this.transmitterList = new TransmitterList();
            }
        }
        return this.transmitterList;
    }

    protected boolean hasTransmitters() {
        return false;
    }

    protected Transmitter createTransmitter() throws MidiUnavailableException {
        throw new MidiUnavailableException("MIDI OUT transmitter not available");
    }

    protected abstract void implOpen() throws MidiUnavailableException;

    protected void finalize() {
        this.close();
    }

    protected abstract class AbstractReceiver
    implements Receiver {
        private boolean open = true;

        protected AbstractReceiver() {
        }

        public synchronized void send(MidiMessage midiMessage, long l2) {
            if (!this.open) {
                throw new IllegalStateException("Receiver is not open");
            }
            this.implSend(midiMessage, l2);
        }

        protected abstract void implSend(MidiMessage var1, long var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.open = false;
            Object object = AbstractMidiDevice.this.traRecLock;
            synchronized (object) {
                AbstractMidiDevice.this.getReceiverList().remove(this);
            }
            AbstractMidiDevice.this.closeInternal(this);
        }

        protected boolean isOpen() {
            return this.open;
        }
    }

    protected class BasicTransmitter
    implements Transmitter {
        private Receiver receiver = null;
        TransmitterList tlist = null;

        protected BasicTransmitter() {
        }

        private void setTransmitterList(TransmitterList transmitterList) {
            this.tlist = transmitterList;
        }

        public void setReceiver(Receiver receiver) {
            if (this.tlist != null && this.receiver != receiver) {
                this.tlist.receiverChanged(this, this.receiver, receiver);
                this.receiver = receiver;
            }
        }

        public Receiver getReceiver() {
            return this.receiver;
        }

        public void close() {
            AbstractMidiDevice.this.closeInternal(this);
            if (this.tlist != null) {
                this.tlist.receiverChanged(this, this.receiver, null);
                this.tlist.remove(this);
                this.tlist = null;
            }
        }
    }

    class TransmitterList {
        private ArrayList<Transmitter> transmitters = new ArrayList();
        private MidiOutDevice.MidiOutReceiver midiOutReceiver;
        private MixerSynth.SynthReceiver mixerSynthReceiver;
        private int optimizedReceiverCount = 0;

        TransmitterList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(Transmitter transmitter) {
            ArrayList<Transmitter> arrayList = this.transmitters;
            synchronized (arrayList) {
                this.transmitters.add(transmitter);
            }
            if (transmitter instanceof BasicTransmitter) {
                ((BasicTransmitter)transmitter).setTransmitterList(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(Transmitter transmitter) {
            ArrayList<Transmitter> arrayList = this.transmitters;
            synchronized (arrayList) {
                int n2 = this.transmitters.indexOf(transmitter);
                if (n2 >= 0) {
                    this.transmitters.remove(n2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void receiverChanged(BasicTransmitter basicTransmitter, Receiver receiver, Receiver receiver2) {
            ArrayList<Transmitter> arrayList = this.transmitters;
            synchronized (arrayList) {
                if (this.midiOutReceiver == receiver) {
                    this.midiOutReceiver = null;
                }
                if (this.mixerSynthReceiver == receiver) {
                    this.mixerSynthReceiver = null;
                }
                if (receiver2 != null) {
                    if (receiver2 instanceof MidiOutDevice.MidiOutReceiver && this.midiOutReceiver == null) {
                        this.midiOutReceiver = (MidiOutDevice.MidiOutReceiver)receiver2;
                    }
                    if (receiver2 instanceof MixerSynth.SynthReceiver && this.mixerSynthReceiver == null) {
                        this.mixerSynthReceiver = (MixerSynth.SynthReceiver)receiver2;
                    }
                }
                this.optimizedReceiverCount = (this.midiOutReceiver != null ? 1 : 0) + (this.mixerSynthReceiver != null ? 1 : 0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            ArrayList<Transmitter> arrayList = this.transmitters;
            synchronized (arrayList) {
                for (int i2 = 0; i2 < this.transmitters.size(); ++i2) {
                    this.transmitters.get(i2).close();
                }
                this.transmitters.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendMessage(int n2, long l2) {
            try {
                ArrayList<Transmitter> arrayList = this.transmitters;
                synchronized (arrayList) {
                    int n3 = this.transmitters.size();
                    if (this.optimizedReceiverCount == n3) {
                        if (this.midiOutReceiver != null) {
                            this.midiOutReceiver.sendPackedMidiMessage(n2, l2);
                        }
                        if (this.mixerSynthReceiver != null) {
                            this.mixerSynthReceiver.sendPackedMidiMessage(n2, l2);
                        }
                    } else {
                        for (int i2 = 0; i2 < n3; ++i2) {
                            Receiver receiver = this.transmitters.get(i2).getReceiver();
                            if (receiver == null) continue;
                            if (this.optimizedReceiverCount > 0) {
                                if (receiver instanceof MidiOutDevice.MidiOutReceiver) {
                                    ((MidiOutDevice.MidiOutReceiver)receiver).sendPackedMidiMessage(n2, l2);
                                    continue;
                                }
                                if (receiver instanceof MixerSynth.SynthReceiver) {
                                    ((MixerSynth.SynthReceiver)receiver).sendPackedMidiMessage(n2, l2);
                                    continue;
                                }
                                receiver.send(new FastShortMessage(n2), l2);
                                continue;
                            }
                            receiver.send(new FastShortMessage(n2), l2);
                        }
                    }
                }
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendMessage(byte[] byArray, long l2) {
            try {
                ArrayList<Transmitter> arrayList = this.transmitters;
                synchronized (arrayList) {
                    int n2 = this.transmitters.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Receiver receiver = this.transmitters.get(i2).getReceiver();
                        if (receiver == null) continue;
                        receiver.send(new FastSysexMessage(byArray), l2);
                    }
                }
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendMessage(MidiMessage midiMessage, long l2) {
            if (midiMessage instanceof FastShortMessage) {
                this.sendMessage(((FastShortMessage)midiMessage).getPackedMsg(), l2);
                return;
            }
            ArrayList<Transmitter> arrayList = this.transmitters;
            synchronized (arrayList) {
                int n2 = this.transmitters.size();
                if (this.optimizedReceiverCount == n2) {
                    if (this.midiOutReceiver != null) {
                        this.midiOutReceiver.send(midiMessage, l2);
                    }
                    if (this.mixerSynthReceiver != null) {
                        this.mixerSynthReceiver.send(midiMessage, l2);
                    }
                } else {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Receiver receiver = this.transmitters.get(i2).getReceiver();
                        if (receiver == null) continue;
                        receiver.send(midiMessage, l2);
                    }
                }
            }
        }
    }
}

