/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management;

import java.lang.management.MemoryUsage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import sun.management.GcInfoBuilder;
import sun.management.GcInfoCompositeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GcInfo
implements CompositeData {
    private final long index;
    private final long startTime;
    private final long endTime;
    private final Map<String, MemoryUsage> usageBeforeGc;
    private final Map<String, MemoryUsage> usageAfterGc;
    private final Object[] extAttributes;
    private final CompositeData cdata;
    private final GcInfoBuilder builder;

    private GcInfo(GcInfoBuilder gcInfoBuilder, long l2, long l3, long l4, MemoryUsage[] memoryUsageArray, MemoryUsage[] memoryUsageArray2, Object[] objectArray) {
        this.builder = gcInfoBuilder;
        this.index = l2;
        this.startTime = l3;
        this.endTime = l4;
        String[] stringArray = gcInfoBuilder.getPoolNames();
        this.usageBeforeGc = new HashMap<String, MemoryUsage>(stringArray.length);
        this.usageAfterGc = new HashMap<String, MemoryUsage>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.usageBeforeGc.put(stringArray[i2], memoryUsageArray[i2]);
            this.usageAfterGc.put(stringArray[i2], memoryUsageArray2[i2]);
        }
        this.extAttributes = objectArray;
        this.cdata = new GcInfoCompositeData(this, gcInfoBuilder, objectArray);
    }

    private GcInfo(CompositeData compositeData) {
        GcInfoCompositeData.validateCompositeData(compositeData);
        this.index = GcInfoCompositeData.getId(compositeData);
        this.startTime = GcInfoCompositeData.getStartTime(compositeData);
        this.endTime = GcInfoCompositeData.getEndTime(compositeData);
        this.usageBeforeGc = GcInfoCompositeData.getMemoryUsageBeforeGc(compositeData);
        this.usageAfterGc = GcInfoCompositeData.getMemoryUsageAfterGc(compositeData);
        this.extAttributes = null;
        this.builder = null;
        this.cdata = compositeData;
    }

    public long getId() {
        return this.index;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.endTime - this.startTime;
    }

    public Map<String, MemoryUsage> getMemoryUsageBeforeGc() {
        return Collections.unmodifiableMap(this.usageBeforeGc);
    }

    public Map<String, MemoryUsage> getMemoryUsageAfterGc() {
        return Collections.unmodifiableMap(this.usageAfterGc);
    }

    public static GcInfo from(CompositeData compositeData) {
        if (compositeData == null) {
            return null;
        }
        if (compositeData instanceof GcInfoCompositeData) {
            return ((GcInfoCompositeData)compositeData).getGcInfo();
        }
        return new GcInfo(compositeData);
    }

    @Override
    public boolean containsKey(String string) {
        return this.cdata.containsKey(string);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.cdata.containsValue(object);
    }

    @Override
    public boolean equals(Object object) {
        return ((Object)this.cdata).equals(object);
    }

    @Override
    public Object get(String string) {
        return this.cdata.get(string);
    }

    @Override
    public Object[] getAll(String[] stringArray) {
        return this.cdata.getAll(stringArray);
    }

    @Override
    public CompositeType getCompositeType() {
        return this.cdata.getCompositeType();
    }

    @Override
    public int hashCode() {
        return ((Object)this.cdata).hashCode();
    }

    @Override
    public String toString() {
        return ((Object)this.cdata).toString();
    }

    @Override
    public Collection values() {
        return this.cdata.values();
    }
}

