/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapCtxFactory;
import com.sun.jndi.ldap.VersionHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidAttributesException;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.DirectoryManager;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

final class Obj {
    static VersionHelper helper = VersionHelper.getVersionHelper();
    static final String[] JAVA_ATTRIBUTES = new String[]{"objectClass", "javaSerializedData", "javaClassName", "javaFactory", "javaCodeBase", "javaReferenceAddress", "javaClassNames", "javaRemoteLocation"};
    static final int OBJECT_CLASS = 0;
    static final int SERIALIZED_DATA = 1;
    static final int CLASSNAME = 2;
    static final int FACTORY = 3;
    static final int CODEBASE = 4;
    static final int REF_ADDR = 5;
    static final int TYPENAME = 6;
    @Deprecated
    private static final int REMOTE_LOC = 7;
    static final String[] JAVA_OBJECT_CLASSES = new String[]{"javaContainer", "javaObject", "javaNamingReference", "javaSerializedObject", "javaMarshalledObject"};
    static final String[] JAVA_OBJECT_CLASSES_LOWER = new String[]{"javacontainer", "javaobject", "javanamingreference", "javaserializedobject", "javamarshalledobject"};
    static final int STRUCTURAL = 0;
    static final int BASE_OBJECT = 1;
    static final int REF_OBJECT = 2;
    static final int SER_OBJECT = 3;
    static final int MAR_OBJECT = 4;

    private Obj() {
    }

    private static Attributes encodeObject(char c2, Object object, Attributes attributes, Attribute attribute, boolean bl2) throws NamingException {
        boolean bl3;
        boolean bl4 = bl3 = attribute.size() == 0 || attribute.size() == 1 && attribute.contains("top");
        if (bl3) {
            attribute.add(JAVA_OBJECT_CLASSES[0]);
        }
        if (object instanceof Referenceable) {
            attribute.add(JAVA_OBJECT_CLASSES[1]);
            attribute.add(JAVA_OBJECT_CLASSES[2]);
            if (!bl2) {
                attributes = (Attributes)attributes.clone();
            }
            attributes.put(attribute);
            return Obj.encodeReference(c2, ((Referenceable)object).getReference(), attributes, object);
        }
        if (object instanceof Reference) {
            attribute.add(JAVA_OBJECT_CLASSES[1]);
            attribute.add(JAVA_OBJECT_CLASSES[2]);
            if (!bl2) {
                attributes = (Attributes)attributes.clone();
            }
            attributes.put(attribute);
            return Obj.encodeReference(c2, (Reference)object, attributes, null);
        }
        if (object instanceof Serializable) {
            Attribute attribute2;
            attribute.add(JAVA_OBJECT_CLASSES[1]);
            if (!attribute.contains(JAVA_OBJECT_CLASSES[4]) && !attribute.contains(JAVA_OBJECT_CLASSES_LOWER[4])) {
                attribute.add(JAVA_OBJECT_CLASSES[3]);
            }
            if (!bl2) {
                attributes = (Attributes)attributes.clone();
            }
            attributes.put(attribute);
            attributes.put(new BasicAttribute(JAVA_ATTRIBUTES[1], Obj.serializeObject(object)));
            if (attributes.get(JAVA_ATTRIBUTES[2]) == null) {
                attributes.put(JAVA_ATTRIBUTES[2], object.getClass().getName());
            }
            if (attributes.get(JAVA_ATTRIBUTES[6]) == null && (attribute2 = LdapCtxFactory.createTypeNameAttr(object.getClass())) != null) {
                attributes.put(attribute2);
            }
        } else if (!(object instanceof DirContext)) {
            throw new IllegalArgumentException("can only bind Referenceable, Serializable, DirContext");
        }
        return attributes;
    }

    private static String[] getCodebases(Attribute attribute) throws NamingException {
        if (attribute == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer((String)attribute.get());
        Vector<String> vector = new Vector<String>(10);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = (String)vector.elementAt(i2);
        }
        return stringArray;
    }

    static Object decodeObject(Attributes attributes) throws NamingException {
        String[] stringArray = Obj.getCodebases(attributes.get(JAVA_ATTRIBUTES[4]));
        try {
            Attribute attribute = attributes.get(JAVA_ATTRIBUTES[1]);
            if (attribute != null) {
                ClassLoader classLoader = helper.getURLClassLoader(stringArray);
                return Obj.deserializeObject((byte[])attribute.get(), classLoader);
            }
            attribute = attributes.get(JAVA_ATTRIBUTES[7]);
            if (attribute != null) {
                return Obj.decodeRmiObject((String)attributes.get(JAVA_ATTRIBUTES[2]).get(), (String)attribute.get(), stringArray);
            }
            attribute = attributes.get(JAVA_ATTRIBUTES[0]);
            if (attribute != null && (attribute.contains(JAVA_OBJECT_CLASSES[2]) || attribute.contains(JAVA_OBJECT_CLASSES_LOWER[2]))) {
                return Obj.decodeReference(attributes, stringArray);
            }
            return null;
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(iOException);
            throw namingException;
        }
    }

    private static Attributes encodeReference(char c2, Reference reference, Attributes attributes, Object object) throws NamingException {
        int n2;
        Attribute attribute;
        if (reference == null) {
            return attributes;
        }
        String string = reference.getClassName();
        if (string != null) {
            attributes.put(new BasicAttribute(JAVA_ATTRIBUTES[2], string));
        }
        if ((string = reference.getFactoryClassName()) != null) {
            attributes.put(new BasicAttribute(JAVA_ATTRIBUTES[3], string));
        }
        if ((string = reference.getFactoryClassLocation()) != null) {
            attributes.put(new BasicAttribute(JAVA_ATTRIBUTES[4], string));
        }
        if (object != null && attributes.get(JAVA_ATTRIBUTES[6]) != null && (attribute = LdapCtxFactory.createTypeNameAttr(object.getClass())) != null) {
            attributes.put(attribute);
        }
        if ((n2 = reference.size()) > 0) {
            BasicAttribute basicAttribute = new BasicAttribute(JAVA_ATTRIBUTES[5]);
            BASE64Encoder bASE64Encoder = null;
            for (int i2 = 0; i2 < n2; ++i2) {
                RefAddr refAddr = reference.get(i2);
                if (refAddr instanceof StringRefAddr) {
                    basicAttribute.add("" + c2 + i2 + c2 + refAddr.getType() + c2 + refAddr.getContent());
                    continue;
                }
                if (bASE64Encoder == null) {
                    bASE64Encoder = new BASE64Encoder();
                }
                basicAttribute.add("" + c2 + i2 + c2 + refAddr.getType() + c2 + c2 + bASE64Encoder.encodeBuffer(Obj.serializeObject(refAddr)));
            }
            attributes.put(basicAttribute);
        }
        return attributes;
    }

    @Deprecated
    private static Object decodeRmiObject(String string, String string2, String[] stringArray) throws NamingException {
        return new Reference(string, new StringRefAddr("URL", string2));
    }

    private static Reference decodeReference(Attributes attributes, String[] stringArray) throws NamingException, IOException {
        String string = null;
        Attribute attribute = attributes.get(JAVA_ATTRIBUTES[2]);
        if (attribute == null) {
            throw new InvalidAttributesException(JAVA_ATTRIBUTES[2] + " attribute is required");
        }
        String string2 = (String)attribute.get();
        attribute = attributes.get(JAVA_ATTRIBUTES[3]);
        if (attribute != null) {
            string = (String)attribute.get();
        }
        Reference reference = new Reference(string2, string, stringArray != null ? stringArray[0] : null);
        attribute = attributes.get(JAVA_ATTRIBUTES[5]);
        if (attribute != null) {
            BASE64Decoder bASE64Decoder = null;
            ClassLoader classLoader = helper.getURLClassLoader(stringArray);
            Vector<RefAddr> vector = new Vector<RefAddr>();
            vector.setSize(attribute.size());
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            while (namingEnumeration.hasMore()) {
                int n2;
                int n3;
                String string3 = (String)namingEnumeration.next();
                if (string3.length() == 0) {
                    throw new InvalidAttributeValueException("malformed " + JAVA_ATTRIBUTES[5] + " attribute - " + "empty attribute value");
                }
                char c2 = string3.charAt(0);
                int n4 = string3.indexOf(c2, n3 = 1);
                if (n4 < 0) {
                    throw new InvalidAttributeValueException("malformed " + JAVA_ATTRIBUTES[5] + " attribute - " + "separator '" + c2 + "'" + "not found");
                }
                String string4 = string3.substring(n3, n4);
                if (string4 == null) {
                    throw new InvalidAttributeValueException("malformed " + JAVA_ATTRIBUTES[5] + " attribute - " + "empty RefAddr position");
                }
                try {
                    n2 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidAttributeValueException("malformed " + JAVA_ATTRIBUTES[5] + " attribute - " + "RefAddr position not an integer");
                }
                n3 = n4 + 1;
                n4 = string3.indexOf(c2, n3);
                if (n4 < 0) {
                    throw new InvalidAttributeValueException("malformed " + JAVA_ATTRIBUTES[5] + " attribute - " + "RefAddr type not found");
                }
                String string5 = string3.substring(n3, n4);
                if (string5 == null) {
                    throw new InvalidAttributeValueException("malformed " + JAVA_ATTRIBUTES[5] + " attribute - " + "empty RefAddr type");
                }
                n3 = n4 + 1;
                if (n3 == string3.length()) {
                    vector.setElementAt(new StringRefAddr(string5, null), n2);
                    continue;
                }
                if (string3.charAt(n3) == c2) {
                    ++n3;
                    if (bASE64Decoder == null) {
                        bASE64Decoder = new BASE64Decoder();
                    }
                    RefAddr refAddr = (RefAddr)Obj.deserializeObject(bASE64Decoder.decodeBuffer(string3.substring(n3)), classLoader);
                    vector.setElementAt(refAddr, n2);
                    continue;
                }
                vector.setElementAt(new StringRefAddr(string5, string3.substring(n3)), n2);
            }
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                reference.add((RefAddr)vector.elementAt(i2));
            }
        }
        return reference;
    }

    private static byte[] serializeObject(Object object) throws NamingException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(iOException);
            throw namingException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object deserializeObject(byte[] byArray, ClassLoader classLoader) throws NamingException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream object = classLoader == null ? new ObjectInputStream(byteArrayInputStream) : new LoaderInputStream(byteArrayInputStream, classLoader);
            try {
                Object classNotFoundException = object.readObject();
                return classNotFoundException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                NamingException namingException = new NamingException();
                namingException.setRootCause(classNotFoundException);
                throw namingException;
            }
            finally {
                object.close();
            }
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(iOException);
            throw namingException;
        }
    }

    static Attributes determineBindAttrs(char c2, Object object, Attributes attributes, boolean bl2, Name name, Context context, Hashtable hashtable) throws NamingException {
        Attribute attribute;
        DirStateFactory.Result result = DirectoryManager.getStateToBind(object, name, context, hashtable, attributes);
        object = result.getObject();
        attributes = result.getAttributes();
        if (object == null) {
            return attributes;
        }
        if (attributes == null && object instanceof DirContext) {
            bl2 = true;
            attributes = ((DirContext)object).getAttributes("");
        }
        boolean bl3 = false;
        if (attributes == null || attributes.size() == 0) {
            attributes = new BasicAttributes(true);
            bl2 = true;
            attribute = new BasicAttribute("objectClass", "top");
        } else {
            attribute = attributes.get("objectClass");
            if (attribute == null && !attributes.isCaseIgnored()) {
                attribute = attributes.get("objectclass");
            }
            if (attribute == null) {
                attribute = new BasicAttribute("objectClass", "top");
            } else if (bl3 || !bl2) {
                attribute = (Attribute)attribute.clone();
            }
        }
        attributes = Obj.encodeObject(c2, object, attributes, attribute, bl2);
        return attributes;
    }

    private static final class LoaderInputStream
    extends ObjectInputStream {
        private ClassLoader classLoader;

        LoaderInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException {
            super(inputStream);
            this.classLoader = classLoader;
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            try {
                return this.classLoader.loadClass(objectStreamClass.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.resolveClass(objectStreamClass);
            }
        }
    }
}

