/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.BerEncoder;
import java.io.IOException;
import javax.naming.NamingException;
import javax.naming.directory.InvalidSearchFilterException;

final class Filter {
    private static final boolean dbg = false;
    private static int dbgIndent = 0;
    static final int LDAP_FILTER_AND = 160;
    static final int LDAP_FILTER_OR = 161;
    static final int LDAP_FILTER_NOT = 162;
    static final int LDAP_FILTER_EQUALITY = 163;
    static final int LDAP_FILTER_SUBSTRINGS = 164;
    static final int LDAP_FILTER_GE = 165;
    static final int LDAP_FILTER_LE = 166;
    static final int LDAP_FILTER_PRESENT = 135;
    static final int LDAP_FILTER_APPROX = 168;
    static final int LDAP_FILTER_EXT = 169;
    static final int LDAP_FILTER_EXT_RULE = 129;
    static final int LDAP_FILTER_EXT_TYPE = 130;
    static final int LDAP_FILTER_EXT_VAL = 131;
    static final int LDAP_FILTER_EXT_DN = 132;
    static final int LDAP_SUBSTRING_INITIAL = 128;
    static final int LDAP_SUBSTRING_ANY = 129;
    static final int LDAP_SUBSTRING_FINAL = 130;

    Filter() {
    }

    static void encodeFilterString(BerEncoder berEncoder, String string, boolean bl2) throws IOException, NamingException {
        if (string == null || string.equals("")) {
            throw new InvalidSearchFilterException("Empty filter");
        }
        byte[] byArray = bl2 ? string.getBytes("UTF8") : string.getBytes("8859_1");
        int n2 = byArray.length;
        Filter.encodeFilter(berEncoder, byArray, 0, n2);
    }

    private static void encodeFilter(BerEncoder berEncoder, byte[] byArray, int n2, int n3) throws IOException, NamingException {
        if (n3 - n2 <= 0) {
            throw new InvalidSearchFilterException("Empty filter");
        }
        int n4 = 0;
        int[] nArray = new int[]{n2};
        while (nArray[0] < n3) {
            block0 : switch (byArray[nArray[0]]) {
                case 40: {
                    nArray[0] = nArray[0] + 1;
                    ++n4;
                    switch (byArray[nArray[0]]) {
                        case 38: {
                            Filter.encodeComplexFilter(berEncoder, byArray, 160, nArray, n3);
                            --n4;
                            break block0;
                        }
                        case 124: {
                            Filter.encodeComplexFilter(berEncoder, byArray, 161, nArray, n3);
                            --n4;
                            break block0;
                        }
                        case 33: {
                            Filter.encodeComplexFilter(berEncoder, byArray, 162, nArray, n3);
                            --n4;
                            break block0;
                        }
                    }
                    int n5 = 1;
                    boolean bl2 = false;
                    int n6 = nArray[0];
                    while (n6 < n3 && n5 > 0) {
                        if (!bl2) {
                            if (byArray[n6] == 40) {
                                ++n5;
                            } else if (byArray[n6] == 41) {
                                --n5;
                            }
                        }
                        bl2 = byArray[n6] == 92 && !bl2;
                        if (n5 <= 0) continue;
                        ++n6;
                    }
                    if (n5 != 0) {
                        throw new InvalidSearchFilterException("Unbalanced parenthesis");
                    }
                    Filter.encodeSimpleFilter(berEncoder, byArray, nArray[0], n6);
                    nArray[0] = n6;
                    --n4;
                    break;
                }
                case 41: {
                    berEncoder.endSeq();
                    nArray[0] = nArray[0] + 1;
                    --n4;
                    break;
                }
                case 32: {
                    nArray[0] = nArray[0] + 1;
                    break;
                }
                default: {
                    Filter.encodeSimpleFilter(berEncoder, byArray, nArray[0], n3);
                    nArray[0] = n3;
                }
            }
            nArray[0] = nArray[0] + 1;
        }
        if (n4 > 0) {
            throw new InvalidSearchFilterException("Unbalanced parenthesis");
        }
    }

    private static int hexchar2int(byte by) {
        if (by >= 48 && by <= 57) {
            return by - 48;
        }
        if (by >= 65 && by <= 70) {
            return by - 65 + 10;
        }
        if (by >= 97 && by <= 102) {
            return by - 97 + 10;
        }
        return -1;
    }

    static byte[] unescapeFilterValue(byte[] byArray, int n2, int n3) throws NamingException {
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = n3 - n2;
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            byte by = byArray[i2];
            if (bl2) {
                int n6 = Filter.hexchar2int(by);
                if (n6 < 0) {
                    if (bl3) {
                        bl2 = false;
                        byArray2[n5++] = by;
                        continue;
                    }
                    throw new InvalidSearchFilterException("invalid escape sequence: " + byArray);
                }
                if (bl3) {
                    byArray2[n5] = (byte)(n6 << 4);
                    bl3 = false;
                    continue;
                }
                int n7 = n5++;
                byArray2[n7] = (byte)(byArray2[n7] | (byte)n6);
                bl2 = false;
                continue;
            }
            if (by != 92) {
                byArray2[n5++] = by;
                bl2 = false;
                continue;
            }
            bl2 = true;
            bl3 = true;
        }
        byte[] byArray3 = new byte[n5];
        System.arraycopy(byArray2, 0, byArray3, 0, n5);
        return byArray3;
    }

    private static int indexOf(byte[] byArray, char c2, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (byArray[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    private static int indexOf(byte[] byArray, String string, int n2, int n3) {
        int n4 = Filter.indexOf(byArray, string.charAt(0), n2, n3);
        if (n4 >= 0) {
            for (int i2 = 1; i2 < string.length(); ++i2) {
                if (byArray[n4 + i2] == string.charAt(i2)) continue;
                return -1;
            }
        }
        return n4;
    }

    private static int findUnescaped(byte[] byArray, char c2, int n2, int n3) {
        while (n2 < n3) {
            int n4 = Filter.indexOf(byArray, c2, n2, n3);
            int n5 = 0;
            int n6 = n4 - 1;
            while (n6 >= n2 && byArray[n6] == 92) {
                --n6;
                ++n5;
            }
            if (n4 == n2 || n4 == -1 || n5 % 2 == 0) {
                return n4;
            }
            n2 = n4 + 1;
        }
        return -1;
    }

    private static void encodeSimpleFilter(BerEncoder berEncoder, byte[] byArray, int n2, int n3) throws IOException, NamingException {
        int n4;
        int n5;
        int n6 = Filter.indexOf(byArray, '=', n2, n3);
        if (n6 == -1) {
            throw new InvalidSearchFilterException("Missing 'equals'");
        }
        int n7 = n6 + 1;
        int n8 = n3;
        int n9 = n2;
        switch (byArray[n6 - 1]) {
            case 60: {
                n5 = 166;
                n4 = n6 - 1;
                break;
            }
            case 62: {
                n5 = 165;
                n4 = n6 - 1;
                break;
            }
            case 126: {
                n5 = 168;
                n4 = n6 - 1;
                break;
            }
            case 58: {
                n5 = 169;
                n4 = n6 - 1;
                break;
            }
            default: {
                n4 = n6;
                if (Filter.findUnescaped(byArray, '*', n7, n8) == -1) {
                    n5 = 163;
                    break;
                }
                if (byArray[n7] == 42 && n7 == n8 - 1) {
                    n5 = 135;
                    break;
                }
                Filter.encodeSubstringFilter(berEncoder, byArray, n9, n4, n7, n8);
                return;
            }
        }
        if (n5 == 135) {
            berEncoder.encodeOctetString(byArray, n5, n9, n4 - n9);
        } else if (n5 == 169) {
            Filter.encodeExtensibleMatch(berEncoder, byArray, n9, n4, n7, n8);
        } else {
            berEncoder.beginSeq(n5);
            berEncoder.encodeOctetString(byArray, 4, n9, n4 - n9);
            berEncoder.encodeOctetString(Filter.unescapeFilterValue(byArray, n7, n8), 4);
            berEncoder.endSeq();
        }
    }

    private static void encodeSubstringFilter(BerEncoder berEncoder, byte[] byArray, int n2, int n3, int n4, int n5) throws IOException, NamingException {
        int n6;
        berEncoder.beginSeq(164);
        berEncoder.encodeOctetString(byArray, 4, n2, n3 - n2);
        berEncoder.beginSeq(48);
        int n7 = n4;
        while ((n6 = Filter.findUnescaped(byArray, '*', n7, n5)) != -1) {
            if (n7 == n4) {
                if (n7 < n6) {
                    berEncoder.encodeOctetString(Filter.unescapeFilterValue(byArray, n7, n6), 128);
                }
            } else if (n7 < n6) {
                berEncoder.encodeOctetString(Filter.unescapeFilterValue(byArray, n7, n6), 129);
            }
            n7 = n6 + 1;
        }
        if (n7 < n5) {
            berEncoder.encodeOctetString(Filter.unescapeFilterValue(byArray, n7, n5), 130);
        }
        berEncoder.endSeq();
        berEncoder.endSeq();
    }

    private static void encodeComplexFilter(BerEncoder berEncoder, byte[] byArray, int n2, int[] nArray, int n3) throws IOException, NamingException {
        nArray[0] = nArray[0] + 1;
        berEncoder.beginSeq(n2);
        int[] nArray2 = Filter.findRightParen(byArray, nArray, n3);
        Filter.encodeFilterList(berEncoder, byArray, nArray2[0], nArray2[1]);
        berEncoder.endSeq();
    }

    private static int[] findRightParen(byte[] byArray, int[] nArray, int n2) throws IOException, NamingException {
        int n3 = 1;
        boolean bl2 = false;
        int n4 = nArray[0];
        while (n4 < n2 && n3 > 0) {
            if (!bl2) {
                if (byArray[n4] == 40) {
                    ++n3;
                } else if (byArray[n4] == 41) {
                    --n3;
                }
            }
            bl2 = byArray[n4] == 92 && !bl2;
            if (n3 <= 0) continue;
            ++n4;
        }
        if (n3 != 0) {
            throw new InvalidSearchFilterException("Unbalanced parenthesis");
        }
        int[] nArray2 = new int[]{nArray[0], n4};
        nArray[0] = n4 + 1;
        return nArray2;
    }

    private static void encodeFilterList(BerEncoder berEncoder, byte[] byArray, int n2, int n3) throws IOException, NamingException {
        int[] nArray = new int[]{n2};
        while (nArray[0] < n3) {
            if (!Character.isSpaceChar((char)byArray[nArray[0]]) && byArray[nArray[0]] != 40) {
                int[] nArray2 = Filter.findRightParen(byArray, nArray, n3);
                int n4 = nArray2[1] - nArray2[0];
                byte[] byArray2 = new byte[n4 + 2];
                System.arraycopy(byArray, nArray2[0], byArray2, 1, n4);
                byArray2[0] = 40;
                byArray2[n4 + 1] = 41;
                Filter.encodeFilter(berEncoder, byArray2, 0, byArray2.length);
            }
            nArray[0] = nArray[0] + 1;
        }
    }

    private static void encodeExtensibleMatch(BerEncoder berEncoder, byte[] byArray, int n2, int n3, int n4, int n5) throws IOException, NamingException {
        boolean bl2 = false;
        berEncoder.beginSeq(169);
        int n6 = Filter.indexOf(byArray, ':', n2, n3);
        if (n6 >= 0) {
            int n7;
            int n8 = Filter.indexOf(byArray, ":dn", n6, n3);
            if (n8 >= 0) {
                bl2 = true;
            }
            if ((n7 = Filter.indexOf(byArray, ':', n6 + 1, n3)) >= 0 || n8 == -1) {
                if (n8 == n6) {
                    berEncoder.encodeOctetString(byArray, 129, n7 + 1, n3 - (n7 + 1));
                } else if (n8 == n7 && n8 >= 0) {
                    berEncoder.encodeOctetString(byArray, 129, n6 + 1, n7 - (n6 + 1));
                } else {
                    berEncoder.encodeOctetString(byArray, 129, n6 + 1, n3 - (n6 + 1));
                }
            }
            if (n6 > n2) {
                berEncoder.encodeOctetString(byArray, 130, n2, n6 - n2);
            }
        } else {
            berEncoder.encodeOctetString(byArray, 130, n2, n3 - n2);
        }
        berEncoder.encodeOctetString(Filter.unescapeFilterValue(byArray, n4, n5), 131);
        berEncoder.encodeBoolean(bl2, 132);
        berEncoder.endSeq();
    }

    private static void dprint(String string, byte[] byArray) {
        Filter.dprint(string, byArray, 0, byArray.length);
    }

    private static void dprint(String string, byte[] byArray, int n2, int n3) {
        String string2 = "  ";
        int n4 = dbgIndent;
        while (n4-- > 0) {
            string2 = string2 + "  ";
        }
        string2 = string2 + string;
        System.err.print(string2);
        for (int i2 = n2; i2 < n3; ++i2) {
            System.err.print((char)byArray[i2]);
        }
        System.err.println();
    }
}

