/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.Ber;
import java.io.UnsupportedEncodingException;

public final class BerDecoder
extends Ber {
    private int origOffset;

    public BerDecoder(byte[] byArray, int n2, int n3) {
        this.buf = byArray;
        this.bufsize = n3;
        this.origOffset = n2;
        this.reset();
    }

    public void reset() {
        this.offset = this.origOffset;
    }

    public int getParsePosition() {
        return this.offset;
    }

    public int parseLength() throws Ber.DecodeException {
        int n2 = this.parseByte();
        if ((n2 & 0x80) == 128) {
            if ((n2 &= 0x7F) == 0) {
                throw new Ber.DecodeException("Indefinite length not supported");
            }
            if (n2 > 4) {
                throw new Ber.DecodeException("encoding too long");
            }
            if (this.bufsize - this.offset < n2) {
                throw new Ber.DecodeException("Insufficient data");
            }
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 = (n3 << 8) + (this.buf[this.offset++] & 0xFF);
            }
            return n3;
        }
        return n2;
    }

    public int parseSeq(int[] nArray) throws Ber.DecodeException {
        int n2 = this.parseByte();
        int n3 = this.parseLength();
        if (nArray != null) {
            nArray[0] = n3;
        }
        return n2;
    }

    void seek(int n2) throws Ber.DecodeException {
        if (this.offset + n2 > this.bufsize || this.offset + n2 < 0) {
            throw new Ber.DecodeException("array index out of bounds");
        }
        this.offset += n2;
    }

    public int parseByte() throws Ber.DecodeException {
        if (this.bufsize - this.offset < 1) {
            throw new Ber.DecodeException("Insufficient data");
        }
        return this.buf[this.offset++] & 0xFF;
    }

    public int peekByte() throws Ber.DecodeException {
        if (this.bufsize - this.offset < 1) {
            throw new Ber.DecodeException("Insufficient data");
        }
        return this.buf[this.offset] & 0xFF;
    }

    public boolean parseBoolean() throws Ber.DecodeException {
        return this.parseIntWithTag(1) != 0;
    }

    public int parseEnumeration() throws Ber.DecodeException {
        return this.parseIntWithTag(10);
    }

    public int parseInt() throws Ber.DecodeException {
        return this.parseIntWithTag(2);
    }

    private int parseIntWithTag(int n2) throws Ber.DecodeException {
        if (this.parseByte() != n2) {
            throw new Ber.DecodeException("Encountered ASN.1 tag " + Integer.toString(this.buf[this.offset - 1] & 0xFF) + " (expected tag " + Integer.toString(n2) + ")");
        }
        int n3 = this.parseLength();
        if (n3 > 4) {
            throw new Ber.DecodeException("INTEGER too long");
        }
        if (n3 > this.bufsize - this.offset) {
            throw new Ber.DecodeException("Insufficient data");
        }
        byte by = this.buf[this.offset++];
        int n4 = 0;
        n4 = by & 0x7F;
        for (int i2 = 1; i2 < n3; ++i2) {
            n4 <<= 8;
            n4 |= this.buf[this.offset++] & 0xFF;
        }
        if ((by & 0x80) == 128) {
            n4 = -n4;
        }
        return n4;
    }

    public String parseString(boolean bl2) throws Ber.DecodeException {
        return this.parseStringWithTag(4, bl2, null);
    }

    public String parseStringWithTag(int n2, boolean bl2, int[] nArray) throws Ber.DecodeException {
        String string;
        int n3 = this.offset;
        int n4 = this.parseByte();
        if (n4 != n2) {
            throw new Ber.DecodeException("Encountered ASN.1 tag " + Integer.toString((byte)n4) + " (expected tag " + n2 + ")");
        }
        int n5 = this.parseLength();
        if (n5 > this.bufsize - this.offset) {
            throw new Ber.DecodeException("Insufficient data");
        }
        if (n5 == 0) {
            string = "";
        } else {
            byte[] byArray = new byte[n5];
            System.arraycopy(this.buf, this.offset, byArray, 0, n5);
            if (bl2) {
                try {
                    string = new String(byArray, "UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new Ber.DecodeException("UTF8 not available on platform");
                }
            }
            try {
                string = new String(byArray, "8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Ber.DecodeException("8859_1 not available on platform");
            }
            this.offset += n5;
        }
        if (nArray != null) {
            nArray[0] = this.offset - n3;
        }
        return string;
    }

    public byte[] parseOctetString(int n2, int[] nArray) throws Ber.DecodeException {
        int n3 = this.offset;
        int n4 = this.parseByte();
        if (n4 != n2) {
            throw new Ber.DecodeException("Encountered ASN.1 tag " + Integer.toString(n4) + " (expected tag " + Integer.toString(n2) + ")");
        }
        int n5 = this.parseLength();
        if (n5 > this.bufsize - this.offset) {
            throw new Ber.DecodeException("Insufficient data");
        }
        byte[] byArray = new byte[n5];
        if (n5 > 0) {
            System.arraycopy(this.buf, this.offset, byArray, 0, n5);
            this.offset += n5;
        }
        if (nArray != null) {
            nArray[0] = this.offset - n3;
        }
        return byArray;
    }

    public int bytesLeft() {
        return this.bufsize - this.offset;
    }
}

