/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public final class DnsName
implements Name {
    private String domain = "";
    private ArrayList labels = new ArrayList();
    private short octets = 1;
    private static final long serialVersionUID = 7040187611324710271L;

    public DnsName() {
    }

    public DnsName(String string) throws InvalidNameException {
        this.parse(string);
    }

    private DnsName(DnsName dnsName, int n2, int n3) {
        int n4 = dnsName.size() - n3;
        int n5 = dnsName.size() - n2;
        this.labels.addAll(dnsName.labels.subList(n4, n5));
        if (this.size() == dnsName.size()) {
            this.domain = dnsName.domain;
            this.octets = dnsName.octets;
        } else {
            for (String string : this.labels) {
                if (string.length() <= 0) continue;
                this.octets = (short)(this.octets + (short)(string.length() + 1));
            }
        }
    }

    public String toString() {
        if (this.domain == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : this.labels) {
                if (stringBuffer.length() > 0 || string.length() == 0) {
                    stringBuffer.append('.');
                }
                DnsName.escape(stringBuffer, string);
            }
            this.domain = stringBuffer.toString();
        }
        return this.domain;
    }

    public boolean isHostName() {
        Iterator iterator = this.labels.iterator();
        while (iterator.hasNext()) {
            if (DnsName.isHostNameLabel((String)iterator.next())) continue;
            return false;
        }
        return true;
    }

    public short getOctets() {
        return this.octets;
    }

    public int size() {
        return this.labels.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            n2 = 31 * n2 + this.getKey(i2).hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Name) || object instanceof CompositeName) {
            return false;
        }
        Name name = (Name)object;
        return this.size() == name.size() && this.compareTo(object) == 0;
    }

    public int compareTo(Object object) {
        Name name = (Name)object;
        return this.compareRange(0, this.size(), name);
    }

    public boolean startsWith(Name name) {
        return this.size() >= name.size() && this.compareRange(0, name.size(), name) == 0;
    }

    public boolean endsWith(Name name) {
        return this.size() >= name.size() && this.compareRange(this.size() - name.size(), this.size(), name) == 0;
    }

    public String get(int n2) {
        if (n2 < 0 || n2 >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = this.size() - n2 - 1;
        return (String)this.labels.get(n3);
    }

    public Enumeration getAll() {
        return new Enumeration(){
            int pos = 0;

            public boolean hasMoreElements() {
                return this.pos < DnsName.this.size();
            }

            public Object nextElement() {
                if (this.pos < DnsName.this.size()) {
                    return DnsName.this.get(this.pos++);
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Name getPrefix(int n2) {
        return new DnsName(this, 0, n2);
    }

    public Name getSuffix(int n2) {
        return new DnsName(this, n2, this.size());
    }

    public Object clone() {
        return new DnsName(this, 0, this.size());
    }

    public Object remove(int n2) {
        if (n2 < 0 || n2 >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = this.size() - n2 - 1;
        String string = (String)this.labels.remove(n3);
        int n4 = string.length();
        if (n4 > 0) {
            this.octets = (short)(this.octets - (short)(n4 + 1));
        }
        this.domain = null;
        return string;
    }

    public Name add(String string) throws InvalidNameException {
        return this.add(this.size(), string);
    }

    public Name add(int n2, String string) throws InvalidNameException {
        if (n2 < 0 || n2 > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = string.length();
        if (n2 > 0 && n3 == 0 || n2 == 0 && this.hasRootLabel()) {
            throw new InvalidNameException("Empty label must be the last label in a domain name");
        }
        if (n3 > 0) {
            if (this.octets + n3 + 1 >= 256) {
                throw new InvalidNameException("Name too long");
            }
            this.octets = (short)(this.octets + (short)(n3 + 1));
        }
        int n4 = this.size() - n2;
        DnsName.verifyLabel(string);
        this.labels.add(n4, string);
        this.domain = null;
        return this;
    }

    public Name addAll(Name name) throws InvalidNameException {
        return this.addAll(this.size(), name);
    }

    public Name addAll(int n2, Name name) throws InvalidNameException {
        if (name instanceof DnsName) {
            DnsName dnsName = (DnsName)name;
            if (dnsName.isEmpty()) {
                return this;
            }
            if (n2 > 0 && dnsName.hasRootLabel() || n2 == 0 && this.hasRootLabel()) {
                throw new InvalidNameException("Empty label must be the last label in a domain name");
            }
            short s2 = (short)(this.octets + dnsName.octets - 1);
            if (s2 > 255) {
                throw new InvalidNameException("Name too long");
            }
            this.octets = s2;
            int n3 = this.size() - n2;
            this.labels.addAll(n3, dnsName.labels);
            this.domain = this.isEmpty() ? dnsName.domain : (this.domain == null || dnsName.domain == null ? null : (n2 == 0 ? this.domain + (dnsName.domain.equals(".") ? "" : ".") + dnsName.domain : (n2 == this.size() ? dnsName.domain + (this.domain.equals(".") ? "" : ".") + this.domain : null)));
        } else if (name instanceof CompositeName) {
            name = (DnsName)name;
        } else {
            for (int i2 = name.size() - 1; i2 >= 0; --i2) {
                this.add(n2, name.get(i2));
            }
        }
        return this;
    }

    boolean hasRootLabel() {
        return !this.isEmpty() && this.get(0).equals("");
    }

    private int compareRange(int n2, int n3, Name name) {
        if (name instanceof CompositeName) {
            name = (DnsName)name;
        }
        int n4 = Math.min(n3 - n2, name.size());
        for (int i2 = 0; i2 < n4; ++i2) {
            String string = this.get(i2 + n2);
            String string2 = name.get(i2);
            int n5 = this.size() - (i2 + n2) - 1;
            int n6 = DnsName.compareLabels(string, string2);
            if (n6 == 0) continue;
            return n6;
        }
        return n3 - n2 - name.size();
    }

    String getKey(int n2) {
        return DnsName.keyForLabel(this.get(n2));
    }

    private void parse(String string) throws InvalidNameException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\') {
                c2 = DnsName.getEscapedOctet(string, i2++);
                if (DnsName.isDigit(string.charAt(i2))) {
                    i2 += 2;
                }
                stringBuffer.append(c2);
                continue;
            }
            if (c2 != '.') {
                stringBuffer.append(c2);
                continue;
            }
            this.add(0, stringBuffer.toString());
            stringBuffer.delete(0, i2);
        }
        if (!string.equals("") && !string.equals(".")) {
            this.add(0, stringBuffer.toString());
        }
        this.domain = string;
    }

    private static char getEscapedOctet(String string, int n2) throws InvalidNameException {
        try {
            char c2 = string.charAt(++n2);
            if (DnsName.isDigit(c2)) {
                char c3 = string.charAt(++n2);
                char c4 = string.charAt(++n2);
                if (DnsName.isDigit(c3) && DnsName.isDigit(c4)) {
                    return (char)((c2 - 48) * 100 + (c3 - 48) * 10 + (c4 - 48));
                }
                throw new InvalidNameException("Invalid escape sequence in " + string);
            }
            return c2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InvalidNameException("Invalid escape sequence in " + string);
        }
    }

    private static void verifyLabel(String string) throws InvalidNameException {
        if (string.length() > 63) {
            throw new InvalidNameException("Label exceeds 63 octets: " + string);
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if ((c2 & 0xFF00) == 0) continue;
            throw new InvalidNameException("Label has two-byte char: " + string);
        }
    }

    private static boolean isHostNameLabel(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (DnsName.isHostNameChar(c2)) continue;
            return false;
        }
        return !string.startsWith("-") && !string.endsWith("-");
    }

    private static boolean isHostNameChar(char c2) {
        return c2 == '-' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9';
    }

    private static boolean isDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private static void escape(StringBuffer stringBuffer, String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '.' || c2 == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c2);
        }
    }

    private static int compareLabels(String string, String string2) {
        int n2 = Math.min(string.length(), string2.length());
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            char c3 = string2.charAt(i2);
            if (c2 >= 'A' && c2 <= 'Z') {
                c2 = (char)(c2 + 32);
            }
            if (c3 >= 'A' && c3 <= 'Z') {
                c3 = (char)(c3 + 32);
            }
            if (c2 == c3) continue;
            return c2 - c3;
        }
        return string.length() - string2.length();
    }

    private static String keyForLabel(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= 'A' && c2 <= 'Z') {
                c2 = (char)(c2 + 32);
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.toString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.parse((String)objectInputStream.readObject());
        }
        catch (InvalidNameException invalidNameException) {
            throw new StreamCorruptedException("Invalid name: " + this.domain);
        }
    }
}

