/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.snmp.SnmpDataTypeEnums;
import com.sun.jmx.snmp.SnmpInt;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.agent.AcmChecker;
import com.sun.jmx.snmp.agent.SnmpEntryOid;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpMibNode;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpRequestTree;
import com.sun.jmx.snmp.agent.SnmpTableEntryFactory;
import com.sun.jmx.snmp.agent.SnmpTableEntryNotification;
import com.sun.jmx.trace.Trace;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public abstract class SnmpMibTable
extends SnmpMibNode
implements NotificationBroadcaster,
Serializable {
    protected int nodeId = 1;
    protected SnmpMib theMib;
    protected boolean creationEnabled = false;
    protected SnmpTableEntryFactory factory = null;
    private int size = 0;
    private static final int Delta = 16;
    private int tablecount = 0;
    private int tablesize = 16;
    private SnmpOid[] tableoids = new SnmpOid[this.tablesize];
    private final Vector entries = new Vector();
    private final Vector entrynames = new Vector();
    private Hashtable handbackTable = new Hashtable();
    private Hashtable filterTable = new Hashtable();
    transient long sequenceNumber = 0L;

    public SnmpMibTable(SnmpMib snmpMib) {
        this.theMib = snmpMib;
        this.setCreationEnabled(false);
    }

    public abstract void createNewEntry(SnmpMibSubRequest var1, SnmpOid var2, int var3) throws SnmpStatusException;

    public abstract boolean isRegistrationRequired();

    public boolean isCreationEnabled() {
        return this.creationEnabled;
    }

    public void setCreationEnabled(boolean bl2) {
        this.creationEnabled = bl2;
    }

    public boolean hasRowStatus() {
        return false;
    }

    public void get(SnmpMibSubRequest snmpMibSubRequest, int n2) throws SnmpStatusException {
        SnmpDataTypeEnums snmpDataTypeEnums;
        boolean bl2 = snmpMibSubRequest.isNewEntry();
        SnmpMibSubRequest snmpMibSubRequest2 = snmpMibSubRequest;
        if (bl2) {
            snmpDataTypeEnums = null;
            Enumeration enumeration = snmpMibSubRequest2.getElements();
            while (enumeration.hasMoreElements()) {
                snmpDataTypeEnums = (SnmpVarBind)enumeration.nextElement();
                snmpMibSubRequest2.registerGetException((SnmpVarBind)snmpDataTypeEnums, noSuchInstanceException);
            }
        }
        snmpDataTypeEnums = snmpMibSubRequest2.getEntryOid();
        this.get(snmpMibSubRequest, (SnmpOid)snmpDataTypeEnums, n2 + 1);
    }

    public void check(SnmpMibSubRequest snmpMibSubRequest, int n2) throws SnmpStatusException {
        SnmpOid snmpOid = snmpMibSubRequest.getEntryOid();
        int n3 = this.getRowAction(snmpMibSubRequest, snmpOid, n2 + 1);
        boolean bl2 = SnmpMibTable.isDebugOn();
        if (bl2) {
            this.debug("check", "Calling beginRowAction");
        }
        this.beginRowAction(snmpMibSubRequest, snmpOid, n2 + 1, n3);
        if (bl2) {
            this.debug("check", "Calling check for " + snmpMibSubRequest.getSize() + " varbinds.");
        }
        this.check(snmpMibSubRequest, snmpOid, n2 + 1);
        if (bl2) {
            this.debug("check", "check finished");
        }
    }

    public void set(SnmpMibSubRequest snmpMibSubRequest, int n2) throws SnmpStatusException {
        boolean bl2 = SnmpMibTable.isDebugOn();
        if (bl2) {
            this.debug("set", "Entering set.");
        }
        SnmpOid snmpOid = snmpMibSubRequest.getEntryOid();
        int n3 = this.getRowAction(snmpMibSubRequest, snmpOid, n2 + 1);
        if (bl2) {
            this.debug("set", "Calling set for " + snmpMibSubRequest.getSize() + "varbinds.");
        }
        this.set(snmpMibSubRequest, snmpOid, n2 + 1);
        if (bl2) {
            this.debug("set", "Calling endRowAction");
        }
        this.endRowAction(snmpMibSubRequest, snmpOid, n2 + 1, n3);
        if (bl2) {
            this.debug("set", "RowAction finished");
        }
    }

    public void addEntry(SnmpOid snmpOid, Object object) throws SnmpStatusException {
        this.addEntry(snmpOid, null, object);
    }

    public synchronized void addEntry(SnmpOid snmpOid, ObjectName objectName, Object object) throws SnmpStatusException {
        if (this.isRegistrationRequired() && objectName == null) {
            throw new SnmpStatusException(3);
        }
        if (this.size == 0) {
            this.insertOid(0, snmpOid);
            if (this.entries != null) {
                this.entries.addElement(object);
            }
            if (this.entrynames != null) {
                this.entrynames.addElement(objectName);
            }
            ++this.size;
            if (this.factory != null) {
                try {
                    this.factory.addEntryCb(0, snmpOid, objectName, object, this);
                }
                catch (SnmpStatusException snmpStatusException) {
                    this.removeOid(0);
                    if (this.entries != null) {
                        this.entries.removeElementAt(0);
                    }
                    if (this.entrynames != null) {
                        this.entrynames.removeElementAt(0);
                    }
                    throw snmpStatusException;
                }
            }
            this.sendNotification(SnmpTableEntryNotification.SNMP_ENTRY_ADDED, new Date().getTime(), object, objectName);
            return;
        }
        int n2 = 0;
        n2 = this.getInsertionPoint(snmpOid, true);
        if (n2 == this.size) {
            this.insertOid(this.tablecount, snmpOid);
            if (this.entries != null) {
                this.entries.addElement(object);
            }
            if (this.entrynames != null) {
                this.entrynames.addElement(objectName);
            }
            ++this.size;
        } else {
            try {
                this.insertOid(n2, snmpOid);
                if (this.entries != null) {
                    this.entries.insertElementAt(object, n2);
                }
                if (this.entrynames != null) {
                    this.entrynames.insertElementAt(objectName, n2);
                }
                ++this.size;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (this.factory != null) {
            try {
                this.factory.addEntryCb(n2, snmpOid, objectName, object, this);
            }
            catch (SnmpStatusException snmpStatusException) {
                this.removeOid(n2);
                if (this.entries != null) {
                    this.entries.removeElementAt(n2);
                }
                if (this.entrynames != null) {
                    this.entrynames.removeElementAt(n2);
                }
                throw snmpStatusException;
            }
        }
        this.sendNotification(SnmpTableEntryNotification.SNMP_ENTRY_ADDED, new Date().getTime(), object, objectName);
    }

    public synchronized void removeEntry(SnmpOid snmpOid, Object object) throws SnmpStatusException {
        int n2 = this.findObject(snmpOid);
        if (n2 == -1) {
            return;
        }
        this.removeEntry(n2, object);
    }

    public void removeEntry(SnmpOid snmpOid) throws SnmpStatusException {
        int n2 = this.findObject(snmpOid);
        if (n2 == -1) {
            return;
        }
        this.removeEntry(n2, null);
    }

    public synchronized void removeEntry(int n2, Object object) throws SnmpStatusException {
        if (n2 == -1) {
            return;
        }
        if (n2 >= this.size) {
            return;
        }
        Object object2 = object;
        if (this.entries != null && this.entries.size() > n2) {
            object2 = this.entries.elementAt(n2);
            this.entries.removeElementAt(n2);
        }
        ObjectName objectName = null;
        if (this.entrynames != null && this.entrynames.size() > n2) {
            objectName = (ObjectName)this.entrynames.elementAt(n2);
            this.entrynames.removeElementAt(n2);
        }
        SnmpOid snmpOid = this.tableoids[n2];
        this.removeOid(n2);
        --this.size;
        if (object2 == null) {
            object2 = object;
        }
        if (this.factory != null) {
            this.factory.removeEntryCb(n2, snmpOid, objectName, object2, this);
        }
        this.sendNotification(SnmpTableEntryNotification.SNMP_ENTRY_REMOVED, new Date().getTime(), object2, objectName);
    }

    public synchronized Object getEntry(SnmpOid snmpOid) throws SnmpStatusException {
        int n2 = this.findObject(snmpOid);
        if (n2 == -1) {
            throw new SnmpStatusException(224);
        }
        return this.entries.elementAt(n2);
    }

    public synchronized ObjectName getEntryName(SnmpOid snmpOid) throws SnmpStatusException {
        int n2 = this.findObject(snmpOid);
        if (this.entrynames == null) {
            return null;
        }
        if (n2 == -1 || n2 >= this.entrynames.size()) {
            throw new SnmpStatusException(224);
        }
        return (ObjectName)this.entrynames.elementAt(n2);
    }

    public Object[] getBasicEntries() {
        Object[] objectArray = new Object[this.size];
        this.entries.copyInto(objectArray);
        return objectArray;
    }

    public int getSize() {
        return this.size;
    }

    public synchronized void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (notificationListener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        Vector<Object> vector = (Vector<Object>)this.handbackTable.get(notificationListener);
        Vector<NotificationFilter> vector2 = (Vector<NotificationFilter>)this.filterTable.get(notificationListener);
        if (vector == null) {
            vector = new Vector<Object>();
            vector2 = new Vector<NotificationFilter>();
            this.handbackTable.put(notificationListener, vector);
            this.filterTable.put(notificationListener, vector2);
        }
        vector.addElement(object);
        vector2.addElement(notificationFilter);
    }

    public synchronized void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        Vector vector = (Vector)this.handbackTable.get(notificationListener);
        Vector vector2 = (Vector)this.filterTable.get(notificationListener);
        if (vector == null) {
            throw new ListenerNotFoundException("listener");
        }
        this.handbackTable.remove(notificationListener);
        this.filterTable.remove(notificationListener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{SnmpTableEntryNotification.SNMP_ENTRY_ADDED, SnmpTableEntryNotification.SNMP_ENTRY_REMOVED};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, "com.sun.jmx.snmp.agent.SnmpTableEntryNotification", "Notifications sent by the SnmpMibTable")};
        return mBeanNotificationInfoArray;
    }

    public void registerEntryFactory(SnmpTableEntryFactory snmpTableEntryFactory) {
        this.factory = snmpTableEntryFactory;
    }

    protected boolean isRowStatus(SnmpOid snmpOid, long l2, Object object) {
        return false;
    }

    protected int getRowAction(SnmpMibSubRequest snmpMibSubRequest, SnmpOid snmpOid, int n2) throws SnmpStatusException {
        boolean bl2 = snmpMibSubRequest.isNewEntry();
        SnmpVarBind snmpVarBind = snmpMibSubRequest.getRowStatusVarBind();
        if (snmpVarBind == null) {
            if (bl2 && !this.hasRowStatus()) {
                return 4;
            }
            return 0;
        }
        try {
            return this.mapRowStatus(snmpOid, snmpVarBind, snmpMibSubRequest.getUserData());
        }
        catch (SnmpStatusException snmpStatusException) {
            SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, snmpStatusException.getStatus());
            return 0;
        }
    }

    protected int mapRowStatus(SnmpOid snmpOid, SnmpVarBind snmpVarBind, Object object) throws SnmpStatusException {
        SnmpValue snmpValue = snmpVarBind.value;
        if (snmpValue instanceof SnmpInt) {
            return ((SnmpInt)snmpValue).intValue();
        }
        throw new SnmpStatusException(12);
    }

    protected SnmpValue setRowStatus(SnmpOid snmpOid, int n2, Object object) throws SnmpStatusException {
        return null;
    }

    protected boolean isRowReady(SnmpOid snmpOid, Object object) throws SnmpStatusException {
        return true;
    }

    protected void checkRowStatusChange(SnmpMibSubRequest snmpMibSubRequest, SnmpOid snmpOid, int n2, int n3) throws SnmpStatusException {
    }

    protected void checkRemoveTableRow(SnmpMibSubRequest snmpMibSubRequest, SnmpOid snmpOid, int n2) throws SnmpStatusException {
    }

    protected void removeTableRow(SnmpMibSubRequest snmpMibSubRequest, SnmpOid snmpOid, int n2) throws SnmpStatusException {
        this.removeEntry(snmpOid);
    }

    protected synchronized void beginRowAction(SnmpMibSubRequest snmpMibSubRequest, SnmpOid snmpOid, int n2, int n3) throws SnmpStatusException {
        boolean bl2 = snmpMibSubRequest.isNewEntry();
        SnmpOid snmpOid2 = snmpOid;
        int n4 = n3;
        switch (n4) {
            case 0: {
                if (!bl2) break;
                if (SnmpMibTable.isDebugOn()) {
                    this.debug("beginRowAction", "Failed to create row[" + snmpOid + "] : RowStatus = unspecified");
                }
                SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, 6);
                break;
            }
            case 4: 
            case 5: {
                if (bl2) {
                    if (this.isCreationEnabled()) {
                        if (SnmpMibTable.isDebugOn()) {
                            this.debug("beginRowAction", "Creating row[" + snmpOid + "] : RowStatus = createAndGo | createAndWait");
                        }
                        this.createNewEntry(snmpMibSubRequest, snmpOid2, n2);
                        break;
                    }
                    if (SnmpMibTable.isDebugOn()) {
                        this.debug("beginRowAction", "Can't create row[" + snmpOid + "] : RowStatus = createAndGo | createAndWait" + " but creation is disabled");
                    }
                    SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, 6);
                    break;
                }
                if (SnmpMibTable.isDebugOn()) {
                    this.debug("beginRowAction", "Can't create row[" + snmpOid + "] : RowStatus = createAndGo | createAndWait" + " but row already exists");
                }
                SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, 12);
                break;
            }
            case 6: {
                if (bl2) {
                    if (SnmpMibTable.isDebugOn()) {
                        this.debug("beginRowAction", "Warning: can't destroy row[" + snmpOid + "] : RowStatus = destroy" + " but row does not exist");
                    }
                } else if (!this.isCreationEnabled()) {
                    if (SnmpMibTable.isDebugOn()) {
                        this.debug("beginRowAction", "Can't destroy row[" + snmpOid + "] : RowStatus = destroy " + " but creation is disabled");
                    }
                    SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, 6);
                }
                this.checkRemoveTableRow(snmpMibSubRequest, snmpOid, n2);
                break;
            }
            case 1: 
            case 2: {
                if (bl2) {
                    if (SnmpMibTable.isDebugOn()) {
                        this.debug("beginRowAction", "Can't switch state of row[" + snmpOid + "] : specified RowStatus = active | notInService" + " but row does not exist");
                    }
                    SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, 12);
                }
                this.checkRowStatusChange(snmpMibSubRequest, snmpOid, n2, n4);
                break;
            }
            default: {
                if (SnmpMibTable.isDebugOn()) {
                    this.debug("beginRowAction", "Invalid RowStatus value for row[" + snmpOid + "] : specified RowStatus = " + n4);
                }
                SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, 12);
            }
        }
    }

    protected void endRowAction(SnmpMibSubRequest snmpMibSubRequest, SnmpOid snmpOid, int n2, int n3) throws SnmpStatusException {
        SnmpVarBind snmpVarBind;
        boolean bl2 = snmpMibSubRequest.isNewEntry();
        SnmpOid snmpOid2 = snmpOid;
        int n4 = n3;
        Object object = snmpMibSubRequest.getUserData();
        SnmpValue snmpValue = null;
        switch (n4) {
            case 0: {
                break;
            }
            case 4: {
                if (SnmpMibTable.isDebugOn()) {
                    this.debug("endRowAction", "Setting RowStatus to `active' for row[" + snmpOid + "] : requested RowStatus = " + "createAndGo");
                }
                snmpValue = this.setRowStatus(snmpOid2, 1, object);
                break;
            }
            case 5: {
                if (this.isRowReady(snmpOid2, object)) {
                    if (SnmpMibTable.isDebugOn()) {
                        this.debug("endRowAction", "Setting RowStatus to `notInService' for row[" + snmpOid + "] : requested RowStatus = " + "createAndWait");
                    }
                    snmpValue = this.setRowStatus(snmpOid2, 2, object);
                    break;
                }
                if (SnmpMibTable.isDebugOn()) {
                    this.debug("endRowAction", "Setting RowStatus to `notReady' for row[" + snmpOid + "] : requested RowStatus = " + "createAndWait");
                }
                snmpValue = this.setRowStatus(snmpOid2, 3, object);
                break;
            }
            case 6: {
                if (bl2) {
                    if (SnmpMibTable.isDebugOn()) {
                        this.debug("endRowAction", "Warning:  requested RowStatus = destroy,but row[" + snmpOid + "] does not exist.");
                    }
                } else if (SnmpMibTable.isDebugOn()) {
                    this.debug("endRowAction", "destroying row[" + snmpOid + "] : requested RowStatus = destroy");
                }
                this.removeTableRow(snmpMibSubRequest, snmpOid2, n2);
                break;
            }
            case 1: {
                if (SnmpMibTable.isDebugOn()) {
                    this.debug("endRowAction", "Setting RowStatus to `active' for row[" + snmpOid + "] : requested RowStatus = " + "active");
                }
                snmpValue = this.setRowStatus(snmpOid2, 1, object);
                break;
            }
            case 2: {
                if (SnmpMibTable.isDebugOn()) {
                    this.debug("endRowAction", "Setting RowStatus to `notInService' for row[" + snmpOid + "] : requested RowStatus = " + "notInService");
                }
                snmpValue = this.setRowStatus(snmpOid2, 2, object);
                break;
            }
            default: {
                if (SnmpMibTable.isDebugOn()) {
                    this.debug("endRowAction", "Invalid RowStatus value for row[" + snmpOid + "] : specified RowStatus = " + n4);
                }
                SnmpMibTable.setRowStatusFail(snmpMibSubRequest, 12);
            }
        }
        if (snmpValue != null && (snmpVarBind = snmpMibSubRequest.getRowStatusVarBind()) != null) {
            snmpVarBind.value = snmpValue;
        }
    }

    protected long getNextVarEntryId(SnmpOid snmpOid, long l2, Object object, int n2) throws SnmpStatusException {
        long l3 = l2;
        while (this.skipEntryVariable(snmpOid, l3 = this.getNextVarEntryId(snmpOid, l3, object), object, n2)) {
        }
        return l3;
    }

    protected boolean skipEntryVariable(SnmpOid snmpOid, long l2, Object object, int n2) {
        return false;
    }

    protected SnmpOid getNextOid(SnmpOid snmpOid, Object object) throws SnmpStatusException {
        if (this.size == 0) {
            throw noSuchInstanceException;
        }
        SnmpOid snmpOid2 = this.tableoids[this.tablecount - 1];
        SnmpOid snmpOid3 = snmpOid;
        if (snmpOid2.equals(snmpOid3)) {
            throw noSuchInstanceException;
        }
        int n2 = this.getInsertionPoint(snmpOid3, false);
        if (n2 > -1 && n2 < this.size) {
            try {
                snmpOid2 = this.tableoids[n2];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw noSuchInstanceException;
            }
        } else {
            throw noSuchInstanceException;
        }
        return snmpOid2;
    }

    protected SnmpOid getNextOid(Object object) throws SnmpStatusException {
        if (this.size == 0) {
            throw noSuchInstanceException;
        }
        return this.tableoids[0];
    }

    protected abstract long getNextVarEntryId(SnmpOid var1, long var2, Object var4) throws SnmpStatusException;

    protected abstract void validateVarEntryId(SnmpOid var1, long var2, Object var4) throws SnmpStatusException;

    protected abstract boolean isReadableEntryId(SnmpOid var1, long var2, Object var4) throws SnmpStatusException;

    protected abstract void get(SnmpMibSubRequest var1, SnmpOid var2, int var3) throws SnmpStatusException;

    protected abstract void check(SnmpMibSubRequest var1, SnmpOid var2, int var3) throws SnmpStatusException;

    protected abstract void set(SnmpMibSubRequest var1, SnmpOid var2, int var3) throws SnmpStatusException;

    SnmpOid getNextOid(long[] lArray, int n2, Object object) throws SnmpStatusException {
        SnmpEntryOid snmpEntryOid = new SnmpEntryOid(lArray, n2);
        return this.getNextOid(snmpEntryOid, object);
    }

    static final void checkRowStatusFail(SnmpMibSubRequest snmpMibSubRequest, int n2) throws SnmpStatusException {
        SnmpVarBind snmpVarBind = snmpMibSubRequest.getRowStatusVarBind();
        SnmpStatusException snmpStatusException = new SnmpStatusException(n2);
        snmpMibSubRequest.registerCheckException(snmpVarBind, snmpStatusException);
    }

    static final void setRowStatusFail(SnmpMibSubRequest snmpMibSubRequest, int n2) throws SnmpStatusException {
        SnmpVarBind snmpVarBind = snmpMibSubRequest.getRowStatusVarBind();
        SnmpStatusException snmpStatusException = new SnmpStatusException(n2);
        snmpMibSubRequest.registerSetException(snmpVarBind, snmpStatusException);
    }

    final synchronized void findHandlingNode(SnmpVarBind snmpVarBind, long[] lArray, int n2, SnmpRequestTree snmpRequestTree) throws SnmpStatusException {
        int n3 = lArray.length;
        if (snmpRequestTree == null) {
            throw new SnmpStatusException(5);
        }
        if (n2 >= n3) {
            throw new SnmpStatusException(6);
        }
        if (lArray[n2] != (long)this.nodeId) {
            throw new SnmpStatusException(6);
        }
        if (n2 + 2 >= n3) {
            throw new SnmpStatusException(6);
        }
        SnmpEntryOid snmpEntryOid = new SnmpEntryOid(lArray, n2 + 2);
        Object object = snmpRequestTree.getUserData();
        boolean bl2 = this.contains(snmpEntryOid, object);
        if (!bl2) {
            if (!snmpRequestTree.isCreationAllowed()) {
                throw noSuchInstanceException;
            }
            if (!this.isCreationEnabled()) {
                throw new SnmpStatusException(6);
            }
        }
        long l2 = lArray[n2 + 1];
        if (bl2) {
            this.validateVarEntryId(snmpEntryOid, l2, object);
        }
        if (snmpRequestTree.isSetRequest() && this.isRowStatus(snmpEntryOid, l2, object)) {
            snmpRequestTree.add(this, n2, snmpEntryOid, snmpVarBind, !bl2, snmpVarBind);
        } else {
            snmpRequestTree.add(this, n2, snmpEntryOid, snmpVarBind, !bl2);
        }
    }

    final synchronized long[] findNextHandlingNode(SnmpVarBind snmpVarBind, long[] lArray, int n2, int n3, SnmpRequestTree snmpRequestTree, AcmChecker acmChecker) throws SnmpStatusException {
        int n4 = lArray.length;
        if (snmpRequestTree == null) {
            throw noSuchObjectException;
        }
        Object object = snmpRequestTree.getUserData();
        int n5 = snmpRequestTree.getRequestPduVersion();
        long l2 = -1L;
        if (n2 >= n4) {
            lArray = new long[]{this.nodeId};
            n2 = 0;
            n4 = 1;
        } else {
            if (lArray[n2] > (long)this.nodeId) {
                throw noSuchObjectException;
            }
            if (lArray[n2] < (long)this.nodeId) {
                lArray = new long[]{this.nodeId};
                n2 = 0;
                n4 = 0;
            } else if (n2 + 1 < n4) {
                l2 = lArray[n2 + 1];
            }
        }
        SnmpOid snmpOid = null;
        if (n2 == n4 - 1) {
            snmpOid = this.getNextOid(object);
            l2 = this.getNextVarEntryId(snmpOid, l2, object, n5);
        } else if (n2 == n4 - 2) {
            snmpOid = this.getNextOid(object);
            if (this.skipEntryVariable(snmpOid, l2, object, n5)) {
                l2 = this.getNextVarEntryId(snmpOid, l2, object, n5);
            }
        } else {
            try {
                snmpOid = this.getNextOid(lArray, n2 + 2, object);
                if (this.skipEntryVariable(snmpOid, l2, object, n5)) {
                    throw noSuchObjectException;
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpOid = this.getNextOid(object);
                l2 = this.getNextVarEntryId(snmpOid, l2, object, n5);
            }
        }
        return this.findNextAccessibleOid(snmpOid, snmpVarBind, lArray, n3, snmpRequestTree, acmChecker, object, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] findNextAccessibleOid(SnmpOid snmpOid, SnmpVarBind snmpVarBind, long[] lArray, int n2, SnmpRequestTree snmpRequestTree, AcmChecker acmChecker, Object object, long l2) throws SnmpStatusException {
        int n3 = snmpRequestTree.getRequestPduVersion();
        do {
            if (snmpOid == null || l2 == -1L) {
                throw noSuchObjectException;
            }
            if (!this.isReadableEntryId(snmpOid, l2, object)) {
                throw noSuchObjectException;
            }
            long[] lArray2 = snmpOid.longValue(false);
            int n4 = lArray2.length;
            long[] lArray3 = new long[n2 + 2 + n4];
            lArray3[0] = -1L;
            System.arraycopy(lArray2, 0, lArray3, n2 + 2, n4);
            lArray3[n2] = this.nodeId;
            lArray3[n2 + 1] = l2;
            acmChecker.add(n2, lArray3, n2, n4 + 2);
            try {
                acmChecker.checkCurrentOid();
                snmpRequestTree.add(this, n2, snmpOid, snmpVarBind, false);
                long[] lArray4 = lArray3;
                acmChecker.remove(n2, n4 + 2);
                return lArray4;
            }
            catch (SnmpStatusException snmpStatusException) {
                try {
                    try {
                        snmpOid = this.getNextOid(snmpOid, object);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        acmChecker.remove(n2, n4 + 2);
                    }
                }
                catch (SnmpStatusException snmpStatusException2) {
                    snmpOid = this.getNextOid(object);
                    l2 = this.getNextVarEntryId(snmpOid, l2, object, n3);
                }
            }
        } while (snmpOid != null && l2 != -1L);
        throw noSuchObjectException;
    }

    final void validateOid(long[] lArray, int n2) throws SnmpStatusException {
        int n3 = lArray.length;
        if (n2 + 2 >= n3) {
            throw noSuchInstanceException;
        }
        if (lArray[n2] != (long)this.nodeId) {
            throw noSuchObjectException;
        }
    }

    private synchronized void sendNotification(Notification notification) {
        Enumeration enumeration = this.handbackTable.keys();
        while (enumeration.hasMoreElements()) {
            NotificationListener notificationListener = (NotificationListener)enumeration.nextElement();
            Vector vector = (Vector)this.handbackTable.get(notificationListener);
            Vector vector2 = (Vector)this.filterTable.get(notificationListener);
            Enumeration enumeration2 = vector2.elements();
            Enumeration enumeration3 = vector.elements();
            while (enumeration3.hasMoreElements()) {
                Object e2 = enumeration3.nextElement();
                NotificationFilter notificationFilter = (NotificationFilter)enumeration2.nextElement();
                if (notificationFilter != null && (notificationFilter == null || !notificationFilter.isNotificationEnabled(notification))) continue;
                notificationListener.handleNotification(notification, e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotification(String string, long l2, Object object, ObjectName objectName) {
        Serializable serializable = this;
        synchronized (serializable) {
            ++this.sequenceNumber;
        }
        serializable = new SnmpTableEntryNotification(string, this, this.sequenceNumber, l2, object, objectName);
        this.sendNotification((Notification)serializable);
    }

    protected boolean contains(SnmpOid snmpOid, Object object) {
        return this.findObject(snmpOid) > -1;
    }

    private final int findObject(SnmpOid snmpOid) {
        int n2 = 0;
        int n3 = this.size - 1;
        int n4 = n2 + (n3 - n2) / 2;
        while (n2 <= n3) {
            SnmpOid snmpOid2 = this.tableoids[n4];
            int n5 = snmpOid.compareTo(snmpOid2);
            if (n5 == 0) {
                return n4;
            }
            if (snmpOid.equals(snmpOid2)) {
                return n4;
            }
            if (n5 > 0) {
                n2 = n4 + 1;
            } else {
                n3 = n4 - 1;
            }
            n4 = n2 + (n3 - n2) / 2;
        }
        return -1;
    }

    private final int getInsertionPoint(SnmpOid snmpOid) throws SnmpStatusException {
        return this.getInsertionPoint(snmpOid, true);
    }

    private final int getInsertionPoint(SnmpOid snmpOid, boolean bl2) throws SnmpStatusException {
        int n2 = 0;
        int n3 = this.size - 1;
        int n4 = n2 + (n3 - n2) / 2;
        while (n2 <= n3) {
            SnmpOid snmpOid2 = this.tableoids[n4];
            int n5 = snmpOid.compareTo(snmpOid2);
            if (n5 == 0) {
                if (bl2) {
                    throw new SnmpStatusException(17, n4);
                }
                return n4 + 1;
            }
            if (n5 > 0) {
                n2 = n4 + 1;
            } else {
                n3 = n4 - 1;
            }
            n4 = n2 + (n3 - n2) / 2;
        }
        return n4;
    }

    private final void removeOid(int n2) {
        if (n2 >= this.tablecount) {
            return;
        }
        if (n2 < 0) {
            return;
        }
        int n3 = --this.tablecount - n2;
        this.tableoids[n2] = null;
        if (n3 > 0) {
            System.arraycopy(this.tableoids, n2 + 1, this.tableoids, n2, n3);
        }
        this.tableoids[this.tablecount] = null;
    }

    private final void insertOid(int n2, SnmpOid snmpOid) {
        if (n2 >= this.tablesize || this.tablecount == this.tablesize) {
            SnmpOid[] snmpOidArray = this.tableoids;
            this.tablesize += 16;
            this.tableoids = new SnmpOid[this.tablesize];
            if (n2 > this.tablecount) {
                n2 = this.tablecount;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            int n3 = n2;
            int n4 = this.tablecount - n2;
            if (n3 > 0) {
                System.arraycopy(snmpOidArray, 0, this.tableoids, 0, n3);
            }
            if (n4 > 0) {
                System.arraycopy(snmpOidArray, n3, this.tableoids, n3 + 1, n4);
            }
        } else if (n2 < this.tablecount) {
            System.arraycopy(this.tableoids, n2, this.tableoids, n2 + 1, this.tablecount - n2);
        }
        this.tableoids[n2] = snmpOid;
        ++this.tablecount;
    }

    private static final boolean isDebugOn() {
        return Trace.isSelected(2, 256);
    }

    private final void debug(String string, String string2) {
        Trace.send(2, 256, this.getClass().getName(), string, string2);
    }
}

