/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.BerException;

public class BerDecoder {
    public static final int BooleanTag = 1;
    public static final int IntegerTag = 2;
    public static final int OctetStringTag = 4;
    public static final int NullTag = 5;
    public static final int OidTag = 6;
    public static final int SequenceTag = 48;
    private final byte[] bytes;
    private int next = 0;
    private final int[] stackBuf = new int[200];
    private int stackTop = 0;

    public BerDecoder(byte[] byArray) {
        this.bytes = byArray;
        this.reset();
    }

    public void reset() {
        this.next = 0;
        this.stackTop = 0;
    }

    public int fetchInteger() throws BerException {
        return this.fetchInteger(2);
    }

    public int fetchInteger(int n2) throws BerException {
        int n3 = 0;
        int n4 = this.next;
        try {
            if (this.fetchTag() != n2) {
                throw new BerException();
            }
            n3 = this.fetchIntegerValue();
        }
        catch (BerException berException) {
            this.next = n4;
            throw berException;
        }
        return n3;
    }

    public long fetchIntegerAsLong() throws BerException {
        return this.fetchIntegerAsLong(2);
    }

    public long fetchIntegerAsLong(int n2) throws BerException {
        long l2 = 0L;
        int n3 = this.next;
        try {
            if (this.fetchTag() != n2) {
                throw new BerException();
            }
            l2 = this.fetchIntegerValueAsLong();
        }
        catch (BerException berException) {
            this.next = n3;
            throw berException;
        }
        return l2;
    }

    public byte[] fetchOctetString() throws BerException {
        return this.fetchOctetString(4);
    }

    public byte[] fetchOctetString(int n2) throws BerException {
        byte[] byArray = null;
        int n3 = this.next;
        try {
            if (this.fetchTag() != n2) {
                throw new BerException();
            }
            byArray = this.fetchStringValue();
        }
        catch (BerException berException) {
            this.next = n3;
            throw berException;
        }
        return byArray;
    }

    public long[] fetchOid() throws BerException {
        return this.fetchOid(6);
    }

    public long[] fetchOid(int n2) throws BerException {
        long[] lArray = null;
        int n3 = this.next;
        try {
            if (this.fetchTag() != n2) {
                throw new BerException();
            }
            lArray = this.fetchOidValue();
        }
        catch (BerException berException) {
            this.next = n3;
            throw berException;
        }
        return lArray;
    }

    public void fetchNull() throws BerException {
        this.fetchNull(5);
    }

    public void fetchNull(int n2) throws BerException {
        int n3 = this.next;
        try {
            if (this.fetchTag() != n2) {
                throw new BerException();
            }
            int n4 = this.fetchLength();
            if (n4 != 0) {
                throw new BerException();
            }
        }
        catch (BerException berException) {
            this.next = n3;
            throw berException;
        }
    }

    public byte[] fetchAny() throws BerException {
        byte[] byArray = null;
        int n2 = this.next;
        try {
            int n3 = this.fetchTag();
            int n4 = this.fetchLength();
            if (n4 < 0) {
                throw new BerException();
            }
            int n5 = this.next + n4 - n2;
            if (n4 > this.bytes.length - this.next) {
                throw new IndexOutOfBoundsException("Decoded length exceeds buffer");
            }
            byte[] byArray2 = new byte[n5];
            System.arraycopy(this.bytes, n2, byArray2, 0, n5);
            this.next += n4;
            byArray = byArray2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.next = n2;
            throw new BerException();
        }
        return byArray;
    }

    public byte[] fetchAny(int n2) throws BerException {
        if (this.getTag() != n2) {
            throw new BerException();
        }
        return this.fetchAny();
    }

    public void openSequence() throws BerException {
        this.openSequence(48);
    }

    public void openSequence(int n2) throws BerException {
        int n3 = this.next;
        try {
            if (this.fetchTag() != n2) {
                throw new BerException();
            }
            int n4 = this.fetchLength();
            if (n4 < 0) {
                throw new BerException();
            }
            if (n4 > this.bytes.length - this.next) {
                throw new BerException();
            }
            this.stackBuf[this.stackTop++] = this.next + n4;
        }
        catch (BerException berException) {
            this.next = n3;
            throw berException;
        }
    }

    public void closeSequence() throws BerException {
        if (this.stackBuf[this.stackTop - 1] == this.next) {
            --this.stackTop;
        } else {
            throw new BerException();
        }
    }

    public boolean cannotCloseSequence() {
        return this.next < this.stackBuf[this.stackTop - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTag() throws BerException {
        int n2 = 0;
        int n3 = this.next;
        try {
            n2 = this.fetchTag();
        }
        finally {
            this.next = n3;
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.bytes.length * 2);
        for (int i2 = 0; i2 < this.bytes.length; ++i2) {
            int n2;
            int n3 = n2 = this.bytes[i2] > 0 ? this.bytes[i2] : this.bytes[i2] + 256;
            if (i2 == this.next) {
                stringBuffer.append("(");
            }
            stringBuffer.append(Character.forDigit(n2 / 16, 16));
            stringBuffer.append(Character.forDigit(n2 % 16, 16));
            if (i2 != this.next) continue;
            stringBuffer.append(")");
        }
        if (this.bytes.length == this.next) {
            stringBuffer.append("()");
        }
        return new String(stringBuffer);
    }

    private final int fetchTag() throws BerException {
        int n2 = 0;
        int n3 = this.next;
        try {
            int n4 = this.bytes[this.next++];
            int n5 = n2 = n4 >= 0 ? n4 : n4 + 256;
            if ((n2 & 0x1F) == 31) {
                while ((this.bytes[this.next] & 0x80) != 0) {
                    n2 <<= 7;
                    n2 |= this.bytes[this.next++] & 0x7F;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.next = n3;
            throw new BerException();
        }
        return n2;
    }

    private final int fetchLength() throws BerException {
        int n2 = 0;
        int n3 = this.next;
        try {
            int n4 = this.bytes[this.next++];
            if (n4 >= 0) {
                n2 = n4;
            } else {
                for (int i2 = 128 + n4; i2 > 0; --i2) {
                    int n5 = this.bytes[this.next++];
                    n2 <<= 8;
                    n2 |= n5 >= 0 ? n5 : n5 + 256;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.next = n3;
            throw new BerException();
        }
        return n2;
    }

    private int fetchIntegerValue() throws BerException {
        int n2 = 0;
        int n3 = this.next;
        try {
            int n4 = this.fetchLength();
            if (n4 <= 0) {
                throw new BerException();
            }
            if (n4 > this.bytes.length - this.next) {
                throw new IndexOutOfBoundsException("Decoded length exceeds buffer");
            }
            int n5 = this.next + n4;
            n2 = this.bytes[this.next++];
            while (this.next < n5) {
                byte by;
                if ((by = this.bytes[this.next++]) < 0) {
                    n2 = n2 << 8 | 256 + by;
                    continue;
                }
                n2 = n2 << 8 | by;
            }
        }
        catch (BerException berException) {
            this.next = n3;
            throw berException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.next = n3;
            throw new BerException();
        }
        catch (ArithmeticException arithmeticException) {
            this.next = n3;
            throw new BerException();
        }
        return n2;
    }

    private final long fetchIntegerValueAsLong() throws BerException {
        long l2 = 0L;
        int n2 = this.next;
        try {
            int n3 = this.fetchLength();
            if (n3 <= 0) {
                throw new BerException();
            }
            if (n3 > this.bytes.length - this.next) {
                throw new IndexOutOfBoundsException("Decoded length exceeds buffer");
            }
            int n4 = this.next + n3;
            l2 = this.bytes[this.next++];
            while (this.next < n4) {
                byte by;
                if ((by = this.bytes[this.next++]) < 0) {
                    l2 = l2 << 8 | (long)(256 + by);
                    continue;
                }
                l2 = l2 << 8 | (long)by;
            }
        }
        catch (BerException berException) {
            this.next = n2;
            throw berException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.next = n2;
            throw new BerException();
        }
        catch (ArithmeticException arithmeticException) {
            this.next = n2;
            throw new BerException();
        }
        return l2;
    }

    private byte[] fetchStringValue() throws BerException {
        byte[] byArray = null;
        int n2 = this.next;
        try {
            int n3 = this.fetchLength();
            if (n3 < 0) {
                throw new BerException();
            }
            if (n3 > this.bytes.length - this.next) {
                throw new IndexOutOfBoundsException("Decoded length exceeds buffer");
            }
            byte[] byArray2 = new byte[n3];
            System.arraycopy(this.bytes, this.next, byArray2, 0, n3);
            this.next += n3;
            byArray = byArray2;
        }
        catch (BerException berException) {
            this.next = n2;
            throw berException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.next = n2;
            throw new BerException();
        }
        catch (ArithmeticException arithmeticException) {
            this.next = n2;
            throw new BerException();
        }
        return byArray;
    }

    private final long[] fetchOidValue() throws BerException {
        long[] lArray = null;
        int n2 = this.next;
        try {
            byte by;
            int n3;
            int n4 = this.fetchLength();
            if (n4 <= 0) {
                throw new BerException();
            }
            if (n4 > this.bytes.length - this.next) {
                throw new IndexOutOfBoundsException("Decoded length exceeds buffer");
            }
            int n5 = 2;
            for (n3 = 1; n3 < n4; ++n3) {
                if ((this.bytes[this.next + n3] & 0x80) != 0) continue;
                ++n5;
            }
            n3 = n5;
            long[] lArray2 = new long[n3];
            if ((by = this.bytes[this.next++]) < 0) {
                throw new BerException();
            }
            long l2 = by / 40;
            if (l2 > 2L) {
                throw new BerException();
            }
            long l3 = by % 40;
            lArray2[0] = l2;
            lArray2[1] = l3;
            int n6 = 2;
            while (n6 < n3) {
                long l4 = 0L;
                byte by2 = this.bytes[this.next++];
                while ((by2 & 0x80) != 0) {
                    if ((l4 = l4 << 7 | (long)(by2 & 0x7F)) < 0L) {
                        throw new BerException();
                    }
                    by2 = this.bytes[this.next++];
                }
                if ((l4 = l4 << 7 | (long)by2) < 0L) {
                    throw new BerException();
                }
                lArray2[n6++] = l4;
            }
            lArray = lArray2;
        }
        catch (BerException berException) {
            this.next = n2;
            throw berException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.next = n2;
            throw new BerException();
        }
        return lArray;
    }
}

