/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.util;

import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.WeakHashMap;

public class CacheMap
extends WeakHashMap {
    private final LinkedList cache = new LinkedList();
    private final int nSoftReferences;

    public CacheMap(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("nSoftReferences = " + n2);
        }
        this.nSoftReferences = n2;
    }

    public Object put(Object object, Object object2) {
        this.cache(object);
        return super.put(object, object2);
    }

    public Object get(Object object) {
        this.cache(object);
        return super.get(object);
    }

    private void cache(Object object) {
        Iterator iterator = this.cache.iterator();
        while (iterator.hasNext()) {
            SoftReference softReference = (SoftReference)iterator.next();
            Object t2 = softReference.get();
            if (t2 == null) {
                iterator.remove();
                continue;
            }
            if (!object.equals(t2)) continue;
            iterator.remove();
            this.cache.add(0, softReference);
            return;
        }
        int n2 = this.cache.size();
        if (n2 == this.nSoftReferences) {
            if (n2 == 0) {
                return;
            }
            iterator.remove();
        }
        this.cache.add(0, new SoftReference<Object>(object));
    }
}

