/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.JLabel;

class WindowsUtils {
    WindowsUtils() {
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    static void repaintMnemonicsInWindow(Window window) {
        if (window == null || !window.isShowing()) {
            return;
        }
        Window[] windowArray = window.getOwnedWindows();
        for (int i2 = 0; i2 < windowArray.length; ++i2) {
            WindowsUtils.repaintMnemonicsInWindow(windowArray[i2]);
        }
        WindowsUtils.repaintMnemonicsInContainer(window);
    }

    static void repaintMnemonicsInContainer(Container container) {
        for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
            Component component = container.getComponent(i2);
            if (component == null || !component.isVisible()) continue;
            if (component instanceof AbstractButton && ((AbstractButton)component).getMnemonic() != 0) {
                component.repaint();
                continue;
            }
            if (component instanceof JLabel && ((JLabel)component).getDisplayedMnemonic() != 0) {
                component.repaint();
                continue;
            }
            if (!(component instanceof Container)) continue;
            WindowsUtils.repaintMnemonicsInContainer((Container)component);
        }
    }
}

