/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.SwingUtilities2;
import com.sun.java.swing.plaf.gtk.CircularIdentityList;
import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKGraphicsUtils;
import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import com.sun.java.swing.plaf.gtk.GTKPainter;
import com.sun.java.swing.plaf.gtk.GTKStyleFactory;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;
import sun.awt.AppContext;
import sun.swing.plaf.synth.DefaultSynthStyle;
import sun.swing.plaf.synth.SynthIcon;

public class GTKStyle
extends DefaultSynthStyle
implements GTKConstants {
    private static final String ICON_PROPERTY_PREFIX = "gtk.icon.";
    static final Color BLACK_COLOR = new ColorUIResource(Color.BLACK);
    static final Color WHITE_COLOR = new ColorUIResource(Color.WHITE);
    private static final Color[][] DEFAULT_COLORS;
    private static final int[] DEFAULT_COLOR_MAP;
    private static final Font DEFAULT_FONT;
    private static final HashMap DATA;
    private static final HashMap CLASS_SPECIFIC_MAP;
    private static final GTKGraphicsUtils GTK_GRAPHICS;
    static final int UNDEFINED_THICKNESS = -1;
    private int xThickness = 2;
    private int yThickness = 2;
    private CircularIdentityList classSpecificValues;
    private GTKStockIconInfo[] icons;

    static Color calculateLightColor(Color color) {
        return GTKColorType.adjustColor(color, 1.0f, 1.3f, 1.3f);
    }

    static Color calculateDarkColor(Color color) {
        return GTKColorType.adjustColor(color, 1.0f, 0.7f, 0.7f);
    }

    static Color calculateMidColor(Color color, Color color2) {
        int n2 = color.getRGB();
        int n3 = color2.getRGB();
        int n4 = (n2 & 0xFF0000) >> 16;
        int n5 = (n3 & 0xFF0000) >> 16;
        int n6 = (n2 & 0xFF00) >> 8;
        int n7 = (n3 & 0xFF00) >> 8;
        int n8 = n2 & 0xFF;
        int n9 = n3 & 0xFF;
        return new ColorUIResource((n4 + n5) / 2 << 16 | (n6 + n7) / 2 << 8 | (n8 + n9) / 2);
    }

    static Color calculateMidColor(Color color) {
        return GTKStyle.calculateMidColor(GTKStyle.calculateLightColor(color), GTKStyle.calculateDarkColor(color));
    }

    static Color[] getColorsFrom(Color color, Color color2) {
        Color color3 = GTKStyle.calculateLightColor(color);
        Color color4 = GTKStyle.calculateDarkColor(color);
        Color color5 = GTKStyle.calculateMidColor(color3, color4);
        Color[] colorArray = new Color[GTKColorType.MAX_COUNT];
        colorArray[GTKColorType.BACKGROUND.getID()] = color;
        colorArray[GTKColorType.LIGHT.getID()] = color3;
        colorArray[GTKColorType.DARK.getID()] = color4;
        colorArray[GTKColorType.MID.getID()] = color5;
        colorArray[GTKColorType.BLACK.getID()] = BLACK_COLOR;
        colorArray[GTKColorType.WHITE.getID()] = WHITE_COLOR;
        colorArray[GTKColorType.FOCUS.getID()] = BLACK_COLOR;
        colorArray[GTKColorType.FOREGROUND.getID()] = color2;
        colorArray[GTKColorType.TEXT_FOREGROUND.getID()] = color2;
        colorArray[GTKColorType.TEXT_BACKGROUND.getID()] = WHITE_COLOR;
        return colorArray;
    }

    public GTKStyle(DefaultSynthStyle defaultSynthStyle) {
        super(defaultSynthStyle);
        if (defaultSynthStyle instanceof GTKStyle) {
            GTKStyle gTKStyle = (GTKStyle)defaultSynthStyle;
            this.xThickness = gTKStyle.xThickness;
            this.yThickness = gTKStyle.yThickness;
            this.icons = gTKStyle.icons;
            this.classSpecificValues = GTKStyle.cloneClassSpecificValues(gTKStyle.classSpecificValues);
        }
    }

    public GTKStyle() {
        super(new Insets(-1, -1, -1, -1), true, null, null);
    }

    public GTKStyle(Font font) {
        this();
        this.setFont(font);
    }

    GTKStyle(DefaultSynthStyle.StateInfo[] stateInfoArray, CircularIdentityList circularIdentityList, Font font, int n2, int n3, GTKStockIconInfo[] gTKStockIconInfoArray) {
        super(new Insets(-1, -1, -1, -1), true, stateInfoArray, null);
        this.setFont(font);
        this.xThickness = n2;
        this.yThickness = n3;
        this.icons = gTKStockIconInfoArray;
        this.classSpecificValues = circularIdentityList;
    }

    public void installDefaults(SynthContext synthContext) {
        super.installDefaults(synthContext);
        if (!synthContext.getRegion().isSubregion()) {
            synthContext.getComponent().putClientProperty(SwingUtilities2.AA_TEXT_PROPERTY_KEY, GTKLookAndFeel.aaText);
        }
    }

    public SynthGraphicsUtils getGraphicsUtils(SynthContext synthContext) {
        return GTK_GRAPHICS;
    }

    public GTKEngine getEngine(SynthContext synthContext) {
        GTKEngine gTKEngine = (GTKEngine)this.get(synthContext, "engine");
        if (gTKEngine == null) {
            return GTKEngine.INSTANCE;
        }
        return gTKEngine;
    }

    public SynthPainter getPainter(SynthContext synthContext) {
        return GTKPainter.INSTANCE;
    }

    public Insets getInsets(SynthContext synthContext, Insets insets) {
        insets = super.getInsets(synthContext, insets);
        if (insets.top == -1) {
            insets.bottom = 0;
            insets.top = 0;
            insets.right = 0;
            insets.left = 0;
            insets = GTKPainter.INSTANCE.getInsets(synthContext, insets);
        }
        return insets;
    }

    public Object getClassSpecificValue(Region region, String string) {
        if (this.classSpecificValues != null) {
            String string2 = GTKStyleFactory.gtkClassFor(region);
            while (string2 != null) {
                Object object;
                CircularIdentityList circularIdentityList = (CircularIdentityList)this.classSpecificValues.get(string2);
                if (circularIdentityList != null && (object = circularIdentityList.get(string)) != null) {
                    return object;
                }
                string2 = GTKStyleFactory.gtkSuperclass(string2);
            }
        }
        return null;
    }

    public Object getClassSpecificValue(SynthContext synthContext, String string) {
        return this.getClassSpecificValue(synthContext.getRegion(), string);
    }

    public int getClassSpecificIntValue(SynthContext synthContext, String string, int n2) {
        Object object = this.getClassSpecificValue(synthContext, string);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return n2;
    }

    public Insets getClassSpecificInsetsValue(SynthContext synthContext, String string, Insets insets) {
        Object object = this.getClassSpecificValue(synthContext, string);
        if (object instanceof Insets) {
            return (Insets)object;
        }
        return insets;
    }

    public boolean getClassSpecificBoolValue(SynthContext synthContext, String string, boolean bl2) {
        Object object = this.getClassSpecificValue(synthContext, string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDefaultValue(SynthContext synthContext, Object object) {
        Object v2 = CLASS_SPECIFIC_MAP.get(object);
        Object object2 = null;
        if (v2 != null && (object2 = this.getClassSpecificValue(synthContext, (String)v2)) != null) {
            return object2;
        }
        if (object == "ScrollPane.viewportBorderInsets") {
            return GTKPainter.INSTANCE.getScrollPaneInsets(synthContext, new Insets(0, 0, 0, 0));
        }
        if (object == "Slider.tickColor") {
            return this.getColor(synthContext.getComponent(), synthContext.getRegion(), synthContext.getComponentState(), ColorType.FOREGROUND);
        }
        HashMap hashMap = DATA;
        synchronized (hashMap) {
            object2 = DATA.get(object);
        }
        if (object2 instanceof StyleSpecificValue) {
            this.put(object, ((StyleSpecificValue)object2).getValue(synthContext));
        }
        if (object2 == null && object != "engine") {
            object2 = UIManager.get(object);
            if (object == "Table.rowHeight") {
                int n2 = this.getClassSpecificIntValue(synthContext, "focus-line-width", 0);
                if (object2 == null && n2 > 0) {
                    object2 = new Integer(16 + 2 * n2);
                }
            }
        }
        return object2;
    }

    protected Font getFontForState(JComponent jComponent, Region region, int n2) {
        Font font = super.getFontForState(jComponent, region, n2 = GTKLookAndFeel.synthStateToGTKState(region, n2));
        if (font == null) {
            return DEFAULT_FONT;
        }
        return font;
    }

    Color getGTKColor(int n2, ColorType colorType) {
        return this.getGTKColor(null, null, n2, colorType);
    }

    public Color getGTKColor(JComponent jComponent, Region region, int n2, ColorType colorType) {
        Color color;
        if (jComponent != null && region != null && !region.isSubregion() && (n2 & 1) == 1 && (colorType == ColorType.BACKGROUND ? !((color = jComponent.getBackground()) instanceof UIResource) : (colorType == ColorType.FOREGROUND ? !((color = jComponent.getForeground()) instanceof UIResource) : (colorType == ColorType.TEXT_FOREGROUND ? !((color = jComponent.getForeground()) instanceof UIResource) : colorType == ColorType.TEXT_BACKGROUND && !((color = jComponent.getBackground()) instanceof UIResource))))) {
            return color;
        }
        color = super.getColorForState(jComponent, region, n2, colorType);
        if (color != null) {
            return color;
        }
        return this.getDefaultColor(jComponent, region, n2, colorType);
    }

    public Color getColor(JComponent jComponent, Region region, int n2, ColorType colorType) {
        if (region == Region.LABEL && colorType == ColorType.TEXT_FOREGROUND) {
            colorType = ColorType.FOREGROUND;
        }
        n2 = GTKLookAndFeel.synthStateToGTKState(region, n2);
        if (!region.isSubregion() && (n2 & 1) == 1) {
            Color color;
            if (colorType == ColorType.BACKGROUND) {
                return jComponent.getBackground();
            }
            if (colorType == ColorType.FOREGROUND) {
                return jComponent.getForeground();
            }
            if (colorType == ColorType.TEXT_FOREGROUND && (color = jComponent.getForeground()) != null && !(color instanceof UIResource)) {
                return color;
            }
        }
        return this.getColorForState(jComponent, region, n2, colorType);
    }

    protected Color getColorForState(JComponent jComponent, Region region, int n2, ColorType colorType) {
        Color color = super.getColorForState(jComponent, region, n2, colorType);
        if (color != null) {
            return color;
        }
        if (colorType == ColorType.FOCUS) {
            return BLACK_COLOR;
        }
        if (colorType == GTKColorType.BLACK) {
            return BLACK_COLOR;
        }
        if (colorType == GTKColorType.WHITE) {
            return WHITE_COLOR;
        }
        if (colorType == ColorType.TEXT_FOREGROUND && (GTKStyleFactory.isLabelBearing(region) || region == Region.MENU_ITEM_ACCELERATOR || region == Region.TABBED_PANE_TAB)) {
            colorType = ColorType.FOREGROUND;
        } else if (region == Region.TABLE || region == Region.LIST || region == Region.TREE || region == Region.TREE_CELL) {
            if (colorType == ColorType.FOREGROUND) {
                colorType = ColorType.TEXT_FOREGROUND;
                if (n2 == 4) {
                    n2 = 512;
                }
            } else if (colorType == ColorType.BACKGROUND) {
                colorType = ColorType.TEXT_BACKGROUND;
                if (n2 == 4) {
                    n2 = 512;
                }
            }
        }
        return this.getDefaultColor(jComponent, region, n2, colorType);
    }

    Color getDefaultColor(JComponent jComponent, Region region, int n2, ColorType colorType) {
        if (colorType == ColorType.FOCUS) {
            return BLACK_COLOR;
        }
        if (colorType == GTKColorType.BLACK) {
            return BLACK_COLOR;
        }
        if (colorType == GTKColorType.WHITE) {
            return WHITE_COLOR;
        }
        for (int i2 = DEFAULT_COLOR_MAP.length - 1; i2 >= 0; --i2) {
            if ((DEFAULT_COLOR_MAP[i2] & n2) == 0 || colorType.getID() >= DEFAULT_COLORS[i2].length) continue;
            return DEFAULT_COLORS[i2][colorType.getID()];
        }
        if (colorType.getID() < DEFAULT_COLORS[2].length) {
            return DEFAULT_COLORS[2][colorType.getID()];
        }
        return null;
    }

    public boolean isOpaque(SynthContext synthContext) {
        Region region = synthContext.getRegion();
        if (region == Region.COMBO_BOX || region == Region.DESKTOP_PANE || region == Region.DESKTOP_ICON || region == Region.EDITOR_PANE || region == Region.FORMATTED_TEXT_FIELD || region == Region.INTERNAL_FRAME || region == Region.LIST || region == Region.MENU_BAR || region == Region.PASSWORD_FIELD || region == Region.POPUP_MENU || region == Region.PROGRESS_BAR || region == Region.ROOT_PANE || region == Region.SCROLL_PANE || region == Region.SPINNER || region == Region.TABLE || region == Region.TEXT_AREA || region == Region.TEXT_FIELD || region == Region.TEXT_PANE || region == Region.TOOL_BAR_DRAG_WINDOW || region == Region.TOOL_TIP || region == Region.TREE || region == Region.VIEWPORT) {
            return true;
        }
        JComponent jComponent = synthContext.getComponent();
        String string = jComponent.getName();
        return string == "ComboBox.renderer" || string == "ComboBox.listRenderer";
    }

    public int getXThickness() {
        return this.xThickness;
    }

    public int getYThickness() {
        return this.yThickness;
    }

    private Icon getStockIcon(SynthContext synthContext, String string, int n2) {
        Object object;
        Object object2;
        Icon icon = null;
        GTKStockIconInfo gTKStockIconInfo = null;
        GTKIconSource gTKIconSource = null;
        int n3 = 0;
        if (synthContext != null) {
            object2 = synthContext.getComponent().getComponentOrientation();
            n3 = object2 == null || ((ComponentOrientation)object2).isLeftToRight() ? 0 : 1;
        }
        if (this.icons != null) {
            for (int i2 = 0; i2 < this.icons.length; ++i2) {
                if (this.icons[i2].getKey() != string) continue;
                gTKStockIconInfo = this.icons[i2];
                break;
            }
            if (gTKStockIconInfo != null) {
                gTKIconSource = gTKStockIconInfo.getBestIconSource(n3, 1, n2);
            }
            if (gTKIconSource != null) {
                icon = gTKIconSource.toIcon();
            }
        }
        if (icon == null) {
            object2 = ICON_PROPERTY_PREFIX + string + '.' + n2 + '.' + (n3 == 1 ? "rtl" : "ltr");
            object = (Image)Toolkit.getDefaultToolkit().getDesktopProperty((String)object2);
            if (object != null) {
                icon = new ImageIcon((Image)object);
                return icon;
            }
            icon = (Icon)((UIDefaults.LazyValue)LookAndFeel.makeIcon(GTKStyle.class, "resources/" + string + "-" + n2 + ".png")).createValue(null);
        }
        if (icon == null) {
            return null;
        }
        object2 = null;
        if (!(gTKIconSource != null && gTKIconSource.getSize() != -100 || (object = GTKStockIconInfo.getIconSize(n2)) == null || icon.getIconWidth() == ((Dimension)object).width && icon.getIconHeight() == ((Dimension)object).height)) {
            object2 = new BufferedImage(((Dimension)object).width, ((Dimension)object).height, 2);
            Graphics2D graphics2D = (Graphics2D)((BufferedImage)object2).getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            Image image = this.getImageFromIcon(icon, false);
            graphics2D.drawImage(image, 0, 0, ((Dimension)object).width, ((Dimension)object).height, null);
            graphics2D.dispose();
        }
        if (object2 != null) {
            icon = new ImageIcon((Image)object2);
        }
        return icon;
    }

    private Image getImageFromIcon(Icon icon, boolean bl2) {
        Image image = null;
        if (icon instanceof ImageIcon) {
            image = ((ImageIcon)icon).getImage();
            if (bl2 && !(image instanceof BufferedImage)) {
                image = null;
            }
        }
        if (image == null) {
            image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            Graphics graphics = image.getGraphics();
            icon.paintIcon(null, graphics, 0, 0);
            graphics.dispose();
        }
        return image;
    }

    void addLabelProperties(GTKStyle gTKStyle) {
        block6: {
            int n2;
            DefaultSynthStyle.StateInfo[] stateInfoArray;
            DefaultSynthStyle.StateInfo[] stateInfoArray2;
            block5: {
                stateInfoArray2 = this.getStateInfo();
                stateInfoArray = gTKStyle.getStateInfo();
                this.setFont(gTKStyle.getFontForState(null, null, 0));
                if (stateInfoArray2 != null) break block5;
                if (stateInfoArray == null) {
                    return;
                }
                stateInfoArray2 = new DefaultSynthStyle.StateInfo[stateInfoArray.length];
                for (int i2 = 0; i2 < stateInfoArray.length; ++i2) {
                    Color color = stateInfoArray[i2].getColor(GTKColorType.FOREGROUND);
                    stateInfoArray2[i2] = this.createStateInfo(stateInfoArray[i2].getComponentState(), GTKColorType.TEXT_FOREGROUND, color);
                }
                break block6;
            }
            for (n2 = stateInfoArray2.length - 1; n2 >= 0; --n2) {
                ((GTKStateInfo)stateInfoArray2[n2]).setColor(GTKColorType.TEXT_FOREGROUND, null);
            }
            if (stateInfoArray == null) break block6;
            for (n2 = stateInfoArray.length - 1; n2 >= 0; --n2) {
                boolean bl2 = false;
                DefaultSynthStyle.StateInfo stateInfo = stateInfoArray[n2];
                int n3 = stateInfo.getComponentState();
                Color color = stateInfo.getColor(GTKColorType.FOREGROUND);
                for (int i3 = stateInfoArray2.length - 1; i3 >= 0; --i3) {
                    if (n3 != stateInfoArray2[i3].getComponentState()) continue;
                    ((GTKStateInfo)stateInfoArray2[i3]).setColor(GTKColorType.TEXT_FOREGROUND, color);
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                DefaultSynthStyle.StateInfo[] stateInfoArray3 = new DefaultSynthStyle.StateInfo[stateInfoArray2.length + 1];
                System.arraycopy(stateInfoArray2, 0, stateInfoArray3, 0, stateInfoArray2.length);
                stateInfoArray3[stateInfoArray2.length] = this.createStateInfo(n3, GTKColorType.TEXT_FOREGROUND, color);
                stateInfoArray2 = stateInfoArray3;
            }
        }
    }

    GTKStateInfo createStateInfo(int n2, ColorType colorType, Color color) {
        Color[] colorArray = new Color[GTKColorType.MAX_COUNT];
        colorArray[colorType.getID()] = color;
        return new GTKStateInfo(n2, null, colorArray, null);
    }

    void put(Object object, Object object2) {
        HashMap<Object, Object> hashMap = this.getData();
        if (hashMap == null) {
            hashMap = new HashMap<Object, Object>();
            this.setData(hashMap);
        }
        hashMap.put(object, object2);
    }

    boolean fillBackground(SynthContext synthContext, int n2) {
        GTKStateInfo gTKStateInfo = (GTKStateInfo)this.getStateInfo(n2);
        if (gTKStateInfo != null) {
            Object object = gTKStateInfo.getBackgroundImage();
            return object == "<none>" || object == null;
        }
        return true;
    }

    Image getBackgroundImage(SynthContext synthContext, int n2) {
        Object object;
        GTKStateInfo gTKStateInfo = (GTKStateInfo)this.getStateInfo(n2);
        if (gTKStateInfo != null && (object = gTKStateInfo.getBackgroundImage()) instanceof Image) {
            return (Image)object;
        }
        return null;
    }

    public Object clone() {
        GTKStyle gTKStyle = (GTKStyle)super.clone();
        gTKStyle.classSpecificValues = GTKStyle.cloneClassSpecificValues(gTKStyle.classSpecificValues);
        return gTKStyle;
    }

    public DefaultSynthStyle addTo(DefaultSynthStyle defaultSynthStyle) {
        if (!(defaultSynthStyle instanceof GTKStyle)) {
            defaultSynthStyle = new GTKStyle(defaultSynthStyle);
        }
        GTKStyle gTKStyle = (GTKStyle)super.addTo(defaultSynthStyle);
        if (this.xThickness != -1) {
            gTKStyle.xThickness = this.xThickness;
        }
        if (this.yThickness != -1) {
            gTKStyle.yThickness = this.yThickness;
        }
        if (gTKStyle.icons == null) {
            gTKStyle.icons = this.icons;
        } else if (this.icons != null) {
            GTKStockIconInfo[] gTKStockIconInfoArray = new GTKStockIconInfo[gTKStyle.icons.length + this.icons.length];
            System.arraycopy(this.icons, 0, gTKStockIconInfoArray, 0, this.icons.length);
            System.arraycopy(gTKStyle.icons, 0, gTKStockIconInfoArray, this.icons.length, gTKStyle.icons.length);
            gTKStyle.icons = gTKStockIconInfoArray;
        }
        if (gTKStyle.classSpecificValues == null) {
            gTKStyle.classSpecificValues = GTKStyle.cloneClassSpecificValues(this.classSpecificValues);
        } else {
            GTKStyle.addClassSpecificValues(this.classSpecificValues, gTKStyle.classSpecificValues);
        }
        return gTKStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addClassSpecificValues(CircularIdentityList circularIdentityList, CircularIdentityList circularIdentityList2) {
        if (circularIdentityList2 == null) {
            throw new IllegalArgumentException("to may not be null");
        }
        if (circularIdentityList == null) {
            return;
        }
        CircularIdentityList circularIdentityList3 = circularIdentityList;
        synchronized (circularIdentityList3) {
            Object object = circularIdentityList.next();
            if (object != null) {
                Object object2 = object;
                do {
                    CircularIdentityList circularIdentityList4 = (CircularIdentityList)circularIdentityList.get();
                    CircularIdentityList circularIdentityList5 = (CircularIdentityList)circularIdentityList2.get(object2);
                    if (circularIdentityList5 == null) {
                        circularIdentityList2.set(object2, circularIdentityList4.clone());
                        continue;
                    }
                    Object object3 = circularIdentityList4.next();
                    if (object3 == null) continue;
                    Object object4 = object3;
                    do {
                        circularIdentityList5.set(object4, circularIdentityList4.get());
                    } while ((object4 = circularIdentityList4.next()) != object3);
                } while ((object2 = circularIdentityList.next()) != object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CircularIdentityList cloneClassSpecificValues(CircularIdentityList circularIdentityList) {
        CircularIdentityList circularIdentityList2;
        if (circularIdentityList == null) {
            return null;
        }
        CircularIdentityList circularIdentityList3 = circularIdentityList;
        synchronized (circularIdentityList3) {
            Object object = circularIdentityList.next();
            if (object == null) {
                return null;
            }
            circularIdentityList2 = new CircularIdentityList();
            Object object2 = object;
            do {
                circularIdentityList2.set(object2, ((CircularIdentityList)circularIdentityList.get()).clone());
            } while ((object2 = circularIdentityList.next()) != object);
        }
        return circularIdentityList2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (this.xThickness != -1) {
            stringBuffer.append("xt=").append(String.valueOf(this.xThickness)).append('\n');
        }
        if (this.yThickness != -1) {
            stringBuffer.append("yt=").append(String.valueOf(this.yThickness)).append('\n');
        }
        if (this.classSpecificValues != null) {
            stringBuffer.append("*** Properties ***\n");
            stringBuffer.append(GTKStyle.classSpecValsToString(this.classSpecificValues)).append('\n');
        }
        if (this.icons != null) {
            stringBuffer.append("*** Stock Icons ***\n");
            for (int i2 = 0; i2 < this.icons.length; ++i2) {
                stringBuffer.append(this.icons[i2].toString()).append('\n');
            }
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    private static String classSpecValsToString(CircularIdentityList circularIdentityList) {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = circularIdentityList.next();
        if (object == null) {
            return "";
        }
        Object object2 = object;
        do {
            stringBuffer.append(object2).append('\n');
            CircularIdentityList circularIdentityList2 = (CircularIdentityList)circularIdentityList.get();
            Object object3 = circularIdentityList2.next();
            if (object3 == null) break;
            Object object4 = object3;
            do {
                stringBuffer.append("    ").append(object4).append('=').append(circularIdentityList2.get()).append('\n');
            } while ((object4 = circularIdentityList2.next()) != object3);
        } while ((object2 = circularIdentityList.next()) != object);
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    static String getStateName(int n2, String string) {
        switch (n2) {
            case 1: {
                return "NORMAL";
            }
            case 4: {
                return "ACTIVE";
            }
            case 512: {
                return "SELECTED";
            }
            case 2: {
                return "PRELIGHT";
            }
            case 8: {
                return "INSENSITIVE";
            }
            case -100: {
                return string;
            }
        }
        return "UNKNOWN";
    }

    static {
        DEFAULT_FONT = new FontUIResource("sansserif", 0, 10);
        DATA = new HashMap();
        GTK_GRAPHICS = new GTKGraphicsUtils();
        DEFAULT_COLOR_MAP = new int[]{4, 512, 1, 2, 8};
        DEFAULT_COLORS = new Color[5][];
        if (!GTKLookAndFeel.is2_2()) {
            GTKStyle.DEFAULT_COLORS[0] = GTKStyle.getColorsFrom(new ColorUIResource(195, 195, 195), BLACK_COLOR);
            GTKStyle.DEFAULT_COLORS[1] = GTKStyle.getColorsFrom(new ColorUIResource(0, 0, 156), WHITE_COLOR);
            GTKStyle.DEFAULT_COLORS[2] = GTKStyle.getColorsFrom(new ColorUIResource(214, 214, 214), BLACK_COLOR);
            GTKStyle.DEFAULT_COLORS[3] = GTKStyle.getColorsFrom(new ColorUIResource(233, 233, 233), BLACK_COLOR);
            GTKStyle.DEFAULT_COLORS[4] = GTKStyle.getColorsFrom(new ColorUIResource(214, 214, 214), new ColorUIResource(117, 117, 117));
            GTKStyle.DEFAULT_COLORS[0][GTKColorType.TEXT_BACKGROUND.getID()] = new ColorUIResource(188, 210, 238);
            GTKStyle.DEFAULT_COLORS[1][GTKColorType.TEXT_BACKGROUND.getID()] = new ColorUIResource(164, 223, 255);
            GTKStyle.DEFAULT_COLORS[1][GTKColorType.TEXT_FOREGROUND.getID()] = BLACK_COLOR;
            GTKStyle.DEFAULT_COLORS[2][GTKColorType.TEXT_FOREGROUND.getID()] = BLACK_COLOR;
            GTKStyle.DEFAULT_COLORS[4][GTKColorType.TEXT_FOREGROUND.getID()] = DEFAULT_COLORS[2][GTKColorType.TEXT_FOREGROUND.getID()];
        } else {
            GTKStyle.DEFAULT_COLORS[0] = GTKStyle.getColorsFrom(new ColorUIResource(186, 181, 171), BLACK_COLOR);
            GTKStyle.DEFAULT_COLORS[1] = GTKStyle.getColorsFrom(new ColorUIResource(75, 105, 131), WHITE_COLOR);
            GTKStyle.DEFAULT_COLORS[2] = GTKStyle.getColorsFrom(new ColorUIResource(220, 218, 213), BLACK_COLOR);
            GTKStyle.DEFAULT_COLORS[3] = GTKStyle.getColorsFrom(new ColorUIResource(238, 235, 231), BLACK_COLOR);
            GTKStyle.DEFAULT_COLORS[4] = GTKStyle.getColorsFrom(new ColorUIResource(220, 218, 213), new ColorUIResource(117, 117, 117));
            GTKStyle.DEFAULT_COLORS[0][GTKColorType.TEXT_BACKGROUND.getID()] = new ColorUIResource(128, 125, 116);
            GTKStyle.DEFAULT_COLORS[1][GTKColorType.TEXT_BACKGROUND.getID()] = new ColorUIResource(75, 105, 131);
            GTKStyle.DEFAULT_COLORS[2][GTKColorType.TEXT_BACKGROUND.getID()] = WHITE_COLOR;
            GTKStyle.DEFAULT_COLORS[3][GTKColorType.TEXT_BACKGROUND.getID()] = WHITE_COLOR;
            GTKStyle.DEFAULT_COLORS[4][GTKColorType.TEXT_BACKGROUND.getID()] = new ColorUIResource(238, 235, 231);
            GTKStyle.DEFAULT_COLORS[0][GTKColorType.TEXT_FOREGROUND.getID()] = WHITE_COLOR;
            GTKStyle.DEFAULT_COLORS[1][GTKColorType.TEXT_FOREGROUND.getID()] = WHITE_COLOR;
            GTKStyle.DEFAULT_COLORS[2][GTKColorType.TEXT_FOREGROUND.getID()] = BLACK_COLOR;
            GTKStyle.DEFAULT_COLORS[3][GTKColorType.TEXT_FOREGROUND.getID()] = BLACK_COLOR;
            GTKStyle.DEFAULT_COLORS[4][GTKColorType.TEXT_FOREGROUND.getID()] = new ColorUIResource(117, 117, 117);
        }
        CLASS_SPECIFIC_MAP = new HashMap();
        CLASS_SPECIFIC_MAP.put("CheckBox.iconTextGap", "indicator-spacing");
        CLASS_SPECIFIC_MAP.put("Slider.thumbHeight", "slider-width");
        CLASS_SPECIFIC_MAP.put("Slider.trackBorder", "trough-border");
        CLASS_SPECIFIC_MAP.put("SplitPane.size", "handle-size");
        CLASS_SPECIFIC_MAP.put("Tree.expanderSize", "expander-size");
        CLASS_SPECIFIC_MAP.put("ScrollBar.thumbHeight", "slider-width");
        CLASS_SPECIFIC_MAP.put("TextArea.caretForeground", "cursor-color");
        CLASS_SPECIFIC_MAP.put("TextArea.caretAspectRatio", "cursor-aspect-ratio");
        CLASS_SPECIFIC_MAP.put("TextField.caretForeground", "cursor-color");
        CLASS_SPECIFIC_MAP.put("TextField.caretAspectRatio", "cursor-aspect-ratio");
        CLASS_SPECIFIC_MAP.put("PasswordField.caretForeground", "cursor-color");
        CLASS_SPECIFIC_MAP.put("PasswordField.caretAspectRatio", "cursor-aspect-ratio");
        CLASS_SPECIFIC_MAP.put("FormattedTextField.caretForeground", "cursor-color");
        CLASS_SPECIFIC_MAP.put("FormattedTextField.caretAspectRatio", "cursor-aspect-");
        CLASS_SPECIFIC_MAP.put("TextPane.caretForeground", "cursor-color");
        CLASS_SPECIFIC_MAP.put("TextPane.caretAspectRatio", "cursor-aspect-ratio");
        CLASS_SPECIFIC_MAP.put("EditorPane.caretForeground", "cursor-color");
        CLASS_SPECIFIC_MAP.put("EditorPane.caretAspectRatio", "cursor-aspect-ratio");
        Object[] objectArray = new Object[]{"FileChooser.cancelIcon", new GTKStockIcon("gtk-cancel", 4), "FileChooser.okIcon", new GTKStockIcon("gtk-ok", 4), "OptionPane.errorIcon", new GTKStockIcon("gtk-dialog-error", 6), "OptionPane.informationIcon", new GTKStockIcon("gtk-dialog-info", 6), "OptionPane.warningIcon", new GTKStockIcon("gtk-dialog-warning", 6), "OptionPane.questionIcon", new GTKStockIcon("gtk-dialog-question", 6), "OptionPane.yesIcon", new GTKStockIcon("gtk-yes", 4), "OptionPane.noIcon", new GTKStockIcon("gtk-no", 4), "OptionPane.cancelIcon", new GTKStockIcon("gtk-cancel", 4), "OptionPane.okIcon", new GTKStockIcon("gtk-ok", 4)};
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            DATA.put(objectArray[i2], objectArray[++i2]);
        }
    }

    static class GTKIconSource
    implements Comparable {
        private Object image;
        private int direction;
        private int state;
        private int size;

        GTKIconSource(String string, int n2, int n3, String string2) {
            this.image = string;
            this.direction = n2;
            this.state = n3;
            this.size = GTKStockIconInfo.getIconType(string2);
        }

        public int getDirection() {
            return this.direction;
        }

        public int getState() {
            return this.state;
        }

        public int getSize() {
            return this.size;
        }

        public int compareTo(Object object) {
            GTKIconSource gTKIconSource = (GTKIconSource)object;
            if (this.direction != -100 && gTKIconSource.direction == -100) {
                return -1;
            }
            if (this.direction == -100 && gTKIconSource.direction != -100) {
                return 1;
            }
            if (this.state != -100 && gTKIconSource.state == -100) {
                return -1;
            }
            if (this.state == -100 && gTKIconSource.state != -100) {
                return 1;
            }
            if (this.size != -100 && gTKIconSource.size == -100) {
                return -1;
            }
            if (this.size == -100 && gTKIconSource.size != -100) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "image=" + this.image + ", dir=" + GTKIconSource.getDirectionName(this.direction) + ", state=" + GTKStyle.getStateName(this.state, "*") + ", size=" + (this.size == -100 ? "*" : "" + this.size);
        }

        private static String getDirectionName(int n2) {
            switch (n2) {
                case 0: {
                    return "LTR";
                }
                case 1: {
                    return "RTL";
                }
                case -100: {
                    return "*";
                }
            }
            return "UNKNOWN";
        }

        public Icon toIcon() {
            if (this.image == null || this.image instanceof Icon) {
                return (Icon)this.image;
            }
            ImageIcon imageIcon = (ImageIcon)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new ImageIcon((String)GTKIconSource.this.image);
                }
            });
            this.image = imageIcon.getIconWidth() > 0 && imageIcon.getIconHeight() > 0 ? imageIcon : null;
            return (Icon)this.image;
        }
    }

    static class GTKLazyValue
    implements UIDefaults.LazyValue {
        private String className;
        private String methodName;

        GTKLazyValue(String string) {
            this(string, null);
        }

        GTKLazyValue(String string, String string2) {
            this.className = string;
            this.methodName = string2;
        }

        public Object createValue(UIDefaults uIDefaults) {
            try {
                Class<?> clazz = Class.forName(this.className, true, Thread.currentThread().getContextClassLoader());
                if (this.methodName == null) {
                    return clazz.newInstance();
                }
                Method method = clazz.getMethod(this.methodName, null);
                return method.invoke(clazz, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
            return null;
        }
    }

    public static class GTKStateInfo
    extends DefaultSynthStyle.StateInfo {
        private Object backgroundImage;

        public GTKStateInfo(int n2, Font font, Color[] colorArray, Object object) {
            super(n2, font, colorArray);
            this.backgroundImage = object;
        }

        public GTKStateInfo(DefaultSynthStyle.StateInfo stateInfo) {
            super(stateInfo);
            if (stateInfo instanceof GTKStateInfo) {
                this.backgroundImage = ((GTKStateInfo)stateInfo).backgroundImage;
            }
        }

        void setColor(ColorType colorType, Color color) {
            Color[] colorArray = this.getColors();
            if (colorArray == null) {
                if (color == null) {
                    return;
                }
                colorArray = new Color[GTKColorType.MAX_COUNT];
                this.setColors(colorArray);
            }
            colorArray[colorType.getID()] = color;
        }

        public Color getColor(ColorType colorType) {
            Color color;
            Color[] colorArray;
            Color color2 = super.getColor(colorType);
            if (color2 == null && (colorArray = this.getColors()) != null && (color = super.getColor(GTKColorType.BACKGROUND)) != null) {
                if (colorType == GTKColorType.LIGHT) {
                    Color color3 = GTKStyle.calculateLightColor(color);
                    colorArray[GTKColorType.LIGHT.getID()] = color3;
                    color2 = color3;
                } else if (colorType == GTKColorType.MID) {
                    Color color4 = GTKStyle.calculateMidColor(color);
                    colorArray[GTKColorType.MID.getID()] = color4;
                    color2 = color4;
                } else if (colorType == GTKColorType.DARK) {
                    Color color5 = GTKStyle.calculateDarkColor(color);
                    colorArray[GTKColorType.DARK.getID()] = color5;
                    color2 = color5;
                }
            }
            return color2;
        }

        Object getBackgroundImage() {
            if (this.backgroundImage == null || this.backgroundImage instanceof Image || this.backgroundImage == "<none>" || this.backgroundImage == "<parent>") {
                return this.backgroundImage;
            }
            ImageIcon imageIcon = (ImageIcon)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new ImageIcon((String)GTKStateInfo.this.backgroundImage);
                }
            });
            this.backgroundImage = imageIcon.getIconWidth() > 0 && imageIcon.getIconHeight() > 0 ? imageIcon.getImage() : null;
            return this.backgroundImage;
        }

        public Object clone() {
            return new GTKStateInfo(this);
        }

        public DefaultSynthStyle.StateInfo addTo(DefaultSynthStyle.StateInfo stateInfo) {
            if (!(stateInfo instanceof GTKStateInfo)) {
                stateInfo = new GTKStateInfo(stateInfo);
            } else {
                super.addTo(stateInfo);
            }
            GTKStateInfo gTKStateInfo = (GTKStateInfo)stateInfo;
            if (this.backgroundImage != null) {
                gTKStateInfo.backgroundImage = this.backgroundImage;
            }
            return gTKStateInfo;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(GTKStyle.getStateName(this.getComponentState(), "UNDEFINED")).append(":\n");
            if (this.getColor(GTKColorType.FOREGROUND) != null) {
                stringBuffer.append("    fg=").append(this.getColor(GTKColorType.FOREGROUND)).append('\n');
            }
            if (this.getColor(GTKColorType.BACKGROUND) != null) {
                stringBuffer.append("    bg=").append(this.getColor(GTKColorType.BACKGROUND)).append('\n');
            }
            if (this.getColor(GTKColorType.TEXT_FOREGROUND) != null) {
                stringBuffer.append("    text=").append(this.getColor(GTKColorType.TEXT_FOREGROUND)).append('\n');
            }
            if (this.getColor(GTKColorType.TEXT_BACKGROUND) != null) {
                stringBuffer.append("    base=").append(this.getColor(GTKColorType.TEXT_BACKGROUND)).append('\n');
            }
            if (this.backgroundImage != null) {
                stringBuffer.append("    pmn=").append(this.backgroundImage).append('\n');
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            return stringBuffer.toString();
        }
    }

    private static class GTKStockIcon
    extends SynthIcon
    implements Cloneable,
    StyleSpecificValue {
        private String key;
        private int size;
        private boolean loadedLTR;
        private boolean loadedRTL;
        private Icon ltrIcon;
        private Icon rtlIcon;
        private SynthStyle style;

        GTKStockIcon(String string, int n2) {
            this.key = string;
            this.size = n2;
        }

        public void paintIcon(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
            Icon icon = this.getIcon(synthContext);
            if (icon != null) {
                if (synthContext == null) {
                    icon.paintIcon(null, graphics, n2, n3);
                } else {
                    icon.paintIcon(synthContext.getComponent(), graphics, n2, n3);
                }
            }
        }

        public int getIconWidth(SynthContext synthContext) {
            Icon icon = this.getIcon(synthContext);
            if (icon != null) {
                return icon.getIconWidth();
            }
            return 0;
        }

        public int getIconHeight(SynthContext synthContext) {
            Icon icon = this.getIcon(synthContext);
            if (icon != null) {
                return icon.getIconHeight();
            }
            return 0;
        }

        private Icon getIcon(SynthContext synthContext) {
            if (synthContext != null) {
                ComponentOrientation componentOrientation = synthContext.getComponent().getComponentOrientation();
                SynthStyle synthStyle = synthContext.getStyle();
                if (synthStyle != this.style) {
                    this.style = synthStyle;
                    this.loadedRTL = false;
                    this.loadedLTR = false;
                }
                if (componentOrientation == null || componentOrientation.isLeftToRight()) {
                    if (!this.loadedLTR) {
                        this.loadedLTR = true;
                        this.ltrIcon = ((GTKStyle)synthContext.getStyle()).getStockIcon(synthContext, this.key, this.size);
                    }
                    return this.ltrIcon;
                }
                if (!this.loadedRTL) {
                    this.loadedRTL = true;
                    this.rtlIcon = ((GTKStyle)synthContext.getStyle()).getStockIcon(synthContext, this.key, this.size);
                }
                return this.rtlIcon;
            }
            return this.ltrIcon;
        }

        public Object getValue(SynthContext synthContext) {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    static class GTKStockIconInfo {
        private String key;
        private GTKIconSource[] sources;
        private static Map<String, Integer> ICON_TYPE_MAP;
        private static final Object ICON_SIZE_KEY;

        GTKStockIconInfo(String string, GTKIconSource[] gTKIconSourceArray) {
            this.key = string.intern();
            this.sources = gTKIconSourceArray;
            Arrays.sort(this.sources);
        }

        public String getKey() {
            return this.key;
        }

        public GTKIconSource getBestIconSource(int n2, int n3, int n4) {
            for (int i2 = 0; i2 < this.sources.length; ++i2) {
                GTKIconSource gTKIconSource = this.sources[i2];
                if (gTKIconSource.direction != -100 && gTKIconSource.direction != n2 || gTKIconSource.state != -100 && gTKIconSource.state != n3 || gTKIconSource.size != -100 && gTKIconSource.size != n4) continue;
                return gTKIconSource;
            }
            return null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("STOCK ICON " + this.key + ":\n");
            for (int i2 = 0; i2 < this.sources.length; ++i2) {
                stringBuffer.append("    ").append(this.sources[i2].toString()).append('\n');
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            return stringBuffer.toString();
        }

        public static int getIconType(String string) {
            Integer n2;
            if (string == null) {
                return -100;
            }
            if (ICON_TYPE_MAP == null) {
                GTKStockIconInfo.initIconTypeMap();
            }
            return (n2 = ICON_TYPE_MAP.get(string)) != null ? n2 : -100;
        }

        private static void initIconTypeMap() {
            ICON_TYPE_MAP = new HashMap<String, Integer>();
            ICON_TYPE_MAP.put("gtk-menu", new Integer(1));
            ICON_TYPE_MAP.put("gtk-small-toolbar", new Integer(2));
            ICON_TYPE_MAP.put("gtk-large-toolbar", new Integer(3));
            ICON_TYPE_MAP.put("gtk-button", new Integer(4));
            ICON_TYPE_MAP.put("gtk-dnd", new Integer(5));
            ICON_TYPE_MAP.put("gtk-dialog", new Integer(6));
        }

        public static Dimension getIconSize(int n2) {
            Dimension[] dimensionArray = GTKStockIconInfo.getIconSizesMap();
            return n2 >= 0 && n2 < dimensionArray.length ? dimensionArray[n2] : null;
        }

        public static void setIconSize(int n2, int n3, int n4) {
            Dimension[] dimensionArray = GTKStockIconInfo.getIconSizesMap();
            if (n2 >= 0 && n2 < dimensionArray.length) {
                dimensionArray[n2] = new Dimension(n3, n4);
            }
        }

        private static Dimension[] getIconSizesMap() {
            AppContext appContext = AppContext.getAppContext();
            Dimension[] dimensionArray = (Dimension[])appContext.get(ICON_SIZE_KEY);
            if (dimensionArray == null) {
                dimensionArray = new Dimension[]{null, new Dimension(16, 16), new Dimension(18, 18), new Dimension(24, 24), new Dimension(20, 20), new Dimension(32, 32), new Dimension(48, 48)};
                appContext.put(ICON_SIZE_KEY, dimensionArray);
            }
            return dimensionArray;
        }

        static {
            ICON_SIZE_KEY = new StringBuffer("IconSize");
        }
    }

    static interface StyleSpecificValue {
        public Object getValue(SynthContext var1);
    }
}

