/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.common;

import com.sun.imageio.plugins.common.BogusColorSpace;
import com.sun.imageio.plugins.common.I18N;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;

public class ImageUtil {
    public static final ColorModel createColorModel(SampleModel sampleModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException("sampleModel == null!");
        }
        int n2 = sampleModel.getDataType();
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                return null;
            }
        }
        ColorModel colorModel = null;
        int[] nArray = sampleModel.getSampleSize();
        if (sampleModel instanceof ComponentSampleModel) {
            int n3 = sampleModel.getNumBands();
            ColorSpace colorSpace = null;
            colorSpace = n3 <= 2 ? ColorSpace.getInstance(1003) : (n3 <= 4 ? ColorSpace.getInstance(1000) : new BogusColorSpace(n3));
            boolean bl2 = n3 == 2 || n3 == 4;
            boolean bl3 = false;
            int n4 = bl2 ? 3 : 1;
            colorModel = new ComponentColorModel(colorSpace, nArray, bl2, bl3, n4, n2);
        } else {
            if (sampleModel.getNumBands() <= 4 && sampleModel instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
                int[] nArray2 = singlePixelPackedSampleModel.getBitMasks();
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = nArray2.length;
                if (n9 <= 2) {
                    n6 = n7 = nArray2[0];
                    n5 = n7;
                    if (n9 == 2) {
                        n8 = nArray2[1];
                    }
                } else {
                    n5 = nArray2[0];
                    n6 = nArray2[1];
                    n7 = nArray2[2];
                    if (n9 == 4) {
                        n8 = nArray2[3];
                    }
                }
                int n10 = 0;
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    n10 += nArray[i2];
                }
                return new DirectColorModel(n10, n5, n6, n7, n8);
            }
            if (sampleModel instanceof MultiPixelPackedSampleModel) {
                int n11 = nArray[0];
                int n12 = 1 << n11;
                byte[] byArray = new byte[n12];
                for (int i3 = 0; i3 < n12; ++i3) {
                    byArray[i3] = (byte)(i3 * 255 / (n12 - 1));
                }
                colorModel = new IndexColorModel(n11, n12, byArray, byArray, byArray);
            }
        }
        return colorModel;
    }

    public static byte[] getPackedBinaryData(Raster raster, Rectangle rectangle) {
        byte[] byArray;
        block29: {
            int n2;
            int n3;
            int n4;
            int n5;
            DataBuffer dataBuffer;
            int n6;
            int n7;
            block27: {
                block30: {
                    block28: {
                        SampleModel sampleModel = raster.getSampleModel();
                        if (!ImageUtil.isBinary(sampleModel)) {
                            throw new IllegalArgumentException(I18N.getString("ImageUtil0"));
                        }
                        int n8 = rectangle.x;
                        int n9 = rectangle.y;
                        n7 = rectangle.width;
                        n6 = rectangle.height;
                        dataBuffer = raster.getDataBuffer();
                        int n10 = n8 - raster.getSampleModelTranslateX();
                        int n11 = n9 - raster.getSampleModelTranslateY();
                        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                        n5 = multiPixelPackedSampleModel.getScanlineStride();
                        n4 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n10, n11);
                        n3 = multiPixelPackedSampleModel.getBitOffset(n10);
                        n2 = (n7 + 7) / 8;
                        if (dataBuffer instanceof DataBufferByte && n4 == 0 && n3 == 0 && n2 == n5 && ((DataBufferByte)dataBuffer).getData().length == n2 * n6) {
                            return ((DataBufferByte)dataBuffer).getData();
                        }
                        byArray = new byte[n2 * n6];
                        int n12 = 0;
                        if (n3 != 0) break block27;
                        if (!(dataBuffer instanceof DataBufferByte)) break block28;
                        byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                        int n13 = n2;
                        int n14 = 0;
                        for (int i2 = 0; i2 < n6; ++i2) {
                            System.arraycopy(byArray2, n4, byArray, n14, n13);
                            n14 += n13;
                            n4 += n5;
                        }
                        break block29;
                    }
                    if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block30;
                    short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                    for (int i3 = 0; i3 < n6; ++i3) {
                        int n15;
                        int n16 = n4;
                        for (n15 = n7; n15 > 8; n15 -= 16) {
                            short s2 = sArray[n16++];
                            byArray[n12++] = (byte)(s2 >>> 8 & 0xFF);
                            byArray[n12++] = (byte)(s2 & 0xFF);
                        }
                        if (n15 > 0) {
                            byArray[n12++] = (byte)(sArray[n16] >>> 8 & 0xFF);
                        }
                        n4 += n5;
                    }
                    break block29;
                }
                if (!(dataBuffer instanceof DataBufferInt)) break block29;
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                for (int i4 = 0; i4 < n6; ++i4) {
                    int n17;
                    int n18;
                    int n19 = n4;
                    for (n18 = n7; n18 > 24; n18 -= 32) {
                        n17 = nArray[n19++];
                        byArray[n12++] = (byte)(n17 >>> 24 & 0xFF);
                        byArray[n12++] = (byte)(n17 >>> 16 & 0xFF);
                        byArray[n12++] = (byte)(n17 >>> 8 & 0xFF);
                        byArray[n12++] = (byte)(n17 & 0xFF);
                    }
                    n17 = 24;
                    while (n18 > 0) {
                        byArray[n12++] = (byte)(nArray[n19] >>> n17 & 0xFF);
                        n17 -= 8;
                        n18 -= 8;
                    }
                    n4 += n5;
                }
                break block29;
            }
            if (dataBuffer instanceof DataBufferByte) {
                byte[] byArray3 = ((DataBufferByte)dataBuffer).getData();
                if ((n3 & 7) == 0) {
                    int n20 = n2;
                    int n21 = 0;
                    for (int i5 = 0; i5 < n6; ++i5) {
                        System.arraycopy(byArray3, n4, byArray, n21, n20);
                        n21 += n20;
                        n4 += n5;
                    }
                } else {
                    int n22 = n3 & 7;
                    int n23 = 8 - n22;
                    for (int i6 = 0; i6 < n6; ++i6) {
                        int n24 = n4;
                        for (int i7 = n7; i7 > 0; i7 -= 8) {
                            byArray[n12++] = i7 > n23 ? (byte)((byArray3[n24++] & 0xFF) << n22 | (byArray3[n24] & 0xFF) >>> n23) : (byte)((byArray3[n24] & 0xFF) << n22);
                        }
                        n4 += n5;
                    }
                }
            } else if (dataBuffer instanceof DataBufferShort || dataBuffer instanceof DataBufferUShort) {
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                for (int i8 = 0; i8 < n6; ++i8) {
                    int n25 = n3;
                    int n26 = 0;
                    while (n26 < n7) {
                        int n27 = n4 + n25 / 16;
                        int n28 = n25 % 16;
                        int n29 = sArray[n27] & 0xFFFF;
                        if (n28 <= 8) {
                            byArray[n12++] = (byte)(n29 >>> 8 - n28);
                        } else {
                            int n30 = n28 - 8;
                            int n31 = sArray[n27 + 1] & 0xFFFF;
                            byArray[n12++] = (byte)(n29 << n30 | n31 >>> 16 - n30);
                        }
                        n26 += 8;
                        n25 += 8;
                    }
                    n4 += n5;
                }
            } else if (dataBuffer instanceof DataBufferInt) {
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                for (int i9 = 0; i9 < n6; ++i9) {
                    int n32 = n3;
                    int n33 = 0;
                    while (n33 < n7) {
                        int n34 = n4 + n32 / 32;
                        int n35 = n32 % 32;
                        int n36 = nArray[n34];
                        if (n35 <= 24) {
                            byArray[n12++] = (byte)(n36 >>> 24 - n35);
                        } else {
                            int n37 = n35 - 24;
                            int n38 = nArray[n34 + 1];
                            byArray[n12++] = (byte)(n36 << n37 | n38 >>> 32 - n37);
                        }
                        n33 += 8;
                        n32 += 8;
                    }
                    n4 += n5;
                }
            }
        }
        return byArray;
    }

    public static byte[] getUnpackedBinaryData(Raster raster, Rectangle rectangle) {
        byte[] byArray;
        block8: {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            DataBuffer dataBuffer;
            block9: {
                block7: {
                    SampleModel sampleModel = raster.getSampleModel();
                    if (!ImageUtil.isBinary(sampleModel)) {
                        throw new IllegalArgumentException(I18N.getString("ImageUtil0"));
                    }
                    int n7 = rectangle.x;
                    int n8 = rectangle.y;
                    int n9 = rectangle.width;
                    int n10 = rectangle.height;
                    dataBuffer = raster.getDataBuffer();
                    int n11 = n7 - raster.getSampleModelTranslateX();
                    int n12 = n8 - raster.getSampleModelTranslateY();
                    MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                    n6 = multiPixelPackedSampleModel.getScanlineStride();
                    n5 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n11, n12);
                    n4 = multiPixelPackedSampleModel.getBitOffset(n11);
                    byArray = new byte[n9 * n10];
                    n3 = n8 + n10;
                    n2 = n7 + n9;
                    int n13 = 0;
                    if (!(dataBuffer instanceof DataBufferByte)) break block7;
                    byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                    for (int i2 = n8; i2 < n3; ++i2) {
                        int n14 = n5 * 8 + n4;
                        for (int i3 = n7; i3 < n2; ++i3) {
                            byte by = byArray2[n14 / 8];
                            byArray[n13++] = (byte)(by >>> (7 - n14 & 7) & 1);
                            ++n14;
                        }
                        n5 += n6;
                    }
                    break block8;
                }
                if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block9;
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                for (int i4 = n8; i4 < n3; ++i4) {
                    int n15 = n5 * 16 + n4;
                    for (int i5 = n7; i5 < n2; ++i5) {
                        short s2 = sArray[n15 / 16];
                        byArray[n13++] = (byte)(s2 >>> 15 - n15 % 16 & 1);
                        ++n15;
                    }
                    n5 += n6;
                }
                break block8;
            }
            if (!(dataBuffer instanceof DataBufferInt)) break block8;
            int[] nArray = ((DataBufferInt)dataBuffer).getData();
            for (int i6 = n8; i6 < n3; ++i6) {
                int n16 = n5 * 32 + n4;
                for (int i7 = n7; i7 < n2; ++i7) {
                    int n17 = nArray[n16 / 32];
                    byArray[n13++] = (byte)(n17 >>> 31 - n16 % 32 & 1);
                    ++n16;
                }
                n5 += n6;
            }
        }
        return byArray;
    }

    public static void setPackedBinaryData(byte[] byArray, WritableRaster writableRaster, Rectangle rectangle) {
        block41: {
            int n2;
            int n3;
            int n4;
            int n5;
            DataBuffer dataBuffer;
            int n6;
            int n7;
            block39: {
                block42: {
                    block40: {
                        SampleModel sampleModel = writableRaster.getSampleModel();
                        if (!ImageUtil.isBinary(sampleModel)) {
                            throw new IllegalArgumentException(I18N.getString("ImageUtil0"));
                        }
                        int n8 = rectangle.x;
                        int n9 = rectangle.y;
                        n7 = rectangle.width;
                        n6 = rectangle.height;
                        dataBuffer = writableRaster.getDataBuffer();
                        int n10 = n8 - writableRaster.getSampleModelTranslateX();
                        int n11 = n9 - writableRaster.getSampleModelTranslateY();
                        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                        n5 = multiPixelPackedSampleModel.getScanlineStride();
                        n4 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n10, n11);
                        n3 = multiPixelPackedSampleModel.getBitOffset(n10);
                        n2 = 0;
                        if (n3 != 0) break block39;
                        if (!(dataBuffer instanceof DataBufferByte)) break block40;
                        byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                        if (byArray2 == byArray) {
                            return;
                        }
                        int n12 = (n7 + 7) / 8;
                        int n13 = 0;
                        for (int i2 = 0; i2 < n6; ++i2) {
                            System.arraycopy(byArray, n13, byArray2, n4, n12);
                            n13 += n12;
                            n4 += n5;
                        }
                        break block41;
                    }
                    if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block42;
                    short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                    for (int i3 = 0; i3 < n6; ++i3) {
                        int n14;
                        int n15 = n4;
                        for (n14 = n7; n14 > 8; n14 -= 16) {
                            sArray[n15++] = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
                        }
                        if (n14 > 0) {
                            sArray[n15++] = (short)((byArray[n2++] & 0xFF) << 8);
                        }
                        n4 += n5;
                    }
                    break block41;
                }
                if (!(dataBuffer instanceof DataBufferInt)) break block41;
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                for (int i4 = 0; i4 < n6; ++i4) {
                    int n16;
                    int n17 = n4;
                    for (n16 = n7; n16 > 24; n16 -= 32) {
                        nArray[n17++] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
                    }
                    int n18 = 24;
                    while (n16 > 0) {
                        int n19 = n17;
                        nArray[n19] = nArray[n19] | (byArray[n2++] & 0xFF) << n18;
                        n18 -= 8;
                        n16 -= 8;
                    }
                    n4 += n5;
                }
                break block41;
            }
            int n20 = (n7 + 7) / 8;
            int n21 = 0;
            if (dataBuffer instanceof DataBufferByte) {
                byte[] byArray3 = ((DataBufferByte)dataBuffer).getData();
                if ((n3 & 7) == 0) {
                    for (int i5 = 0; i5 < n6; ++i5) {
                        System.arraycopy(byArray, n21, byArray3, n4, n20);
                        n21 += n20;
                        n4 += n5;
                    }
                } else {
                    int n22 = n3 & 7;
                    int n23 = 8 - n22;
                    int n24 = 8 + n23;
                    byte by = (byte)(255 << n23);
                    byte by2 = ~by;
                    for (int i6 = 0; i6 < n6; ++i6) {
                        int n25 = n4;
                        for (int i7 = n7; i7 > 0; i7 -= 8) {
                            byte by3 = byArray[n2++];
                            if (i7 > n24) {
                                byArray3[n25] = (byte)(byArray3[n25] & by | (by3 & 0xFF) >>> n22);
                                byArray3[++n25] = (byte)((by3 & 0xFF) << n23);
                                continue;
                            }
                            if (i7 > n23) {
                                byArray3[n25] = (byte)(byArray3[n25] & by | (by3 & 0xFF) >>> n22);
                                byArray3[++n25] = (byte)(byArray3[n25] & by2 | (by3 & 0xFF) << n23);
                                continue;
                            }
                            int n26 = (1 << n23 - i7) - 1;
                            byArray3[n25] = (byte)(byArray3[n25] & (by | n26) | (by3 & 0xFF) >>> n22 & ~n26);
                        }
                        n4 += n5;
                    }
                }
            } else if (dataBuffer instanceof DataBufferShort || dataBuffer instanceof DataBufferUShort) {
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                int n27 = n3 & 7;
                int n28 = 8 - n27;
                int n29 = 16 + n28;
                short s2 = (short)(~(255 << n28));
                short s3 = (short)(65535 << n28);
                short s4 = ~s3;
                for (int i8 = 0; i8 < n6; ++i8) {
                    int n30 = n3;
                    int n31 = n7;
                    int n32 = 0;
                    while (n32 < n7) {
                        int n33 = n4 + (n30 >> 4);
                        int n34 = n30 & 0xF;
                        int n35 = byArray[n2++] & 0xFF;
                        if (n34 <= 8) {
                            if (n31 < 8) {
                                n35 &= 255 << 8 - n31;
                            }
                            sArray[n33] = (short)(sArray[n33] & s2 | n35 << n28);
                        } else if (n31 > n29) {
                            sArray[n33] = (short)(sArray[n33] & s3 | n35 >>> n27 & 0xFFFF);
                            sArray[++n33] = (short)(n35 << n28 & 0xFFFF);
                        } else if (n31 > n28) {
                            sArray[n33] = (short)(sArray[n33] & s3 | n35 >>> n27 & 0xFFFF);
                            sArray[++n33] = (short)(sArray[n33] & s4 | n35 << n28 & 0xFFFF);
                        } else {
                            int n36 = (1 << n28 - n31) - 1;
                            sArray[n33] = (short)(sArray[n33] & (s3 | n36) | n35 >>> n27 & 0xFFFF & ~n36);
                        }
                        n32 += 8;
                        n30 += 8;
                        n31 -= 8;
                    }
                    n4 += n5;
                }
            } else if (dataBuffer instanceof DataBufferInt) {
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                int n37 = n3 & 7;
                int n38 = 8 - n37;
                int n39 = 32 + n38;
                int n40 = -1 << n38;
                int n41 = ~n40;
                for (int i9 = 0; i9 < n6; ++i9) {
                    int n42 = n3;
                    int n43 = n7;
                    int n44 = 0;
                    while (n44 < n7) {
                        int n45;
                        int n46 = n4 + (n42 >> 5);
                        int n47 = n42 & 0x1F;
                        int n48 = byArray[n2++] & 0xFF;
                        if (n47 <= 24) {
                            n45 = 24 - n47;
                            if (n43 < 8) {
                                n48 &= 255 << 8 - n43;
                            }
                            nArray[n46] = nArray[n46] & ~(255 << n45) | n48 << n45;
                        } else if (n43 > n39) {
                            nArray[n46] = nArray[n46] & n40 | n48 >>> n37;
                            nArray[++n46] = n48 << n38;
                        } else if (n43 > n38) {
                            nArray[n46] = nArray[n46] & n40 | n48 >>> n37;
                            nArray[++n46] = nArray[n46] & n41 | n48 << n38;
                        } else {
                            n45 = (1 << n38 - n43) - 1;
                            nArray[n46] = nArray[n46] & (n40 | n45) | n48 >>> n37 & ~n45;
                        }
                        n44 += 8;
                        n42 += 8;
                        n43 -= 8;
                    }
                    n4 += n5;
                }
            }
        }
    }

    public static void setUnpackedBinaryData(byte[] byArray, WritableRaster writableRaster, Rectangle rectangle) {
        block11: {
            int n2;
            int n3;
            int n4;
            int n5;
            DataBuffer dataBuffer;
            int n6;
            int n7;
            block12: {
                block10: {
                    SampleModel sampleModel = writableRaster.getSampleModel();
                    if (!ImageUtil.isBinary(sampleModel)) {
                        throw new IllegalArgumentException(I18N.getString("ImageUtil0"));
                    }
                    int n8 = rectangle.x;
                    int n9 = rectangle.y;
                    n7 = rectangle.width;
                    n6 = rectangle.height;
                    dataBuffer = writableRaster.getDataBuffer();
                    int n10 = n8 - writableRaster.getSampleModelTranslateX();
                    int n11 = n9 - writableRaster.getSampleModelTranslateY();
                    MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                    n5 = multiPixelPackedSampleModel.getScanlineStride();
                    n4 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n10, n11);
                    n3 = multiPixelPackedSampleModel.getBitOffset(n10);
                    n2 = 0;
                    if (!(dataBuffer instanceof DataBufferByte)) break block10;
                    byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                    for (int i2 = 0; i2 < n6; ++i2) {
                        int n12 = n4 * 8 + n3;
                        for (int i3 = 0; i3 < n7; ++i3) {
                            if (byArray[n2++] != 0) {
                                int n13 = n12 / 8;
                                byArray2[n13] = (byte)(byArray2[n13] | (byte)(1 << (7 - n12 & 7)));
                            }
                            ++n12;
                        }
                        n4 += n5;
                    }
                    break block11;
                }
                if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block12;
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                for (int i4 = 0; i4 < n6; ++i4) {
                    int n14 = n4 * 16 + n3;
                    for (int i5 = 0; i5 < n7; ++i5) {
                        if (byArray[n2++] != 0) {
                            int n15 = n14 / 16;
                            sArray[n15] = (short)(sArray[n15] | (short)(1 << 15 - n14 % 16));
                        }
                        ++n14;
                    }
                    n4 += n5;
                }
                break block11;
            }
            if (!(dataBuffer instanceof DataBufferInt)) break block11;
            int[] nArray = ((DataBufferInt)dataBuffer).getData();
            for (int i6 = 0; i6 < n6; ++i6) {
                int n16 = n4 * 32 + n3;
                for (int i7 = 0; i7 < n7; ++i7) {
                    if (byArray[n2++] != 0) {
                        int n17 = n16 / 32;
                        nArray[n17] = nArray[n17] | 1 << 31 - n16 % 32;
                    }
                    ++n16;
                }
                n4 += n5;
            }
        }
    }

    public static boolean isBinary(SampleModel sampleModel) {
        return sampleModel instanceof MultiPixelPackedSampleModel && ((MultiPixelPackedSampleModel)sampleModel).getPixelBitStride() == 1 && sampleModel.getNumBands() == 1;
    }

    public static ColorModel createColorModel(ColorSpace colorSpace, SampleModel sampleModel) {
        ColorModel colorModel = null;
        if (sampleModel == null) {
            throw new IllegalArgumentException(I18N.getString("ImageUtil1"));
        }
        int n2 = sampleModel.getNumBands();
        if (n2 < 1 || n2 > 4) {
            return null;
        }
        int n3 = sampleModel.getDataType();
        if (sampleModel instanceof ComponentSampleModel) {
            if (n3 < 0 || n3 > 5) {
                return null;
            }
            if (colorSpace == null) {
                colorSpace = n2 <= 2 ? ColorSpace.getInstance(1003) : ColorSpace.getInstance(1000);
            }
            boolean bl2 = n2 == 2 || n2 == 4;
            int n4 = bl2 ? 3 : 1;
            boolean bl3 = false;
            int n5 = DataBuffer.getDataTypeSize(n3);
            int[] nArray = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = n5;
            }
            colorModel = new ComponentColorModel(colorSpace, nArray, bl2, bl3, n4, n3);
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            int[] nArray = singlePixelPackedSampleModel.getBitMasks();
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            n2 = nArray.length;
            if (n2 <= 2) {
                n7 = n8 = nArray[0];
                n6 = n8;
                if (n2 == 2) {
                    n9 = nArray[1];
                }
            } else {
                n6 = nArray[0];
                n7 = nArray[1];
                n8 = nArray[2];
                if (n2 == 4) {
                    n9 = nArray[3];
                }
            }
            int[] nArray2 = singlePixelPackedSampleModel.getSampleSize();
            int n10 = 0;
            for (int i3 = 0; i3 < nArray2.length; ++i3) {
                n10 += nArray2[i3];
            }
            if (colorSpace == null) {
                colorSpace = ColorSpace.getInstance(1000);
            }
            colorModel = new DirectColorModel(colorSpace, n10, n6, n7, n8, n9, false, sampleModel.getDataType());
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            int n11 = ((MultiPixelPackedSampleModel)sampleModel).getPixelBitStride();
            int n12 = 1 << n11;
            byte[] byArray = new byte[n12];
            for (int i4 = 0; i4 < n12; ++i4) {
                byArray[i4] = (byte)(255 * i4 / (n12 - 1));
            }
            colorModel = new IndexColorModel(n11, n12, byArray, byArray, byArray);
        }
        return colorModel;
    }

    public static int getElementSize(SampleModel sampleModel) {
        int n2 = DataBuffer.getDataTypeSize(sampleModel.getDataType());
        if (sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            return multiPixelPackedSampleModel.getSampleSize(0) * multiPixelPackedSampleModel.getNumBands();
        }
        if (sampleModel instanceof ComponentSampleModel) {
            return sampleModel.getNumBands() * n2;
        }
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            return n2;
        }
        return n2 * sampleModel.getNumBands();
    }

    public static long getTileSize(SampleModel sampleModel) {
        int n2 = DataBuffer.getDataTypeSize(sampleModel.getDataType());
        if (sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            return (multiPixelPackedSampleModel.getScanlineStride() * multiPixelPackedSampleModel.getHeight() + (multiPixelPackedSampleModel.getDataBitOffset() + n2 - 1) / n2) * ((n2 + 7) / 8);
        }
        if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            int[] nArray = componentSampleModel.getBandOffsets();
            int n3 = nArray[0];
            for (int i2 = 1; i2 < nArray.length; ++i2) {
                n3 = Math.max(n3, nArray[i2]);
            }
            long l2 = 0L;
            int n4 = componentSampleModel.getPixelStride();
            int n5 = componentSampleModel.getScanlineStride();
            if (n3 >= 0) {
                l2 += (long)(n3 + 1);
            }
            if (n4 > 0) {
                l2 += (long)(n4 * (sampleModel.getWidth() - 1));
            }
            if (n5 > 0) {
                l2 += (long)(n5 * (sampleModel.getHeight() - 1));
            }
            int[] nArray2 = componentSampleModel.getBankIndices();
            n3 = nArray2[0];
            for (int i3 = 1; i3 < nArray2.length; ++i3) {
                n3 = Math.max(n3, nArray2[i3]);
            }
            return l2 * (long)(n3 + 1) * (long)((n2 + 7) / 8);
        }
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            long l3 = singlePixelPackedSampleModel.getScanlineStride() * (singlePixelPackedSampleModel.getHeight() - 1) + singlePixelPackedSampleModel.getWidth();
            return l3 * (long)((n2 + 7) / 8);
        }
        return 0L;
    }

    public static long getBandSize(SampleModel sampleModel) {
        int n2 = DataBuffer.getDataTypeSize(sampleModel.getDataType());
        if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            int n3 = componentSampleModel.getPixelStride();
            int n4 = componentSampleModel.getScanlineStride();
            long l2 = Math.min(n3, n4);
            if (n3 > 0) {
                l2 += (long)(n3 * (sampleModel.getWidth() - 1));
            }
            if (n4 > 0) {
                l2 += (long)(n4 * (sampleModel.getHeight() - 1));
            }
            return l2 * (long)((n2 + 7) / 8);
        }
        return ImageUtil.getTileSize(sampleModel);
    }

    public static boolean isIndicesForGrayscale(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray.length != byArray2.length || byArray.length != byArray3.length) {
            return false;
        }
        int n2 = byArray.length;
        if (n2 != 256) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = (byte)i2;
            if (byArray[i2] == by && byArray2[i2] == by && byArray3[i2] == by) continue;
            return false;
        }
        return true;
    }

    public static String convertObjectToString(Object object) {
        if (object == null) {
            return "";
        }
        String string = "";
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                string = string + byArray[i2] + " ";
            }
            return string;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                string = string + nArray[i3] + " ";
            }
            return string;
        }
        if (object instanceof short[]) {
            short[] sArray = (short[])object;
            for (int i4 = 0; i4 < sArray.length; ++i4) {
                string = string + sArray[i4] + " ";
            }
            return string;
        }
        return object.toString();
    }

    public static final void canEncodeImage(ImageWriter imageWriter, ImageTypeSpecifier imageTypeSpecifier) throws IIOException {
        ImageWriterSpi imageWriterSpi = imageWriter.getOriginatingProvider();
        if (imageTypeSpecifier != null && imageWriterSpi != null && !imageWriterSpi.canEncodeImage(imageTypeSpecifier)) {
            throw new IIOException(I18N.getString("ImageUtil2") + " " + imageWriter.getClass().getName());
        }
    }

    public static final void canEncodeImage(ImageWriter imageWriter, ColorModel colorModel, SampleModel sampleModel) throws IIOException {
        ImageTypeSpecifier imageTypeSpecifier = null;
        if (colorModel != null && sampleModel != null) {
            imageTypeSpecifier = new ImageTypeSpecifier(colorModel, sampleModel);
        }
        ImageUtil.canEncodeImage(imageWriter, imageTypeSpecifier);
    }

    public static final boolean imageIsContiguous(RenderedImage renderedImage) {
        SampleModel sampleModel;
        Object object;
        if (renderedImage instanceof BufferedImage) {
            object = ((BufferedImage)renderedImage).getRaster();
            sampleModel = ((Raster)object).getSampleModel();
        } else {
            sampleModel = renderedImage.getSampleModel();
        }
        if (sampleModel instanceof ComponentSampleModel) {
            object = (ComponentSampleModel)sampleModel;
            if (((ComponentSampleModel)object).getPixelStride() != ((SampleModel)object).getNumBands()) {
                return false;
            }
            int[] nArray = ((ComponentSampleModel)object).getBandOffsets();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] == i2) continue;
                return false;
            }
            int[] nArray2 = ((ComponentSampleModel)object).getBankIndices();
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                if (nArray2[i3] == 0) continue;
                return false;
            }
            return true;
        }
        return ImageUtil.isBinary(sampleModel);
    }
}

