/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.spi.orb;

import com.sun.corba.se.spi.orb.ParserData;
import com.sun.corba.se.spi.orb.ParserImplBase;
import com.sun.corba.se.spi.orb.PropertyParser;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class ParserImplTableBase
extends ParserImplBase {
    private final ParserData[] entries;

    public ParserImplTableBase(ParserData[] parserDataArray) {
        this.entries = parserDataArray;
        this.setDefaultValues();
    }

    protected PropertyParser makeParser() {
        PropertyParser propertyParser = new PropertyParser();
        for (int i2 = 0; i2 < this.entries.length; ++i2) {
            ParserData parserData = this.entries[i2];
            parserData.addToParser(propertyParser);
        }
        return propertyParser;
    }

    protected void setDefaultValues() {
        FieldMap fieldMap = new FieldMap(this.entries, true);
        this.setFields(fieldMap);
    }

    public void setTestValues() {
        FieldMap fieldMap = new FieldMap(this.entries, false);
        this.setFields(fieldMap);
    }

    private static class FieldMap
    extends AbstractMap {
        private final ParserData[] entries;
        private final boolean useDefault;

        public FieldMap(ParserData[] parserDataArray, boolean bl2) {
            this.entries = parserDataArray;
            this.useDefault = bl2;
        }

        public Set entrySet() {
            return new AbstractSet(){

                public Iterator iterator() {
                    return new Iterator(){
                        int ctr = 0;

                        public boolean hasNext() {
                            return this.ctr < FieldMap.this.entries.length;
                        }

                        public Object next() {
                            ParserData parserData = FieldMap.this.entries[this.ctr++];
                            MapEntry mapEntry = new MapEntry(parserData.getFieldName());
                            if (FieldMap.this.useDefault) {
                                mapEntry.setValue(parserData.getDefaultValue());
                            } else {
                                mapEntry.setValue(parserData.getTestValue());
                            }
                            return mapEntry;
                        }

                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                public int size() {
                    return FieldMap.this.entries.length;
                }
            };
        }
    }

    private static final class MapEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        public MapEntry(Object object) {
            this.key = object;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof MapEntry)) {
                return false;
            }
            MapEntry mapEntry = (MapEntry)object;
            return this.key.equals(mapEntry.key) && this.value.equals(mapEntry.value);
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }
    }
}

