/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.dynamicany;

import com.sun.corba.se.impl.corba.AnyImpl;
import com.sun.corba.se.impl.dynamicany.DynAnyBasicImpl;
import com.sun.corba.se.impl.dynamicany.DynAnyImpl;
import com.sun.corba.se.impl.dynamicany.DynArrayImpl;
import com.sun.corba.se.impl.dynamicany.DynEnumImpl;
import com.sun.corba.se.impl.dynamicany.DynFixedImpl;
import com.sun.corba.se.impl.dynamicany.DynSequenceImpl;
import com.sun.corba.se.impl.dynamicany.DynStructImpl;
import com.sun.corba.se.impl.dynamicany.DynUnionImpl;
import com.sun.corba.se.impl.dynamicany.DynValueBoxImpl;
import com.sun.corba.se.impl.dynamicany.DynValueImpl;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.spi.orb.ORB;
import java.math.BigDecimal;
import org.omg.CORBA.Any;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;

public class DynAnyUtil {
    static boolean isConsistentType(TypeCode typeCode) {
        int n2 = typeCode.kind().value();
        return n2 != 13 && n2 != 31 && n2 != 32;
    }

    static boolean isConstructedDynAny(DynAny dynAny) {
        int n2 = dynAny.type().kind().value();
        return n2 == 19 || n2 == 15 || n2 == 20 || n2 == 16 || n2 == 17 || n2 == 28 || n2 == 29 || n2 == 30;
    }

    static DynAny createMostDerivedDynAny(Any any, ORB oRB, boolean bl2) throws InconsistentTypeCode {
        if (any == null || !DynAnyUtil.isConsistentType(any.type())) {
            throw new InconsistentTypeCode();
        }
        switch (any.type().kind().value()) {
            case 19: {
                return new DynSequenceImpl(oRB, any, bl2);
            }
            case 15: {
                return new DynStructImpl(oRB, any, bl2);
            }
            case 20: {
                return new DynArrayImpl(oRB, any, bl2);
            }
            case 16: {
                return new DynUnionImpl(oRB, any, bl2);
            }
            case 17: {
                return new DynEnumImpl(oRB, any, bl2);
            }
            case 28: {
                return new DynFixedImpl(oRB, any, bl2);
            }
            case 29: {
                return new DynValueImpl(oRB, any, bl2);
            }
            case 30: {
                return new DynValueBoxImpl(oRB, any, bl2);
            }
        }
        return new DynAnyBasicImpl(oRB, any, bl2);
    }

    static DynAny createMostDerivedDynAny(TypeCode typeCode, ORB oRB) throws InconsistentTypeCode {
        if (typeCode == null || !DynAnyUtil.isConsistentType(typeCode)) {
            throw new InconsistentTypeCode();
        }
        switch (typeCode.kind().value()) {
            case 19: {
                return new DynSequenceImpl(oRB, typeCode);
            }
            case 15: {
                return new DynStructImpl(oRB, typeCode);
            }
            case 20: {
                return new DynArrayImpl(oRB, typeCode);
            }
            case 16: {
                return new DynUnionImpl(oRB, typeCode);
            }
            case 17: {
                return new DynEnumImpl(oRB, typeCode);
            }
            case 28: {
                return new DynFixedImpl(oRB, typeCode);
            }
            case 29: {
                return new DynValueImpl(oRB, typeCode);
            }
            case 30: {
                return new DynValueBoxImpl(oRB, typeCode);
            }
        }
        return new DynAnyBasicImpl(oRB, typeCode);
    }

    static Any extractAnyFromStream(TypeCode typeCode, InputStream inputStream, ORB oRB) {
        return AnyImpl.extractAnyFromStream(typeCode, inputStream, oRB);
    }

    static Any createDefaultAnyOfType(TypeCode typeCode, ORB oRB) {
        ORBUtilSystemException oRBUtilSystemException = ORBUtilSystemException.get(oRB, "rpc.presentation");
        Any any = oRB.create_any();
        switch (typeCode.kind().value()) {
            case 8: {
                any.insert_boolean(false);
                break;
            }
            case 2: {
                any.insert_short((short)0);
                break;
            }
            case 4: {
                any.insert_ushort((short)0);
                break;
            }
            case 3: {
                any.insert_long(0);
                break;
            }
            case 5: {
                any.insert_ulong(0);
                break;
            }
            case 23: {
                any.insert_longlong(0L);
                break;
            }
            case 24: {
                any.insert_ulonglong(0L);
                break;
            }
            case 6: {
                any.insert_float(0.0f);
                break;
            }
            case 7: {
                any.insert_double(0.0);
                break;
            }
            case 10: {
                any.insert_octet((byte)0);
                break;
            }
            case 9: {
                any.insert_char('\u0000');
                break;
            }
            case 26: {
                any.insert_wchar('\u0000');
                break;
            }
            case 18: {
                any.type(typeCode);
                any.insert_string("");
                break;
            }
            case 27: {
                any.type(typeCode);
                any.insert_wstring("");
                break;
            }
            case 14: {
                any.insert_Object(null);
                break;
            }
            case 12: {
                any.insert_TypeCode(any.type());
                break;
            }
            case 11: {
                any.insert_any(oRB.create_any());
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 29: 
            case 30: {
                any.type(typeCode);
                break;
            }
            case 28: {
                any.insert_fixed(new BigDecimal("0.0"), typeCode);
                break;
            }
            case 1: 
            case 13: 
            case 21: 
            case 31: 
            case 32: {
                any.type(typeCode);
                break;
            }
            case 0: {
                break;
            }
            case 25: {
                throw oRBUtilSystemException.tkLongDoubleNotSupported();
            }
            default: {
                throw oRBUtilSystemException.typecodeNotSupported();
            }
        }
        return any;
    }

    static Any copy(Any any, ORB oRB) {
        return new AnyImpl(oRB, any);
    }

    static DynAny convertToNative(DynAny dynAny, ORB oRB) {
        if (dynAny instanceof DynAnyImpl) {
            return dynAny;
        }
        try {
            return DynAnyUtil.createMostDerivedDynAny(dynAny.to_any(), oRB, true);
        }
        catch (InconsistentTypeCode inconsistentTypeCode) {
            return null;
        }
    }

    static boolean isInitialized(Any any) {
        boolean bl2 = ((AnyImpl)any).isInitialized();
        switch (any.type().kind().value()) {
            case 18: {
                return bl2 && any.extract_string() != null;
            }
            case 27: {
                return bl2 && any.extract_wstring() != null;
            }
        }
        return bl2;
    }

    static boolean set_current_component(DynAny dynAny, DynAny dynAny2) {
        if (dynAny2 != null) {
            try {
                dynAny.rewind();
                do {
                    if (dynAny.current_component() != dynAny2) continue;
                    return true;
                } while (dynAny.next());
            }
            catch (TypeMismatch typeMismatch) {
                // empty catch block
            }
        }
        return false;
    }
}

