/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <ctype.h>

#include <errno.h>
#include <limits.h>
#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "modules.h"


#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "input.h"

#include "goto.h"
#include "entry.h"
#include "duplicate.h"
#include "new.h"
#include "misc.h"
#include "monitor.h"
#include "print.h"
#include "rename.h"
#include "run.h"
#include "symlink.h"
#include "widgets.h"
#include "refresh.h"
#include "settings.h"
#include "terminal.h"


#define PRINT_STATUS_INPUT print_status("xfce/question", _("Input requested"), NULL)
#define PRINT_STATUS_DONE print_status("xfce/info", _("Command done"), NULL)


G_MODULE_EXPORT
gchar *workdir = NULL;

static void save_workdir_history(char *p){
    gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
    gchar *f=g_build_filename(xdg_dir,WORKDIR_DBH_FILE,NULL);

    g_free(xdg_dir);
    XFC_save_to_history(f,p);
    g_free(f);
}

static void check1_toggle (GtkToggleButton *togglebutton, gpointer user_data){
    	GtkWidget *check = WIDGET("checkbutton3");
    	if (tree_details->input != RUN_INPUT && tree_details->input !=  RUN_DOUBLE_CLICK) return;
	gtk_button_set_label((GtkButton *) check, _("Hold"));
	
	if (!gtk_toggle_button_get_active (togglebutton)) gtk_widget_hide(check); else gtk_widget_show(check);
}


G_MODULE_EXPORT
int extra_key_completion (gpointer user_data)
{
    	GtkEntry *entry=(GtkEntry *)WIDGET("input_entry");
	gboolean interm;
	gboolean hold;
      	GtkWidget *check = WIDGET("checkbutton3");
      	gchar *choice = g_strdup((gchar *)gtk_entry_get_text((GtkEntry *)entry));
    	if (tree_details->input != RUN_INPUT && tree_details->input !=  RUN_DOUBLE_CLICK) return FALSE;
	recover_flags(choice, &interm, &hold);
        gtk_toggle_button_set_active ((GtkToggleButton *)check,hold);
	gtk_button_set_label((GtkButton *) check, _("Hold"));
      	check = WIDGET("checkbutton1");
        gtk_toggle_button_set_active ((GtkToggleButton *)check,interm);	
#ifdef DEBUG
	printf("at extra_key_completion!\n");
#endif
	return FALSE;
}

static gchar *fix_relative_path(GtkTreeView *treeview,gchar *choice){
    GtkTreeIter iter;
    tree_entry_t *en;
    gchar *g;
    /* invalid stuff */
    if (!choice) return NULL; 
    if (!strlen(choice)) return g_strdup(choice); 
    /* network stuff */
    if (strncmp(choice,"//",2)==0) return g_strdup(choice); 
    /* absolute path */
    if (*choice == G_DIR_SEPARATOR && g_file_test((const gchar *)choice,G_FILE_TEST_IS_DIR)) return g_strdup(choice); 
    /* relative to xffm-root-folder, maybe */
    get_local_root(treeview, &iter, &en);
    g=g_strconcat(en->path,G_DIR_SEPARATOR_S,choice,NULL);
    if (g_file_test((const gchar *)g,G_FILE_TEST_IS_DIR)) {
        return g;
    }
    /* relative to homedir, maybe */
    g=g_strconcat(GETWD,G_DIR_SEPARATOR_S,choice,NULL);
    if (g_file_test((const gchar *)g,G_FILE_TEST_IS_DIR)) {
        return g;
    }
    return g_strdup(choice);
}


G_MODULE_EXPORT
void show_input (int which)
{
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    GtkCheckButton *check_button1, *check_button2;
    GtkLabel *label;
    GtkEntry *entry;
    GtkCombo *combo;
    /*GtkToggleButton *w; */
    GtkTreeIter iter;
    char *path, *name;
    tree_entry_t *en;
    gchar *sname;
    static xfc_combo_info_t *combo_info=NULL;
    


    if(tree_details->tubo_object)
	assert_not_reached();
    
    if (tree_details->input != OTHER_INPUT){
      cancel_input(NULL,NULL);
    }

    label = (GtkLabel *) WIDGET("input_label");
    entry = (GtkEntry *) WIDGET("input_entry");
    combo=(GtkCombo *)WIDGET("input_combo");
    check_button1 = (GtkCheckButton *) WIDGET("checkbutton1");
    if (!combo_info){
	    g_signal_connect((gpointer)check_button1,"toggled",G_CALLBACK (check1_toggle),(gpointer) treeview);
	    combo_info = XFC_init_combo(combo);
    } else {
	    XFC_clear_history(combo_info);
    }


    combo_info->activate_func = on_input_activate;
    combo_info->activate_user_data=(gpointer)combo_info;
    combo_info->cancel_func = cancel_input;
    combo_info->cancel_user_data=(gpointer)treeview;
    
    hideit(tree_details->window, "box_tb1");
    /*hideit(tree_details->window, "filter_box");*/
    showit(tree_details->window, "input_box");
    showit(tree_details->window, "input_combo");

    XFC_set_combo(combo_info,NULL);
    hideit(tree_details->window, "checkbutton1");
    hideit(tree_details->window, "checkbutton2");
    hideit(tree_details->window, "checkbutton3");

    if(gtk_toggle_button_get_active((GtkToggleButton *) check_button1))
	gtk_toggle_button_set_active((GtkToggleButton *) check_button1, FALSE);
    if (which==NEW_INPUT || which==NEW_DIR_INPUT)
	gtk_toggle_button_set_active((GtkToggleButton *) check_button1, TRUE);

    check_button2 = (GtkCheckButton *) WIDGET("checkbutton2");
    if(gtk_toggle_button_get_active((GtkToggleButton *) check_button2))
	gtk_toggle_button_set_active((GtkToggleButton *) check_button2, FALSE);

    tree_details->input = which;

    en = get_selected_entry(&iter);
    if(!en || !en->path)
    {
	path = g_strdup(GETWD);
	name = _("New");
    }
    else
    {
	path = g_strdup(en->path);
	if(IS_PATH(en->type))
	{
	    if (!strrchr(path, '/')) {
		g_warning("show_input(): en->path is not absolute!\n");
		name=path;
	    } else {
	      name = strrchr(path, '/');
	      *name = 0;
	      name++;
	    }
	}
	else
	{
	    name = _("New");
	}
    }

    switch (which)
    {
	case FREQUENCY_INPUT:
	case RECENT_INPUT:
	case SAVE_BOOK_INPUT:
	case NEW_BOOK_INPUT: 
	case RENAME_INPUT:
	case DUPLICATE_INPUT:
	{
	    gchar *t1,*t2;
	    gtk_entry_set_text(entry, "");
	    if (which==SAVE_BOOK_INPUT || which==NEW_BOOK_INPUT) 
		t1=g_strdup(""),t2=_("Book");
	    else if (which==RECENT_INPUT) 
		t1=g_strdup_printf("%d",tree_details->recent_days),t2=_("Days");
	    else if (which==FREQUENCY_INPUT) 
		t1=g_strdup_printf("%d",tree_details->frequent_count),t2=_("Hits");
	    else if (which==RENAME_INPUT || which==DUPLICATE_INPUT) 
		t1=g_strdup(new_name(path, name)),t2=_("Name");
	    else t1=g_strdup(""), t2="";
	    gtk_entry_set_text(entry, t1);
	    gtk_label_set_text(label, t2);
	    g_free(t1);
	    PRINT_STATUS_INPUT;
	    break;
	}
	case NEW_BOOK_WIN_INPUT: 
	case OPEN_BOOK_INPUT: 
	{	
	    BOOK_set_book_combo();
	    gtk_label_set_text(label,_("Book"));
	    PRINT_STATUS_INPUT;
	    break;
	}
	case SYMLINK_INPUT:
	    sname=g_strconcat(name,"-lnk",NULL);
	    gtk_entry_set_text(entry, sname);
	    g_free(sname);
	    sname=NULL;
	    gtk_label_set_text(label, _("Name"));
	    PRINT_STATUS_INPUT;
	    break;
	case PRINT_INPUT:
	    gtk_entry_set_text(entry, "lpr");
	    gtk_label_set_text(label, _("Command"));
	    print_status("xfce/question", 
			    " ", 
			    FILENAME(en), NULL);
	    break;
	case NEW_INPUT:
	case NEW_FILE_INPUT:
	case NEW_DIR_INPUT:
	    set_new_combo();
	    gtk_label_set_text(label, _("Name"));
	    print_status("xfce/question", _("Name"), NULL);
	    if (which == NEW_INPUT){
	      gtk_button_set_label((GtkButton *) check_button1, _("Directory"));
	      showit(tree_details->window, "checkbutton1");
	    }
	    break; 
	case WORKDIR_INPUT: 
	    {
	      gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	      gchar *f=g_build_filename(xdg_dir,WORKDIR_DBH_FILE,NULL);

	      g_free(xdg_dir);
	      XFC_read_history(combo_info,f);
    	      XFC_set_combo(combo_info,NULL);
   	      g_free (f);
	    }
	    gtk_label_set_text(label,workdir?_(workdir):_("Output dir"));
	    PRINT_STATUS_INPUT;
	    break;
	case NEW_WIN_INPUT: 
	case NEW_TERM_INPUT: 
	    {
	      gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	      gchar *f=g_build_filename(xdg_dir,GOTO_DBH_FILE,NULL);
	      const gchar *p = get_selected_chdir();

	      g_free(xdg_dir);
	      XFC_read_history(combo_info,f);
    	      XFC_set_combo(combo_info,NULL);
   	      g_free (f);
	      XFC_set_entry(combo_info,(gchar *)p);
	    }
	    gtk_label_set_text(label,_("Directory"));
	    PRINT_STATUS_INPUT;
	    break;  
	case GOTO_INPUT:
	    {
	      gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	      gchar *f=g_build_filename(xdg_dir,GOTO_DBH_FILE,NULL);
	      
	      g_free(xdg_dir);
	      XFC_read_history(combo_info,f);
    	      /* implied by XFC_set_entry: XFC_set_combo(combo_info,NULL);*/
	      XFC_set_blank(combo_info);
   	      g_free (f);
	    }
	    /*set_goto_combo(combo_info);*/
	    gtk_label_set_text(label, _("Go to"));
	    PRINT_STATUS_INPUT;
	    break;
	case RUN_INPUT:
	case RUN_DOUBLE_CLICK:
	    switch (which)
	    {
		case RUN_INPUT:
	    	    set_run_combo(combo_info);
		    gtk_label_set_text(label, _("Run"));
		    PRINT_STATUS_INPUT;
		    break;
		case RUN_DOUBLE_CLICK:
	    	    set_run_combo(combo_info);
		    gtk_label_set_text(label, _("Open with"));
		    gtk_button_set_label((GtkButton *) check_button2, 
				    _("Remember"));
		    showit(tree_details->window, "checkbutton2");
		    if(en && en->path)
		    {
		      int in_term;
		      gchar **text_editors;
		      const gchar *p=get_from_open_history(en->path, &in_term);
		      if (p) {
			XFC_set_entry(combo_info,(gchar *)p);
			gtk_toggle_button_set_active((GtkToggleButton *) check_button2, (gboolean)in_term);	
		      }
		      else if ((text_editors=text_type_OK(en->path))!=NULL){  
			  /* OK to apply an editor */
			int k;
			for (k=0;text_editors[k];k++){
			    gchar *c=g_find_program_in_path(text_editors[k]);
			    if (c){
				g_free(c);
				XFC_set_entry(combo_info,(gchar *)text_editors[k]);
				break;
			    }
			}	
		      }
		      else {
			const gchar *p=MIME_command(en->path);
			/*printf("DBG:no history to set for %s\n",en->path);*/
			if (p) XFC_set_entry(combo_info,(gchar *)p);
			else XFC_set_blank(combo_info);
		      }
		    }
		    else printf("DBG:path is nullllll\n");
		    PRINT_STATUS_INPUT;
		    break;

	    }

	    gtk_button_set_label((GtkButton *) check_button1, _("In terminal"));
	    showit(tree_details->window, "checkbutton1");
	    break;

	default:
	    break;
    }
    g_free(path);
    path=NULL;
    gtk_widget_grab_focus((GtkWidget *) entry);
    /* these will preselect */
    
    if (which == NEW_INPUT || which == SYMLINK_INPUT ||
	which == NEW_FILE_INPUT || which == NEW_DIR_INPUT ||
	which ==  RUN_INPUT || which == RUN_DOUBLE_CLICK ||
        which == PRINT_INPUT || which == SAVE_BOOK_INPUT ||
        which == FREQUENCY_INPUT || which == RECENT_INPUT ||
	which == NEW_WIN_INPUT || which == NEW_TERM_INPUT ){
      gtk_editable_set_position(GTK_EDITABLE (entry),0);
      gtk_editable_select_region (GTK_EDITABLE (entry), 0, -1);
    } else {
      gtk_editable_select_region (GTK_EDITABLE (entry), 0, 0);
      gtk_editable_set_position(GTK_EDITABLE (entry),-1);
    }
    if (which==WORKDIR_INPUT) gtk_main();
}

G_MODULE_EXPORT
void ok_input (GtkTreeView * treeview)
{
    gchar *choice;
    GtkTreeIter iter;
    GtkEntry *entry;
    tree_entry_t *en;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    gchar *nfile=NULL;
    GtkTreePath *treepath;
    GtkTreeRowReference *reference;
    treestuff_t *treestuff=get_treestuff(treeview);


    print_status(NULL," ",NULL);
    entry = (GtkEntry *) WIDGET("input_entry");
    choice = g_strdup((gchar *)gtk_entry_get_text(entry));
    hideit(tree_details->window, "input_box");
    if(tree_details->preferences & SHOW_TB1)
	showit(tree_details->window, "box_tb1");
#if 0    
#ifdef USE_FILTER_BAR
    if(tree_details->preferences & SHOW_F)
	showit(tree_details->window, "filter_box");
#endif
#endif
   
    gtk_widget_grab_focus((GtkWidget *) treeview);

    if (!choice) return;
    g_strstrip(choice);
    if (!strlen(choice)) {
	g_free(choice); choice=NULL;
	return;
    }


    TRACE("at input ok,tree_details->input=%d (%d,%d)",tree_details->input,RUN_DOUBLE_CLICK,RUN_INPUT);
    switch (tree_details->input)
    {
	default:
	    break;
	case RECENT_INPUT:
	case FREQUENCY_INPUT:
	    {
		char *p;
		for (p=choice;p && *p;p++){
		    if (!isdigit(*p)){
			print_status("xfce/error",
			       strerror(EINVAL), " : ", 
			       choice, NULL);
			break;
		    }
		}
		if (tree_details->input==FREQUENCY_INPUT) {
		    tree_details->frequent_count = atoi(choice);
		} else if (tree_details->input==RECENT_INPUT) {
		    tree_details->recent_days = atoi(choice);
		}
		on_refresh((GtkButton *) treeview,NULL);
		write_xffm_config();
	    }	
	    break;
	case NEW_BOOK_WIN_INPUT:
	    {
		gchar *argv[3];
		argv[0]="xfbook";
		argv[1]=choice;
		argv[2]=0;
		runv(argv);
		break;
	    }
	case NEW_TERM_INPUT:
	case NEW_WIN_INPUT:
	{
	    gchar *g = fix_relative_path(treeview,choice);
	    if (!g_file_test((const gchar *)g,G_FILE_TEST_IS_DIR)){
		print_status("xfce/error",
			       strerror(ENOENT), " : ", 
			       choice, NULL);
	    } else {
	      if (tree_details->input == NEW_WIN_INPUT){
	        char *argv[3];
		argv[0] = "xftree4";
		argv[1] = (char *)g;
		argv[2] = 0;
		runv(argv);
	      } else if (tree_details->input == NEW_TERM_INPUT){
		new_terminal_path(g);
	      }
	      /* save both relative and absolute paths for autocompletion */
	      if (g_file_test((const gchar *)g,G_FILE_TEST_IS_DIR)) {
		save_to_go_history(choice);
		save_to_go_history(g);
	      }
	    }
	    g_free(g);
	    break;
	}
	case OPEN_BOOK_INPUT:
	case NEW_BOOK_INPUT:
	    if (!choice || !strlen(choice)) return;
	    BOOK_set_bookfile(choice);
    	    g_free(choice);
	    choice=NULL;
    	    BOOK_reload_book(treeview); 
	    return;
	case SAVE_BOOK_INPUT:
	    {
	      gchar *oldname,*newname;
	      int status;
	      if (!choice || !strlen(choice)) return;
	      oldname=g_strdup(BOOK_get_bookfile_path());
	      BOOK_set_bookfile(choice);
    	      g_free(choice);
	      choice=NULL;
	      newname=g_strdup(BOOK_get_bookfile_path());
	    
	      /*printf("DBG:replacing %s for %s\n",oldname,newname);*/
	      /* XXX: probably should warn on overwritting */
	      if (fork()) wait(&status);
	      else {
		      execlp("cp","cp","-f",oldname,newname,0);
		      printf("DBG: should not be reached. fork failed!\n");
	      }
	      g_free(oldname); oldname=NULL;
	      g_free(newname); newname=NULL;
	      if (strcmp(tree_details->argv[0],"xfbook")==0 || strcmp(tree_details->argv[0],"xfbook4")==0){
		g_free(tree_details->argv[1]);
		tree_details->argv[1] = g_strdup(BOOK_get_bookfile_path());
	      }
   	      BOOK_reload_book(treeview); 
	    }
	    return;
	case WORKDIR_INPUT:
	    g_free(workdir);
	    workdir=g_strdup(choice);
	    save_workdir_history(workdir);
    	    g_free(choice);
	    choice=NULL;
	    /* OTHER_INPUT should cancel whatever is waiting on gtk loop */
    	    /*tree_details->input = OTHER_INPUT;*/
	    gtk_main_quit();
	    return;
	case RENAME_INPUT:
	case PRINT_INPUT:
	case SYMLINK_INPUT:
	case DUPLICATE_INPUT:
	    en = get_selected_entry(&iter);
	    if(!en || !IS_PATH(en->type))
		assert_not_reached();
	    treepath = gtk_tree_model_get_path(treemodel, &iter);
	    gtk_tree_path_up(treepath);
	    reference = gtk_tree_row_reference_new(treemodel, treepath);
	    gtk_tree_path_free(treepath);
	    {

		char *path = g_strdup(en->path);
		*(strrchr(path, '/')) = 0;
		switch (tree_details->input)
		{
		    default:
			break;
		    case RENAME_INPUT:
			nfile=g_strconcat(path, "/",choice,NULL);
			if (rename_it(treeview, &iter, nfile, en->path))
			PRINT_STATUS_DONE;
			break;
		    case PRINT_INPUT:
			if (print_it(&iter, choice, en->path))
				PRINT_STATUS_DONE;
			break;
		    case SYMLINK_INPUT:
			nfile=g_strconcat(path, "/",choice,NULL);
			if (symlink_it(treeview, &iter, nfile, en->path))
				PRINT_STATUS_DONE;
			break;
		    case DUPLICATE_INPUT:
			nfile=g_strconcat(path, "/",choice,NULL);
			if (duplicate_it(treeview, &iter, nfile, en->path))
				PRINT_STATUS_DONE;
			break;
		}
	    }

	    if(set_load_wait())
	    {
		update_dir(treeview, reference);
		unset_load_wait();
	    }

	    gtk_tree_row_reference_free(reference);

	    break;
	case RUN_DOUBLE_CLICK:
	case RUN_INPUT:
	    {
		gboolean in_terminal, remember, hold;
		GtkWidget *check;
		gchar *in_cmd;
		TRACE("at RUN_INPUT");
		check = WIDGET("checkbutton1");
		in_terminal = gtk_toggle_button_get_active((GtkToggleButton *) check);
		check = WIDGET("checkbutton3");
		hold = gtk_toggle_button_get_active((GtkToggleButton *) check);

		if (g_file_test(choice,G_FILE_TEST_IS_DIR)){
		    if (in_terminal) {
			new_terminal_path(choice);
			{
			    gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
			    gchar *f=g_strconcat(xdg_dir,RUN_DBH_FILE,NULL);

			    g_free(xdg_dir);
			    XFC_save_to_history(f,choice);
			    save_flags(choice,in_terminal,hold);
			    g_free(f);
			}
			break;
		    }
		    else in_cmd = g_strdup_printf("xftree4 %s",choice);
		} else {
		    in_cmd = g_strdup(choice);
		}
		    
		if(tree_details->input == RUN_INPUT)
		{
		    remember = FALSE;
		    en = NULL;
		}
		else
		{		/*RUN_DOUBLE_CLICK */
		    check = WIDGET("checkbutton2");
		    remember = gtk_toggle_button_get_active((GtkToggleButton *) check);
		    en = get_selected_entry( &iter);
		}
		TRACE("at input ok on_run %s",in_cmd);
		if(on_run(in_cmd, en, in_terminal, remember, TRUE, hold))
		{
		    print_status("xfce/info", _("Executing"), " ", in_cmd, NULL);
		}
		g_free(in_cmd);
		in_cmd=NULL;
	    }
	    break;
	case GOTO_INPUT:
	    {
	      gchar *g=fix_relative_path(treeview,choice);
	      if((access(g, X_OK) && strncmp(g,"//",2)) ||
	       (strncmp(choice,"//",2)==0 && strlen(choice)<3) )
	      {
	        if (access(choice, F_OK))
		       	print_status( "xfce/error",
			       strerror(ENOENT), " : ", 
			       choice, NULL);
		else print_status( "xfce/error",
			       strerror(EPERM), " : ", 
			       choice, NULL);
		g_free(g);
	      }
	      else
	      {
#ifdef USE_SMB_BRANCH
		if (strncmp(choice,"//",2)==0) get_network_root(treeview, &iter, &en);
		else 
#endif
		    get_local_root(treeview, &iter, &en);
		/*pushgo(treestuff, g);*/
		go_to(treestuff, g);
		/* save relative path for autocompletion */
		if (g_file_test((const gchar *)g,G_FILE_TEST_IS_DIR)) 
		    save_to_go_history(choice);
		g_free(g);
	      }
	    }
	    break;
	case NEW_FILE_INPUT:
	case NEW_DIR_INPUT:
	case NEW_INPUT:
	    {

		GtkWidget *w = WIDGET("checkbutton1");

		en = get_selected_entry(&iter);
    		if(!en || 
		   (!IS_PATH(en->type) &&
	            !IS_NETDIR(en->subtype) &&
 	            !IS_NETFILE(en->subtype) && 
 	            !IS_XF_NETSHARE(en->subtype)
 	           )) break;
		if (!gtk_toggle_button_get_active((GtkToggleButton *) w) &&
		    (IS_NETDIR(en->subtype) || 
 	            IS_NETFILE(en->subtype) || 
	            IS_XF_NETSHARE(en->subtype))
		   ){
	    		print_status("xfce/error",
			    strerror(ENOTSUP),
			    NULL);
			break;
		}

		treepath = gtk_tree_model_get_path(treemodel, &iter);
		reference = gtk_tree_row_reference_new(treemodel, treepath);
		gtk_tree_path_free(treepath);

		{
		    char *path = g_strdup(en->path);
		    char *name = g_strdup(choice);
		    if(!IS_DIR(en->type))
		    {
			*(strrchr(path, '/')) = 0;
		    }
		    new_it(treeview, path, name, gtk_toggle_button_get_active((GtkToggleButton *) w));
		    g_free(path);
		    path=NULL;
		    g_free(name);
		    name=NULL;
		}
		if(set_load_wait())
		{
		    update_dir(treeview, reference);
		    unset_load_wait();
		}

		gtk_tree_row_reference_free(reference);
	    }
	    break;
    }
    g_free(nfile);
    nfile=NULL;
    g_free(choice);
    choice=NULL;
    tree_details->input = OTHER_INPUT;
    local_monitor(TRUE);
}

G_MODULE_EXPORT
void cancel_input (GtkEntry *entry,gpointer data)
{
    hideit(tree_details->window, "input_box");
    if(tree_details->preferences & SHOW_TB1)
	showit(tree_details->window, "box_tb1");
#if 0    
#ifdef USE_FILTER_BAR
    if(tree_details->preferences & SHOW_F)
	showit(tree_details->window, "filter_box");
#endif
#endif
    
    if (tree_details->input==WORKDIR_INPUT){
	    g_free(workdir);
	    workdir=NULL;
	    tree_details->input = OTHER_INPUT;
	    gtk_main_quit(); /* this lets on_autotype_C continue */
    } else {
	    tree_details->input = OTHER_INPUT;
    }
}

/* callbacks */



G_MODULE_EXPORT
void on_input_cancel (GtkButton * button, gpointer user_data)
{
    cancel_input(NULL,NULL);
}


G_MODULE_EXPORT
void on_input_ok (GtkButton * button, gpointer user_data)
{
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    ok_input(treeview);
}


G_MODULE_EXPORT
void on_input_activate (GtkEntry * entry, gpointer user_data)
{
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    ok_input(treeview);

}
