#ifndef __LS_ICON_H__
#define __LS_ICON_H__

#include <gtk/gtk.h>
#include <gdk/gdk.h>

#include <libxfcegui4/libxfcegui4.h>
#include <libxfce4mcs/mcs-client.h>

typedef enum
{
    LS_ICON_WIN_DEFAULT = 0,
    LS_ICON_WIN_MINIMIZED = 1,
    LS_ICON_WIN_SKIP = 2,
    LS_ICON_WIN_OTHER_WS = 3,
    LS_ICON_WIN_SIZE = 4
} LSIconWin;

typedef enum
{
    LS_ICON_STATE_NORMAL = 0,
    LS_ICON_STATE_PRELIGHT = 1,
    LS_ICON_STATE_ACTIVE = 2,
    LS_ICON_STATE_SIZE = 3
} LSIconState;

/* maximum length of string reserved for a tooltip				*/
#define LS_ICON_MAX_TOOLTIP_LEN	1024

/* becourse of a lag of definition in xfce_iconbutton.h we have to do it here	*/
#ifndef XFCE_TYPE_ICONBUTTON
#define XFCE_TYPE_ICONBUTTON	(xfce_iconbutton_get_type())
#endif /* ifndef XFCE_TYPE_ICONBUTTON          */
#define LS_TYPE_ICON		(ls_icon_get_type())
#define LS_ICON(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), LS_TYPE_ICON, LSIcon))
#define LS_ICON_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), LS_TYPE_ICON, LSIconClass))
#define LS_IS_ICON(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LS_TYPE_ICON))
#define LS_IS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LS_TYPE_ICON))

typedef struct _LSIconClass LSIconClass;
typedef struct _LSIconPrivate LSIconPrivate;
typedef struct _LSIcon LSIcon;
typedef struct _LSColor LSColor;
typedef struct _LSDisplayIcon LSDisplayIcon;

#include <ls_iconboxwin.h>
#include <ls_iconbox.h>

struct _LSIcon
{
    /* GtkButton          parent_instance;                                        */
    GtkEventBox parent_instance;
    LSIconPrivate *priv;
};

struct _LSIconClass
{
    /* GtkButtonClass     parent_class;                                           */
    GtkEventBoxClass parent_class;
    /* static vars                                                                */
};

struct _LSDisplayIcon
{
    gboolean minimized;
    gboolean notMinimized;
    gboolean skipTasklist;
};

GType ls_icon_get_type ();
LSIcon *ls_icon_new (NetkWindow * pWin, NetkScreen * pScreen);
NetkWindow *ls_icon_get_window (LSIcon * plsi);
void ls_icon_set_ftooltip (LSIcon * plsi, const char *szFormat, ...);
void ls_icon_set_parent (LSIcon * plsi, LSIconBox * plsib);
void ls_icon_set_use_color (LSIcon * plsi, gint nUseColor);
void ls_icon_set_show_same_workspace (LSIcon * plsi, LSDisplayIcon * pdi);
void ls_icon_set_show_other_workspace (LSIcon * plsi, LSDisplayIcon * pdi);

LSIconBox *ls_icon_get_parent (LSIcon * plsi);
glong ls_icon_get_window_xid (LSIcon * plsi);
NetkScreen *ls_icon_get_screen (LSIcon * plsi);
void ls_icon_create_menu (LSIcon * plsi);
gboolean ls_icon_re_evaluate_visibility (LSIcon * plsi);
void ls_icon_set_icon (LSIcon * plis, GdkPixbuf * pPixPuf);
gboolean ls_icon_re_evaluate_icon (LSIcon * plsi);
void ls_icon_set_color (LSIcon * plsi, glong lState);
#endif /* ifndef __LS_ICON_H__                 */
