/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Alerts;
import com.sun.net.ssl.internal.ssl.CipherSuite;
import com.sun.net.ssl.internal.ssl.CipherSuiteList;
import com.sun.net.ssl.internal.ssl.ClientDiffieHellmanPublic;
import com.sun.net.ssl.internal.ssl.DHKeyExchange;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.Handshaker;
import com.sun.net.ssl.internal.ssl.KerberosWrapper;
import com.sun.net.ssl.internal.ssl.PreMasterSecret;
import com.sun.net.ssl.internal.ssl.ProtocolList;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLEngineImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import sun.security.jgss.krb5.Krb5Util;

final class ClientHandshaker
extends Handshaker {
    private PublicKey serverKey;
    private BigInteger serverDH;
    private DHKeyExchange dh;
    private HandshakeMessage.CertificateRequest certRequest;
    private boolean serverKeyExchangeReceived;
    private ProtocolVersion maxProtocolVersion;

    ClientHandshaker(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList) {
        super(sSLSocketImpl, sSLContextImpl, protocolList, true, true);
    }

    ClientHandshaker(SSLEngineImpl sSLEngineImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList) {
        super(sSLEngineImpl, sSLContextImpl, protocolList, true, true);
    }

    void processMessage(byte by, int n) throws IOException {
        if (this.state > by && by != 0 && this.state != 1) {
            throw new SSLProtocolException("Handshake message sequence violation, " + by);
        }
        switch (by) {
            case 0: {
                this.serverHelloRequest(new HandshakeMessage.HelloRequest(this.input));
                break;
            }
            case 2: {
                this.serverHello(new HandshakeMessage.ServerHello(this.input));
                break;
            }
            case 11: {
                if (this.keyExchange == K_DH_ANON || this.keyExchange == K_KRB5 || this.keyExchange == K_KRB5_EXPORT) {
                    this.fatalSE((byte)10, "unexpected server cert chain");
                }
                this.serverCertificate(new HandshakeMessage.CertificateMsg(this.input));
                this.serverKey = this.session.getPeerCertificates()[0].getPublicKey();
                break;
            }
            case 12: {
                this.serverKeyExchangeReceived = true;
                if (this.keyExchange == K_RSA || this.keyExchange == K_RSA_EXPORT) {
                    try {
                        this.serverKeyExchange(new HandshakeMessage.RSA_ServerKeyExchange(this.input, n));
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        ClientHandshaker.throwSSLException("Server key", generalSecurityException);
                    }
                    break;
                }
                if (this.keyExchange == K_DH_ANON) {
                    this.serverKeyExchange(new HandshakeMessage.DH_ServerKeyExchange(this.input));
                    break;
                }
                if (this.keyExchange == K_DHE_DSS || this.keyExchange == K_DHE_RSA) {
                    try {
                        this.serverKeyExchange(new HandshakeMessage.DH_ServerKeyExchange(this.input, this.serverKey, this.clnt_random.random_bytes, this.svr_random.random_bytes, n));
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        ClientHandshaker.throwSSLException("Server key", generalSecurityException);
                    }
                    break;
                }
                if (this.keyExchange == K_KRB5 || this.keyExchange == K_KRB5_EXPORT) {
                    throw new SSLProtocolException("unexpected receipt of server key exchange algorithm");
                }
                throw new SSLProtocolException("unsupported key exchange algorithm = " + this.keyExchange);
            }
            case 13: {
                if (this.keyExchange == K_DH_ANON) {
                    throw new SSLHandshakeException("Client authentication requested for anonymous cipher suite.");
                }
                if (this.keyExchange == K_KRB5 || this.keyExchange == K_KRB5_EXPORT) {
                    throw new SSLHandshakeException("Client certificate requested for kerberos cipher suite.");
                }
                this.certRequest = new HandshakeMessage.CertificateRequest(this.input);
                if (debug == null || !Debug.isOn("handshake")) break;
                this.certRequest.print(System.out);
                break;
            }
            case 14: {
                this.serverHelloDone(new HandshakeMessage.ServerHelloDone(this.input));
                break;
            }
            case 20: {
                this.serverFinished(new HandshakeMessage.Finished(this.protocolVersion, this.input));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal client handshake msg, " + by);
            }
        }
        if (this.state < by) {
            this.state = by;
        }
    }

    private void serverHelloRequest(HandshakeMessage.HelloRequest helloRequest) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            helloRequest.print(System.out);
        }
        if (this.state < 1) {
            this.kickstart();
        }
    }

    private void serverHello(HandshakeMessage.ServerHello serverHello) throws IOException {
        ProtocolVersion protocolVersion;
        this.serverKeyExchangeReceived = false;
        if (debug != null && Debug.isOn("handshake")) {
            serverHello.print(System.out);
        }
        if (!this.enabledProtocols.contains(protocolVersion = serverHello.protocolVersion)) {
            throw new SSLHandshakeException("Server chose unsupported or disabled protocol: " + protocolVersion);
        }
        this.setVersion(protocolVersion);
        this.svr_random = serverHello.svr_random;
        if (!this.isEnabled(serverHello.cipherSuite)) {
            this.fatalSE((byte)47, "Server selected disabled ciphersuite " + this.cipherSuite);
        }
        this.setCipherSuite(serverHello.cipherSuite);
        if (serverHello.compression_method != 0) {
            this.fatalSE((byte)47, "compression type not supported, " + serverHello.compression_method);
        }
        if (this.session != null) {
            if (this.session.getSessionId().equals(serverHello.sessionId)) {
                CipherSuite cipherSuite = this.session.getSuite();
                if (this.cipherSuite != cipherSuite) {
                    throw new SSLProtocolException("Server returned wrong cipher suite for session");
                }
                ProtocolVersion protocolVersion2 = this.session.getProtocolVersion();
                if (this.protocolVersion != protocolVersion2) {
                    throw new SSLProtocolException("Server resumed session with wrong protocol version");
                }
                if (cipherSuite.keyExchange == K_KRB5 || cipherSuite.keyExchange == K_KRB5_EXPORT) {
                    Subject subject;
                    Principal principal;
                    block19: {
                        principal = this.session.getLocalPrincipal();
                        subject = null;
                        try {
                            subject = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    return Krb5Util.getSubject((String)"com.sun.net.ssl.client", (AccessControlContext)ClientHandshaker.this.getAccSE());
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            subject = null;
                            if (debug == null || !Debug.isOn("session")) break block19;
                            System.out.println("Attempt to obtain subject failed!");
                        }
                    }
                    if (subject != null) {
                        Set<KerberosPrincipal> set = subject.getPrincipals(KerberosPrincipal.class);
                        if (!set.contains(principal)) {
                            throw new SSLProtocolException("Server resumed session with wrong subject identity");
                        }
                        if (debug != null && Debug.isOn("session")) {
                            System.out.println("Subject identity is same");
                        }
                    } else {
                        if (debug != null && Debug.isOn("session")) {
                            System.out.println("Kerberos credentials are not present in the current Subject; check if  javax.security.auth.useSubjectAsCreds system property has been set to false");
                        }
                        throw new SSLProtocolException("Server resumed session with no subject");
                    }
                }
                this.resumingSession = true;
                this.state = 19;
                this.calculateConnectionKeys(this.session.getMasterSecret());
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% Server resumed " + this.session);
                }
                return;
            }
            this.session = null;
            if (!this.enableNewSession) {
                throw new SSLException("New session creation is disabled");
            }
        }
        this.session = new SSLSessionImpl(this.protocolVersion, this.cipherSuite, serverHello.sessionId, this.getHostSE(), this.getPortSE());
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("** " + this.cipherSuite);
        }
    }

    private void serverKeyExchange(HandshakeMessage.RSA_ServerKeyExchange rSA_ServerKeyExchange) throws IOException, GeneralSecurityException {
        if (debug != null && Debug.isOn("handshake")) {
            rSA_ServerKeyExchange.print(System.out);
        }
        if (!rSA_ServerKeyExchange.verify(this.serverKey, this.clnt_random, this.svr_random)) {
            this.fatalSE((byte)40, "server key exchange invalid");
        }
        this.serverKey = rSA_ServerKeyExchange.getPublicKey();
    }

    private void getDHephemeral(BigInteger bigInteger, BigInteger bigInteger2) {
        this.dh = new DHKeyExchange(bigInteger, bigInteger2);
        int n = !this.cipherSuite.exportable ? 768 : 512;
        this.dh.generateKeyPair(this.sslContext.getSecureRandom(), n);
    }

    private void serverKeyExchange(HandshakeMessage.DH_ServerKeyExchange dH_ServerKeyExchange) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            dH_ServerKeyExchange.print(System.out);
        }
        this.getDHephemeral(dH_ServerKeyExchange.getModulus(), dH_ServerKeyExchange.getBase());
        this.serverDH = dH_ServerKeyExchange.getServerPublicKey();
    }

    private void serverHelloDone(HandshakeMessage.ServerHelloDone serverHelloDone) throws IOException {
        HandshakeMessage handshakeMessage;
        Object object;
        Object object2;
        if (debug != null && Debug.isOn("handshake")) {
            serverHelloDone.print(System.out);
        }
        this.input.digestNow();
        PrivateKey privateKey = null;
        if (this.certRequest != null) {
            String[] stringArray;
            int n;
            object2 = this.sslContext.getX509KeyManager();
            object = null;
            handshakeMessage = null;
            X509Certificate[] x509CertificateArray = null;
            ArrayList<String[]> arrayList = new ArrayList<String[]>(4);
            for (n = 0; n < this.certRequest.types.length; ++n) {
                switch (this.certRequest.types[n]) {
                    case 1: {
                        stringArray = "RSA";
                        break;
                    }
                    case 2: {
                        stringArray = "DSA";
                        break;
                    }
                    case 3: {
                        stringArray = "DH_RSA";
                        break;
                    }
                    case 4: {
                        stringArray = "DH_DSA";
                        break;
                    }
                    default: {
                        stringArray = null;
                    }
                }
                if (stringArray == null || arrayList.contains(stringArray)) continue;
                arrayList.add(stringArray);
            }
            n = arrayList.size();
            if (n != 0) {
                stringArray = arrayList.toArray(new String[n]);
                object = this.conn != null ? object2.chooseClientAlias(stringArray, this.certRequest.getAuthorities(), this.conn) : ((X509ExtendedKeyManager)object2).chooseEngineClientAlias(stringArray, this.certRequest.getAuthorities(), this.engine);
            }
            if (object != null) {
                x509CertificateArray = object2.getCertificateChain((String)object);
                handshakeMessage = new HandshakeMessage.CertificateMsg(x509CertificateArray);
                privateKey = object2.getPrivateKey((String)object);
                this.session.setLocalPrivateKey(privateKey);
            } else if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
                handshakeMessage = new HandshakeMessage.CertificateMsg(new X509Certificate[0]);
            } else {
                this.warningSE((byte)41);
            }
            if (handshakeMessage != null) {
                this.session.setLocalCertificates(x509CertificateArray);
                if (debug != null && Debug.isOn("handshake")) {
                    ((HandshakeMessage.CertificateMsg)handshakeMessage).print(System.out);
                }
                handshakeMessage.write(this.output);
            }
        }
        if (this.keyExchange == K_RSA || this.keyExchange == K_RSA_EXPORT) {
            object2 = new PreMasterSecret(this.protocolVersion, this.maxProtocolVersion, this.sslContext.getSecureRandom(), this.serverKey);
        } else if (this.keyExchange == K_DH_RSA || this.keyExchange == K_DH_DSS) {
            object2 = new ClientDiffieHellmanPublic();
        } else if (this.keyExchange == K_DHE_RSA || this.keyExchange == K_DHE_DSS || this.keyExchange == K_DH_ANON) {
            object2 = new ClientDiffieHellmanPublic(this.dh.getPublicKey());
        } else if (this.keyExchange == K_KRB5 || this.keyExchange == K_KRB5_EXPORT) {
            object = this.getHostSE();
            if (object == null) {
                throw new IOException("Hostname is required to use Kerberos cipher suites");
            }
            handshakeMessage = new KerberosWrapper((String)object, this.isLoopbackSE(), this.getAccSE(), this.protocolVersion, this.sslContext.getSecureRandom());
            this.session.setPeerPrincipal(((KerberosWrapper)handshakeMessage).getPeerPrincipal());
            this.session.setLocalPrincipal(((KerberosWrapper)handshakeMessage).getLocalPrincipal());
            object2 = handshakeMessage;
        } else {
            throw new RuntimeException("Unsupported key exchange: " + this.keyExchange);
        }
        if (debug != null && Debug.isOn("handshake")) {
            ((HandshakeMessage)object2).print(System.out);
        }
        ((HandshakeMessage)object2).write(this.output);
        this.output.doHashes();
        this.output.flush();
        object = this.keyExchange == K_RSA || this.keyExchange == K_RSA_EXPORT ? (Object)((PreMasterSecret)object2).preMaster : (this.keyExchange == K_KRB5 || this.keyExchange == K_KRB5_EXPORT ? (Object)((KerberosWrapper)object2).getPreMasterSecret().getUnencrypted() : (Object)this.dh.getAgreedSecret(this.serverDH));
        this.calculateKeys((byte[])object);
        Arrays.fill((byte[])object, (byte)0);
        if (privateKey != null) {
            try {
                handshakeMessage = new HandshakeMessage.CertificateVerify(this.protocolVersion, this.handshakeHash, privateKey, this.session.getMasterSecret(), this.sslContext.getSecureRandom());
            }
            catch (GeneralSecurityException generalSecurityException) {
                this.fatalSE((byte)40, "Error signing certificate verify", generalSecurityException);
                handshakeMessage = null;
            }
            if (debug != null && Debug.isOn("handshake")) {
                ((HandshakeMessage.CertificateVerify)handshakeMessage).print(System.out);
            }
            handshakeMessage.write(this.output);
            this.output.doHashes();
        }
        this.sendChangeCipherAndFinish();
    }

    private void serverFinished(HandshakeMessage.Finished finished) throws IOException {
        boolean bl;
        if (debug != null && Debug.isOn("handshake")) {
            finished.print(System.out);
        }
        if (!(bl = finished.verify(this.protocolVersion, this.handshakeHash, 2, this.session.getMasterSecret()))) {
            this.fatalSE((byte)47, "server 'finished' message doesn't verify");
        }
        if (this.resumingSession) {
            this.input.digestNow();
            this.sendChangeCipherAndFinish();
        }
        this.session.setLastAccessedTime(System.currentTimeMillis());
        if (!this.resumingSession) {
            if (this.session.isRejoinable()) {
                ((SSLSessionContextImpl)this.sslContext.engineGetClientSessionContext()).put(this.session);
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% Cached client session: " + this.session);
                }
            } else if (debug != null && Debug.isOn("session")) {
                System.out.println("%% Didn't cache non-resumable client session: " + this.session);
            }
        }
    }

    private void sendChangeCipherAndFinish() throws IOException {
        HandshakeMessage.Finished finished = new HandshakeMessage.Finished(this.protocolVersion, this.handshakeHash, 1, this.session.getMasterSecret());
        this.sendChangeCipherSpec(finished);
        this.state = 19;
    }

    HandshakeMessage getKickstartMessage() throws SSLException {
        HandshakeMessage.ClientHello clientHello = new HandshakeMessage.ClientHello(this.sslContext.getSecureRandom(), this.protocolVersion);
        this.maxProtocolVersion = this.protocolVersion;
        this.clnt_random = clientHello.clnt_random;
        this.session = ((SSLSessionContextImpl)this.sslContext.engineGetClientSessionContext()).get(this.getHostSE(), this.getPortSE());
        if (debug != null && Debug.isOn("session")) {
            if (this.session != null) {
                System.out.println("%% Client cached " + this.session + (this.session.isRejoinable() ? "" : " (not rejoinable)"));
            } else {
                System.out.println("%% No cached client session");
            }
        }
        if (this.session != null && !this.session.isRejoinable()) {
            this.session = null;
        }
        if (this.session != null) {
            CipherSuite cipherSuite = this.session.getSuite();
            ProtocolVersion protocolVersion = this.session.getProtocolVersion();
            if (!this.isEnabled(cipherSuite)) {
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% can't resume, cipher disabled");
                }
                this.session = null;
            }
            if (this.session != null && !this.enabledProtocols.contains(protocolVersion)) {
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% can't resume, protocol disabled");
                }
                this.session = null;
            }
            if (this.session != null) {
                if (debug != null && (Debug.isOn("handshake") || Debug.isOn("session"))) {
                    System.out.println("%% Try resuming " + this.session + " from port " + this.getLocalPortSE());
                }
                clientHello.sessionId = this.session.getSessionId();
                clientHello.protocolVersion = protocolVersion;
                this.maxProtocolVersion = protocolVersion;
                this.setVersion(protocolVersion);
            }
            if (!this.enableNewSession) {
                if (this.session == null) {
                    throw new SSLException("Can't reuse existing SSL client session");
                }
                clientHello.cipherSuites = new CipherSuiteList(cipherSuite);
                return clientHello;
            }
        }
        if (this.session == null) {
            if (this.enableNewSession) {
                clientHello.sessionId = SSLSessionImpl.nullSession.getSessionId();
            } else {
                throw new SSLException("No existing session to resume.");
            }
        }
        clientHello.cipherSuites = this.enabledCipherSuites;
        return clientHello;
    }

    void handshakeAlert(byte by) throws SSLProtocolException {
        String string = Alerts.alertDescription(by);
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("SSL - handshake alert: " + string);
        }
        throw new SSLProtocolException("handshake alert:  " + string);
    }

    private void serverCertificate(HandshakeMessage.CertificateMsg certificateMsg) throws IOException {
        X509Certificate[] x509CertificateArray;
        if (debug != null && Debug.isOn("handshake")) {
            certificateMsg.print(System.out);
        }
        if ((x509CertificateArray = certificateMsg.getCertificateChain()).length == 0) {
            this.fatalSE((byte)42, "empty certificate chain");
        }
        X509TrustManager x509TrustManager = this.sslContext.getX509TrustManager();
        try {
            String string = this.keyExchange == K_RSA_EXPORT && !this.serverKeyExchangeReceived ? ClientHandshaker.K_RSA.name : this.keyExchange.name;
            x509TrustManager.checkServerTrusted(x509CertificateArray != null ? (X509Certificate[])x509CertificateArray.clone() : x509CertificateArray, string);
        }
        catch (CertificateException certificateException) {
            this.fatalSE((byte)46, certificateException);
        }
        this.session.setPeerCertificates(x509CertificateArray);
    }
}

