/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.Era;
import sun.util.calendar.Gregorian;

public abstract class CalendarSystem {
    static Map names;
    static Map calendars;
    private static final String pkg = "sun.util.calendar.";
    private static final String[] namePairs;
    private static final Gregorian GREGORIAN_INSTANCE;

    private static synchronized void initNames() {
        if (names != null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < namePairs.length; i2 += 2) {
            stringBuilder.setLength(0);
            String string = stringBuilder.append(pkg).append(namePairs[i2 + 1]).toString();
            hashMap.put(namePairs[i2], string);
            calendars.put(string, stringBuilder.append(".Date").toString());
        }
        names = hashMap;
    }

    public static Gregorian getGregorianCalendar() {
        return GREGORIAN_INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalendarSystem forName(String string) {
        if ("gregorian".equals(string)) {
            return GREGORIAN_INSTANCE;
        }
        CalendarSystem calendarSystem = null;
        Map map = calendars;
        synchronized (map) {
            String string2;
            calendarSystem = (CalendarSystem)calendars.get(string);
            if (calendarSystem != null) {
                return calendarSystem;
            }
            if (names == null) {
                CalendarSystem.initNames();
            }
            if ((string2 = (String)names.get(string)) == null) {
                return null;
            }
            if (!string2.endsWith("LocalGregorianCalendar")) {
                try {
                    Class<?> clazz = Class.forName(string2);
                    calendarSystem = (CalendarSystem)clazz.newInstance();
                    calendars.put(string, calendarSystem);
                    return calendarSystem;
                }
                catch (Exception exception) {
                    throw new RuntimeException("internal error", exception);
                }
            }
        }
        return calendarSystem;
    }

    public abstract String getName();

    public abstract CalendarDate getCalendarDate();

    public abstract CalendarDate getCalendarDate(long var1);

    public abstract CalendarDate getCalendarDate(long var1, CalendarDate var3);

    public abstract CalendarDate getCalendarDate(long var1, TimeZone var3);

    public abstract CalendarDate newCalendarDate();

    public abstract CalendarDate newCalendarDate(TimeZone var1);

    public abstract long getTime(CalendarDate var1);

    public abstract int getYearLength(CalendarDate var1);

    public abstract int getYearLengthInMonths(CalendarDate var1);

    public abstract int getMonthLength(CalendarDate var1);

    public abstract int getWeekLength();

    public abstract Era getEra(String var1);

    public abstract Era[] getEras();

    public abstract void setEra(CalendarDate var1, String var2);

    public abstract CalendarDate getNthDayOfWeek(int var1, int var2, CalendarDate var3);

    public abstract CalendarDate setTimeOfDay(CalendarDate var1, int var2);

    public abstract boolean validate(CalendarDate var1);

    public abstract boolean normalize(CalendarDate var1);

    static {
        calendars = new HashMap();
        namePairs = new String[]{"gregorian", "Gregorian", "julian", "JulianCalendar"};
        GREGORIAN_INSTANCE = new Gregorian();
    }
}

