/*
 * Decompiled with CFR 0.152.
 */
package sun.swing.plaf.synth;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;

public class DefaultSynthStyle
extends SynthStyle
implements Cloneable {
    private static final Object PENDING = new String("Pending");
    private boolean opaque;
    private Insets insets;
    private StateInfo[] states;
    private Map data;
    private Font font;
    private SynthGraphicsUtils synthGraphics;
    private SynthPainter painter;

    public DefaultSynthStyle() {
    }

    public DefaultSynthStyle(DefaultSynthStyle defaultSynthStyle) {
        this.opaque = defaultSynthStyle.opaque;
        if (defaultSynthStyle.insets != null) {
            this.insets = new Insets(defaultSynthStyle.insets.top, defaultSynthStyle.insets.left, defaultSynthStyle.insets.bottom, defaultSynthStyle.insets.right);
        }
        if (defaultSynthStyle.states != null) {
            this.states = new StateInfo[defaultSynthStyle.states.length];
            for (int i2 = defaultSynthStyle.states.length - 1; i2 >= 0; --i2) {
                this.states[i2] = (StateInfo)defaultSynthStyle.states[i2].clone();
            }
        }
        if (defaultSynthStyle.data != null) {
            this.data = new HashMap();
            this.data.putAll(defaultSynthStyle.data);
        }
        this.font = defaultSynthStyle.font;
        this.synthGraphics = defaultSynthStyle.synthGraphics;
        this.painter = defaultSynthStyle.painter;
    }

    public DefaultSynthStyle(Insets insets, boolean bl2, StateInfo[] stateInfoArray, Map map) {
        this.insets = insets;
        this.opaque = bl2;
        this.states = stateInfoArray;
        this.data = map;
    }

    public Color getColor(SynthContext synthContext, ColorType colorType) {
        return this.getColor(synthContext.getComponent(), synthContext.getRegion(), synthContext.getComponentState(), colorType);
    }

    public Color getColor(JComponent jComponent, Region region, int n2, ColorType colorType) {
        Color color;
        if (!region.isSubregion() && n2 == 1) {
            if (colorType == ColorType.BACKGROUND) {
                return jComponent.getBackground();
            }
            if (colorType == ColorType.FOREGROUND) {
                return jComponent.getForeground();
            }
            if (colorType == ColorType.TEXT_FOREGROUND && !((color = jComponent.getForeground()) instanceof UIResource)) {
                return color;
            }
        }
        if ((color = this.getColorForState(jComponent, region, n2, colorType)) == null) {
            if (colorType == ColorType.BACKGROUND || colorType == ColorType.TEXT_BACKGROUND) {
                return jComponent.getBackground();
            }
            if (colorType == ColorType.FOREGROUND || colorType == ColorType.TEXT_FOREGROUND) {
                return jComponent.getForeground();
            }
        }
        return color;
    }

    protected Color getColorForState(SynthContext synthContext, ColorType colorType) {
        return this.getColorForState(synthContext.getComponent(), synthContext.getRegion(), synthContext.getComponentState(), colorType);
    }

    protected Color getColorForState(JComponent jComponent, Region region, int n2, ColorType colorType) {
        Color color;
        StateInfo stateInfo = this.getStateInfo(n2);
        if (stateInfo != null && (color = stateInfo.getColor(colorType)) != null) {
            return color;
        }
        if ((stateInfo == null || stateInfo.getComponentState() != 0) && (stateInfo = this.getStateInfo(0)) != null) {
            return stateInfo.getColor(colorType);
        }
        return null;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont(SynthContext synthContext) {
        return this.getFont(synthContext.getComponent(), synthContext.getRegion(), synthContext.getComponentState());
    }

    public Font getFont(JComponent jComponent, Region region, int n2) {
        if (n2 == 1) {
            return jComponent.getFont();
        }
        Font font = jComponent.getFont();
        if (font != null && !(font instanceof UIResource)) {
            return font;
        }
        return this.getFontForState(jComponent, region, n2);
    }

    protected Font getFontForState(JComponent jComponent, Region region, int n2) {
        Font font;
        if (jComponent == null) {
            return this.font;
        }
        StateInfo stateInfo = this.getStateInfo(n2);
        if (stateInfo != null && (font = stateInfo.getFont()) != null) {
            return font;
        }
        if ((stateInfo == null || stateInfo.getComponentState() != 0) && (stateInfo = this.getStateInfo(0)) != null && (font = stateInfo.getFont()) != null) {
            return font;
        }
        return this.font;
    }

    protected Font getFontForState(SynthContext synthContext) {
        return this.getFontForState(synthContext.getComponent(), synthContext.getRegion(), synthContext.getComponentState());
    }

    public void setGraphicsUtils(SynthGraphicsUtils synthGraphicsUtils) {
        this.synthGraphics = synthGraphicsUtils;
    }

    public SynthGraphicsUtils getGraphicsUtils(SynthContext synthContext) {
        if (this.synthGraphics == null) {
            return super.getGraphicsUtils(synthContext);
        }
        return this.synthGraphics;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public Insets getInsets(SynthContext synthContext, Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (this.insets != null) {
            insets.left = this.insets.left;
            insets.right = this.insets.right;
            insets.top = this.insets.top;
            insets.bottom = this.insets.bottom;
        } else {
            insets.bottom = 0;
            insets.top = 0;
            insets.right = 0;
            insets.left = 0;
        }
        return insets;
    }

    public void setPainter(SynthPainter synthPainter) {
        this.painter = synthPainter;
    }

    public SynthPainter getPainter(SynthContext synthContext) {
        return this.painter;
    }

    public void setOpaque(boolean bl2) {
        this.opaque = bl2;
    }

    public boolean isOpaque(SynthContext synthContext) {
        return this.opaque;
    }

    public void setData(Map map) {
        this.data = map;
    }

    public Map getData() {
        return this.data;
    }

    public Object get(SynthContext synthContext, Object object) {
        StateInfo stateInfo = this.getStateInfo(synthContext.getComponentState());
        if (stateInfo != null && stateInfo.getData() != null && this.getKeyFromData(stateInfo.getData(), object) != null) {
            return this.getKeyFromData(stateInfo.getData(), object);
        }
        stateInfo = this.getStateInfo(0);
        if (stateInfo != null && stateInfo.getData() != null && this.getKeyFromData(stateInfo.getData(), object) != null) {
            return this.getKeyFromData(stateInfo.getData(), object);
        }
        if (this.getKeyFromData(this.data, object) != null) {
            return this.getKeyFromData(this.data, object);
        }
        return this.getDefaultValue(synthContext, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getKeyFromData(Map map, Object object) {
        Object object2 = null;
        if (map != null) {
            Map map2 = map;
            synchronized (map2) {
                object2 = map.get(object);
            }
            while (object2 == PENDING) {
                map2 = map;
                synchronized (map2) {
                    try {
                        map.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    object2 = map.get(object);
                }
            }
            if (object2 instanceof UIDefaults.LazyValue) {
                map2 = map;
                synchronized (map2) {
                    map.put(object, PENDING);
                }
                object2 = ((UIDefaults.LazyValue)object2).createValue(null);
                map2 = map;
                synchronized (map2) {
                    map.put(object, object2);
                    map.notifyAll();
                }
            }
        }
        return object2;
    }

    public Object getDefaultValue(SynthContext synthContext, Object object) {
        return super.get(synthContext, object);
    }

    public Object clone() {
        DefaultSynthStyle defaultSynthStyle;
        try {
            defaultSynthStyle = (DefaultSynthStyle)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        if (this.states != null) {
            defaultSynthStyle.states = new StateInfo[this.states.length];
            for (int i2 = this.states.length - 1; i2 >= 0; --i2) {
                defaultSynthStyle.states[i2] = (StateInfo)this.states[i2].clone();
            }
        }
        if (this.data != null) {
            defaultSynthStyle.data = new HashMap();
            defaultSynthStyle.data.putAll(this.data);
        }
        return defaultSynthStyle;
    }

    public DefaultSynthStyle addTo(DefaultSynthStyle defaultSynthStyle) {
        if (this.insets != null) {
            defaultSynthStyle.insets = this.insets;
        }
        if (this.font != null) {
            defaultSynthStyle.font = this.font;
        }
        if (this.painter != null) {
            defaultSynthStyle.painter = this.painter;
        }
        if (this.synthGraphics != null) {
            defaultSynthStyle.synthGraphics = this.synthGraphics;
        }
        defaultSynthStyle.opaque = this.opaque;
        if (this.states != null) {
            if (defaultSynthStyle.states == null) {
                defaultSynthStyle.states = new StateInfo[this.states.length];
                for (int i2 = this.states.length - 1; i2 >= 0; --i2) {
                    if (this.states[i2] == null) continue;
                    defaultSynthStyle.states[i2] = (StateInfo)this.states[i2].clone();
                }
            } else {
                int n2;
                int n3;
                int n4;
                int n5 = 0;
                int n6 = 0;
                int n7 = defaultSynthStyle.states.length;
                for (int i3 = this.states.length - 1; i3 >= 0; --i3) {
                    n4 = this.states[i3].getComponentState();
                    n3 = 0;
                    for (n2 = n7 - 1 - n6; n2 >= 0; --n2) {
                        if (n4 != defaultSynthStyle.states[n2].getComponentState()) continue;
                        defaultSynthStyle.states[n2] = this.states[i3].addTo(defaultSynthStyle.states[n2]);
                        StateInfo stateInfo = defaultSynthStyle.states[n7 - 1 - n6];
                        defaultSynthStyle.states[n7 - 1 - n6] = defaultSynthStyle.states[n2];
                        defaultSynthStyle.states[n2] = stateInfo;
                        ++n6;
                        n3 = 1;
                        break;
                    }
                    if (n3 != 0) continue;
                    ++n5;
                }
                if (n5 != 0) {
                    StateInfo[] stateInfoArray = new StateInfo[n5 + n7];
                    n4 = n7;
                    System.arraycopy(defaultSynthStyle.states, 0, stateInfoArray, 0, n7);
                    for (n3 = this.states.length - 1; n3 >= 0; --n3) {
                        n2 = this.states[n3].getComponentState();
                        boolean bl2 = false;
                        for (int i4 = n7 - 1; i4 >= 0; --i4) {
                            if (n2 != defaultSynthStyle.states[i4].getComponentState()) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) continue;
                        stateInfoArray[n4++] = (StateInfo)this.states[n3].clone();
                    }
                    defaultSynthStyle.states = stateInfoArray;
                }
            }
        }
        if (this.data != null) {
            if (defaultSynthStyle.data == null) {
                defaultSynthStyle.data = new HashMap();
            }
            defaultSynthStyle.data.putAll(this.data);
        }
        return defaultSynthStyle;
    }

    public void setStateInfo(StateInfo[] stateInfoArray) {
        this.states = stateInfoArray;
    }

    public StateInfo[] getStateInfo() {
        return this.states;
    }

    public StateInfo getStateInfo(int n2) {
        if (this.states != null) {
            int n3 = 0;
            int n4 = -1;
            int n5 = -1;
            if (n2 == 0) {
                for (int i2 = this.states.length - 1; i2 >= 0; --i2) {
                    if (this.states[i2].getComponentState() != 0) continue;
                    return this.states[i2];
                }
                return null;
            }
            for (int i3 = this.states.length - 1; i3 >= 0; --i3) {
                int n6 = this.states[i3].getComponentState();
                if (n6 == 0) {
                    if (n5 != -1) continue;
                    n5 = i3;
                    continue;
                }
                if ((n2 & n6) != n6) continue;
                int n7 = n6;
                n7 -= (0xAAAAAAAA & n7) >>> 1;
                n7 = (n7 & 0x33333333) + (n7 >>> 2 & 0x33333333);
                n7 = n7 + (n7 >>> 4) & 0xF0F0F0F;
                n7 += n7 >>> 8;
                n7 += n7 >>> 16;
                if ((n7 &= 0xFF) <= n3) continue;
                n4 = i3;
                n3 = n7;
            }
            if (n4 != -1) {
                return this.states[n4];
            }
            if (n5 != -1) {
                return this.states[n5];
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append(',');
        stringBuffer.append("data=").append(this.data).append(',');
        stringBuffer.append("font=").append(this.font).append(',');
        stringBuffer.append("insets=").append(this.insets).append(',');
        stringBuffer.append("synthGraphics=").append(this.synthGraphics).append(',');
        stringBuffer.append("painter=").append(this.painter).append(',');
        StateInfo[] stateInfoArray = this.getStateInfo();
        if (stateInfoArray != null) {
            stringBuffer.append("states[");
            for (int i2 = 0; i2 < stateInfoArray.length; ++i2) {
                stringBuffer.append(stateInfoArray[i2].toString()).append(',');
            }
            stringBuffer.append(']').append(',');
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public static class StateInfo {
        private Map data;
        private Font font;
        private Color[] colors;
        private int state;

        public StateInfo() {
        }

        public StateInfo(int n2, Font font, Color[] colorArray) {
            this.state = n2;
            this.font = font;
            this.colors = colorArray;
        }

        public StateInfo(StateInfo stateInfo) {
            this.state = stateInfo.state;
            this.font = stateInfo.font;
            if (stateInfo.data != null) {
                if (this.data == null) {
                    this.data = new HashMap();
                }
                this.data.putAll(stateInfo.data);
            }
            if (stateInfo.colors != null) {
                this.colors = new Color[stateInfo.colors.length];
                System.arraycopy(stateInfo.colors, 0, this.colors, 0, stateInfo.colors.length);
            }
        }

        public Map getData() {
            return this.data;
        }

        public void setData(Map map) {
            this.data = map;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public Font getFont() {
            return this.font;
        }

        public void setColors(Color[] colorArray) {
            this.colors = colorArray;
        }

        public Color[] getColors() {
            return this.colors;
        }

        public Color getColor(ColorType colorType) {
            int n2;
            if (this.colors != null && (n2 = colorType.getID()) < this.colors.length) {
                return this.colors[n2];
            }
            return null;
        }

        public StateInfo addTo(StateInfo stateInfo) {
            if (this.font != null) {
                stateInfo.font = this.font;
            }
            if (this.data != null) {
                if (stateInfo.data == null) {
                    stateInfo.data = new HashMap();
                }
                stateInfo.data.putAll(this.data);
            }
            if (this.colors != null) {
                if (stateInfo.colors == null) {
                    stateInfo.colors = new Color[this.colors.length];
                    System.arraycopy(this.colors, 0, stateInfo.colors, 0, this.colors.length);
                } else {
                    if (stateInfo.colors.length < this.colors.length) {
                        Color[] colorArray = stateInfo.colors;
                        stateInfo.colors = new Color[this.colors.length];
                        System.arraycopy(colorArray, 0, stateInfo.colors, 0, colorArray.length);
                    }
                    for (int i2 = this.colors.length - 1; i2 >= 0; --i2) {
                        if (this.colors[i2] == null) continue;
                        stateInfo.colors[i2] = this.colors[i2];
                    }
                }
            }
            return stateInfo;
        }

        public void setComponentState(int n2) {
            this.state = n2;
        }

        public int getComponentState() {
            return this.state;
        }

        private final int getMatchCount(int n2) {
            n2 &= this.state;
            n2 -= (0xAAAAAAAA & n2) >>> 1;
            n2 = (n2 & 0x33333333) + (n2 >>> 2 & 0x33333333);
            n2 = n2 + (n2 >>> 4) & 0xF0F0F0F;
            n2 += n2 >>> 8;
            n2 += n2 >>> 16;
            return n2 & 0xFF;
        }

        public Object clone() {
            return new StateInfo(this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString()).append(',');
            stringBuffer.append("state=").append(Integer.toString(this.state)).append(',');
            stringBuffer.append("font=").append(this.font).append(',');
            if (this.colors != null) {
                stringBuffer.append("colors=").append(Arrays.asList(this.colors)).append(',');
            }
            return stringBuffer.toString();
        }
    }
}

