/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.Arrays;
import sun.misc.HexDumpEncoder;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public class KeyIdentifier {
    private byte[] octetString;

    public KeyIdentifier(byte[] byArray) {
        this.octetString = (byte[])byArray.clone();
    }

    public KeyIdentifier(DerValue derValue) throws IOException {
        this.octetString = derValue.getOctetString();
    }

    public KeyIdentifier(PublicKey publicKey) throws IOException {
        DerValue derValue = new DerValue(publicKey.getEncoded());
        if (derValue.tag != 48) {
            throw new IOException("PublicKey value is not a valid X.509 public key");
        }
        AlgorithmId algorithmId = AlgorithmId.parse(derValue.data.getDerValue());
        byte[] byArray = derValue.data.getUnalignedBitString().toByteArray();
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("SHA1 not supported");
        }
        messageDigest.update(byArray);
        this.octetString = messageDigest.digest();
    }

    public byte[] getIdentifier() {
        return (byte[])this.octetString.clone();
    }

    public String toString() {
        String string = "KeyIdentifier [\n";
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        string = string + hexDumpEncoder.encodeBuffer(this.octetString);
        string = string + "]\n";
        return string;
    }

    void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putOctetString(this.octetString);
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.octetString.length; ++i2) {
            n2 += this.octetString[i2] * i2;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KeyIdentifier)) {
            return false;
        }
        return Arrays.equals(this.octetString, ((KeyIdentifier)object).getIdentifier());
    }
}

