/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import sun.misc.HexDumpEncoder;
import sun.security.util.BitArray;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNameInterface;

public class IPAddressName
implements GeneralNameInterface {
    private byte[] address;
    private boolean isIPv4;
    private String name;
    private static final int MASKSIZE = 16;

    public IPAddressName(DerValue derValue) throws IOException {
        this(derValue.getOctetString());
    }

    public IPAddressName(byte[] byArray) throws IOException {
        if (byArray.length == 4 || byArray.length == 8) {
            this.isIPv4 = true;
        } else if (byArray.length == 16 || byArray.length == 32) {
            this.isIPv4 = false;
        } else {
            throw new IOException("Invalid IPAddressName");
        }
        this.address = byArray;
    }

    public IPAddressName(String string) throws IOException {
        if (string == null || string.length() == 0) {
            throw new IOException("IPAddress cannot be null or empty");
        }
        if (string.charAt(string.length() - 1) == '/') {
            throw new IOException("Invalid IPAddress: " + string);
        }
        if (string.indexOf(58) >= 0) {
            this.parseIPv6(string);
            this.isIPv4 = false;
        } else if (string.indexOf(46) >= 0) {
            this.parseIPv4(string);
            this.isIPv4 = true;
        } else {
            throw new IOException("Invalid IPAddress: " + string);
        }
    }

    private void parseIPv4(String string) throws IOException {
        int n2 = string.indexOf(47);
        if (n2 == -1) {
            this.address = InetAddress.getByName(string).getAddress();
        } else {
            this.address = new byte[8];
            byte[] byArray = InetAddress.getByName(string.substring(n2 + 1)).getAddress();
            byte[] byArray2 = InetAddress.getByName(string.substring(0, n2)).getAddress();
            System.arraycopy(byArray2, 0, this.address, 0, 4);
            System.arraycopy(byArray, 0, this.address, 4, 4);
        }
    }

    private void parseIPv6(String string) throws IOException {
        int n2 = string.indexOf(47);
        if (n2 == -1) {
            this.address = InetAddress.getByName(string).getAddress();
        } else {
            this.address = new byte[32];
            byte[] byArray = InetAddress.getByName(string.substring(0, n2)).getAddress();
            System.arraycopy(byArray, 0, this.address, 0, 16);
            int n3 = Integer.parseInt(string.substring(n2 + 1));
            if (n3 > 128) {
                throw new IOException("IPv6Address prefix is longer than 128");
            }
            BitArray bitArray = new BitArray(128);
            for (int i2 = 0; i2 < n3; ++i2) {
                bitArray.set(i2, true);
            }
            byte[] byArray2 = bitArray.toByteArray();
            for (int i3 = 0; i3 < 16; ++i3) {
                this.address[16 + i3] = byArray2[i3];
            }
        }
    }

    public int getType() {
        return 7;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putOctetString(this.address);
    }

    public String toString() {
        try {
            return "IPAddress: " + this.getName();
        }
        catch (IOException iOException) {
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            return "IPAddress: " + hexDumpEncoder.encodeBuffer(this.address);
        }
    }

    public String getName() throws IOException {
        if (this.name != null) {
            return this.name;
        }
        if (this.isIPv4) {
            byte[] byArray = new byte[4];
            System.arraycopy(this.address, 0, byArray, 0, 4);
            this.name = InetAddress.getByAddress(byArray).getHostAddress();
            if (this.address.length == 8) {
                byte[] byArray2 = new byte[4];
                System.arraycopy(this.address, 4, byArray2, 0, 4);
                this.name = this.name + "/" + InetAddress.getByAddress(byArray2).getHostAddress();
            }
        } else {
            byte[] byArray = new byte[16];
            System.arraycopy(this.address, 0, byArray, 0, 16);
            this.name = InetAddress.getByAddress(byArray).getHostAddress();
            if (this.address.length == 32) {
                int n2;
                byte[] byArray3 = new byte[16];
                for (int i2 = 16; i2 < 32; ++i2) {
                    byArray3[i2 - 16] = this.address[i2];
                }
                BitArray bitArray = new BitArray(128, byArray3);
                for (n2 = 0; n2 < 128 && bitArray.get(n2); ++n2) {
                }
                this.name = this.name + "/" + n2;
                while (n2 < 128) {
                    if (bitArray.get(n2)) {
                        throw new IOException("Invalid IPv6 subdomain - set bit " + n2 + " not contiguous");
                    }
                    ++n2;
                }
            }
        }
        return this.name;
    }

    public byte[] getBytes() {
        return (byte[])this.address.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IPAddressName)) {
            return false;
        }
        byte[] byArray = ((IPAddressName)object).getBytes();
        if (byArray.length != this.address.length) {
            return false;
        }
        if (this.address.length == 8 || this.address.length == 32) {
            int n2;
            int n3 = this.address.length / 2;
            byte[] byArray2 = new byte[n3];
            byte[] byArray3 = new byte[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                byArray2[n2] = (byte)(this.address[n2] & this.address[n2 + n3]);
                byArray3[n2] = (byte)(byArray[n2] & byArray[n2 + n3]);
                if (byArray2[n2] == byArray3[n2]) continue;
                return false;
            }
            for (n2 = n3; n2 < this.address.length; ++n2) {
                if (this.address[n2] == byArray[n2]) continue;
                return false;
            }
            return true;
        }
        return Arrays.equals(byArray, this.address);
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.address.length; ++i2) {
            n2 += this.address[i2] * i2;
        }
        return n2;
    }

    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n2;
        if (generalNameInterface == null) {
            n2 = -1;
        } else if (generalNameInterface.getType() != 7) {
            n2 = -1;
        } else if (((IPAddressName)generalNameInterface).equals(this)) {
            n2 = 0;
        } else {
            byte[] byArray = ((IPAddressName)generalNameInterface).getBytes();
            if (byArray.length == 4 && this.address.length == 4) {
                n2 = 3;
            } else if (byArray.length == 8 && this.address.length == 8 || byArray.length == 32 && this.address.length == 32) {
                boolean bl2 = true;
                boolean bl3 = true;
                boolean bl4 = false;
                boolean bl5 = false;
                int n3 = this.address.length / 2;
                for (int i2 = 0; i2 < n3; ++i2) {
                    if ((byte)(this.address[i2] & this.address[i2 + n3]) != this.address[i2]) {
                        bl4 = true;
                    }
                    if ((byte)(byArray[i2] & byArray[i2 + n3]) != byArray[i2]) {
                        bl5 = true;
                    }
                    if ((byte)(this.address[i2 + n3] & byArray[i2 + n3]) != this.address[i2 + n3] || (byte)(this.address[i2] & this.address[i2 + n3]) != (byte)(byArray[i2] & this.address[i2 + n3])) {
                        bl2 = false;
                    }
                    if ((byte)(byArray[i2 + n3] & this.address[i2 + n3]) == byArray[i2 + n3] && (byte)(byArray[i2] & byArray[i2 + n3]) == (byte)(this.address[i2] & byArray[i2 + n3])) continue;
                    bl3 = false;
                }
                n2 = bl4 || bl5 ? (bl4 && bl5 ? 0 : (bl4 ? 2 : 1)) : (bl2 ? 1 : (bl3 ? 2 : 3));
            } else if (byArray.length == 8 || byArray.length == 32) {
                int n4;
                int n5 = byArray.length / 2;
                for (n4 = 0; n4 < n5 && (this.address[n4] & byArray[n4 + n5]) == byArray[n4]; ++n4) {
                }
                n2 = n4 == n5 ? 2 : 3;
            } else if (this.address.length == 8 || this.address.length == 32) {
                int n6;
                int n7 = this.address.length / 2;
                for (n6 = 0; n6 < n7 && (byArray[n6] & this.address[n6 + n7]) == this.address[n6]; ++n6) {
                }
                n2 = n6 == n7 ? 1 : 3;
            } else {
                n2 = 3;
            }
        }
        return n2;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not defined for IPAddressName");
    }
}

