/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.X509Factory;
import sun.security.util.Cache;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.X509CertImpl;

public class X509CertificatePair {
    private static final byte TAG_FORWARD = 0;
    private static final byte TAG_REVERSE = 1;
    private X509Certificate forward;
    private X509Certificate reverse;
    private byte[] encoded;
    private static final Cache cache = Cache.newSoftMemoryCache(750);

    public X509CertificatePair() {
    }

    public X509CertificatePair(X509Certificate x509Certificate, X509Certificate x509Certificate2) throws CertificateException {
        if (x509Certificate == null && x509Certificate2 == null) {
            throw new CertificateException("at least one of certificate pair must be non-null");
        }
        this.forward = x509Certificate;
        this.reverse = x509Certificate2;
        this.checkPair();
    }

    private X509CertificatePair(byte[] byArray) throws CertificateException {
        try {
            this.parse(new DerValue(byArray));
            this.encoded = byArray;
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.toString());
        }
        this.checkPair();
    }

    public static synchronized void clearCache() {
        cache.clear();
    }

    public static synchronized X509CertificatePair generateCertificatePair(byte[] byArray) throws CertificateException {
        Cache.EqualByteArray equalByteArray = new Cache.EqualByteArray(byArray);
        X509CertificatePair x509CertificatePair = (X509CertificatePair)cache.get(equalByteArray);
        if (x509CertificatePair != null) {
            return x509CertificatePair;
        }
        x509CertificatePair = new X509CertificatePair(byArray);
        equalByteArray = new Cache.EqualByteArray(x509CertificatePair.encoded);
        cache.put(equalByteArray, x509CertificatePair);
        return x509CertificatePair;
    }

    public void setForward(X509Certificate x509Certificate) throws CertificateException {
        this.checkPair();
        this.forward = x509Certificate;
    }

    public void setReverse(X509Certificate x509Certificate) throws CertificateException {
        this.checkPair();
        this.reverse = x509Certificate;
    }

    public X509Certificate getForward() {
        return this.forward;
    }

    public X509Certificate getReverse() {
        return this.reverse;
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            if (this.encoded == null) {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.emit(derOutputStream);
                this.encoded = derOutputStream.toByteArray();
            }
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
        return this.encoded;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X.509 Certificate Pair: [\n");
        if (this.forward != null) {
            stringBuffer.append("  Forward: " + this.forward + "\n");
        }
        if (this.reverse != null) {
            stringBuffer.append("  Reverse: " + this.reverse + "\n");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void parse(DerValue derValue) throws IOException, CertificateException {
        if (derValue.tag != 48) {
            throw new IOException("Sequence tag missing for X509CertificatePair");
        }
        block4: while (derValue.data != null && derValue.data.available() != 0) {
            DerValue derValue2 = derValue.data.getDerValue();
            short s2 = (byte)(derValue2.tag & 0x1F);
            switch (s2) {
                case 0: {
                    if (!derValue2.isContextSpecific() || !derValue2.isConstructed()) continue block4;
                    if (this.forward != null) {
                        throw new IOException("Duplicate forward certificate in X509CertificatePair");
                    }
                    derValue2 = derValue2.data.getDerValue();
                    this.forward = X509Factory.intern(new X509CertImpl(derValue2.toByteArray()));
                    continue block4;
                }
                case 1: {
                    if (!derValue2.isContextSpecific() || !derValue2.isConstructed()) continue block4;
                    if (this.reverse != null) {
                        throw new IOException("Duplicate reverse certificate in X509CertificatePair");
                    }
                    derValue2 = derValue2.data.getDerValue();
                    this.reverse = X509Factory.intern(new X509CertImpl(derValue2.toByteArray()));
                    continue block4;
                }
            }
            throw new IOException("Invalid encoding of X509CertificatePair");
        }
        if (this.forward == null && this.reverse == null) {
            throw new CertificateException("at least one of certificate pair must be non-null");
        }
    }

    private void emit(DerOutputStream derOutputStream) throws IOException, CertificateEncodingException {
        DerOutputStream derOutputStream2;
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.forward != null) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putDerValue(new DerValue(this.forward.getEncoded()));
            derOutputStream3.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        }
        if (this.reverse != null) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putDerValue(new DerValue(this.reverse.getEncoded()));
            derOutputStream3.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream3);
    }

    private void checkPair() throws CertificateException {
        if (this.forward == null || this.reverse == null) {
            return;
        }
        X500Principal x500Principal = this.forward.getSubjectX500Principal();
        X500Principal x500Principal2 = this.forward.getIssuerX500Principal();
        X500Principal x500Principal3 = this.reverse.getSubjectX500Principal();
        X500Principal x500Principal4 = this.reverse.getIssuerX500Principal();
        if (!x500Principal2.equals(x500Principal3) || !x500Principal4.equals(x500Principal)) {
            throw new CertificateException("subject and issuer names in forward and reverse certificates do not match");
        }
        try {
            PublicKey publicKey = this.reverse.getPublicKey();
            if (!(publicKey instanceof DSAPublicKey) || ((DSAPublicKey)publicKey).getParams() != null) {
                this.forward.verify(publicKey);
            }
            if (!((publicKey = this.forward.getPublicKey()) instanceof DSAPublicKey) || ((DSAPublicKey)publicKey).getParams() != null) {
                this.reverse.verify(publicKey);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CertificateException("invalid signature: " + generalSecurityException.getMessage());
        }
    }
}

