/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import sun.security.provider.DigestBase;

abstract class SHA5
extends DigestBase {
    private static final int ITERATION = 80;
    private static final long[] ROUND_CONSTS = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};
    private final long[] W;
    private final long[] state;
    private final byte[] bits;
    private final int[] intBits;
    private final long[] initialHashes;

    SHA5(String string, int n2, long[] lArray) {
        super(string, n2, 128);
        this.initialHashes = lArray;
        this.state = new long[8];
        this.W = new long[80];
        this.bits = new byte[8];
        this.intBits = new int[2];
        this.implReset();
    }

    SHA5(SHA5 sHA5) {
        super(sHA5);
        this.initialHashes = sHA5.initialHashes;
        this.state = (long[])sHA5.state.clone();
        this.W = new long[80];
        this.bits = new byte[8];
        this.intBits = new int[2];
    }

    final void implReset() {
        System.arraycopy(this.initialHashes, 0, this.state, 0, this.state.length);
    }

    final void implDigest(byte[] byArray, int n2) {
        long l2 = this.bytesProcessed << 3;
        int n3 = (int)this.bytesProcessed & 0x7F;
        int n4 = n3 < 112 ? 112 - n3 : 240 - n3;
        this.engineUpdate(padding, 0, n4 + 8);
        this.intBits[1] = (int)l2;
        this.intBits[0] = (int)(l2 >> 32);
        SHA5.i2bBig(this.intBits, 0, this.bits, 0, 8);
        this.engineUpdate(this.bits, 0, 8);
        SHA5.l2bBig(this.state, 0, byArray, n2, this.engineGetDigestLength());
    }

    private static long lf_ch(long l2, long l3, long l4) {
        return l2 & l3 ^ (l2 ^ 0xFFFFFFFFFFFFFFFFL) & l4;
    }

    private static long lf_maj(long l2, long l3, long l4) {
        return l2 & l3 ^ l2 & l4 ^ l3 & l4;
    }

    private static long lf_R(long l2, int n2) {
        return l2 >>> n2;
    }

    private static long lf_S(long l2, int n2) {
        return l2 >>> n2 | l2 << 64 - n2;
    }

    private static long lf_sigma0(long l2) {
        return SHA5.lf_S(l2, 28) ^ SHA5.lf_S(l2, 34) ^ SHA5.lf_S(l2, 39);
    }

    private static long lf_sigma1(long l2) {
        return SHA5.lf_S(l2, 14) ^ SHA5.lf_S(l2, 18) ^ SHA5.lf_S(l2, 41);
    }

    private static long lf_delta0(long l2) {
        return SHA5.lf_S(l2, 1) ^ SHA5.lf_S(l2, 8) ^ SHA5.lf_R(l2, 7);
    }

    private static long lf_delta1(long l2) {
        return SHA5.lf_S(l2, 19) ^ SHA5.lf_S(l2, 61) ^ SHA5.lf_R(l2, 6);
    }

    final void implCompress(byte[] byArray, int n2) {
        SHA5.b2lBig(byArray, n2, this.W, 0, 128);
        for (int i2 = 16; i2 < 80; ++i2) {
            this.W[i2] = SHA5.lf_delta1(this.W[i2 - 2]) + this.W[i2 - 7] + SHA5.lf_delta0(this.W[i2 - 15]) + this.W[i2 - 16];
        }
        long l2 = this.state[0];
        long l3 = this.state[1];
        long l4 = this.state[2];
        long l5 = this.state[3];
        long l6 = this.state[4];
        long l7 = this.state[5];
        long l8 = this.state[6];
        long l9 = this.state[7];
        for (int i3 = 0; i3 < 80; ++i3) {
            long l10 = l9 + SHA5.lf_sigma1(l6) + SHA5.lf_ch(l6, l7, l8) + ROUND_CONSTS[i3] + this.W[i3];
            long l11 = SHA5.lf_sigma0(l2) + SHA5.lf_maj(l2, l3, l4);
            l9 = l8;
            l8 = l7;
            l7 = l6;
            l6 = l5 + l10;
            l5 = l4;
            l4 = l3;
            l3 = l2;
            l2 = l10 + l11;
        }
        this.state[0] = this.state[0] + l2;
        this.state[1] = this.state[1] + l3;
        this.state[2] = this.state[2] + l4;
        this.state[3] = this.state[3] + l5;
        this.state[4] = this.state[4] + l6;
        this.state[5] = this.state[5] + l7;
        this.state[6] = this.state[6] + l8;
        this.state[7] = this.state[7] + l9;
    }

    public static final class SHA384
    extends SHA5 {
        private static final long[] INITIAL_HASHES = new long[]{-3766243637369397544L, 7105036623409894663L, -7973340178411365097L, 1526699215303891257L, 7436329637833083697L, -8163818279084223215L, -2662702644619276377L, 5167115440072839076L};

        public SHA384() {
            super("SHA-384", 48, INITIAL_HASHES);
        }

        private SHA384(SHA384 sHA384) {
            super(sHA384);
        }

        public Object clone() {
            return new SHA384(this);
        }
    }

    public static final class SHA512
    extends SHA5 {
        private static final long[] INITIAL_HASHES = new long[]{7640891576956012808L, -4942790177534073029L, 4354685564936845355L, -6534734903238641935L, 5840696475078001361L, -7276294671716946913L, 2270897969802886507L, 6620516959819538809L};

        public SHA512() {
            super("SHA-512", 64, INITIAL_HASHES);
        }

        private SHA512(SHA512 sHA512) {
            super(sHA512);
        }

        public Object clone() {
            return new SHA512(this);
        }
    }
}

