/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.ietf.jgss.GSSException;
import sun.security.jgss.krb5.Krb5Token;
import sun.security.jgss.krb5.WrapToken;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.internal.crypto.Des3;

class CipherHelper {
    private static final int KG_USAGE_SEAL = 22;
    private static final int KG_USAGE_SIGN = 23;
    private static final int KG_USAGE_SEQ = 24;
    private static final int DES_CHECKSUM_SIZE = 8;
    private static final int IV_SIZE = 8;
    private static final byte[] ZERO_IV = new byte[8];
    private Cipher desCipher = null;
    private int etype;
    private int sgnAlg;
    private int sealAlg;
    private byte[] keybytes;

    CipherHelper(EncryptionKey encryptionKey) throws GSSException {
        this.etype = encryptionKey.getEType();
        this.keybytes = encryptionKey.getBytes();
        switch (this.etype) {
            case 1: {
                this.sgnAlg = 512;
                this.sealAlg = 0;
                this.getDesCipher();
                break;
            }
            case 3: {
                this.sgnAlg = 0;
                this.sealAlg = 0;
                this.getDesCipher();
                break;
            }
            case 16: {
                this.sgnAlg = 1024;
                this.sealAlg = 512;
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported encryption type: " + this.etype);
            }
        }
    }

    int getSgnAlg() {
        return this.sgnAlg;
    }

    int getSealAlg() {
        return this.sealAlg;
    }

    int getEType() {
        return this.etype;
    }

    byte[] calculateChecksum(int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, int n3, int n4) throws GSSException {
        switch (n2) {
            case 0: {
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                    messageDigest.update(byArray);
                    messageDigest.update(byArray3, n3, n4);
                    if (byArray2 != null) {
                        messageDigest.update(byArray2);
                    }
                    byArray3 = messageDigest.digest();
                    n3 = 0;
                    n4 = byArray3.length;
                    byArray = null;
                    byArray2 = null;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    GSSException gSSException = new GSSException(11, -1, "Could not get MD5 Message Digest - " + noSuchAlgorithmException.getMessage());
                    gSSException.initCause(noSuchAlgorithmException);
                    throw gSSException;
                }
            }
            case 512: {
                return this.getDesCbcChecksum(this.keybytes, byArray, byArray3, n3, n4);
            }
            case 1024: {
                int n5;
                int n6;
                byte[] byArray4;
                if (byArray == null && byArray2 == null) {
                    byArray4 = byArray3;
                    n6 = n4;
                    n5 = n3;
                } else {
                    n6 = (byArray != null ? byArray.length : 0) + n4 + (byArray2 != null ? byArray2.length : 0);
                    byArray4 = new byte[n6];
                    int n7 = 0;
                    if (byArray != null) {
                        System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
                        n7 = byArray.length;
                    }
                    System.arraycopy(byArray3, 0, byArray4, n7, n4);
                    n7 += n4;
                    if (byArray2 != null) {
                        System.arraycopy(byArray2, 0, byArray4, n7, byArray2.length);
                    }
                    n5 = 0;
                }
                try {
                    byte[] byArray5 = Des3.calculateChecksum(this.keybytes, 23, byArray4, n5, n6);
                    return byArray5;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    GSSException gSSException = new GSSException(11, -1, "Could not use HMAC-SHA1-DES3-KD signing algorithm - " + generalSecurityException.getMessage());
                    gSSException.initCause(generalSecurityException);
                    throw gSSException;
                }
            }
        }
        throw new GSSException(11, -1, "Unsupported signing algorithm: " + this.sgnAlg);
    }

    byte[] encryptSeq(byte[] byArray, byte[] byArray2, int n2, int n3) throws GSSException {
        switch (this.sgnAlg) {
            case 0: 
            case 512: {
                try {
                    Cipher cipher = this.getInitializedDes(true, this.keybytes, byArray);
                    return cipher.doFinal(byArray2, n2, n3);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    GSSException gSSException = new GSSException(11, -1, "Could not encrypt sequence number using DES - " + generalSecurityException.getMessage());
                    gSSException.initCause(generalSecurityException);
                    throw gSSException;
                }
            }
            case 1024: {
                byte[] byArray3;
                if (byArray.length == 8) {
                    byArray3 = byArray;
                } else {
                    byArray3 = new byte[8];
                    System.arraycopy(byArray, 0, byArray3, 0, 8);
                }
                try {
                    return Des3.encryptRaw(this.keybytes, 24, byArray3, byArray2, n2, n3);
                }
                catch (Exception exception) {
                    GSSException gSSException = new GSSException(11, -1, "Could not encrypt sequence number using DES3-KD - " + exception.getMessage());
                    gSSException.initCause(exception);
                    throw gSSException;
                }
            }
        }
        throw new GSSException(11, -1, "Unsupported signing algorithm: " + this.sgnAlg);
    }

    byte[] decryptSeq(byte[] byArray, byte[] byArray2, int n2, int n3) throws GSSException {
        switch (this.sgnAlg) {
            case 0: 
            case 512: {
                try {
                    Cipher cipher = this.getInitializedDes(false, this.keybytes, byArray);
                    return cipher.doFinal(byArray2, n2, n3);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    GSSException gSSException = new GSSException(11, -1, "Could not decrypt sequence number using DES - " + generalSecurityException.getMessage());
                    gSSException.initCause(generalSecurityException);
                    throw gSSException;
                }
            }
            case 1024: {
                byte[] byArray3;
                if (byArray.length == 8) {
                    byArray3 = byArray;
                } else {
                    byArray3 = new byte[8];
                    System.arraycopy(byArray, 0, byArray3, 0, 8);
                }
                try {
                    return Des3.decryptRaw(this.keybytes, 24, byArray3, byArray2, n2, n3);
                }
                catch (Exception exception) {
                    GSSException gSSException = new GSSException(11, -1, "Could not decrypt sequence number using DES3-KD - " + exception.getMessage());
                    gSSException.initCause(exception);
                    throw gSSException;
                }
            }
        }
        throw new GSSException(11, -1, "Unsupported signing algorithm: " + this.sgnAlg);
    }

    int getChecksumLength() throws GSSException {
        switch (this.etype) {
            case 1: 
            case 3: {
                return 8;
            }
            case 16: {
                return Des3.getChecksumLength();
            }
        }
        throw new GSSException(11, -1, "Unsupported encryption type: " + this.etype);
    }

    void decryptData(WrapToken wrapToken, byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws GSSException {
        switch (this.sealAlg) {
            case 0: {
                this.desCbcDecrypt(wrapToken, CipherHelper.getDesEncryptionKey(this.keybytes), byArray, n2, n3, byArray2, n4);
                break;
            }
            case 512: {
                this.des3KdDecrypt(wrapToken, byArray, n2, n3, byArray2, n4);
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported seal algorithm: " + this.sealAlg);
            }
        }
    }

    void decryptData(WrapToken wrapToken, InputStream inputStream, int n2, byte[] byArray, int n3) throws GSSException, IOException {
        switch (this.sealAlg) {
            case 0: {
                this.desCbcDecrypt(wrapToken, CipherHelper.getDesEncryptionKey(this.keybytes), inputStream, n2, byArray, n3);
                break;
            }
            case 512: {
                byte[] byArray2 = new byte[n2];
                try {
                    Krb5Token.readFully(inputStream, byArray2, 0, n2);
                }
                catch (IOException iOException) {
                    GSSException gSSException = new GSSException(10, -1, "Cannot read complete token");
                    gSSException.initCause(iOException);
                    throw gSSException;
                }
                this.des3KdDecrypt(wrapToken, byArray2, 0, n2, byArray, n3);
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported seal algorithm: " + this.sealAlg);
            }
        }
    }

    void encryptData(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, OutputStream outputStream) throws GSSException, IOException {
        switch (this.sealAlg) {
            case 0: {
                Cipher cipher = this.getInitializedDes(true, CipherHelper.getDesEncryptionKey(this.keybytes), ZERO_IV);
                CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, cipher);
                cipherOutputStream.write(byArray);
                cipherOutputStream.write(byArray2, n2, n3);
                cipherOutputStream.write(byArray3);
                break;
            }
            case 512: {
                byte[] byArray4 = this.des3KdEncrypt(byArray, byArray2, n2, n3, byArray3);
                outputStream.write(byArray4);
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported seal algorithm: " + this.sealAlg);
            }
        }
    }

    void encryptData(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, byte[] byArray4, int n4) throws GSSException {
        switch (this.sealAlg) {
            case 0: {
                int n5 = n4;
                Cipher cipher = this.getInitializedDes(true, CipherHelper.getDesEncryptionKey(this.keybytes), ZERO_IV);
                try {
                    n5 += cipher.update(byArray, 0, byArray.length, byArray4, n5);
                    n5 += cipher.update(byArray2, n2, n3, byArray4, n5);
                    cipher.update(byArray3, 0, byArray3.length, byArray4, n5);
                    cipher.doFinal();
                    break;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    GSSException gSSException = new GSSException(11, -1, "Could not use DES Cipher - " + generalSecurityException.getMessage());
                    gSSException.initCause(generalSecurityException);
                    throw gSSException;
                }
            }
            case 512: {
                byte[] byArray5 = this.des3KdEncrypt(byArray, byArray2, n2, n3, byArray3);
                System.arraycopy(byArray5, 0, byArray4, n4, byArray5.length);
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported seal algorithm: " + this.sealAlg);
            }
        }
    }

    private final Cipher getDesCipher() throws GSSException {
        if (this.desCipher == null) {
            try {
                this.desCipher = Cipher.getInstance("DES/CBC/NoPadding");
            }
            catch (GeneralSecurityException generalSecurityException) {
                GSSException gSSException = new GSSException(11, -1, "Cannot get DES cipher - " + generalSecurityException.getMessage());
                gSSException.initCause(generalSecurityException);
                throw gSSException;
            }
        }
        return this.desCipher;
    }

    private byte[] getDesCbcChecksum(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) throws GSSException {
        Cipher cipher = this.getInitializedDes(true, byArray, ZERO_IV);
        int n4 = cipher.getBlockSize();
        byte[] byArray4 = new byte[n4];
        int n5 = n3 / n4;
        int n6 = n3 % n4;
        if (n6 == 0) {
            System.arraycopy(byArray3, n2 + --n5 * n4, byArray4, 0, n4);
        } else {
            System.arraycopy(byArray3, n2 + n5 * n4, byArray4, 0, n6);
        }
        try {
            byte[] byArray5 = new byte[Math.max(n4, byArray2 == null ? n4 : byArray2.length)];
            if (byArray2 != null) {
                cipher.update(byArray2, 0, byArray2.length, byArray5, 0);
            }
            for (int i2 = 0; i2 < n5; ++i2) {
                cipher.update(byArray3, n2, n4, byArray5, 0);
                n2 += n4;
            }
            byte[] byArray6 = new byte[n4];
            cipher.update(byArray4, 0, n4, byArray6, 0);
            cipher.doFinal();
            return byArray6;
        }
        catch (GeneralSecurityException generalSecurityException) {
            GSSException gSSException = new GSSException(11, -1, "Could not use DES Cipher - " + generalSecurityException.getMessage());
            gSSException.initCause(generalSecurityException);
            throw gSSException;
        }
    }

    private final Cipher getInitializedDes(boolean bl2, byte[] byArray, byte[] byArray2) throws GSSException {
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "DES");
            if (this.desCipher == null) {
                throw new GSSException(11, -1, "Internal Error:Uninitialized desCipher");
            }
            this.desCipher.init(bl2 ? 1 : 2, (Key)secretKeySpec, ivParameterSpec);
            return this.desCipher;
        }
        catch (GeneralSecurityException generalSecurityException) {
            GSSException gSSException = new GSSException(11, -1, generalSecurityException.getMessage());
            gSSException.initCause(generalSecurityException);
            throw gSSException;
        }
    }

    private void desCbcDecrypt(WrapToken wrapToken, byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, int n4) throws GSSException {
        try {
            int n5 = 0;
            Cipher cipher = this.getInitializedDes(false, byArray, ZERO_IV);
            n5 = cipher.update(byArray2, n2, 8, wrapToken.confounder);
            n2 += 8;
            int n6 = cipher.getBlockSize();
            int n7 = (n3 -= 8) / n6 - 1;
            for (int i2 = 0; i2 < n7; ++i2) {
                n5 = cipher.update(byArray2, n2, n6, byArray3, n4);
                n2 += n6;
                n4 += n6;
            }
            byte[] byArray4 = new byte[n6];
            cipher.update(byArray2, n2, n6, byArray4);
            cipher.doFinal();
            byte by = byArray4[n6 - 1];
            if (by < 1 || by > 8) {
                throw new GSSException(10, -1, "Invalid padding on Wrap Token");
            }
            wrapToken.padding = WrapToken.pads[by];
            System.arraycopy(byArray4, 0, byArray3, n4, n6 -= by);
        }
        catch (GeneralSecurityException generalSecurityException) {
            GSSException gSSException = new GSSException(11, -1, "Could not use DES cipher - " + generalSecurityException.getMessage());
            gSSException.initCause(generalSecurityException);
            throw gSSException;
        }
    }

    private void desCbcDecrypt(WrapToken wrapToken, byte[] byArray, InputStream inputStream, int n2, byte[] byArray2, int n3) throws GSSException, IOException {
        int n4 = 0;
        Cipher cipher = this.getInitializedDes(false, byArray, ZERO_IV);
        WrapTokenInputStream wrapTokenInputStream = new WrapTokenInputStream(inputStream, n2);
        CipherInputStream cipherInputStream = new CipherInputStream(wrapTokenInputStream, cipher);
        n4 = cipherInputStream.read(wrapToken.confounder);
        int n5 = cipher.getBlockSize();
        int n6 = (n2 -= n4) / n5 - 1;
        for (int i2 = 0; i2 < n6; ++i2) {
            n4 = cipherInputStream.read(byArray2, n3, n5);
            n3 += n5;
        }
        byte[] byArray3 = new byte[n5];
        n4 = cipherInputStream.read(byArray3);
        try {
            cipher.doFinal();
        }
        catch (GeneralSecurityException generalSecurityException) {
            GSSException gSSException = new GSSException(11, -1, "Could not use DES cipher - " + generalSecurityException.getMessage());
            gSSException.initCause(generalSecurityException);
            throw gSSException;
        }
        byte by = byArray3[n5 - 1];
        if (by < 1 || by > 8) {
            throw new GSSException(10, -1, "Invalid padding on Wrap Token");
        }
        wrapToken.padding = WrapToken.pads[by];
        System.arraycopy(byArray3, 0, byArray2, n3, n5 -= by);
    }

    private static byte[] getDesEncryptionKey(byte[] byArray) throws GSSException {
        if (byArray.length > 8) {
            throw new GSSException(11, -100, "Invalid DES Key!");
        }
        byte[] byArray2 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray2[i2] = (byte)(byArray[i2] ^ 0xF0);
        }
        return byArray2;
    }

    private void des3KdDecrypt(WrapToken wrapToken, byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws GSSException {
        byte[] byArray3;
        try {
            byArray3 = Des3.decryptRaw(this.keybytes, 22, ZERO_IV, byArray, n2, n3);
        }
        catch (GeneralSecurityException generalSecurityException) {
            GSSException gSSException = new GSSException(11, -1, "Could not use DES3-KD Cipher - " + generalSecurityException.getMessage());
            gSSException.initCause(generalSecurityException);
            throw gSSException;
        }
        byte by = byArray3[byArray3.length - 1];
        if (by < 1 || by > 8) {
            throw new GSSException(10, -1, "Invalid padding on Wrap Token");
        }
        wrapToken.padding = WrapToken.pads[by];
        int n5 = byArray3.length - 8 - by;
        System.arraycopy(byArray3, 8, byArray2, n4, n5);
        System.arraycopy(byArray3, 0, wrapToken.confounder, 0, 8);
    }

    private byte[] des3KdEncrypt(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3) throws GSSException {
        byte[] byArray4 = new byte[byArray.length + n3 + byArray3.length];
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
        System.arraycopy(byArray2, n2, byArray4, byArray.length, n3);
        System.arraycopy(byArray3, 0, byArray4, byArray.length + n3, byArray3.length);
        try {
            byte[] byArray5 = Des3.encryptRaw(this.keybytes, 22, ZERO_IV, byArray4, 0, byArray4.length);
            return byArray5;
        }
        catch (Exception exception) {
            GSSException gSSException = new GSSException(11, -1, "Could not use DES3-KD Cipher - " + exception.getMessage());
            gSSException.initCause(exception);
            throw gSSException;
        }
    }

    class WrapTokenInputStream
    extends InputStream {
        private InputStream is;
        private int length;
        private int remaining;
        private int temp;

        public WrapTokenInputStream(InputStream inputStream, int n2) {
            this.is = inputStream;
            this.length = n2;
            this.remaining = n2;
        }

        public final int read() throws IOException {
            if (this.remaining == 0) {
                return -1;
            }
            this.temp = this.is.read();
            if (this.temp != -1) {
                this.remaining -= this.temp;
            }
            return this.temp;
        }

        public final int read(byte[] byArray) throws IOException {
            if (this.remaining == 0) {
                return -1;
            }
            this.temp = Math.min(this.remaining, byArray.length);
            this.temp = this.is.read(byArray, 0, this.temp);
            if (this.temp != -1) {
                this.remaining -= this.temp;
            }
            return this.temp;
        }

        public final int read(byte[] byArray, int n2, int n3) throws IOException {
            if (this.remaining == 0) {
                return -1;
            }
            this.temp = Math.min(this.remaining, n3);
            this.temp = this.is.read(byArray, n2, this.temp);
            if (this.temp != -1) {
                this.remaining -= this.temp;
            }
            return this.temp;
        }

        public final long skip(long l2) throws IOException {
            if (this.remaining == 0) {
                return 0L;
            }
            this.temp = (int)Math.min((long)this.remaining, l2);
            this.temp = (int)this.is.skip(this.temp);
            this.remaining -= this.temp;
            return this.temp;
        }

        public final int available() throws IOException {
            return Math.min(this.remaining, this.is.available());
        }

        public final void close() throws IOException {
            this.remaining = 0;
        }
    }
}

