/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.ColorSupported;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.Finishings;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.NumberUp;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PDLOverrideSupported;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PagesPerMinute;
import javax.print.attribute.standard.PagesPerMinuteColor;
import javax.print.attribute.standard.PrinterInfo;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterLocation;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.print.attribute.standard.PrinterMessageFromOperator;
import javax.print.attribute.standard.PrinterMoreInfo;
import javax.print.attribute.standard.PrinterMoreInfoManufacturer;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterState;
import javax.print.attribute.standard.PrinterStateReasons;
import javax.print.attribute.standard.PrinterURI;
import javax.print.attribute.standard.QueuedJobCount;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.print.event.PrintServiceAttributeListener;
import sun.print.AttributeClass;
import sun.print.CUPSPrinter;
import sun.print.CustomMediaSizeName;
import sun.print.CustomMediaTray;
import sun.print.PSPrinterJob;
import sun.print.ServiceNotifier;
import sun.print.SunPrinterJobService;
import sun.print.UnixPrintJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPPPrintService
implements PrintService,
SunPrinterJobService {
    public static boolean debugPrint = false;
    private static String debugPrefix = "IPPPrintService>> ";
    private String printer;
    private URI myURI;
    private URL myURL;
    private transient ServiceNotifier notifier = null;
    private static int MAXCOPIES = 1000;
    private static int ATTRIBUTESTR_MAX = 80;
    private CUPSPrinter cps;
    private HttpURLConnection urlConnection = null;
    private DocFlavor[] supportedDocFlavors;
    private Class[] supportedCats;
    private MediaTray[] mediaTrays;
    private MediaSizeName[] mediaSizeNames;
    private CustomMediaSizeName[] customMediaSizeNames;
    private int defaultMediaIndex;
    private boolean isCupsPrinter;
    private boolean init;
    private HashMap getAttMap;
    private boolean pngImagesAdded = false;
    private boolean gifImagesAdded = false;
    private boolean jpgImagesAdded = false;
    private static final byte STATUSCODE_SUCCESS = 0;
    private static final byte GRPTAG_OP_ATTRIBUTES = 1;
    private static final byte GRPTAG_JOB_ATTRIBUTES = 2;
    private static final byte GRPTAG_PRINTER_ATTRIBUTES = 4;
    private static final byte GRPTAG_END_ATTRIBUTES = 3;
    public static final String OP_GET_ATTRIBUTES = "000B";
    public static final String OP_CUPS_GET_DEFAULT = "4001";
    public static final String OP_CUPS_GET_PRINTERS = "4002";
    private static Object[] printReqAttribDefault = new Object[]{Chromaticity.COLOR, new Copies(1), Fidelity.FIDELITY_FALSE, Finishings.NONE, new JobName("", Locale.getDefault()), JobSheets.NONE, MediaSizeName.NA_LETTER, new NumberUp(1), OrientationRequested.PORTRAIT, new PageRanges(1), new RequestingUserName("", Locale.getDefault()), Sides.ONE_SIDED};
    private static Object[][] serviceAttributes = new Object[][]{{ColorSupported.class, "color-supported"}, {PagesPerMinute.class, "pages-per-minute"}, {PagesPerMinuteColor.class, "pages-per-minute-color"}, {PDLOverrideSupported.class, "pdl-override-supported"}, {PrinterInfo.class, "printer-info"}, {PrinterIsAcceptingJobs.class, "printer-is-accepting-jobs"}, {PrinterLocation.class, "printer-location"}, {PrinterMakeAndModel.class, "printer-make-and-model"}, {PrinterMessageFromOperator.class, "printer-message-from-operator"}, {PrinterMoreInfo.class, "printer-more-info"}, {PrinterMoreInfoManufacturer.class, "printer-more-info-manufacturer"}, {PrinterName.class, "printer-name"}, {PrinterState.class, "printer-state"}, {PrinterStateReasons.class, "printer-state-reasons"}, {PrinterURI.class, "printer-uri"}, {QueuedJobCount.class, "queued-job-count"}};
    private static DocFlavor[] appPDF = new DocFlavor[]{DocFlavor.BYTE_ARRAY.PDF, DocFlavor.INPUT_STREAM.PDF, DocFlavor.URL.PDF};
    private static DocFlavor[] appPostScript = new DocFlavor[]{DocFlavor.BYTE_ARRAY.POSTSCRIPT, DocFlavor.INPUT_STREAM.POSTSCRIPT, DocFlavor.URL.POSTSCRIPT};
    private static DocFlavor[] appOctetStream = new DocFlavor[]{DocFlavor.BYTE_ARRAY.AUTOSENSE, DocFlavor.INPUT_STREAM.AUTOSENSE, DocFlavor.URL.AUTOSENSE};
    private static DocFlavor[] textPlain = new DocFlavor[]{DocFlavor.BYTE_ARRAY.TEXT_PLAIN_HOST, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_8, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_16, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_16BE, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_16LE, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_US_ASCII, DocFlavor.INPUT_STREAM.TEXT_PLAIN_HOST, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_8, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_16, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_16BE, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_16LE, DocFlavor.INPUT_STREAM.TEXT_PLAIN_US_ASCII, DocFlavor.URL.TEXT_PLAIN_HOST, DocFlavor.URL.TEXT_PLAIN_UTF_8, DocFlavor.URL.TEXT_PLAIN_UTF_16, DocFlavor.URL.TEXT_PLAIN_UTF_16BE, DocFlavor.URL.TEXT_PLAIN_UTF_16LE, DocFlavor.URL.TEXT_PLAIN_US_ASCII, DocFlavor.CHAR_ARRAY.TEXT_PLAIN, DocFlavor.STRING.TEXT_PLAIN, DocFlavor.READER.TEXT_PLAIN};
    private static DocFlavor[] imageJPG = new DocFlavor[]{DocFlavor.BYTE_ARRAY.JPEG, DocFlavor.INPUT_STREAM.JPEG, DocFlavor.URL.JPEG};
    private static DocFlavor[] imageGIF = new DocFlavor[]{DocFlavor.BYTE_ARRAY.GIF, DocFlavor.INPUT_STREAM.GIF, DocFlavor.URL.GIF};
    private static DocFlavor[] imagePNG = new DocFlavor[]{DocFlavor.BYTE_ARRAY.PNG, DocFlavor.INPUT_STREAM.PNG, DocFlavor.URL.PNG};
    private static DocFlavor[] textHtml = new DocFlavor[]{DocFlavor.BYTE_ARRAY.TEXT_HTML_HOST, DocFlavor.BYTE_ARRAY.TEXT_HTML_HOST, DocFlavor.BYTE_ARRAY.TEXT_HTML_UTF_8, DocFlavor.BYTE_ARRAY.TEXT_HTML_UTF_16, DocFlavor.BYTE_ARRAY.TEXT_HTML_UTF_16BE, DocFlavor.BYTE_ARRAY.TEXT_HTML_UTF_16LE, DocFlavor.BYTE_ARRAY.TEXT_HTML_US_ASCII, DocFlavor.INPUT_STREAM.TEXT_HTML_HOST, DocFlavor.INPUT_STREAM.TEXT_HTML_UTF_8, DocFlavor.INPUT_STREAM.TEXT_HTML_UTF_16, DocFlavor.INPUT_STREAM.TEXT_HTML_UTF_16BE, DocFlavor.INPUT_STREAM.TEXT_HTML_UTF_16LE, DocFlavor.INPUT_STREAM.TEXT_HTML_US_ASCII, DocFlavor.URL.TEXT_HTML_HOST, DocFlavor.URL.TEXT_HTML_UTF_8, DocFlavor.URL.TEXT_HTML_UTF_16, DocFlavor.URL.TEXT_HTML_UTF_16BE, DocFlavor.URL.TEXT_HTML_UTF_16LE, DocFlavor.URL.TEXT_HTML_US_ASCII};
    private static DocFlavor[] appPCL = new DocFlavor[]{DocFlavor.BYTE_ARRAY.PCL, DocFlavor.INPUT_STREAM.PCL, DocFlavor.URL.PCL};
    private static Object[] allDocFlavors = new Object[]{appPDF, appPostScript, appOctetStream, textPlain, imageJPG, imageGIF, imagePNG, textHtml, appPCL};

    protected static void debug_println(String string) {
        if (debugPrint) {
            System.out.println(string);
        }
    }

    IPPPrintService(String string, URL uRL) {
        if (string == null || uRL == null) {
            throw new IllegalArgumentException("null uri or printer name");
        }
        this.printer = string;
        this.supportedDocFlavors = null;
        this.supportedCats = null;
        this.mediaSizeNames = null;
        this.customMediaSizeNames = null;
        this.mediaTrays = null;
        this.myURL = uRL;
        this.cps = null;
        this.isCupsPrinter = false;
        this.init = false;
        this.defaultMediaIndex = -1;
        String string2 = this.myURL.getHost();
        if (string2 != null && string2.equals(CUPSPrinter.getServer())) {
            this.isCupsPrinter = true;
            try {
                this.myURI = new URI("ipp://" + string2 + "/printers/" + this.printer);
                IPPPrintService.debug_println(debugPrefix + "IPPPrintService myURI : " + this.myURI);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("invalid url");
            }
        }
    }

    private void initAttributes() {
        if (!this.init) {
            this.init = true;
            this.customMediaSizeNames = new CustomMediaSizeName[0];
            this.urlConnection = IPPPrintService.getIPPConnection(this.myURL);
            if (this.urlConnection == null) {
                this.mediaSizeNames = new MediaSizeName[0];
                this.mediaTrays = new MediaTray[0];
                IPPPrintService.debug_println("NULL urlConnection ");
                return;
            }
            this.opGetAttributes();
            if (this.isCupsPrinter) {
                try {
                    this.cps = new CUPSPrinter(this.printer);
                    this.mediaSizeNames = this.cps.getMediaSizeNames();
                    this.mediaTrays = this.cps.getMediaTrays();
                    this.customMediaSizeNames = this.cps.getCustomMediaSizeNames();
                    this.urlConnection.disconnect();
                    return;
                }
                catch (Exception exception) {
                    IPPPrintService.debug_println(debugPrefix + " error creating CUPSPrinter");
                }
            }
            Media[] mediaArray = this.getSupportedMedia();
            ArrayList<Media> arrayList = new ArrayList<Media>();
            ArrayList<Media> arrayList2 = new ArrayList<Media>();
            for (int i2 = 0; i2 < mediaArray.length; ++i2) {
                if (mediaArray[i2] instanceof MediaSizeName) {
                    arrayList.add(mediaArray[i2]);
                    continue;
                }
                if (!(mediaArray[i2] instanceof MediaTray)) continue;
                arrayList2.add(mediaArray[i2]);
            }
            if (arrayList != null) {
                this.mediaSizeNames = new MediaSizeName[arrayList.size()];
                this.mediaSizeNames = arrayList.toArray(this.mediaSizeNames);
            }
            if (arrayList2 != null) {
                this.mediaTrays = new MediaTray[arrayList2.size()];
                this.mediaTrays = arrayList2.toArray(this.mediaTrays);
            }
            this.urlConnection.disconnect();
        }
    }

    @Override
    public DocPrintJob createPrintJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new UnixPrintJob(this);
    }

    @Override
    public Object getSupportedAttributeValues(Class<? extends Attribute> clazz, DocFlavor docFlavor, AttributeSet attributeSet) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " does not implement Attribute");
        }
        if (docFlavor != null) {
            if (!this.isDocFlavorSupported(docFlavor)) {
                throw new IllegalArgumentException(docFlavor + " is an unsupported flavor");
            }
            if (this.isAutoSense(docFlavor)) {
                return null;
            }
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return null;
        }
        if (!this.isDestinationSupported(docFlavor, attributeSet)) {
            return null;
        }
        this.initAttributes();
        if (clazz == Copies.class || clazz == CopiesSupported.class) {
            AttributeClass attributeClass;
            CopiesSupported copiesSupported = new CopiesSupported(1, MAXCOPIES);
            AttributeClass attributeClass2 = attributeClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get(copiesSupported.getName()) : null;
            if (attributeClass != null) {
                int[] nArray = attributeClass.getIntRangeValue();
                copiesSupported = new CopiesSupported(nArray[0], nArray[1]);
            }
            return copiesSupported;
        }
        if (clazz == Chromaticity.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.URL.PNG)) {
                Chromaticity[] chromaticityArray = new Chromaticity[]{Chromaticity.COLOR};
                return chromaticityArray;
            }
            return null;
        }
        if (clazz == Destination.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                try {
                    return new Destination(new File("out.ps").toURI());
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            return null;
        }
        if (clazz == Fidelity.class) {
            Fidelity[] fidelityArray = new Fidelity[]{Fidelity.FIDELITY_FALSE, Fidelity.FIDELITY_TRUE};
            return fidelityArray;
        }
        if (clazz == Finishings.class) {
            int[] nArray;
            AttributeClass attributeClass;
            AttributeClass attributeClass3 = attributeClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get("finishings-supported") : null;
            if (attributeClass != null && (nArray = attributeClass.getArrayOfIntValues()) != null && nArray.length > 0) {
                Finishings[] finishingsArray = new Finishings[nArray.length];
                block9: for (int i2 = 0; i2 < nArray.length; ++i2) {
                    finishingsArray[i2] = Finishings.NONE;
                    Finishings[] finishingsArray2 = (Finishings[])new ExtFinishing(100).getAll();
                    for (int i3 = 0; i3 < finishingsArray2.length; ++i3) {
                        if (nArray[i2] != finishingsArray2[i3].getValue()) continue;
                        finishingsArray[i2] = finishingsArray2[i3];
                        continue block9;
                    }
                }
                return finishingsArray;
            }
        } else {
            if (clazz == JobName.class) {
                return new JobName("Java Printing", null);
            }
            if (clazz == JobSheets.class) {
                JobSheets[] jobSheetsArray = new JobSheets[]{JobSheets.NONE, JobSheets.STANDARD};
                return jobSheetsArray;
            }
            if (clazz == Media.class) {
                int n2;
                Media[] mediaArray = new Media[this.mediaSizeNames.length + this.mediaTrays.length];
                for (n2 = 0; n2 < this.mediaSizeNames.length; ++n2) {
                    mediaArray[n2] = this.mediaSizeNames[n2];
                }
                for (n2 = 0; n2 < this.mediaTrays.length; ++n2) {
                    mediaArray[n2 + this.mediaSizeNames.length] = this.mediaTrays[n2];
                }
                return mediaArray;
            }
            if (clazz == MediaPrintableArea.class) {
                MediaPrintableArea[] mediaPrintableAreaArray;
                MediaPrintableArea[] mediaPrintableAreaArray2 = null;
                if (this.cps != null) {
                    mediaPrintableAreaArray2 = this.cps.getMediaPrintableArea();
                }
                if (mediaPrintableAreaArray2 == null) {
                    return null;
                }
                if (attributeSet == null || attributeSet.size() == 0) {
                    return mediaPrintableAreaArray2;
                }
                int n3 = -1;
                Media media = (Media)attributeSet.get(Media.class);
                if (media != null && media instanceof MediaSizeName) {
                    mediaPrintableAreaArray = (MediaPrintableArea[])media;
                    for (int i4 = 0; i4 < this.mediaSizeNames.length; ++i4) {
                        if (!mediaPrintableAreaArray.equals(this.mediaSizeNames[i4])) continue;
                        n3 = i4;
                    }
                }
                if (n3 == -1) {
                    return null;
                }
                mediaPrintableAreaArray = new MediaPrintableArea[]{mediaPrintableAreaArray2[n3]};
                return mediaPrintableAreaArray;
            }
            if (clazz == NumberUp.class) {
                AttributeClass attributeClass;
                AttributeClass attributeClass4 = attributeClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get("number-up-supported") : null;
                if (attributeClass != null) {
                    int[] nArray = attributeClass.getArrayOfIntValues();
                    if (nArray != null) {
                        NumberUp[] numberUpArray = new NumberUp[nArray.length];
                        for (int i5 = 0; i5 < nArray.length; ++i5) {
                            numberUpArray[i5] = new NumberUp(nArray[i5]);
                        }
                        return numberUpArray;
                    }
                    return null;
                }
            } else if (clazz == OrientationRequested.class) {
                int[] nArray;
                AttributeClass attributeClass;
                if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                    OrientationRequested[] orientationRequestedArray = new OrientationRequested[]{OrientationRequested.PORTRAIT, OrientationRequested.LANDSCAPE, OrientationRequested.REVERSE_LANDSCAPE};
                    return orientationRequestedArray;
                }
                AttributeClass attributeClass5 = attributeClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get("orientation-requested-supported") : null;
                if (attributeClass != null && (nArray = attributeClass.getArrayOfIntValues()) != null && nArray.length > 0) {
                    OrientationRequested[] orientationRequestedArray = new OrientationRequested[nArray.length];
                    block15: for (int i6 = 0; i6 < nArray.length; ++i6) {
                        switch (nArray[i6]) {
                            default: {
                                orientationRequestedArray[i6] = OrientationRequested.PORTRAIT;
                                continue block15;
                            }
                            case 4: {
                                orientationRequestedArray[i6] = OrientationRequested.LANDSCAPE;
                                continue block15;
                            }
                            case 5: {
                                orientationRequestedArray[i6] = OrientationRequested.REVERSE_LANDSCAPE;
                                continue block15;
                            }
                            case 6: {
                                orientationRequestedArray[i6] = OrientationRequested.REVERSE_PORTRAIT;
                            }
                        }
                    }
                    return orientationRequestedArray;
                }
            } else {
                if (clazz == PageRanges.class) {
                    if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                        PageRanges[] pageRangesArray = new PageRanges[]{new PageRanges(1, Integer.MAX_VALUE)};
                        return pageRangesArray;
                    }
                    return null;
                }
                if (clazz == RequestingUserName.class) {
                    String string = "";
                    try {
                        string = System.getProperty("user.name", "");
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    return new RequestingUserName(string, null);
                }
                if (clazz == Sides.class) {
                    String[] stringArray;
                    AttributeClass attributeClass;
                    AttributeClass attributeClass6 = attributeClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get("sides-supported") : null;
                    if (attributeClass != null && (stringArray = attributeClass.getArrayOfStringValues()) != null && stringArray.length > 0) {
                        Sides[] sidesArray = new Sides[stringArray.length];
                        for (int i7 = 0; i7 < stringArray.length; ++i7) {
                            sidesArray[i7] = stringArray[i7].endsWith("long-edge") ? Sides.TWO_SIDED_LONG_EDGE : (stringArray[i7].endsWith("short-edge") ? Sides.TWO_SIDED_SHORT_EDGE : Sides.ONE_SIDED);
                        }
                        return sidesArray;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public AttributeSet getUnsupportedAttributes(DocFlavor docFlavor, AttributeSet attributeSet) {
        if (docFlavor != null && !this.isDocFlavorSupported(docFlavor)) {
            throw new IllegalArgumentException("flavor " + docFlavor + "is not supported");
        }
        if (attributeSet == null) {
            return null;
        }
        HashAttributeSet hashAttributeSet = new HashAttributeSet();
        Attribute[] attributeArray = attributeSet.toArray();
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            try {
                Attribute attribute = attributeArray[i2];
                if (!this.isAttributeCategorySupported(attribute.getCategory())) {
                    hashAttributeSet.add(attribute);
                    continue;
                }
                if (this.isAttributeValueSupported(attribute, docFlavor, attributeSet)) continue;
                hashAttributeSet.add(attribute);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (hashAttributeSet.isEmpty()) {
            return null;
        }
        return hashAttributeSet;
    }

    @Override
    public DocFlavor[] getSupportedDocFlavors() {
        AttributeClass attributeClass;
        if (this.supportedDocFlavors != null) {
            int n2 = this.supportedDocFlavors.length;
            DocFlavor[] docFlavorArray = new DocFlavor[n2];
            System.arraycopy(this.supportedDocFlavors, 0, docFlavorArray, 0, n2);
            return docFlavorArray;
        }
        this.initAttributes();
        if (this.getAttMap != null && this.getAttMap.containsKey("document-format-supported") && (attributeClass = (AttributeClass)this.getAttMap.get("document-format-supported")) != null) {
            int n3;
            boolean bl2 = false;
            String[] stringArray = attributeClass.getArrayOfStringValues();
            ArrayList<DocFlavor> arrayList = new ArrayList<DocFlavor>();
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                int n4;
                for (n4 = 0; n4 < allDocFlavors.length; ++n4) {
                    DocFlavor[] docFlavorArray = (DocFlavor[])allDocFlavors[n4];
                    String string = docFlavorArray[0].getMimeType();
                    if (!string.startsWith(stringArray[n3])) continue;
                    arrayList.addAll(Arrays.asList(docFlavorArray));
                    if (string.equals("image/png")) {
                        this.pngImagesAdded = true;
                        break;
                    }
                    if (string.equals("image/gif")) {
                        this.gifImagesAdded = true;
                        break;
                    }
                    if (string.equals("image/jpeg")) {
                        this.jpgImagesAdded = true;
                        break;
                    }
                    if (string.indexOf("postscript") == -1) break;
                    arrayList.add(DocFlavor.SERVICE_FORMATTED.PAGEABLE);
                    arrayList.add(DocFlavor.SERVICE_FORMATTED.PRINTABLE);
                    bl2 = true;
                    break;
                }
                if (n4 != allDocFlavors.length) continue;
                arrayList.add(new DocFlavor.BYTE_ARRAY(stringArray[n3]));
                arrayList.add(new DocFlavor.INPUT_STREAM(stringArray[n3]));
                arrayList.add(new DocFlavor.URL(stringArray[n3]));
            }
            if (bl2) {
                if (!this.jpgImagesAdded) {
                    arrayList.addAll(Arrays.asList(imageJPG));
                }
                if (!this.pngImagesAdded) {
                    arrayList.addAll(Arrays.asList(imagePNG));
                }
                if (!this.gifImagesAdded) {
                    arrayList.addAll(Arrays.asList(imageGIF));
                }
            }
            this.supportedDocFlavors = new DocFlavor[arrayList.size()];
            arrayList.toArray(this.supportedDocFlavors);
            n3 = this.supportedDocFlavors.length;
            DocFlavor[] docFlavorArray = new DocFlavor[n3];
            System.arraycopy(this.supportedDocFlavors, 0, docFlavorArray, 0, n3);
            return docFlavorArray;
        }
        return null;
    }

    @Override
    public boolean isDocFlavorSupported(DocFlavor docFlavor) {
        if (this.supportedDocFlavors == null) {
            this.getSupportedDocFlavors();
        }
        if (this.supportedDocFlavors != null) {
            for (int i2 = 0; i2 < this.supportedDocFlavors.length; ++i2) {
                if (!docFlavor.equals(this.supportedDocFlavors[i2])) continue;
                return true;
            }
        }
        return false;
    }

    public CustomMediaSizeName findCustomMedia(MediaSizeName mediaSizeName) {
        for (int i2 = 0; i2 < this.customMediaSizeNames.length; ++i2) {
            CustomMediaSizeName customMediaSizeName = this.customMediaSizeNames[i2];
            MediaSizeName mediaSizeName2 = customMediaSizeName.getStandardMedia();
            if (!mediaSizeName.equals(mediaSizeName2)) continue;
            return this.customMediaSizeNames[i2];
        }
        return null;
    }

    private Media getIPPMedia(String string) {
        CustomMediaSizeName customMediaSizeName = new CustomMediaSizeName("sample", "", 0.0f, 0.0f);
        Media[] mediaArray = customMediaSizeName.getSuperEnumTable();
        for (int i2 = 0; i2 < mediaArray.length; ++i2) {
            if (!string.equals("" + mediaArray[i2])) continue;
            return mediaArray[i2];
        }
        CustomMediaTray customMediaTray = new CustomMediaTray("sample", "");
        Media[] mediaArray2 = customMediaTray.getSuperEnumTable();
        for (int i3 = 0; i3 < mediaArray2.length; ++i3) {
            if (!string.equals("" + mediaArray2[i3])) continue;
            return mediaArray2[i3];
        }
        return null;
    }

    private Media[] getSupportedMedia() {
        AttributeClass attributeClass;
        if (this.getAttMap != null && this.getAttMap.containsKey("media-supported") && (attributeClass = (AttributeClass)this.getAttMap.get("media-supported")) != null) {
            String[] stringArray = attributeClass.getArrayOfStringValues();
            Media[] mediaArray = new Media[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                Media media;
                mediaArray[i2] = media = this.getIPPMedia(stringArray[i2]);
            }
            return mediaArray;
        }
        return new Media[0];
    }

    public Class[] getSupportedAttributeCategories() {
        if (this.supportedCats != null) {
            return this.supportedCats;
        }
        this.initAttributes();
        ArrayList<Class<Attribute>> arrayList = new ArrayList<Class<Attribute>>();
        for (int i2 = 0; i2 < printReqAttribDefault.length; ++i2) {
            PrintRequestAttribute printRequestAttribute = (PrintRequestAttribute)printReqAttribDefault[i2];
            if (this.getAttMap == null || !this.getAttMap.containsKey(printRequestAttribute.getName() + "-supported")) continue;
            Class<? extends Attribute> clazz = printRequestAttribute.getCategory();
            arrayList.add(clazz);
        }
        if (this.isCupsPrinter) {
            if (!arrayList.contains(Media.class)) {
                arrayList.add(Media.class);
            }
            arrayList.add(MediaPrintableArea.class);
            arrayList.add(Destination.class);
        }
        if (this.getAttMap != null && this.getAttMap.containsKey("color-supported")) {
            arrayList.add(Chromaticity.class);
        }
        this.supportedCats = new Class[arrayList.size()];
        arrayList.toArray(this.supportedCats);
        return this.supportedCats;
    }

    @Override
    public boolean isAttributeCategorySupported(Class<? extends Attribute> clazz) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not an Attribute");
        }
        if (this.supportedCats == null) {
            this.getSupportedAttributeCategories();
        }
        for (int i2 = 0; i2 < this.supportedCats.length; ++i2) {
            if (clazz != this.supportedCats[i2]) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends PrintServiceAttribute> T getAttribute(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("category");
        }
        if (!PrintServiceAttribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Not a PrintServiceAttribute");
        }
        this.initAttributes();
        if (clazz == PrinterName.class) {
            return (T)new PrinterName(this.printer, null);
        }
        if (clazz == QueuedJobCount.class) {
            AttributeClass attributeClass;
            QueuedJobCount queuedJobCount = new QueuedJobCount(0);
            AttributeClass attributeClass2 = attributeClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get(queuedJobCount.getName()) : null;
            if (attributeClass != null) {
                queuedJobCount = new QueuedJobCount(attributeClass.getIntValue());
            }
            return (T)queuedJobCount;
        }
        if (clazz == PrinterIsAcceptingJobs.class) {
            AttributeClass attributeClass;
            PrinterIsAcceptingJobs printerIsAcceptingJobs = PrinterIsAcceptingJobs.ACCEPTING_JOBS;
            AttributeClass attributeClass3 = attributeClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get(printerIsAcceptingJobs.getName()) : null;
            if (attributeClass != null && attributeClass.getByteValue() == 0) {
                printerIsAcceptingJobs = PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS;
            }
            return (T)printerIsAcceptingJobs;
        }
        if (clazz == ColorSupported.class) {
            AttributeClass attributeClass;
            ColorSupported colorSupported = ColorSupported.SUPPORTED;
            AttributeClass attributeClass4 = attributeClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get(colorSupported.getName()) : null;
            if (attributeClass != null && attributeClass.getByteValue() == 0) {
                colorSupported = ColorSupported.NOT_SUPPORTED;
            }
            return (T)colorSupported;
        }
        if (clazz == PDLOverrideSupported.class) {
            if (this.isCupsPrinter) {
                return (T)PDLOverrideSupported.NOT_ATTEMPTED;
            }
            return (T)PDLOverrideSupported.NOT_ATTEMPTED;
        }
        return null;
    }

    @Override
    public PrintServiceAttributeSet getAttributes() {
        this.init = false;
        this.initAttributes();
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        for (int i2 = 0; i2 < serviceAttributes.length; ++i2) {
            Class clazz;
            Object t2;
            String string = (String)serviceAttributes[i2][1];
            if (this.getAttMap == null || !this.getAttMap.containsKey(string) || (t2 = this.getAttribute(clazz = (Class)serviceAttributes[i2][0])) == null) continue;
            hashPrintServiceAttributeSet.add((Attribute)t2);
        }
        return AttributeSetUtilities.unmodifiableView(hashPrintServiceAttributeSet);
    }

    public boolean isIPPSupportedImages(String string) {
        if (this.supportedDocFlavors == null) {
            this.getSupportedDocFlavors();
        }
        if (string.equals("image/png") && this.pngImagesAdded) {
            return true;
        }
        if (string.equals("image/gif") && this.gifImagesAdded) {
            return true;
        }
        return string.equals("image/jpeg") && this.jpgImagesAdded;
    }

    private boolean isSupportedCopies(Copies copies) {
        int n2;
        int n3;
        CopiesSupported copiesSupported = (CopiesSupported)this.getSupportedAttributeValues(Copies.class, null, null);
        int[][] nArray = copiesSupported.getMembers();
        if (nArray.length > 0 && nArray[0].length > 0) {
            n3 = nArray[0][0];
            n2 = nArray[0][1];
        } else {
            n3 = 1;
            n2 = MAXCOPIES;
        }
        int n4 = copies.getValue();
        return n4 >= n3 && n4 <= n2;
    }

    private boolean isAutoSense(DocFlavor docFlavor) {
        return docFlavor.equals(DocFlavor.BYTE_ARRAY.AUTOSENSE) || docFlavor.equals(DocFlavor.INPUT_STREAM.AUTOSENSE) || docFlavor.equals(DocFlavor.URL.AUTOSENSE);
    }

    private boolean isSupportedMediaTray(MediaTray mediaTray) {
        this.initAttributes();
        if (this.mediaTrays != null) {
            for (int i2 = 0; i2 < this.mediaTrays.length; ++i2) {
                if (!mediaTray.equals(this.mediaTrays[i2])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSupportedMedia(MediaSizeName mediaSizeName) {
        this.initAttributes();
        for (int i2 = 0; i2 < this.mediaSizeNames.length; ++i2) {
            IPPPrintService.debug_println("mediaSizeNames[i] " + this.mediaSizeNames[i2]);
            if (!mediaSizeName.equals(this.mediaSizeNames[i2])) continue;
            return true;
        }
        return false;
    }

    private boolean isDestinationSupported(DocFlavor docFlavor, AttributeSet attributeSet) {
        return attributeSet == null || attributeSet.get(Destination.class) == null || docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE);
    }

    @Override
    public boolean isAttributeValueSupported(Attribute attribute, DocFlavor docFlavor, AttributeSet attributeSet) {
        Class<? extends Attribute> clazz;
        if (attribute == null) {
            throw new NullPointerException("null attribute");
        }
        if (docFlavor != null) {
            if (!this.isDocFlavorSupported(docFlavor)) {
                throw new IllegalArgumentException(docFlavor + " is an unsupported flavor");
            }
            if (this.isAutoSense(docFlavor)) {
                return false;
            }
        }
        if (!this.isAttributeCategorySupported(clazz = attribute.getCategory())) {
            return false;
        }
        if (!this.isDestinationSupported(docFlavor, attributeSet)) {
            return false;
        }
        if (attribute.getCategory() == Chromaticity.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.URL.PNG)) {
                return attribute == Chromaticity.COLOR;
            }
            return false;
        }
        if (attribute.getCategory() == Copies.class) {
            return this.isSupportedCopies((Copies)attribute);
        }
        if (attribute.getCategory() == Destination.class) {
            URI uRI;
            return (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) && "file".equals((uRI = ((Destination)attribute).getURI()).getScheme()) && !uRI.getSchemeSpecificPart().equals("");
        }
        if (attribute.getCategory() == Media.class) {
            if (attribute instanceof MediaSizeName) {
                return this.isSupportedMedia((MediaSizeName)attribute);
            }
            if (attribute instanceof MediaTray) {
                return this.isSupportedMediaTray((MediaTray)attribute);
            }
        } else if (attribute.getCategory() == PageRanges.class) {
            if (docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                return false;
            }
        } else if (attribute.getCategory() == SheetCollate.class) {
            if (docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                return false;
            }
        } else {
            if (attribute.getCategory() == Sides.class) {
                Sides[] sidesArray = (Sides[])this.getSupportedAttributeValues(Sides.class, docFlavor, attributeSet);
                if (sidesArray != null) {
                    for (int i2 = 0; i2 < sidesArray.length; ++i2) {
                        if (sidesArray[i2] != (Sides)attribute) continue;
                        return true;
                    }
                }
                return false;
            }
            if (attribute.getCategory() == OrientationRequested.class) {
                OrientationRequested[] orientationRequestedArray = (OrientationRequested[])this.getSupportedAttributeValues(OrientationRequested.class, docFlavor, attributeSet);
                if (orientationRequestedArray != null) {
                    for (int i3 = 0; i3 < orientationRequestedArray.length; ++i3) {
                        if (orientationRequestedArray[i3] != (OrientationRequested)attribute) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public Object getDefaultAttributeValue(Class<? extends Attribute> clazz) {
        PrintRequestAttribute printRequestAttribute;
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not an Attribute");
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return null;
        }
        this.initAttributes();
        String string = null;
        for (int i2 = 0; i2 < printReqAttribDefault.length; ++i2) {
            printRequestAttribute = (PrintRequestAttribute)printReqAttribDefault[i2];
            if (printRequestAttribute.getCategory() != clazz) continue;
            string = printRequestAttribute.getName();
            break;
        }
        String string2 = string + "-default";
        PrintRequestAttribute printRequestAttribute2 = printRequestAttribute = this.getAttMap != null ? (AttributeClass)this.getAttMap.get(string2) : null;
        if (clazz == Copies.class) {
            if (printRequestAttribute != null) {
                return new Copies(((AttributeClass)((Object)printRequestAttribute)).getIntValue());
            }
            return new Copies(1);
        }
        if (clazz == Chromaticity.class) {
            return Chromaticity.COLOR;
        }
        if (clazz == Destination.class) {
            try {
                return new Destination(new File("out.ps").toURI());
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        if (clazz == Fidelity.class) {
            return Fidelity.FIDELITY_FALSE;
        }
        if (clazz == Finishings.class) {
            return Finishings.NONE;
        }
        if (clazz == JobName.class) {
            return new JobName("Java Printing", null);
        }
        if (clazz == JobSheets.class) {
            if (printRequestAttribute != null && ((AttributeClass)((Object)printRequestAttribute)).getStringValue().equals("none")) {
                return JobSheets.NONE;
            }
            return JobSheets.STANDARD;
        }
        if (clazz == Media.class) {
            this.defaultMediaIndex = 0;
            if (this.mediaSizeNames.length == 0) {
                return null;
            }
            if (printRequestAttribute != null) {
                String string3 = ((AttributeClass)((Object)printRequestAttribute)).getStringValue();
                if (this.isCupsPrinter) {
                    for (int i3 = 0; i3 < this.customMediaSizeNames.length; ++i3) {
                        if (this.customMediaSizeNames[i3].toString().indexOf(string3) == -1) continue;
                        this.defaultMediaIndex = i3;
                        return this.mediaSizeNames[this.defaultMediaIndex];
                    }
                } else {
                    for (int i4 = 0; i4 < this.mediaSizeNames.length; ++i4) {
                        if (this.mediaSizeNames[i4].toString().indexOf(string3) == -1) continue;
                        this.defaultMediaIndex = i4;
                        return this.mediaSizeNames[this.defaultMediaIndex];
                    }
                }
            }
            return this.mediaSizeNames[this.defaultMediaIndex];
        }
        if (clazz == MediaPrintableArea.class) {
            MediaPrintableArea[] mediaPrintableAreaArray;
            if (this.cps != null && (mediaPrintableAreaArray = this.cps.getMediaPrintableArea()) != null) {
                if (this.defaultMediaIndex == -1) {
                    this.getDefaultAttributeValue(Media.class);
                }
                return mediaPrintableAreaArray[this.defaultMediaIndex];
            }
        } else {
            if (clazz == NumberUp.class) {
                return new NumberUp(1);
            }
            if (clazz == OrientationRequested.class) {
                if (printRequestAttribute != null) {
                    switch (((AttributeClass)((Object)printRequestAttribute)).getIntValue()) {
                        default: {
                            return OrientationRequested.PORTRAIT;
                        }
                        case 4: {
                            return OrientationRequested.LANDSCAPE;
                        }
                        case 5: {
                            return OrientationRequested.REVERSE_LANDSCAPE;
                        }
                        case 6: 
                    }
                    return OrientationRequested.REVERSE_PORTRAIT;
                }
                return OrientationRequested.PORTRAIT;
            }
            if (clazz == PageRanges.class) {
                if (printRequestAttribute != null) {
                    int[] nArray = ((AttributeClass)((Object)printRequestAttribute)).getIntRangeValue();
                    return new PageRanges(nArray[0], nArray[1]);
                }
                return new PageRanges(1, Integer.MAX_VALUE);
            }
            if (clazz == RequestingUserName.class) {
                String string4 = "";
                try {
                    string4 = System.getProperty("user.name", "");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return new RequestingUserName(string4, null);
            }
            if (clazz == SheetCollate.class) {
                return SheetCollate.UNCOLLATED;
            }
            if (clazz == Sides.class) {
                if (printRequestAttribute != null) {
                    if (((AttributeClass)((Object)printRequestAttribute)).getStringValue().endsWith("long-edge")) {
                        return Sides.TWO_SIDED_LONG_EDGE;
                    }
                    if (((AttributeClass)((Object)printRequestAttribute)).getStringValue().endsWith("short-edge")) {
                        return Sides.TWO_SIDED_SHORT_EDGE;
                    }
                }
                return Sides.ONE_SIDED;
            }
        }
        return null;
    }

    @Override
    public ServiceUIFactory getServiceUIFactory() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeNotifier() {
        IPPPrintService iPPPrintService = this;
        synchronized (iPPPrintService) {
            if (this.notifier != null) {
                this.notifier.wake();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        IPPPrintService iPPPrintService = this;
        synchronized (iPPPrintService) {
            if (printServiceAttributeListener == null) {
                return;
            }
            if (this.notifier == null) {
                this.notifier = new ServiceNotifier(this);
            }
            this.notifier.addListener(printServiceAttributeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        IPPPrintService iPPPrintService = this;
        synchronized (iPPPrintService) {
            if (printServiceAttributeListener == null || this.notifier == null) {
                return;
            }
            this.notifier.removeListener(printServiceAttributeListener);
            if (this.notifier.isEmpty()) {
                this.notifier.stopNotifier();
                this.notifier = null;
            }
        }
    }

    @Override
    public String getName() {
        return this.printer;
    }

    @Override
    public boolean usesClass(Class clazz) {
        return clazz == PSPrinterJob.class;
    }

    public static HttpURLConnection getIPPConnection(URL uRL) {
        HttpURLConnection httpURLConnection;
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
        }
        catch (IOException iOException) {
            return null;
        }
        if (!(httpURLConnection instanceof HttpURLConnection)) {
            return null;
        }
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDefaultUseCaches(false);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestProperty("Content-type", "application/ipp");
        return httpURLConnection;
    }

    private void opGetAttributes() {
        try {
            boolean bl2;
            IPPPrintService.debug_println(debugPrefix + "opGetAttributes myURI " + this.myURI + " myURL " + this.myURL);
            AttributeClass[] attributeClassArray = new AttributeClass[]{AttributeClass.ATTRIBUTES_CHARSET, AttributeClass.ATTRIBUTES_NATURAL_LANGUAGE};
            AttributeClass[] attributeClassArray2 = new AttributeClass[]{AttributeClass.ATTRIBUTES_CHARSET, AttributeClass.ATTRIBUTES_NATURAL_LANGUAGE, new AttributeClass("printer-uri", 69, "" + this.myURI)};
            OutputStream outputStream = this.urlConnection.getOutputStream();
            boolean bl3 = bl2 = this.myURI == null ? IPPPrintService.writeIPPRequest(outputStream, OP_GET_ATTRIBUTES, attributeClassArray) : IPPPrintService.writeIPPRequest(outputStream, OP_GET_ATTRIBUTES, attributeClassArray2);
            if (bl2) {
                InputStream inputStream = null;
                inputStream = this.urlConnection.getInputStream();
                if (inputStream != null) {
                    HashMap[] hashMapArray = IPPPrintService.readIPPResponse(inputStream);
                    if (hashMapArray != null && hashMapArray.length > 0) {
                        this.getAttMap = hashMapArray[0];
                    }
                } else {
                    IPPPrintService.debug_println(debugPrefix + "opGetAttributes - null input stream");
                }
                inputStream.close();
            }
            outputStream.close();
        }
        catch (IOException iOException) {
            IPPPrintService.debug_println(debugPrefix + "opGetAttributes - input/output stream: " + iOException);
        }
    }

    public static boolean writeIPPRequest(OutputStream outputStream, String string, AttributeClass[] attributeClassArray) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        char[] cArray = new char[]{(char)Byte.parseByte(string.substring(0, 2), 16), (char)Byte.parseByte(string.substring(2, 4), 16)};
        char[] cArray2 = new char[]{'\u0001', '\u0001', '\u0000', '\u0001'};
        try {
            outputStreamWriter.write(cArray2, 0, 2);
            outputStreamWriter.write(cArray, 0, 2);
            cArray2[0] = '\u0000';
            cArray2[1] = '\u0000';
            outputStreamWriter.write(cArray2, 0, 4);
            cArray2[0] = '\u0001';
            outputStreamWriter.write(cArray2[0]);
            for (int i2 = 0; i2 < attributeClassArray.length; ++i2) {
                AttributeClass attributeClass = attributeClassArray[i2];
                outputStreamWriter.write(attributeClass.getType());
                char[] cArray3 = attributeClass.getLenChars();
                outputStreamWriter.write(cArray3, 0, 2);
                outputStreamWriter.write("" + attributeClass, 0, attributeClass.getName().length());
                if (attributeClass.getType() < 53 || attributeClass.getType() > 73) continue;
                String string2 = (String)attributeClass.getObjectValue();
                cArray2[0] = '\u0000';
                cArray2[1] = (char)string2.length();
                outputStreamWriter.write(cArray2, 0, 2);
                outputStreamWriter.write(string2, 0, string2.length());
            }
            outputStreamWriter.write(3);
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            IPPPrintService.debug_println(debugPrefix + "IPPPrintService Exception in writeIPPRequest: " + iOException);
            return false;
        }
        return true;
    }

    public static HashMap[] readIPPResponse(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        byte[] byArray = new byte[ATTRIBUTESTR_MAX];
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            if (dataInputStream.read(byArray, 0, 8) > -1 && byArray[2] == 0) {
                int n2 = 0;
                short s2 = 0;
                String string = null;
                int n3 = 68;
                ArrayList arrayList = new ArrayList();
                HashMap<String, AttributeClass> hashMap = new HashMap<String, AttributeClass>();
                byArray[0] = dataInputStream.readByte();
                while (byArray[0] >= 1 && byArray[0] <= 4 && byArray[0] != 3) {
                    AttributeClass attributeClass;
                    byte[] byArray2;
                    IPPPrintService.debug_println(debugPrefix + "checking group tag,  response[0]= " + byArray[0]);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    n2 = 0;
                    string = null;
                    byArray[0] = dataInputStream.readByte();
                    while (byArray[0] >= 33 && byArray[0] <= 74) {
                        s2 = dataInputStream.readShort();
                        if (s2 != 0 && string != null) {
                            byteArrayOutputStream.write(n2);
                            byteArrayOutputStream.flush();
                            byteArrayOutputStream.close();
                            byArray2 = byteArrayOutputStream.toByteArray();
                            if (hashMap.containsKey(string)) {
                                arrayList.add(hashMap);
                                hashMap = new HashMap();
                            }
                            attributeClass = new AttributeClass(string, n3, byArray2);
                            hashMap.put(attributeClass.getName(), attributeClass);
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            n2 = 0;
                        }
                        if (n2 == 0) {
                            n3 = byArray[0];
                        }
                        if (s2 != 0) {
                            dataInputStream.read(byArray, 0, s2);
                            string = new String(byArray, 0, (int)s2);
                        }
                        s2 = dataInputStream.readShort();
                        byteArrayOutputStream.write(s2);
                        dataInputStream.read(byArray, 0, s2);
                        byteArrayOutputStream.write(byArray, 0, s2);
                        ++n2;
                        byArray[0] = dataInputStream.readByte();
                    }
                    if (string == null) continue;
                    byteArrayOutputStream.write(n2);
                    byteArrayOutputStream.flush();
                    byteArrayOutputStream.close();
                    if (n2 != 0 && hashMap.containsKey(string)) {
                        arrayList.add(hashMap);
                        hashMap = new HashMap();
                    }
                    byArray2 = byteArrayOutputStream.toByteArray();
                    attributeClass = new AttributeClass(string, n3, byArray2);
                    hashMap.put(attributeClass.getName(), attributeClass);
                }
                dataInputStream.close();
                if (hashMap != null && hashMap.size() > 0) {
                    arrayList.add(hashMap);
                }
                return arrayList.toArray(new HashMap[arrayList.size()]);
            }
            IPPPrintService.debug_println(debugPrefix + "readIPPResponse client error, IPP status code-" + Integer.toHexString(byArray[2]) + " & " + Integer.toHexString(byArray[3]));
            return null;
        }
        catch (IOException iOException) {
            IPPPrintService.debug_println(debugPrefix + "readIPPResponse: " + iOException);
            return null;
        }
    }

    public String toString() {
        return "IPP Printer : " + this.getName();
    }

    @Override
    public boolean equals(Object object) {
        return object == this || object instanceof IPPPrintService && ((IPPPrintService)object).getName().equals(this.getName());
    }

    private class ExtFinishing
    extends Finishings {
        ExtFinishing(int n2) {
            super(100);
        }

        EnumSyntax[] getAll() {
            EnumSyntax[] enumSyntaxArray = super.getEnumValueTable();
            return enumSyntaxArray;
        }
    }
}

