/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ISO_8859_1;
import sun.nio.cs.ISO_8859_15;
import sun.nio.cs.MS1252;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;
import sun.nio.cs.US_ASCII;
import sun.nio.cs.UTF_16;
import sun.nio.cs.UTF_16BE;
import sun.nio.cs.UTF_16LE;

class UTF_8
extends Charset
implements HistoricallyNamedCharset {
    public UTF_8() {
        super("UTF-8", StandardCharsets.aliases_UTF_8);
    }

    public String historicalName() {
        return "UTF8";
    }

    public boolean contains(Charset charset) {
        return charset instanceof US_ASCII || charset instanceof ISO_8859_1 || charset instanceof ISO_8859_15 || charset instanceof MS1252 || charset instanceof UTF_8 || charset instanceof UTF_16 || charset instanceof UTF_16BE || charset.name().equals("GBK") || charset.name().equals("GB18030") || charset.name().equals("ISO-8859-2") || charset.name().equals("ISO-8859-3") || charset.name().equals("ISO-8859-4") || charset.name().equals("ISO-8859-5") || charset.name().equals("ISO-8859-6") || charset.name().equals("ISO-8859-7") || charset.name().equals("ISO-8859-8") || charset.name().equals("ISO-8859-9") || charset.name().equals("ISO-8859-13") || charset.name().equals("windows-1251") || charset.name().equals("windows-1253") || charset.name().equals("windows-1254") || charset.name().equals("windows-1255") || charset.name().equals("windows-1256") || charset.name().equals("windows-1257") || charset.name().equals("windows-1258") || charset.name().equals("windows-932") || charset.name().equals("x-mswin-936") || charset.name().equals("x-windows-949") || charset.name().equals("x-windows-950") || charset.name().equals("windows-31j") || charset.name().equals("JIS_X0201") || charset.name().equals("x-JIS0208") || charset.name().equals("JIS_X0212-1990") || charset.name().equals("GB2312") || charset.name().equals("EUC-KR") || charset.name().equals("x-EUC-TW") || charset.name().equals("EUC-JP") || charset.name().equals("x-euc-jp-linux") || charset.name().equals("KOI8-R") || charset.name().equals("TIS-620") || charset.name().equals("x-ISCII91") || charset.name().equals("Big5") || charset.name().equals("Big5-HKSCS") || charset.name().equals("x-MS950-HKSCS") || charset.name().equals("ISO-2022-JP") || charset.name().equals("ISO-2022-KR") || charset.name().equals("x-ISO-2022-CN-CNS") || charset.name().equals("x-ISO-2022-CN-GB") || charset.name().equals("Big5-HKSCS") || charset.name().equals("x-Johab") || charset.name().equals("Shift_JIS") || charset instanceof UTF_16LE;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Decoder
    extends CharsetDecoder {
        private final Surrogate.Generator sgg = new Surrogate.Generator();

        private Decoder(Charset charset) {
            super(charset, 1.0f, 2.0f);
        }

        private boolean isContinuation(int n2) {
            return (n2 & 0xC0) == 128;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n2 <= n3);
            n2 = n2 <= n3 ? n2 : n3;
            char[] cArray = charBuffer.array();
            int n4 = charBuffer.arrayOffset() + charBuffer.position();
            int n5 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n4 <= n5);
            n4 = n4 <= n5 ? n4 : n5;
            try {
                block40: while (n2 < n3) {
                    byte by = byArray[n2];
                    switch (by >> 4 & 0xF) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            if (n5 - n4 < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            cArray[n4++] = (char)(by & 0x7F);
                            ++n2;
                            continue block40;
                        }
                        case 12: 
                        case 13: {
                            if (n3 - n2 < 2) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            if (n5 - n4 < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byte by2 = byArray[n2 + 1];
                            if (!this.isContinuation(by2)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                            cArray[n4++] = (char)((by & 0x1F) << 6 | (by2 & 0x3F) << 0);
                            n2 += 2;
                            continue block40;
                        }
                        case 14: {
                            if (n3 - n2 < 3) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            if (n5 - n4 < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byte by2 = byArray[n2 + 1];
                            if (!this.isContinuation(by2)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                            byte by3 = byArray[n2 + 2];
                            if (!this.isContinuation(by3)) {
                                CoderResult coderResult = CoderResult.malformedForLength(2);
                                return coderResult;
                            }
                            cArray[n4++] = (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | (by3 & 0x3F) << 0);
                            n2 += 3;
                            continue block40;
                        }
                        case 15: {
                            int n6;
                            int n7;
                            byte by3;
                            byte by2;
                            switch (by & 0xF) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    if (n3 - n2 < 4) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    by2 = byArray[n2 + 1];
                                    if (!this.isContinuation(by2)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(1);
                                        return coderResult;
                                    }
                                    by3 = byArray[n2 + 2];
                                    if (!this.isContinuation(by3)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(2);
                                        return coderResult;
                                    }
                                    byte by4 = byArray[n2 + 3];
                                    if (!this.isContinuation(by4)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(3);
                                        return coderResult;
                                    }
                                    n7 = (by & 7) << 18 | (by2 & 0x3F) << 12 | (by3 & 0x3F) << 6 | (by4 & 0x3F) << 0;
                                    n6 = 4;
                                    break;
                                }
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: {
                                    if (n3 - n2 < 5) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    by2 = byArray[n2 + 1];
                                    if (!this.isContinuation(by2)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(1);
                                        return coderResult;
                                    }
                                    by3 = byArray[n2 + 2];
                                    if (!this.isContinuation(by3)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(2);
                                        return coderResult;
                                    }
                                    byte by4 = byArray[n2 + 3];
                                    if (!this.isContinuation(by4)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(3);
                                        return coderResult;
                                    }
                                    byte by5 = byArray[n2 + 4];
                                    if (!this.isContinuation(by5)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(4);
                                        return coderResult;
                                    }
                                    n7 = (by & 3) << 24 | (by2 & 0x3F) << 18 | (by3 & 0x3F) << 12 | (by4 & 0x3F) << 6 | (by5 & 0x3F) << 0;
                                    n6 = 5;
                                    break;
                                }
                                case 12: 
                                case 13: {
                                    if (n3 - n2 < 6) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    by2 = byArray[n2 + 1];
                                    if (!this.isContinuation(by2)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(1);
                                        return coderResult;
                                    }
                                    by3 = byArray[n2 + 2];
                                    if (!this.isContinuation(by3)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(2);
                                        return coderResult;
                                    }
                                    byte by4 = byArray[n2 + 3];
                                    if (!this.isContinuation(by4)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(3);
                                        return coderResult;
                                    }
                                    byte by5 = byArray[n2 + 4];
                                    if (!this.isContinuation(by5)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(4);
                                        return coderResult;
                                    }
                                    byte by6 = byArray[n2 + 5];
                                    if (!this.isContinuation(by6)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(5);
                                        return coderResult;
                                    }
                                    n7 = (by & 1) << 30 | (by2 & 0x3F) << 24 | (by3 & 0x3F) << 18 | (by4 & 0x3F) << 12 | (by5 & 0x3F) << 6 | by6 & 0x3F;
                                    n6 = 6;
                                    break;
                                }
                                default: {
                                    CoderResult coderResult = CoderResult.malformedForLength(1);
                                    return coderResult;
                                }
                            }
                            int n8 = this.sgg.generate(n7, n6, cArray, n4, n5);
                            if (n8 < 0) {
                                CoderResult coderResult = this.sgg.error();
                                return coderResult;
                            }
                            n4 += n8;
                            n2 += n6;
                            continue block40;
                        }
                    }
                    CoderResult coderResult = CoderResult.malformedForLength(1);
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n2 - byteBuffer.arrayOffset());
                charBuffer.position(n4 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n2 = byteBuffer.position();
            try {
                block40: while (byteBuffer.hasRemaining()) {
                    byte by = byteBuffer.get();
                    switch (by >> 4 & 0xF) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            if (charBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            charBuffer.put((char)by);
                            ++n2;
                            continue block40;
                        }
                        case 12: 
                        case 13: {
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            if (charBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byte by2 = byteBuffer.get();
                            if (!this.isContinuation(by2)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                            charBuffer.put((char)((by & 0x1F) << 6 | (by2 & 0x3F) << 0));
                            n2 += 2;
                            continue block40;
                        }
                        case 14: {
                            if (byteBuffer.remaining() < 2) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            if (charBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byte by2 = byteBuffer.get();
                            if (!this.isContinuation(by2)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                            byte by3 = byteBuffer.get();
                            if (!this.isContinuation(by3)) {
                                CoderResult coderResult = CoderResult.malformedForLength(2);
                                return coderResult;
                            }
                            charBuffer.put((char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | (by3 & 0x3F) << 0));
                            n2 += 3;
                            continue block40;
                        }
                        case 15: {
                            int n3;
                            int n4;
                            byte by3;
                            byte by2;
                            switch (by & 0xF) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    if (byteBuffer.remaining() < 3) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    by2 = byteBuffer.get();
                                    if (!this.isContinuation(by2)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(1);
                                        return coderResult;
                                    }
                                    by3 = byteBuffer.get();
                                    if (!this.isContinuation(by3)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(2);
                                        return coderResult;
                                    }
                                    byte by4 = byteBuffer.get();
                                    if (!this.isContinuation(by4)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(3);
                                        return coderResult;
                                    }
                                    n4 = (by & 7) << 18 | (by2 & 0x3F) << 12 | (by3 & 0x3F) << 6 | (by4 & 0x3F) << 0;
                                    n3 = 4;
                                    break;
                                }
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: {
                                    if (byteBuffer.remaining() < 4) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    by2 = byteBuffer.get();
                                    if (!this.isContinuation(by2)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(1);
                                        return coderResult;
                                    }
                                    by3 = byteBuffer.get();
                                    if (!this.isContinuation(by3)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(2);
                                        return coderResult;
                                    }
                                    byte by4 = byteBuffer.get();
                                    if (!this.isContinuation(by4)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(3);
                                        return coderResult;
                                    }
                                    byte by5 = byteBuffer.get();
                                    if (!this.isContinuation(by5)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(4);
                                        return coderResult;
                                    }
                                    n4 = (by & 3) << 24 | (by2 & 0x3F) << 18 | (by3 & 0x3F) << 12 | (by4 & 0x3F) << 6 | (by5 & 0x3F) << 0;
                                    n3 = 5;
                                    break;
                                }
                                case 12: 
                                case 13: {
                                    if (byteBuffer.remaining() < 4) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    by2 = byteBuffer.get();
                                    if (!this.isContinuation(by2)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(1);
                                        return coderResult;
                                    }
                                    by3 = byteBuffer.get();
                                    if (!this.isContinuation(by3)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(2);
                                        return coderResult;
                                    }
                                    byte by4 = byteBuffer.get();
                                    if (!this.isContinuation(by4)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(3);
                                        return coderResult;
                                    }
                                    byte by5 = byteBuffer.get();
                                    if (!this.isContinuation(by5)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(4);
                                        return coderResult;
                                    }
                                    byte by6 = byteBuffer.get();
                                    if (!this.isContinuation(by6)) {
                                        CoderResult coderResult = CoderResult.malformedForLength(5);
                                        return coderResult;
                                    }
                                    n4 = (by & 1) << 30 | (by2 & 0x3F) << 24 | (by3 & 0x3F) << 18 | (by4 & 0x3F) << 12 | (by5 & 0x3F) << 6 | by6 & 0x3F;
                                    n3 = 6;
                                    break;
                                }
                                default: {
                                    CoderResult coderResult = CoderResult.malformedForLength(1);
                                    return coderResult;
                                }
                            }
                            if (this.sgg.generate(n4, n3, charBuffer) < 0) {
                                CoderResult coderResult = this.sgg.error();
                                return coderResult;
                            }
                            n2 += n3;
                            continue block40;
                        }
                    }
                    CoderResult coderResult = CoderResult.malformedForLength(1);
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n2);
            }
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }
    }

    private static class Encoder
    extends CharsetEncoder {
        private final Surrogate.Parser sgp = new Surrogate.Parser();

        private Encoder(Charset charset) {
            super(charset, 1.1f, 4.0f);
        }

        public boolean canEncode(char c2) {
            return !Surrogate.is(c2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n2 = charBuffer.arrayOffset() + charBuffer.position();
            int n3 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n2 <= n3);
            n2 = n2 <= n3 ? n2 : n3;
            byte[] byArray = byteBuffer.array();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n5 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n4 <= n5);
            n4 = n4 <= n5 ? n4 : n5;
            try {
                while (n2 < n3) {
                    int n6;
                    char c2 = cArray[n2];
                    if (c2 < '\u0080') {
                        if (n4 >= n5) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n4++] = (byte)c2;
                        ++n2;
                        continue;
                    }
                    if (!Surrogate.is(c2)) {
                        if (c2 < '\u0800') {
                            if (n5 - n4 < 2) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n4++] = (byte)(0xC0 | c2 >> 6);
                            byArray[n4++] = (byte)(0x80 | c2 >> 0 & 0x3F);
                            ++n2;
                            continue;
                        }
                        if (c2 <= '\uffff') {
                            if (n5 - n4 < 3) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n4++] = (byte)(0xE0 | c2 >> 12);
                            byArray[n4++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                            byArray[n4++] = (byte)(0x80 | c2 >> 0 & 0x3F);
                            ++n2;
                            continue;
                        }
                    }
                    if ((n6 = this.sgp.parse(c2, cArray, n2, n3)) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    if (n6 < 0x200000) {
                        if (n5 - n4 < 4) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n4++] = (byte)(0xF0 | n6 >> 18);
                        byArray[n4++] = (byte)(0x80 | n6 >> 12 & 0x3F);
                        byArray[n4++] = (byte)(0x80 | n6 >> 6 & 0x3F);
                        byArray[n4++] = (byte)(0x80 | n6 >> 0 & 0x3F);
                        n2 += this.sgp.increment();
                        continue;
                    }
                    assert (false);
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n2 - charBuffer.arrayOffset());
                byteBuffer.position(n4 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n2 = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    int n3;
                    char c2 = charBuffer.get();
                    if (c2 < '\u0080') {
                        if (!byteBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)c2);
                        ++n2;
                        continue;
                    }
                    if (!Surrogate.is(c2)) {
                        if (c2 < '\u0800') {
                            if (byteBuffer.remaining() < 2) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)(0xC0 | c2 >> 6));
                            byteBuffer.put((byte)(0x80 | c2 >> 0 & 0x3F));
                            ++n2;
                            continue;
                        }
                        if (c2 <= '\uffff') {
                            if (byteBuffer.remaining() < 3) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)(0xE0 | c2 >> 12));
                            byteBuffer.put((byte)(0x80 | c2 >> 6 & 0x3F));
                            byteBuffer.put((byte)(0x80 | c2 >> 0 & 0x3F));
                            ++n2;
                            continue;
                        }
                    }
                    if ((n3 = this.sgp.parse(c2, charBuffer)) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    if (n3 < 0x200000) {
                        if (byteBuffer.remaining() < 4) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)(0xF0 | n3 >> 18));
                        byteBuffer.put((byte)(0x80 | n3 >> 12 & 0x3F));
                        byteBuffer.put((byte)(0x80 | n3 >> 6 & 0x3F));
                        byteBuffer.put((byte)(0x80 | n3 >> 0 & 0x3F));
                        n2 += this.sgp.increment();
                        continue;
                    }
                    assert (false);
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n2);
            }
        }

        protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }
    }
}

