/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.PollArrayWrapper;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;
import sun.nio.ch.Util;

abstract class AbstractPollSelectorImpl
extends SelectorImpl {
    PollArrayWrapper pollWrapper;
    protected final int INIT_CAP = 10;
    protected SelectionKeyImpl[] channelArray;
    protected int channelOffset = 0;
    protected int totalChannels;
    private boolean closed = false;

    AbstractPollSelectorImpl(SelectorProvider selectorProvider, int n2, int n3) {
        super(selectorProvider);
        this.totalChannels = n2;
        this.channelOffset = n3;
    }

    void putEventOps(SelectionKeyImpl selectionKeyImpl, int n2) {
        this.pollWrapper.putEventOps(selectionKeyImpl.getIndex(), n2);
    }

    public Selector wakeup() {
        this.pollWrapper.interrupt();
        return this;
    }

    protected abstract int doSelect(long var1) throws IOException;

    protected void implClose() throws IOException {
        if (!this.closed) {
            this.closed = true;
            for (int i2 = this.channelOffset; i2 < this.totalChannels; ++i2) {
                SelectionKeyImpl selectionKeyImpl = this.channelArray[i2];
                assert (selectionKeyImpl.getIndex() != -1);
                selectionKeyImpl.setIndex(-1);
                this.deregister(selectionKeyImpl);
                SelectableChannel selectableChannel = this.channelArray[i2].channel();
                if (selectableChannel.isOpen() || selectableChannel.isRegistered()) continue;
                ((SelChImpl)((Object)selectableChannel)).kill();
            }
            this.implCloseInterrupt();
            this.pollWrapper.free();
            this.pollWrapper = null;
            this.selectedKeys = null;
            this.channelArray = null;
            this.totalChannels = 0;
        }
    }

    protected abstract void implCloseInterrupt() throws IOException;

    protected int updateSelectedKeys() {
        int n2 = 0;
        for (int i2 = this.channelOffset; i2 < this.totalChannels; ++i2) {
            int n3 = this.pollWrapper.getReventOps(i2);
            if (n3 == 0) continue;
            SelectionKeyImpl selectionKeyImpl = this.channelArray[i2];
            this.pollWrapper.putReventOps(i2, 0);
            if (this.selectedKeys.contains(selectionKeyImpl)) {
                if (!selectionKeyImpl.channel.translateAndSetReadyOps(n3, selectionKeyImpl)) continue;
                ++n2;
                continue;
            }
            selectionKeyImpl.channel.translateAndSetReadyOps(n3, selectionKeyImpl);
            if ((selectionKeyImpl.nioReadyOps() & selectionKeyImpl.nioInterestOps()) == 0) continue;
            this.selectedKeys.add(selectionKeyImpl);
            ++n2;
        }
        return n2;
    }

    protected void implRegister(SelectionKeyImpl selectionKeyImpl) {
        if (this.channelArray.length == this.totalChannels) {
            int n2 = this.pollWrapper.totalChannels * 2;
            SelectionKeyImpl[] selectionKeyImplArray = new SelectionKeyImpl[n2];
            for (int i2 = this.channelOffset; i2 < this.totalChannels; ++i2) {
                selectionKeyImplArray[i2] = this.channelArray[i2];
            }
            this.channelArray = selectionKeyImplArray;
            this.pollWrapper.grow(n2);
        }
        this.channelArray[this.totalChannels] = selectionKeyImpl;
        selectionKeyImpl.setIndex(this.totalChannels);
        this.pollWrapper.addEntry(selectionKeyImpl.channel);
        ++this.totalChannels;
        this.keys.add(selectionKeyImpl);
    }

    protected void implDereg(SelectionKeyImpl selectionKeyImpl) throws IOException {
        Object object;
        int n2 = selectionKeyImpl.getIndex();
        assert (n2 >= 0);
        if (n2 != this.totalChannels - 1) {
            object = this.channelArray[this.totalChannels - 1];
            this.channelArray[n2] = object;
            ((SelectionKeyImpl)object).setIndex(n2);
            this.pollWrapper.release(n2);
            PollArrayWrapper.replaceEntry(this.pollWrapper, this.totalChannels - 1, this.pollWrapper, n2);
        } else {
            this.pollWrapper.release(n2);
        }
        this.channelArray[this.totalChannels - 1] = null;
        --this.totalChannels;
        --this.pollWrapper.totalChannels;
        selectionKeyImpl.setIndex(-1);
        this.keys.remove(selectionKeyImpl);
        this.selectedKeys.remove(selectionKeyImpl);
        this.deregister(selectionKeyImpl);
        object = selectionKeyImpl.channel();
        if (!((AbstractInterruptibleChannel)object).isOpen() && !((SelectableChannel)object).isRegistered()) {
            ((SelChImpl)object).kill();
        }
    }

    static {
        Util.load();
    }
}

