/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.BitSet;

public class ParseUtil {
    static BitSet encodedInPath = new BitSet(256);

    public static String encodePath(String string) {
        return ParseUtil.encodePath(string, true);
    }

    public static String encodePath(String string, boolean bl2) {
        char[] cArray = new char[string.length() * 2 + 16];
        int n2 = 0;
        char[] cArray2 = string.toCharArray();
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = cArray2[i2];
            if (!bl2 && c2 == '/' || bl2 && c2 == File.separatorChar) {
                cArray[n2++] = 47;
            } else if (c2 <= '\u007f') {
                if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9') {
                    cArray[n2++] = c2;
                } else if (encodedInPath.get(c2)) {
                    n2 = ParseUtil.escape(cArray, c2, n2);
                } else {
                    cArray[n2++] = c2;
                }
            } else if (c2 > '\u07ff') {
                n2 = ParseUtil.escape(cArray, (char)(0xE0 | c2 >> 12 & 0xF), n2);
                n2 = ParseUtil.escape(cArray, (char)(0x80 | c2 >> 6 & 0x3F), n2);
                n2 = ParseUtil.escape(cArray, (char)(0x80 | c2 >> 0 & 0x3F), n2);
            } else {
                n2 = ParseUtil.escape(cArray, (char)(0xC0 | c2 >> 6 & 0x1F), n2);
                n2 = ParseUtil.escape(cArray, (char)(0x80 | c2 >> 0 & 0x3F), n2);
            }
            if (n2 + 9 <= cArray.length) continue;
            int n4 = cArray.length * 2 + 16;
            if (n4 < 0) {
                n4 = Integer.MAX_VALUE;
            }
            char[] cArray3 = new char[n4];
            System.arraycopy(cArray, 0, cArray3, 0, n2);
            cArray = cArray3;
        }
        return new String(cArray, 0, n2);
    }

    private static int escape(char[] cArray, char c2, int n2) {
        cArray[n2++] = 37;
        cArray[n2++] = Character.forDigit(c2 >> 4 & 0xF, 16);
        cArray[n2++] = Character.forDigit(c2 & 0xF, 16);
        return n2;
    }

    private static char unescape(String string, int n2) {
        return (char)Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16);
    }

    public static String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 != '%') {
                ++n2;
            } else {
                try {
                    c2 = ParseUtil.unescape(string, n2);
                    n2 += 3;
                    if ((c2 & 0x80) != 0) {
                        switch (c2 >> 4) {
                            case 12: 
                            case 13: {
                                char c3 = ParseUtil.unescape(string, n2);
                                n2 += 3;
                                c2 = (char)((c2 & 0x1F) << 6 | c3 & 0x3F);
                                break;
                            }
                            case 14: {
                                char c3 = ParseUtil.unescape(string, n2);
                                char c4 = ParseUtil.unescape(string, n2 += 3);
                                n2 += 3;
                                c2 = (char)((c2 & 0xF) << 12 | (c3 & 0x3F) << 6 | c4 & 0x3F);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException();
                }
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public String canonizeString(String string) {
        int n2 = 0;
        int n3 = string.length();
        while ((n2 = string.indexOf("/../")) >= 0) {
            n3 = string.lastIndexOf(47, n2 - 1);
            if (n3 >= 0) {
                string = string.substring(0, n3) + string.substring(n2 + 3);
                continue;
            }
            string = string.substring(n2 + 3);
        }
        while ((n2 = string.indexOf("/./")) >= 0) {
            string = string.substring(0, n2) + string.substring(n2 + 2);
        }
        while (string.endsWith("/..")) {
            n2 = string.indexOf("/..");
            n3 = string.lastIndexOf(47, n2 - 1);
            if (n3 >= 0) {
                string = string.substring(0, n3 + 1);
                continue;
            }
            string = string.substring(0, n2);
        }
        if (string.endsWith("/.")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static URL fileToEncodedURL(File file) throws MalformedURLException {
        String string = file.getAbsolutePath();
        if (!(string = ParseUtil.encodePath(string)).startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + "/";
        }
        return new URL("file", "", string);
    }

    public static URI toURI(URL uRL) {
        URI uRI;
        String string = uRL.getProtocol();
        String string2 = uRL.getAuthority();
        String string3 = uRL.getPath();
        String string4 = uRL.getQuery();
        String string5 = uRL.getRef();
        if (string3 != null && !string3.startsWith("/")) {
            string3 = "/" + string3;
        }
        try {
            uRI = new URI(string, string2, string3, string4, string5);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRI = null;
        }
        return uRI;
    }

    static {
        encodedInPath.set(61);
        encodedInPath.set(59);
        encodedInPath.set(63);
        encodedInPath.set(47);
        encodedInPath.set(35);
        encodedInPath.set(32);
        encodedInPath.set(60);
        encodedInPath.set(62);
        encodedInPath.set(37);
        encodedInPath.set(34);
        encodedInPath.set(123);
        encodedInPath.set(125);
        encodedInPath.set(124);
        encodedInPath.set(92);
        encodedInPath.set(94);
        encodedInPath.set(91);
        encodedInPath.set(93);
        encodedInPath.set(96);
        for (int i2 = 0; i2 < 32; ++i2) {
            encodedInPath.set(i2);
        }
        encodedInPath.set(127);
    }
}

