/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.jar.Attributes;

public class ExtensionInfo {
    public static final int COMPATIBLE = 0;
    public static final int REQUIRE_SPECIFICATION_UPGRADE = 1;
    public static final int REQUIRE_IMPLEMENTATION_UPGRADE = 2;
    public static final int REQUIRE_VENDOR_SWITCH = 3;
    public static final int INCOMPATIBLE = 4;
    public String title;
    public String name;
    public String specVersion;
    public String specVendor;
    public String implementationVersion;
    public String vendor;
    public String vendorId;
    public String url;
    private static final ResourceBundle rb = ResourceBundle.getBundle("sun.misc.resources.Messages");

    public ExtensionInfo() {
    }

    public ExtensionInfo(String string, Attributes attributes) throws NullPointerException {
        String string2 = string != null ? string + "-" : "";
        String string3 = string2 + Attributes.Name.EXTENSION_NAME.toString();
        this.name = attributes.getValue(string3);
        if (this.name != null) {
            this.name = this.name.trim();
        }
        string3 = string2 + Attributes.Name.SPECIFICATION_TITLE.toString();
        this.title = attributes.getValue(string3);
        if (this.title != null) {
            this.title = this.title.trim();
        }
        string3 = string2 + Attributes.Name.SPECIFICATION_VERSION.toString();
        this.specVersion = attributes.getValue(string3);
        if (this.specVersion != null) {
            this.specVersion = this.specVersion.trim();
        }
        string3 = string2 + Attributes.Name.SPECIFICATION_VENDOR.toString();
        this.specVendor = attributes.getValue(string3);
        if (this.specVendor != null) {
            this.specVendor = this.specVendor.trim();
        }
        string3 = string2 + Attributes.Name.IMPLEMENTATION_VERSION.toString();
        this.implementationVersion = attributes.getValue(string3);
        if (this.implementationVersion != null) {
            this.implementationVersion = this.implementationVersion.trim();
        }
        string3 = string2 + Attributes.Name.IMPLEMENTATION_VENDOR.toString();
        this.vendor = attributes.getValue(string3);
        if (this.vendor != null) {
            this.vendor = this.vendor.trim();
        }
        string3 = string2 + Attributes.Name.IMPLEMENTATION_VENDOR_ID.toString();
        this.vendorId = attributes.getValue(string3);
        if (this.vendorId != null) {
            this.vendorId = this.vendorId.trim();
        }
        string3 = string2 + Attributes.Name.IMPLEMENTATION_URL.toString();
        this.url = attributes.getValue(string3);
        if (this.url != null) {
            this.url = this.url.trim();
        }
    }

    public int isCompatibleWith(ExtensionInfo extensionInfo) {
        if (this.name == null || extensionInfo.name == null) {
            return 4;
        }
        if (this.name.compareTo(extensionInfo.name) == 0) {
            if (this.specVersion == null || extensionInfo.specVersion == null) {
                return 0;
            }
            int n2 = this.compareExtensionVersion(this.specVersion, extensionInfo.specVersion);
            if (n2 < 0) {
                if (this.vendorId != null && extensionInfo.vendorId != null && this.vendorId.compareTo(extensionInfo.vendorId) != 0) {
                    return 3;
                }
                return 1;
            }
            if (this.vendorId != null && extensionInfo.vendorId != null) {
                if (this.vendorId.compareTo(extensionInfo.vendorId) != 0) {
                    return 3;
                }
                if (this.implementationVersion != null && extensionInfo.implementationVersion != null && (n2 = this.compareExtensionVersion(this.implementationVersion, extensionInfo.implementationVersion)) < 0) {
                    return 2;
                }
            }
            return 0;
        }
        return 4;
    }

    public String toString() {
        return "Extension : title(" + this.title + "), name(" + this.name + "), spec vendor(" + this.specVendor + "), spec version(" + this.specVersion + "), impl vendor(" + this.vendor + "), impl vendor id(" + this.vendorId + "), impl version(" + this.implementationVersion + "), impl url(" + this.url + ")";
    }

    private int compareExtensionVersion(String string, String string2) throws NumberFormatException {
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        return this.strictCompareExtensionVersion(string, string2);
    }

    private int strictCompareExtensionVersion(String string, String string2) throws NumberFormatException {
        if (string.equals(string2)) {
            return 0;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".,");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".,");
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        if (stringTokenizer.hasMoreTokens()) {
            n2 = this.convertToken(stringTokenizer.nextToken().toString());
        }
        if (stringTokenizer2.hasMoreTokens()) {
            n3 = this.convertToken(stringTokenizer2.nextToken().toString());
        }
        if (n2 > n3) {
            return 1;
        }
        if (n3 > n2) {
            return -1;
        }
        int n4 = string.indexOf(".");
        int n5 = string2.indexOf(".");
        if (n4 == -1) {
            n4 = string.length() - 1;
        }
        if (n5 == -1) {
            n5 = string2.length() - 1;
        }
        return this.strictCompareExtensionVersion(string.substring(n4 + 1), string2.substring(n5 + 1));
    }

    private int convertToken(String string) {
        int n2;
        int n3;
        if (string == null || string.equals("")) {
            return 0;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = n3 = string.length();
        Object[] objectArray = new Object[]{this.name};
        MessageFormat messageFormat = new MessageFormat(rb.getString("optpkg.versionerror"));
        String string2 = messageFormat.format(objectArray);
        int n8 = string.indexOf("-");
        int n9 = string.indexOf("_");
        if (n8 == -1 && n9 == -1) {
            try {
                return Integer.parseInt(string) * 100;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println(string2);
                return 0;
            }
        }
        if (n9 != -1) {
            int n10;
            try {
                n10 = Integer.parseInt(string.substring(0, n9));
                char c2 = string.charAt(n3 - 1);
                if (Character.isLetter(c2)) {
                    n4 = Character.getNumericValue(c2);
                    n7 = n3 - 1;
                    n6 = Integer.parseInt(string.substring(n9 + 1, n7));
                    if (n4 >= Character.getNumericValue('a') && n4 <= Character.getNumericValue('z')) {
                        n5 = n6 * 100 + n4;
                    } else {
                        n5 = 0;
                        System.out.println(string2);
                    }
                } else {
                    n6 = Integer.parseInt(string.substring(n9 + 1, n7));
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println(string2);
                return 0;
            }
            return n10 * 100 + (n6 + n5);
        }
        try {
            n2 = Integer.parseInt(string.substring(0, n8));
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(string2);
            return 0;
        }
        String string3 = string.substring(n8 + 1);
        String string4 = "";
        int n11 = 0;
        if (string3.indexOf("ea") != -1) {
            string4 = string3.substring(2);
            n11 = 50;
        } else if (string3.indexOf("alpha") != -1) {
            string4 = string3.substring(5);
            n11 = 40;
        } else if (string3.indexOf("beta") != -1) {
            string4 = string3.substring(4);
            n11 = 30;
        } else if (string3.indexOf("rc") != -1) {
            string4 = string3.substring(2);
            n11 = 20;
        }
        if (string4 == null || string4.equals("")) {
            return n2 * 100 - n11;
        }
        try {
            return n2 * 100 - n11 + Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(string2);
            return 0;
        }
    }
}

