/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.WindowPeer;
import java.security.AccessController;
import java.util.Vector;
import sun.awt.DisplayChangedListener;
import sun.awt.SunToolkit;
import sun.awt.im.InputMethodManager;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MInputMethod;
import sun.awt.motif.MInputMethodControl;
import sun.awt.motif.MMenuBarPeer;
import sun.awt.motif.MPanelPeer;
import sun.awt.motif.MToolkit;
import sun.awt.motif.MWindowAttributes;
import sun.security.action.GetIntegerAction;

class MWindowPeer
extends MPanelPeer
implements WindowPeer,
DisplayChangedListener {
    Insets insets = new Insets(0, 0, 0, 0);
    MWindowAttributes winAttr;
    static Vector allWindows = new Vector();
    int iconWidth = -1;
    int iconHeight = -1;
    int dropTargetCount = 0;
    private Vector imList = new Vector();
    private Vector tcList = new Vector();

    native void pCreate(MComponentPeer var1, String var2);

    native void pShow();

    native void pShowModal(boolean var1);

    native void pHide();

    native void pReshape(int var1, int var2, int var3, int var4);

    native void pDispose();

    native void pSetTitle(String var1);

    public native void setState(int var1);

    public native int getState();

    public native void setResizable(boolean var1);

    native void addTextComponentNative(MComponentPeer var1);

    native void removeTextComponentNative();

    native void pSetIMMOption(String var1);

    native void pSetMenuBar(MMenuBarPeer var1);

    native void setSaveUnder(boolean var1);

    native void registerX11DropTarget(Component var1);

    native void unregisterX11DropTarget(Component var1);

    native void doUpdateAlwaysOnTop(boolean var1);

    private static native void initIDs();

    private static int getInset(String string, int n2) {
        Integer n3 = (Integer)AccessController.doPrivileged(new GetIntegerAction(string, n2));
        return n3;
    }

    MWindowPeer() {
        this.insets = new Insets(0, 0, 0, 0);
        this.winAttr = new MWindowAttributes();
    }

    MWindowPeer(Window window) {
        this();
        this.init(window);
        allWindows.addElement(this);
    }

    void create(MComponentPeer mComponentPeer) {
        this.pCreate(mComponentPeer, this.target.getClass().getName());
    }

    void init(Window window) {
        Color color;
        if (this.winAttr.nativeDecor) {
            this.insets.top = MWindowPeer.getInset("awt.frame.topInset", -1);
            this.insets.left = MWindowPeer.getInset("awt.frame.leftInset", -1);
            this.insets.bottom = MWindowPeer.getInset("awt.frame.bottomInset", -1);
            this.insets.right = MWindowPeer.getInset("awt.frame.rightInset", -1);
        }
        super.init(window);
        InputMethodManager inputMethodManager = InputMethodManager.getInstance();
        String string = inputMethodManager.getTriggerMenuString();
        if (string != null) {
            this.pSetIMMOption(string);
        }
        this.pSetTitle(this.winAttr.title);
        this.setResizable(this.winAttr.isResizable);
        this.setSaveUnder(true);
        Font font = window.getFont();
        if (font == null) {
            font = defaultFont;
            window.setFont(font);
            this.setFont(font);
        }
        if ((color = window.getBackground()) == null) {
            window.setBackground(SystemColor.window);
            this.setBackground(SystemColor.window);
        }
        if ((color = window.getForeground()) == null) {
            window.setForeground(SystemColor.windowText);
            this.setForeground(SystemColor.windowText);
        }
    }

    protected void disposeImpl() {
        allWindows.removeElement(this);
        super.disposeImpl();
    }

    public native void toBack();

    public void updateAlwaysOnTop() {
        this.doUpdateAlwaysOnTop(((Window)this.target).isAlwaysOnTop());
    }

    public void toFront() {
        if (this.target.isVisible()) {
            this.pShow();
        }
    }

    public void setVisible(boolean bl2) {
        super.setVisible(bl2);
        this.doUpdateAlwaysOnTop(((Window)this.target).isAlwaysOnTop());
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void handleQuit() {
        this.postEvent(new WindowEvent((Window)this.target, 201));
    }

    public void handleDestroy() {
        final Window window = (Window)this.target;
        SunToolkit.executeOnEventHandlerThread(window, new Runnable(){

            public void run() {
                window.dispose();
            }
        });
    }

    public void handleIconify() {
        this.postEvent(new WindowEvent((Window)this.target, 203));
    }

    public void handleDeiconify() {
        this.postEvent(new WindowEvent((Window)this.target, 204));
    }

    public void handleStateChange(int n2, int n3) {
        this.postEvent(new WindowEvent((Window)this.target, 209, n2, n3));
    }

    public void handleResize(int n2, int n3) {
        if (!this.tcList.isEmpty() && !this.imList.isEmpty()) {
            for (int i2 = 0; i2 < this.imList.size(); ++i2) {
                ((MInputMethod)this.imList.elementAt(i2)).configureStatus();
            }
        }
        this.validateSurface(n2, n3);
        this.postEvent(new ComponentEvent(this.target, 101));
    }

    public Insets insets() {
        return this.getInsets();
    }

    public void handleMoved(int n2, int n3) {
        this.postEvent(new ComponentEvent(this.target, 100));
    }

    private native AWTEvent wrapInSequenced(AWTEvent var1);

    public void handleWindowFocusIn() {
        WindowEvent windowEvent = new WindowEvent((Window)this.target, 207);
        this.postEvent(this.wrapInSequenced(windowEvent));
    }

    public void handleWindowFocusOut(Window window) {
        WindowEvent windowEvent = new WindowEvent((Window)this.target, 208, window);
        this.postEvent(this.wrapInSequenced(windowEvent));
    }

    void notifyIMMOptionChange() {
        InputMethodManager.getInstance().notifyChangeRequest(this.target);
    }

    public void addInputMethod(MInputMethod mInputMethod) {
        if (!this.imList.contains(mInputMethod)) {
            this.imList.addElement(mInputMethod);
        }
    }

    public void removeInputMethod(MInputMethod mInputMethod) {
        if (this.imList.contains(mInputMethod)) {
            this.imList.removeElement(mInputMethod);
        }
    }

    public void addTextComponent(MComponentPeer mComponentPeer) {
        if (this.tcList.contains(mComponentPeer)) {
            return;
        }
        if (this.tcList.isEmpty()) {
            this.addTextComponentNative(mComponentPeer);
            if (!this.imList.isEmpty()) {
                for (int i2 = 0; i2 < this.imList.size(); ++i2) {
                    ((MInputMethod)this.imList.elementAt(i2)).reconfigureXIC((MInputMethodControl)((Object)this));
                }
            }
            MToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = MWindowPeer.this.target.getTreeLock();
                    synchronized (object) {
                        MWindowPeer.this.target.doLayout();
                    }
                }
            });
        }
        this.tcList.addElement(mComponentPeer);
    }

    public void removeTextComponent(MComponentPeer mComponentPeer) {
        if (!this.tcList.contains(mComponentPeer)) {
            return;
        }
        this.tcList.removeElement(mComponentPeer);
        if (this.tcList.isEmpty()) {
            this.removeTextComponentNative();
            if (!this.imList.isEmpty()) {
                for (int i2 = 0; i2 < this.imList.size(); ++i2) {
                    ((MInputMethod)this.imList.elementAt(i2)).reconfigureXIC((MInputMethodControl)((Object)this));
                }
            }
            this.target.doLayout();
        }
    }

    public MComponentPeer getTextComponent() {
        if (!this.tcList.isEmpty()) {
            return (MComponentPeer)this.tcList.firstElement();
        }
        return null;
    }

    boolean hasDecorations(int n2) {
        boolean bl2;
        if (!this.winAttr.nativeDecor) {
            return false;
        }
        int n3 = this.winAttr.decorations;
        boolean bl3 = bl2 = (n3 & n2) == n2;
        if ((n3 & MWindowAttributes.AWT_DECOR_ALL) != 0) {
            return !bl2;
        }
        return bl2;
    }

    public boolean checkNativePaintOnSetBounds(int n2, int n3) {
        return n2 > this.oldWidth || n3 > this.oldHeight;
    }

    native void resetTargetGC(Component var1);

    public void draggedToNewScreen(int n2) {
        final int n3 = n2;
        SunToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            public void run() {
                MWindowPeer.this.displayChanged(n3);
            }
        });
    }

    public void displayChanged(int n2) {
        this.resetLocalGC(n2);
        this.resetTargetGC(this.target);
        super.displayChanged(n2);
    }

    public synchronized void addDropTarget() {
        if (this.dropTargetCount == 0) {
            this.registerX11DropTarget(this.target);
        }
        ++this.dropTargetCount;
    }

    public synchronized void removeDropTarget() {
        --this.dropTargetCount;
        if (this.dropTargetCount == 0) {
            this.unregisterX11DropTarget(this.target);
        }
    }

    public boolean requestWindowFocus() {
        return false;
    }

    static {
        MWindowPeer.initIDs();
    }
}

