/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.InvalidDnDOperationException;
import java.util.Map;
import sun.awt.X11.IXAnyEvent;
import sun.awt.X11.MotifDnDConstants;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDragSourceProtocol;
import sun.awt.X11.XDragSourceProtocolListener;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XException;
import sun.awt.X11.XSelectionRequestEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

class MotifDnDDragSourceProtocol
extends XDragSourceProtocol
implements XEventDispatcher {
    private static final Unsafe unsafe = XlibWrapper.unsafe;
    private long targetEnterServerTime = 0L;

    protected MotifDnDDragSourceProtocol(XDragSourceProtocolListener xDragSourceProtocolListener) {
        super(xDragSourceProtocolListener);
        XToolkit.addEventDispatcher(XWindow.getXAWTRootWindow().getWindow(), this);
    }

    static XDragSourceProtocol createInstance(XDragSourceProtocolListener xDragSourceProtocolListener) {
        return new MotifDnDDragSourceProtocol(xDragSourceProtocolListener);
    }

    protected void initializeDragImpl(int n2, Transferable transferable, Map map, long[] lArray) throws InvalidDnDOperationException, IllegalArgumentException, XException {
        long l2 = XDragSourceProtocol.getDragSourceWindow();
        try {
            int n3 = MotifDnDConstants.getIndexForTargetList(lArray);
            MotifDnDConstants.writeDragInitiatorInfoStruct(l2, n3);
        }
        catch (XException xException) {
            this.cleanup();
            throw xException;
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            this.cleanup();
            throw invalidDnDOperationException;
        }
        if (!MotifDnDConstants.MotifDnDSelection.setOwner(transferable, map, lArray, 0L)) {
            this.cleanup();
            throw new InvalidDnDOperationException("Cannot acquire selection ownership");
        }
    }

    public boolean processClientMessage(XClientMessageEvent xClientMessageEvent) {
        if (xClientMessageEvent.get_message_type() != MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom()) {
            return false;
        }
        long l2 = xClientMessageEvent.get_data();
        byte by = (byte)(unsafe.getByte(l2) & 0x7F);
        byte by2 = (byte)(unsafe.getByte(l2) & 0xFFFFFF80);
        byte by3 = unsafe.getByte(l2 + 1L);
        boolean bl2 = by3 != MotifDnDConstants.getByteOrderByte();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (by2 != -128) {
            return false;
        }
        switch (by) {
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                return false;
            }
        }
        int n5 = unsafe.getInt(l2 + 4L);
        if (bl2) {
            n5 = MotifDnDConstants.Swapper.swap(n5);
        }
        long l3 = n5;
        if (this.targetEnterServerTime == 0L || l3 < this.targetEnterServerTime) {
            return true;
        }
        if (by != 4) {
            short s2 = unsafe.getShort(l2 + 2L);
            if (bl2) {
                s2 = MotifDnDConstants.Swapper.swap(s2);
            }
            byte by4 = (byte)((s2 & 0xF0) >> 4);
            byte by5 = (byte)((s2 & 0xF) >> 0);
            n2 = by4 == 3 ? MotifDnDConstants.getJavaActionsForMotifActions(by5) : 0;
            short s3 = unsafe.getShort(l2 + 8L);
            short s4 = unsafe.getShort(l2 + 10L);
            if (bl2) {
                s3 = MotifDnDConstants.Swapper.swap(s3);
                s4 = MotifDnDConstants.Swapper.swap(s4);
            }
            n3 = s3;
            n4 = s4;
        }
        this.getProtocolListener().handleDragReply(n2, n3, n4);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attachTargetWindow(long l2, long l3) {
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l2, MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO, 0L, 65535L, false, 0L);
        try {
            int n2 = windowPropertyGetter.execute(XToolkit.IgnoreBadWindowHandler);
            if (n2 == 0 && windowPropertyGetter.getData() != 0L && windowPropertyGetter.getActualType() != 0L && windowPropertyGetter.getActualFormat() == 8 && windowPropertyGetter.getNumberOfItems() >= 16) {
                long l4 = windowPropertyGetter.getData();
                byte by = unsafe.getByte(l4);
                byte by2 = unsafe.getByte(l4 + 2L);
                switch (by2) {
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: {
                        int n3 = unsafe.getInt(l4 + 4L);
                        if (by != MotifDnDConstants.getByteOrderByte()) {
                            n3 = MotifDnDConstants.Swapper.swap(n3);
                        }
                        byte by3 = unsafe.getByte(l4 + 1L);
                        this.setTargetWindow(l2);
                        this.setTargetProxyWindow(n3);
                        this.setTargetProtocolVersion(by3);
                        boolean bl2 = true;
                        return bl2;
                    }
                }
                boolean bl3 = false;
                return bl3;
            }
            boolean bl4 = false;
            return bl4;
        }
        finally {
            windowPropertyGetter.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEnterMessage(long[] lArray, int n2, int n3, long l2) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        assert (this.getTargetWindow() != 0L);
        assert (lArray != null);
        this.targetEnterServerTime = l2;
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(this.getTargetWindow());
            xClientMessageEvent.set_format(8);
            xClientMessageEvent.set_message_type(MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom());
            long l3 = xClientMessageEvent.get_data();
            int n4 = MotifDnDConstants.getMotifActionsForJavaActions(n2) << 0 | MotifDnDConstants.getMotifActionsForJavaActions(n3) << 8;
            unsafe.putByte(l3, (byte)0);
            unsafe.putByte(l3 + 1L, MotifDnDConstants.getByteOrderByte());
            unsafe.putShort(l3 + 2L, (short)n4);
            unsafe.putInt(l3 + 4L, (int)l2);
            unsafe.putInt(l3 + 8L, (int)XDragSourceProtocol.getDragSourceWindow());
            unsafe.putInt(l3 + 12L, (int)MotifDnDConstants.XA_MOTIF_ATOM_0.getAtom());
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, xClientMessageEvent.pData);
        }
        finally {
            xClientMessageEvent.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMoveMessage(int n2, int n3, int n4, int n5, long l2) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        assert (this.getTargetWindow() != 0L);
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(this.getTargetWindow());
            xClientMessageEvent.set_format(8);
            xClientMessageEvent.set_message_type(MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom());
            long l3 = xClientMessageEvent.get_data();
            int n6 = MotifDnDConstants.getMotifActionsForJavaActions(n4) << 0 | MotifDnDConstants.getMotifActionsForJavaActions(n5) << 8;
            unsafe.putByte(l3, (byte)2);
            unsafe.putByte(l3 + 1L, MotifDnDConstants.getByteOrderByte());
            unsafe.putShort(l3 + 2L, (short)n6);
            unsafe.putInt(l3 + 4L, (int)l2);
            unsafe.putShort(l3 + 8L, (short)n2);
            unsafe.putShort(l3 + 10L, (short)n3);
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, xClientMessageEvent.pData);
        }
        finally {
            xClientMessageEvent.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendLeaveMessage(long l2) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        assert (this.getTargetWindow() != 0L);
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(this.getTargetWindow());
            xClientMessageEvent.set_format(8);
            xClientMessageEvent.set_message_type(MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom());
            long l3 = xClientMessageEvent.get_data();
            unsafe.putByte(l3, (byte)1);
            unsafe.putByte(l3 + 1L, MotifDnDConstants.getByteOrderByte());
            unsafe.putShort(l3 + 2L, (short)0);
            unsafe.putInt(l3 + 4L, (int)l2);
            unsafe.putInt(l3 + 8L, (int)XDragSourceProtocol.getDragSourceWindow());
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, xClientMessageEvent.pData);
        }
        finally {
            xClientMessageEvent.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendDropMessage(int n2, int n3, int n4, int n5, long l2) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        assert (this.getTargetWindow() != 0L);
        this.sendLeaveMessage(l2);
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(this.getTargetWindow());
            xClientMessageEvent.set_format(8);
            xClientMessageEvent.set_message_type(MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom());
            long l3 = xClientMessageEvent.get_data();
            int n6 = MotifDnDConstants.getMotifActionsForJavaActions(n4) << 0 | MotifDnDConstants.getMotifActionsForJavaActions(n5) << 8;
            unsafe.putByte(l3, (byte)5);
            unsafe.putByte(l3 + 1L, MotifDnDConstants.getByteOrderByte());
            unsafe.putShort(l3 + 2L, (short)n6);
            unsafe.putInt(l3 + 4L, (int)l2);
            unsafe.putShort(l3 + 8L, (short)n2);
            unsafe.putShort(l3 + 10L, (short)n3);
            unsafe.putInt(l3 + 12L, (int)MotifDnDConstants.XA_MOTIF_ATOM_0.getAtom());
            unsafe.putInt(l3 + 16L, (int)XDragSourceProtocol.getDragSourceWindow());
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, xClientMessageEvent.pData);
        }
        finally {
            xClientMessageEvent.dispose();
        }
    }

    public void cleanupTargetInfo() {
        super.cleanupTargetInfo();
        this.targetEnterServerTime = 0L;
    }

    public void dispatchEvent(IXAnyEvent iXAnyEvent) {
        switch (iXAnyEvent.get_type()) {
            case 30: {
                XSelectionRequestEvent xSelectionRequestEvent = new XSelectionRequestEvent(iXAnyEvent.getPData());
                long l2 = xSelectionRequestEvent.get_selection();
                if (l2 != MotifDnDConstants.XA_MOTIF_ATOM_0.getAtom()) break;
                long l3 = xSelectionRequestEvent.get_target();
                if (l3 == MotifDnDConstants.XA_XmTRANSFER_SUCCESS.getAtom()) {
                    this.getProtocolListener().handleDragFinished(true);
                    break;
                }
                if (l3 != MotifDnDConstants.XA_XmTRANSFER_FAILURE.getAtom()) break;
                this.getProtocolListener().handleDragFinished(false);
            }
        }
    }
}

